/**
 * @author Gavin
 * @description socket封装
 * */
interface ConstructorInterface {
  url: string;
  cb: (msg: MessageEvent<any>) => void;
}
enum WsOrderEnum {
  open = 0,
  close = 1,
}
export class WsClass {
  wsImpl: WebSocket;
  url: string;
  cb: (msg: MessageEvent<any>) => void;
  isConnect: Boolean;
  wsOrder: WsOrderEnum;
  reconnectTime: number;
  reconnectTimeId: number;
  heartTimeId: number;
  constructor({ url, cb }: ConstructorInterface) {
    this.url = url;
    this.wsOrder = 0;
    this.wsImpl = null as unknown as WebSocket;
    this.isConnect = false;
    this.reconnectTime = 0;
    this.reconnectTimeId = 0;
    this.heartTimeId = 0;
    this.cb = cb as unknown as (msg: MessageEvent<any>) => void;
    this.init({ url, cb });
  }
  init({ url, cb }: ConstructorInterface) {
    this.wsOrder = WsOrderEnum.open;
    this.wsImpl = new WebSocket(url);
    this.wsOpenListener();
    this.wsMessageListener(cb);
    this.wsErrorListener();
    this.wsCloseListener();
  }
  wsOpenListener() {
    this.wsImpl.addEventListener("open", () => {
      console.log("链接成功");
      this.isConnect = true;
      this.wsHeart();
    });
  }
  wsSend(sendObj: any) {
    console.log("this", this);
    console.log("this.wsImpl", this.wsImpl);
    console.log(`发送信息${sendObj}`);
    this.wsImpl.send(JSON.stringify(sendObj));
  }
  wsMessageListener(cb: (msg: MessageEvent<any>) => void) {
    this.wsImpl.addEventListener("message", (msg) => {
      cb(msg);
    });
  }
  wsErrorListener() {
    this.wsImpl.addEventListener("error", () => {
        this.isConnect = false;
      // 如果是关闭的时候出现异常
      if(this.wsOrder === WsOrderEnum.open){
        console.log("ws异常重连");
        this.wsReconnect();
      } else {
        this.wsImpl.close()
      }
    });
  }
  wsCloseListener() {
    this.wsImpl.addEventListener("close", (event) => {
      this.isConnect = false;
      // 非正常关闭  服务器奔溃 或 网络慢 链接超时 会自动出发close
      if (this.wsOrder === WsOrderEnum.open) {
        this.wsReconnect();
      } else {
        console.log("ws链接关闭");
        this.wsClear()
      }
    });
  }
  wsClear(){
    // 垃圾回收 周期前 挂载的事件 包括 定时器 要清除一下绑定关系
    clearInterval(this.heartTimeId);
    this.wsImpl.close()
    this.wsImpl.onmessage = null;
    this.wsImpl.onopen = null;
    this.wsImpl.onerror = null;
    this.wsImpl.onclose = null;
  }
  wsReconnect() {
    // 防抖
    this.wsClear()
    clearInterval(this.reconnectTimeId);
    this.reconnectTimeId = (setTimeout(() => {
      this.reconnectTime++;
      this.init({
        url: this.url,
        cb: this.cb,
      });
    }, 1000) as any);
  }
  // ping pong 心跳  检索链接  及时作出重连动作
  wsHeart() {
    clearInterval(this.heartTimeId);
    this.heartTimeId = (setInterval(() => {
      this.wsSend("ping");
    }, 10000) as any);
  }
}
