import { createApp } from 'vue'
import App from './App.vue'
import router from './router'

import ElementPlus from 'element-plus';
import 'element-plus/dist/index.css';

import store from './store/index'
import {useState, useMutations, useGetters, useActions} from './utils/mapStore'
let app = createApp(App)

app.config.globalProperties.$mapStore = {
    useState,
    useMutations,
    useGetters,
    useActions
};

app.use(ElementPlus)
app.use(router)
app.use(store)
app.mount('#app')
