# 1、node环境准备
	cd /opt
	# 1)、node安装包下载，下载地址：https://nodejs.org/zh-cn/download/
    wget -c https://nodejs.org/dist/v12.18.3/node-v12.18.3-linux-x64.tar.xz
    
	# 2)、node安装
	tar xf node-v12.18.3-linux-x64.tar.xz
	
	# 3)、node环境变量配置
	cat >>/etc/profile <<-'END'
	export PATH=$PATH:/opt/node-v12.18.3-linux-x64/bin
	END
	source /etc/profile
    
# 2、项目环境准备
    # 1)、拷贝完整项目到服务器文件下
	cd /data0/wwwroot/
	  #上传项目文件
	
    # 2)、进入项目目录，安装依赖 `npm i`
    cd /data0/wwwrooo/XXX
	npm install
	
	# 3)、打包： `npm run build`
	npm run build
    
	# 4)、启动： `npm run start`
	npm run start
    
	# 以守护进程的方式运行
	# 5)、安装pm2，`npm install pm2 -g`
	npm install pm2 -g
	# 6)、pm2启动项目：` pm2 start ./node_modules/nuxt/bin/nuxt -- start`
	pm2 start ./node_modules/nuxt/bin/nuxt -- start

# 3、准备nginx配置文件
server {
    server_name  www.wecloud.cn;
    listen 80;
	
    location / {
        proxy_intercept_errors on;
        error_page 404 =404 /404.html;

        index  index.html index.htm index.php;
        proxy_set_header Host $host;
        proxy_set_header X-Real-IP $remote_addr;
        proxy_set_header REMOTE-HOST $remote_addr;
        proxy_set_header X-Forwarded-For $proxy_add_x_forwarded_for;
        proxy_pass http://127.0.0.1:3000; #后端服务器，具体配置upstream部分即可 

    }
}