/*
 * Decompiled with CFR 0.152.
 */
package com.ym.tlifang.api.controller.user;

import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.config.annotation.Reference;
import com.ym.tlifang.Constants;
import com.ym.tlifang.ResultModel;
import com.ym.tlifang.ResultStatus;
import com.ym.tlifang.api.authorization.annotation.Authorization;
import com.ym.tlifang.api.authorization.annotation.CurrentUser;
import com.ym.tlifang.api.authorization.annotation.LanguageType;
import com.ym.tlifang.api.controller.BaseController;
import com.ym.tlifang.api.exception.ServiceException;
import com.ym.tlifang.model.user.CheckMobileModel;
import com.ym.tlifang.model.user.LoginModel;
import com.ym.tlifang.service.company.CompanyMemberInfoService;
import com.ym.tlifang.service.user.LoginRecordService;
import com.ym.tlifang.service.user.UserService;
import com.ym.tlifang.user.TokenModel;
import com.ym.tlifang.user.User;
import com.ym.tlifang.util.IpUtil;
import com.ym.tlifang.util.JsonUtil;
import com.ym.tlifang.util.JwtUtil;
import com.ym.tlifang.util.StringUtils;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.SignatureException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"tokens"})
@Api(value="tokens", description="\u767b\u5f55\u76f8\u5173")
public class TokenController
extends BaseController {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Reference
    private UserService userService;
    @Reference
    private LoginRecordService loginRecordService;
    @Reference
    private CompanyMemberInfoService companyMemberInfoService;
    @Autowired
    private StringRedisTemplate redis;
    String openPlatformAppId = "wx5e011cdd62c1ffaa";
    String openPlatformRedirect_uri = "http://47.97.74.251:8081/api/v2";

    @PostMapping
    @ApiOperation(value="\u767b\u5f55")
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    public ResultModel<TokenModel> login(@LanguageType String type, @RequestBody LoginModel user, HttpServletRequest request) throws Exception {
        return this.userService.loginUser(user, null, request.getHeader("platform"), IpUtil.getIpAddr((HttpServletRequest)request), user.getPushToken(), type);
    }

    @PutMapping
    @ApiOperation(value="\u91cd\u65b0\u83b7\u53d6token")
    @ApiImplicitParams(value={@ApiImplicitParam(name="refreshToken", value="refreshToken", required=true, dataType="string", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    public ResultModel<TokenModel> refreshToken(@LanguageType String languageType, @RequestBody String refreshToken) {
        try {
            Claims claims = JwtUtil.checkToken((String)refreshToken);
            String type = (String)claims.get("type", String.class);
            if (!Constants.TokenType.refreshToken.getType().equals(type)) {
                return ResultModel.error((ResultStatus)ResultStatus.TOKEN_TYPE_ERROR, (String)languageType);
            }
            Long userId = (Long)claims.get("userId", Long.class);
            String token = JwtUtil.getToken((Map)claims, (long)-1702967296L, (String)(userId + ""));
            User user = this.userService.findOne(userId);
            this.redis.boundValueOps((Object)token).set((Object)userId.toString(), 720L, TimeUnit.HOURS);
            this.redis.boundValueOps((Object)("user_" + userId)).set((Object)JsonUtil.jackson.writeValueAsString((Object)user), 720L, TimeUnit.HOURS);
            return ResultModel.suc((Object)new TokenModel(userId.longValue(), token, ""), (String)languageType);
        }
        catch (SignatureException e) {
            throw new ServiceException(ResultStatus.REFRESHTOKEN_ERROR);
        }
        catch (ExpiredJwtException e) {
            throw new ServiceException(ResultStatus.REFRESHTOKEN_EXPIRED);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @DeleteMapping
    @ApiOperation(value="\u9000\u51fa\u767b\u5f55")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="currentUser", value="\u7528\u6237\u5bf9\u8c61\uff08\u4e0d\u7528\u4f20\uff09", required=false, dataType="user", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel logout(@LanguageType String languageType, @CurrentUser User currentUser, HttpServletRequest request) {
        String authorization = request.getHeader("Authorization");
        String token = authorization.replace("Bearer ", "");
        this.redis.delete((Object)token);
        this.redis.delete((Object)("user_" + currentUser.getId()));
        currentUser.setPushToken(null);
        this.userService.save(currentUser);
        return ResultModel.ok((String)languageType);
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/mobiles/check"})
    @ApiOperation(value="\u68c0\u9a8c\u624b\u673a\u53f7\u7801", notes="\u767b\u5f55\u754c\u9762\u68c0\u6d4b")
    @ApiImplicitParams(value={})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    public ResultModel<CheckMobileModel> checkMobile(@LanguageType String languageType, @RequestBody CheckMobileModel checkMobileModel) {
        User queryUser = this.userService.findByMobile(checkMobileModel.getMobile());
        if (queryUser == null) {
            return ResultModel.error((ResultStatus)ResultStatus.MOBILE_NO_EXIST, (String)languageType);
        }
        return ResultModel.ok((String)languageType);
    }

    @RequestMapping(value={"/wxLoginCheck"}, method={RequestMethod.GET})
    @ApiOperation(value="\u5fae\u4fe1\u626b\u63cf\u767b\u5f55")
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @ResponseBody
    public ResultModel wxLoginCheck(@LanguageType String languageType) {
        Map weixinLoginUrl = this.weixinLoginUrl();
        String url = (String)weixinLoginUrl.get("url");
        return ResultModel.suc((Object)url, (String)languageType);
    }

    @RequestMapping(value={"wxLoginCode"}, method={RequestMethod.GET})
    @ApiOperation(value="\u5fae\u4fe1\u626b\u63cf\u56de\u8c03\u5730\u5740")
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    public ResultModel<TokenModel> wxlogin(@LanguageType String languageType, String code, String state) throws Exception {
        this.logger.info("code----------" + code);
        this.logger.info("state----------" + state);
        return ResultModel.ok((String)languageType);
    }

    public Map<String, String> weixinLoginUrl() {
        String url = "https://open.weixin.qq.com/connect/qrconnect?appid=" + this.openPlatformAppId + "&redirect_uri=" + URL.encode((String)("'" + this.openPlatformRedirect_uri + "'/wxLoginCode")) + "&response_type=code&scope=snsapi_login&state=STATE#wechat_redirect";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("url", url);
        map.put("getRedirect_uri", this.openPlatformRedirect_uri);
        return map;
    }

    @PostMapping(value={"/savePush"})
    @ApiOperation(value="\u4fdd\u5b58\u4fe1\u9e3dpush_token")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="currentUser", value="\u7528\u6237\u5bf9\u8c61\uff08\u4e0d\u7528\u4f20\uff09", required=false, dataType="user", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel savePush(@LanguageType String languageType, @CurrentUser User currentUser, @RequestBody LoginModel model, HttpServletRequest request) {
        if (StringUtils.isNotBlank((String)model.getPushToken())) {
            currentUser.setPushToken(StringUtils.isNullStr((Object)model.getPushToken()));
            this.userService.save(currentUser);
        }
        return ResultModel.ok((String)languageType);
    }
}

