/*
 * Decompiled with CFR 0.152.
 */
package com.ym.tlifang.api.controller.task.subtask;

import com.alibaba.dubbo.config.annotation.Reference;
import com.ym.tlifang.Constants;
import com.ym.tlifang.ResultModel;
import com.ym.tlifang.ResultStatus;
import com.ym.tlifang.api.authorization.annotation.Authorization;
import com.ym.tlifang.api.authorization.annotation.CurrentUser;
import com.ym.tlifang.api.authorization.annotation.LanguageType;
import com.ym.tlifang.service.system.DynamicService;
import com.ym.tlifang.service.task.TaskService;
import com.ym.tlifang.service.task.subtask.SubtaskService;
import com.ym.tlifang.task.subtask.Subtask;
import com.ym.tlifang.user.User;
import com.ym.tlifang.util.StringUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.Date;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"subtask"})
@Api(value="tasks", description="\u4efb\u52a1\u76f8\u5173")
public class SubtaskController {
    @Reference
    private SubtaskService subtaskService;
    @Reference
    private TaskService taskService;
    @Reference
    private DynamicService dynamicService;

    @PostMapping
    @ApiOperation(value="\u521b\u5efa\u5b50\u4efb\u52a1")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel addSubtask(@LanguageType String languageType, @CurrentUser User currentUser, @RequestBody Subtask subtask) {
        if (StringUtils.isEmpty((Object)subtask.getCreatorId()) || StringUtils.isEmpty((Object)subtask.getTaskId()) || StringUtils.isEmpty((Object)subtask.getTitle())) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        if (Constants.TaskType.taskComplete.getType().equals(this.taskService.findOne(subtask.getTaskId()).getStatus())) {
            return ResultModel.error((ResultStatus)ResultStatus.SUBTASK_NOT_MODIFY, (String)languageType);
        }
        if (Constants.Subtask.subtaskNum.getType() <= this.subtaskService.countByTaskId(subtask.getTaskId())) {
            return ResultModel.error((ResultStatus)ResultStatus.SUBTASK_NUMBER, (String)languageType);
        }
        subtask.setStatus(StringUtils.isEmpty((Object)subtask.getStatus()) ? Constants.Subtask.unfinished.getType() : subtask.getStatus());
        Subtask subtaskResult = this.subtaskService.save(subtask);
        this.dynamicService.saveTaskDynamic(currentUser.getId(), Constants.DynamicParentType.task, subtaskResult.getTaskId(), Constants.DynamicOriginatorType.subtask, subtaskResult.getId(), Constants.DynamicType.createSubTask.getName(), Constants.DynamicActionType.subtaskAdd, subtask.getTitle(), Constants.DynamicType.createSubTask.getNameEnglish());
        return ResultModel.suc((Object)subtaskResult, (String)languageType);
    }

    @GetMapping(value={"/{taskId}"})
    @ApiOperation(value="\u67e5\u8be2\u6240\u6709\u5b50\u4efb\u52a1")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="taskId", value="\u4efb\u52a1Id", required=true, dataType="Long", paramType="path")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel getAllSubtasks(@LanguageType String languageType, @PathVariable Long taskId) {
        if (StringUtils.isEmpty((Object)taskId)) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        return ResultModel.suc((Object)this.subtaskService.findAllSubtasks(taskId), (String)languageType);
    }

    @PutMapping
    @ApiOperation(value="\u66f4\u65b0\u5b50\u4efb\u52a1")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="status", value="\u72b6\u6001(1:\u5df2\u5b8c\u6210,0:\u672a\u5b8c\u6210)", required=false, dataType="Integer", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel updateSubtask(@LanguageType String languageType, @CurrentUser User currentUser, @RequestBody Subtask subtask) {
        if (StringUtils.isEmpty((Object)subtask.getId())) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        Subtask subtaskRecode = this.subtaskService.findBySubtask(subtask.getId());
        String title = subtaskRecode.getTitle();
        if (StringUtils.isEmpty((Object)subtaskRecode)) {
            return ResultModel.error((ResultStatus)ResultStatus.SUBTASK_NO_EXIST, (String)languageType);
        }
        if (Constants.TaskType.taskComplete.getType().equals(this.taskService.findOne(subtaskRecode.getTaskId()).getStatus())) {
            return ResultModel.error((ResultStatus)ResultStatus.SUBTASK_NOT_MODIFY, (String)languageType);
        }
        subtaskRecode.setTitle(StringUtils.isEmpty((Object)subtask.getTitle()) ? subtaskRecode.getTitle() : subtask.getTitle());
        subtaskRecode.setAssigneeId(StringUtils.isEmpty((Object)subtask.getAssigneeId()) ? subtaskRecode.getAssigneeId() : subtask.getAssigneeId());
        subtaskRecode.setStatus(StringUtils.isEmpty((Object)subtask.getStatus()) ? Constants.Subtask.unfinished.getType() : subtask.getStatus());
        subtaskRecode.setDateDue(StringUtils.isEmpty((Object)subtask.getDateDue()) ? subtaskRecode.getDateDue() : subtask.getDateDue());
        subtaskRecode.setUpdateDate(new Date());
        this.subtaskService.save(subtaskRecode);
        String content = Constants.DynamicType.updateSubTask.getName();
        String contentEnglish = Constants.DynamicType.updateSubTask.getNameEnglish();
        if (Constants.Subtask.complete.getType().equals(subtask.getStatus())) {
            content = Constants.DynamicType.commitSubTask.getName();
            contentEnglish = Constants.DynamicType.commitSubTask.getNameEnglish();
        }
        this.dynamicService.saveTaskDynamic(currentUser.getId(), Constants.DynamicParentType.task, subtaskRecode.getTaskId(), Constants.DynamicOriginatorType.subtask, subtask.getId(), content, Constants.DynamicActionType.subtaskUpdate, subtaskRecode.getTitle(), contentEnglish);
        return ResultModel.ok((String)languageType);
    }

    @DeleteMapping(value={"/{id}"})
    @ApiOperation(value="\u5220\u9664\u5b50\u4efb\u52a1")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="id", value="\u5b50\u4efb\u52a1Id", required=true, dataType="Long", paramType="path")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel deleteSubtask(@LanguageType String languageType, @CurrentUser User currentUser, @PathVariable Long id) {
        if (StringUtils.isEmpty((Object)id)) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        Subtask subtask = this.subtaskService.findBySubtask(id);
        if (StringUtils.isEmpty((Object)subtask)) {
            return ResultModel.error((ResultStatus)ResultStatus.SUBTASK_NO_EXIST, (String)languageType);
        }
        subtask.setDelFlag(Boolean.valueOf(true));
        subtask.setUpdateDate(new Date());
        Subtask subtaskResult = this.subtaskService.save(subtask);
        this.dynamicService.saveTaskDynamic(currentUser.getId(), Constants.DynamicParentType.task, subtask.getTaskId(), Constants.DynamicOriginatorType.subtask, subtask.getId(), Constants.DynamicType.delSubTask.getName(), Constants.DynamicActionType.subtaskDelete, subtask.getTitle(), Constants.DynamicType.delSubTask.getNameEnglish());
        return ResultModel.ok((String)languageType);
    }
}

