/*
 * Decompiled with CFR 0.152.
 */
package com.ym.tlifang.api.controller.sys;

import com.alibaba.dubbo.config.annotation.Reference;
import com.amazonaws.services.s3.model.S3Object;
import com.ym.tlifang.Constants;
import com.ym.tlifang.ResultModel;
import com.ym.tlifang.ResultStatus;
import com.ym.tlifang.api.authorization.annotation.LanguageType;
import com.ym.tlifang.api.config.ApiConfig;
import com.ym.tlifang.file.ImFileEntity;
import com.ym.tlifang.service.file.ImFileService;
import com.ym.tlifang.util.AmazonStorageUtil;
import com.ym.tlifang.util.EncryptUtils;
import com.ym.tlifang.util.StringUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.UUID;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"im"})
@Api(value="im", description="im\u4f1a\u8bdd\u6587\u4ef6\u76f8\u5173")
public class imStorageController {
    @Reference
    ImFileService imFileService;
    @Autowired
    ApiConfig apiConfig;

    @PostMapping(value={"/file/{conversationId}/{encrypt}"})
    @ApiOperation(value="im\u4f1a\u8bdd\u6587\u4ef6\u4e0a\u4f20\u76f8\u5173")
    @ApiImplicitParams(value={@ApiImplicitParam(name="conversationId", value="\u4f1a\u8bddid", required=true, dataType="Long", paramType="path"), @ApiImplicitParam(name="encrypt", value="\u662f\u5426\u52a0\u5bc6\uff080.\u975e\u52a0\u5bc6 1.\u52a0\u5bc6\uff09", required=true, dataType="int", paramType="path")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    public ResultModel newUploadImFileToS3(@LanguageType String languageType, @PathVariable Long conversationId, @PathVariable Integer encrypt, @RequestParam(value="file") MultipartFile multfile) throws IOException {
        String url = null;
        String decodeName = URLDecoder.decode(multfile.getOriginalFilename(), "UTF-8");
        String resultFileName = decodeName.substring(0, decodeName.indexOf(".")) + System.currentTimeMillis() + decodeName.substring(decodeName.lastIndexOf("."));
        long saveFileStart = System.currentTimeMillis();
        File file = this.transferToTempFile(multfile, encrypt);
        long saveFileEnd = System.currentTimeMillis();
        System.out.println("save file time: " + (saveFileEnd - saveFileStart) / 1000L);
        if (!file.exists()) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR);
        }
        long start = System.currentTimeMillis();
        url = AmazonStorageUtil.uploadToS3Expiration((String)Constants.AMAZON_S3_BUCKET_IM_NAME, (File)file, (String)resultFileName);
        long end = System.currentTimeMillis();
        System.out.println("upload file time: " + (end - start) / 1000L);
        file.delete();
        if (StringUtils.isEmpty((Object)url)) {
            return ResultModel.error((ResultStatus)ResultStatus.UPLOAD_FAILED, (String)languageType);
        }
        ImFileEntity imFileEntity = new ImFileEntity();
        imFileEntity.setConversationId(conversationId);
        imFileEntity.setSize(Long.valueOf(multfile.getSize()));
        imFileEntity.setUrl(url);
        imFileEntity.setName(decodeName);
        imFileEntity.setBucketName(Constants.AMAZON_S3_BUCKET_IM_NAME);
        imFileEntity.setEncrypt(encrypt);
        imFileEntity.setCreateBy(Long.valueOf(123L));
        imFileEntity = this.imFileService.sava(imFileEntity);
        String urlResult = this.apiConfig.getImUrl() + imFileEntity.getId();
        return ResultModel.suc((Object)urlResult);
    }

    @GetMapping(value={"/download/{id}"})
    @ApiOperation(value="im\u4f1a\u8bdd\u6587\u4ef6\u4e0b\u8f7d\u76f8\u5173")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="id", required=true, dataType="Long", paramType="path")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    public void downloadToS3(@PathVariable Long id, HttpServletResponse response) throws IOException {
        ImFileEntity fileEntity = this.imFileService.findOne(id);
        String substring = fileEntity.getUrl().substring(fileEntity.getUrl().lastIndexOf("/") + 1);
        String decode = URLDecoder.decode(substring, "UTF-8");
        S3Object object = AmazonStorageUtil.doToS3((String)Constants.AMAZON_S3_BUCKET_IM_NAME, (String)decode);
        response.reset();
        response.setContentType("application/x-msdownload");
        response.setHeader("Content-Disposition", "attachment; filename=" + substring);
        try {
            BufferedOutputStream outputStream = new BufferedOutputStream((OutputStream)response.getOutputStream());
            BufferedInputStream input = new BufferedInputStream((InputStream)object.getObjectContent());
            if (fileEntity.getEncrypt() == 1) {
                ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                byte[] buffer = new byte[4096];
                int len = -1;
                while ((len = input.read(buffer)) != -1) {
                    outStream.write(buffer, 0, len);
                }
                byte[] fileByte = outStream.toByteArray();
                String key = "00000000";
                byte[] newKey = key.getBytes();
                fileByte = EncryptUtils.decrypt((byte[])fileByte, (byte[])newKey);
                outputStream.write(fileByte, 0, fileByte.length);
            } else {
                byte[] buffer = new byte[4096];
                int bytesRead = -1;
                while ((bytesRead = input.read(buffer)) != -1) {
                    outputStream.write(buffer, 0, bytesRead);
                }
            }
            input.close();
            outputStream.flush();
            outputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private File transferToTempFile(MultipartFile multFile, Integer encrypt) throws IOException, IllegalStateException {
        File desc = File.createTempFile(UUID.randomUUID().toString(), AmazonStorageUtil.getFileSuffix((String)multFile.getOriginalFilename()));
        try {
            BufferedInputStream in = new BufferedInputStream(multFile.getInputStream());
            BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(desc.toPath(), new OpenOption[0]));
            if (encrypt == 1) {
                ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                byte[] buffer = new byte[4096];
                int len = -1;
                while ((len = in.read(buffer)) != -1) {
                    outStream.write(buffer, 0, len);
                }
                byte[] fileByte = outStream.toByteArray();
                String key = "00000000";
                byte[] newKey = key.getBytes();
                fileByte = EncryptUtils.encrypt((byte[])fileByte, (byte[])newKey);
                out.write(fileByte, 0, fileByte.length);
            } else {
                byte[] buffer = new byte[4096];
                int bytesRead = -1;
                while ((bytesRead = in.read(buffer)) != -1) {
                    out.write(buffer, 0, bytesRead);
                }
            }
            in.close();
            out.flush();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return desc;
    }
}

