/*
 * Decompiled with CFR 0.152.
 */
package com.ym.tlifang.api.controller.statement;

import com.alibaba.dubbo.config.annotation.Reference;
import com.ym.tlifang.PageInfo;
import com.ym.tlifang.ResultModel;
import com.ym.tlifang.ResultStatus;
import com.ym.tlifang.api.authorization.annotation.Authorization;
import com.ym.tlifang.api.authorization.annotation.CurrentUser;
import com.ym.tlifang.api.authorization.annotation.LanguageType;
import com.ym.tlifang.api.controller.BaseController;
import com.ym.tlifang.model.statistics.CompanyStatisticsModel;
import com.ym.tlifang.service.attendance.AttendanceReportUserService;
import com.ym.tlifang.service.statement.CompanyStatisticsService;
import com.ym.tlifang.service.statement.ProjectStatisticsService;
import com.ym.tlifang.service.statement.TaskStatisticsService;
import com.ym.tlifang.statement.ProjectStatistics;
import com.ym.tlifang.statement.TaskStatistics;
import com.ym.tlifang.user.User;
import com.ym.tlifang.util.DateUtils;
import com.ym.tlifang.util.StringUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.text.ParseException;
import java.util.Date;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"statements"})
@Api(value="statements", description="\u62a5\u8868\u76f8\u5173")
public class StatementController
extends BaseController {
    @Reference
    private CompanyStatisticsService companyStatisticsService;
    @Reference
    private ProjectStatisticsService projectStatisticsService;
    @Reference
    private TaskStatisticsService taskStatisticsService;
    @Reference
    private AttendanceReportUserService attendanceReportUserService;

    @GetMapping(value={"/company/{companyId}"})
    @ApiOperation(value="\u56e2\u961f\u7edf\u8ba1")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="companyId", value="\u516c\u53f8id", required=true, dataType="long", paramType="path")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<CompanyStatisticsModel> getCompanyStatistics(@LanguageType String languageType, @PathVariable Long companyId) {
        if (StringUtils.isEmpty((Object)companyId)) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        return ResultModel.suc((Object)this.companyStatisticsService.findMaxCompanyStatistics(companyId), (String)languageType);
    }

    @GetMapping(value={"/project/{companyId}"})
    @ApiOperation(value="\u7ba1\u7406\u8005/\u6210\u5458\uff08\u6309\u9879\u76ee\u7edf\u8ba1\uff09")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="currentUser", value="\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body"), @ApiImplicitParam(name="companyId", value="\u516c\u53f8id", required=true, dataType="long", paramType="path"), @ApiImplicitParam(name="departmentId", value="\u90e8\u95e8id(\u7ba1\u7406\u8005\u65e0\u9700\u4f20)", required=false, dataType="long", paramType="query"), @ApiImplicitParam(name="date", value="\u65f6\u95f4\u5b57\u7b26\u4e32ps:2018-03", required=true, dataType="string", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<ProjectStatistics> getProjectDetail(@LanguageType String languageType, @CurrentUser User currentUser, @PathVariable Long companyId, Long departmentId, String date) {
        if (StringUtils.isEmpty((Object)companyId) || StringUtils.isEmpty((Object)date)) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        return ResultModel.suc((Object)this.projectStatisticsService.findByCompanyIdAndDate(companyId, departmentId, date), (String)languageType);
    }

    @GetMapping(value={"/task/{companyId}"})
    @ApiOperation(value="\u7ba1\u7406\u8005\uff08\u6309\u4efb\u52a1\u7edf\u8ba1\uff09")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="currentUser", value="\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body"), @ApiImplicitParam(name="companyId", value="\u516c\u53f8id", required=true, dataType="long", paramType="path"), @ApiImplicitParam(name="date", value="\u65f6\u95f4\u5b57\u7b26\u4e32ps:2018-03", required=true, dataType="string", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<TaskStatistics> getTaskDetail(@LanguageType String languageType, @CurrentUser User currentUser, @PathVariable Long companyId, String date) {
        if (StringUtils.isEmpty((Object)companyId) || StringUtils.isEmpty((Object)date)) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        return ResultModel.suc((Object)this.taskStatisticsService.findByCompanyIdAndDate(companyId, date), (String)languageType);
    }

    @GetMapping(value={"/memberspro/project/{companyId}"})
    @ApiOperation(value="\u6210\u5458\u7edf\u8ba1(\u6309\u9879\u76ee)")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="currentUser", value="\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body"), @ApiImplicitParam(name="companyId", value="\u516c\u53f8id", required=true, dataType="long", paramType="path"), @ApiImplicitParam(name="pageNo", value="\u9875\u7801", required=false, dataType="int", paramType="query"), @ApiImplicitParam(name="pageSize", value="\u663e\u793a\u6570\u91cf", required=false, dataType="int", paramType="query"), @ApiImplicitParam(name="departmentId", value="\u90e8\u95e8id(\u7b5b\u9009\u6761\u4ef6)", required=false, dataType="long", paramType="query"), @ApiImplicitParam(name="date", value="\u65f6\u95f4\u5b57\u7b26\u4e32ps:2018-03", required=true, dataType="string", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<PageInfo<ProjectStatistics>> getMemberProjectDetail(@LanguageType String languageType, @CurrentUser User currentUser, @PathVariable Long companyId, String date, Long departmentId, Integer pageNo, Integer pageSize) {
        if (StringUtils.isEmpty((Object)companyId) || StringUtils.isEmpty((Object)date)) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        PageInfo pageInfo = this.projectStatisticsService.findMembersByCompanyIdAndDate(companyId, date, departmentId, pageNo, pageSize);
        return ResultModel.suc((Object)pageInfo, (String)languageType);
    }

    @GetMapping(value={"/members/task/{companyId}"})
    @ApiOperation(value="\u6210\u5458\u7edf\u8ba1(\u6309\u4efb\u52a1)")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="currentUser", value="\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body"), @ApiImplicitParam(name="companyId", value="\u516c\u53f8id", required=true, dataType="long", paramType="path"), @ApiImplicitParam(name="pageNo", value="\u9875\u7801", required=false, dataType="int", paramType="query"), @ApiImplicitParam(name="pageSize", value="\u663e\u793a\u6570\u91cf", required=false, dataType="int", paramType="query"), @ApiImplicitParam(name="departmentId", value="\u90e8\u95e8id(\u7b5b\u9009\u6761\u4ef6)", required=false, dataType="long", paramType="query"), @ApiImplicitParam(name="date", value="\u65f6\u95f4\u5b57\u7b26\u4e32ps:2018-03", required=true, dataType="string", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<PageInfo<TaskStatistics>> getMemberTaskDetail(@LanguageType String languageType, @CurrentUser User currentUser, @PathVariable Long companyId, String date, Long departmentId, Integer pageNo, Integer pageSize) {
        if (StringUtils.isEmpty((Object)companyId) || StringUtils.isEmpty((Object)date)) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        PageInfo pageInfo = this.taskStatisticsService.findMembersByCompanyIdAndDate(companyId, date, departmentId, pageNo, pageSize);
        return ResultModel.suc((Object)pageInfo, (String)languageType);
    }

    @GetMapping(value={"/company/statistics/{companyId}"})
    @ApiOperation(value="\u9879\u76ee\u7edf\u8ba1-\u9879\u76ee\u6c47\u603b\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="currentUser", value="\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body"), @ApiImplicitParam(name="companyId", value="\u516c\u53f8id", required=true, dataType="long", paramType="path")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<ProjectStatistics> getMemberProjectDetail(@LanguageType String languageType, @CurrentUser User currentUser, @PathVariable Long companyId) {
        if (StringUtils.isEmpty((Object)companyId)) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        return ResultModel.suc((Object)this.projectStatisticsService.findByCompanyId(companyId), (String)languageType);
    }

    @GetMapping(value={"/project/statistics/{companyId}"})
    @ApiOperation(value="\u9879\u76ee\u7edf\u8ba1-\u9879\u76ee\u8fdb\u5ea6")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="currentUser", value="\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body"), @ApiImplicitParam(name="companyId", value="\u516c\u53f8id", required=true, dataType="long", paramType="path"), @ApiImplicitParam(name="pageNo", value="\u9875\u7801", required=false, dataType="int", paramType="query"), @ApiImplicitParam(name="pageSize", value="\u663e\u793a\u6570\u91cf", required=false, dataType="int", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<PageInfo<ProjectStatistics>> getMemberProjectDetail(@LanguageType String languageType, @CurrentUser User currentUser, @PathVariable Long companyId, Integer pageNo, Integer pageSize) {
        if (StringUtils.isEmpty((Object)companyId)) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        PageInfo pageInfo = this.projectStatisticsService.findProjectsByCompanyId(companyId, pageNo, pageSize);
        return ResultModel.suc((Object)pageInfo, (String)languageType);
    }

    @GetMapping(value={"/MemberStatistics/{companyId}"})
    @ApiOperation(value="\u6210\u5458\u62a5\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="companyId", value="\u516c\u53f8id", required=true, dataType="long", paramType="path"), @ApiImplicitParam(name="departmentId", value="\u90e8\u95e8Id", required=false, dataType="long", paramType="query"), @ApiImplicitParam(name="intervalType", value="\u65f6\u95f4\u7c7b\u578b(\u65e5:0,\u6708:1,\u5e74:2) ", required=false, dataType="Integer", paramType="query"), @ApiImplicitParam(name="startTime", value="\u5f00\u59cb\u65f6\u95f4", required=false, dataType="String", paramType="query"), @ApiImplicitParam(name="endTime", value="\u7ed3\u675f\u65f6\u95f4", required=false, dataType="String", paramType="query"), @ApiImplicitParam(name="pageNo", value="\u9875\u7801", required=false, dataType="Integer", paramType="query"), @ApiImplicitParam(name="pageSize", value="\u6bcf\u9875\u663e\u793a\u6570\u91cf", required=false, dataType="Integer", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel getMemberStatistics(@LanguageType String languageType, @PathVariable Long companyId, Long departmentId, Integer intervalType, String startTime, String endTime, Integer pageNo, Integer pageSize) throws ParseException {
        if (StringUtils.isEmpty((Object)companyId)) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        if (StringUtils.isEmpty((Object)startTime) && StringUtils.isEmpty((Object)endTime) && StringUtils.isEmpty((Object)intervalType)) {
            Date yesterday = DateUtils.addDateNum((Date)new Date(), (int)-1);
            startTime = DateUtils.formatDate((Date)yesterday, (Object[])new Object[0]);
            endTime = DateUtils.formatDate((Date)yesterday, (Object[])new Object[0]);
            intervalType = 1;
        }
        return ResultModel.suc((Object)this.attendanceReportUserService.findMemberStatisticsByCompany(companyId, departmentId, intervalType, startTime, endTime, pageNo, pageSize), (String)languageType);
    }
}

