/*
 * Decompiled with CFR 0.152.
 */
package com.ym.tlifang.api.controller.project;

import com.alibaba.dubbo.config.annotation.Reference;
import com.github.binarywang.java.emoji.EmojiConverter;
import com.ym.tlifang.Constants;
import com.ym.tlifang.ResultModel;
import com.ym.tlifang.ResultStatus;
import com.ym.tlifang.api.authorization.annotation.Authorization;
import com.ym.tlifang.api.authorization.annotation.CurrentUser;
import com.ym.tlifang.api.authorization.annotation.LanguageType;
import com.ym.tlifang.api.controller.BaseController;
import com.ym.tlifang.model.project.ProjectMemberAddDelModel;
import com.ym.tlifang.project.Project;
import com.ym.tlifang.project.ProjectUser;
import com.ym.tlifang.service.company.CompanyMemberInfoService;
import com.ym.tlifang.service.company.CompanyUserRelationService;
import com.ym.tlifang.service.project.ProjectService;
import com.ym.tlifang.service.project.ProjectUserService;
import com.ym.tlifang.service.system.NoticeService;
import com.ym.tlifang.service.task.TaskService;
import com.ym.tlifang.service.user.UserService;
import com.ym.tlifang.user.User;
import com.ym.tlifang.util.PasswordEncoder;
import com.ym.tlifang.util.StringUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"project"})
@Api(value="project", description="\u9879\u76ee\u76f8\u5173")
public class ProjectUserController
extends BaseController {
    @Reference
    private ProjectUserService projectUserService;
    @Reference
    private ProjectService projectService;
    @Reference
    private CompanyMemberInfoService companyMemberInfoService;
    @Reference
    private CompanyUserRelationService companyUserRelationService;
    @Reference
    private UserService userService;
    @Reference
    private TaskService taskService;
    @Reference
    private NoticeService noticeService;
    @Autowired
    private static EmojiConverter emojiConverter = EmojiConverter.getInstance();

    @PostMapping(value={"/{projectId}/member"})
    @ApiOperation(value="\u6dfb\u52a0/\u5220\u9664\u9879\u76ee\u6210\u5458")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="user", value="\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body"), @ApiImplicitParam(name="projectId", value="\u9879\u76eeid", required=true, dataType="Long", paramType="path")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<Project> addDelMember(@CurrentUser User user, @PathVariable Long projectId, @RequestBody ProjectMemberAddDelModel projectMemberAddDelModel, @LanguageType String languageType) {
        if (StringUtils.isEmpty((Object)projectId) || StringUtils.isEmpty((Object)projectMemberAddDelModel.getCompanyId()) || projectMemberAddDelModel.getCompanyId() == 0L) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        Project project = this.projectService.findByCompanyIdAndProjectId(projectMemberAddDelModel.getCompanyId(), projectId);
        if (project == null) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        this.projectUserService.updateAddAndDelProjectMember(user, projectMemberAddDelModel, project, languageType);
        project = this.projectUserService.findByCompanyIdAndProjectId(projectMemberAddDelModel.getCompanyId(), project.getId(), project);
        project.setName(emojiConverter.toUnicode(project.getName()));
        project.setDescription(emojiConverter.toUnicode(StringUtils.isEmpty((Object)project.getDescription()) ? "" : project.getDescription()));
        return ResultModel.suc((Object)project);
    }

    @DeleteMapping(value={"/{projectId}/delmember"})
    @ApiOperation(value="\u6210\u5458\u9000\u51fa\u9879\u76ee")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="user", value="\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body"), @ApiImplicitParam(name="projectId", value="\u9879\u76eeid", required=true, dataType="Long", paramType="path")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<Project> delMember(@CurrentUser User user, @PathVariable Long projectId, @LanguageType String languageType) {
        if (StringUtils.isEmpty((Object)projectId)) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        Project project = this.projectService.findByProjectId(projectId);
        if (project == null) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        ProjectUser projectUser = this.projectUserService.findByUserIdAndProjectIdAndDelFlagFalse(user.getId(), project.getId(), languageType);
        if (projectUser == null) {
            return ResultModel.error((ResultStatus)ResultStatus.PROJECTMEMBER_NO_EXIST, (String)languageType);
        }
        if (projectUser.getType().equals(Constants.TypeStatus.projectOwner.getType())) {
            return ResultModel.error((ResultStatus)ResultStatus.PROJECTINFO_OWNER, (String)languageType);
        }
        this.projectUserService.deleteProjectUser(projectUser);
        return ResultModel.ok();
    }

    @PutMapping(value={"/{projectId}/manager/{userId}"})
    @ApiOperation(value="\u8bbe\u7f6e\u7ba1\u7406\u5458")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="user", value="\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body"), @ApiImplicitParam(name="projectId", value="\u9879\u76eeid", required=true, dataType="Long", paramType="path"), @ApiImplicitParam(name="userId", value="\u7528\u6237id", required=true, dataType="Long", paramType="path")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<Project> memberProject(@CurrentUser User user, @PathVariable Long projectId, @PathVariable Long userId, @LanguageType String languageType) {
        if (StringUtils.isEmpty((Object)projectId) || StringUtils.isEmpty((Object)userId)) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        ProjectUser projectUser = this.projectUserService.findByUserIdAndProjectIdAndDelFlagFalse(userId, projectId, languageType);
        if (projectUser == null) {
            return ResultModel.error((ResultStatus)ResultStatus.PROJECTMEMBER_NO_EXIST, (String)languageType);
        }
        if (projectUser.getType().equals(Constants.TypeStatus.projectOwner.getType())) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        Project project = this.projectService.findByOwnerIdAndCompanyIdAndId(user.getId(), projectUser.getCompanyId(), projectId);
        if (StringUtils.isEmpty((Object)project)) {
            return ResultModel.error((ResultStatus)ResultStatus.PROJECTINFO_OWNER_NO_EXIST, (String)languageType);
        }
        ResultModel projectResultModel = this.projectUserService.updateProjectManager(user, projectUser);
        projectUser = (ProjectUser)projectResultModel.getData();
        project = this.projectService.findByProjectId(projectUser.getProjectId());
        project = this.projectUserService.findByCompanyIdAndProjectId(projectUser.getCompanyId(), projectUser.getProjectId(), project);
        project.setName(emojiConverter.toUnicode(project.getName()));
        project.setDescription(emojiConverter.toUnicode(StringUtils.isEmpty((Object)project.getDescription()) ? "" : project.getDescription()));
        return ResultModel.suc((Object)project);
    }

    @PutMapping(value={"/{projectId}/status"})
    @ApiOperation(value="\u9879\u76ee\u8fdb\u884c\u72b6\u6001")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="user", value="\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body"), @ApiImplicitParam(name="projectId", value="\u9879\u76eeid", required=true, dataType="Long", paramType="path")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<Project> statuesProject(@CurrentUser User user, @PathVariable Long projectId, @RequestBody ProjectMemberAddDelModel projectMemberAddDelModel, @LanguageType String languageType) {
        ProjectUser projectUser;
        if (StringUtils.isEmpty((Object)projectMemberAddDelModel.getStatus())) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        String status = projectMemberAddDelModel.getStatus();
        if (Constants.ProjectStatus.projectAccomplish.getType().equals(status) || Constants.ProjectStatus.projectDiscontinue.getType().equals(status)) {
            if (StringUtils.isEmpty((Object)projectMemberAddDelModel.getPassword())) {
                return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
            }
            String encryptPassword = PasswordEncoder.encrypt((String)projectMemberAddDelModel.getPassword(), (String)"ym2018");
            if (!user.getPassword().equals(encryptPassword)) {
                return ResultModel.error((ResultStatus)ResultStatus.PASSWORD_ERROR, (String)languageType);
            }
        }
        if ((projectUser = this.projectUserService.findByUserIdAndProjectIdAndDelFlagFalse(user.getId(), projectId, languageType)) == null) {
            return ResultModel.error((ResultStatus)ResultStatus.PROJECTMEMBER_NO_EXIST, (String)languageType);
        }
        if (projectUser.getType().equals(Constants.TypeStatus.projectOrdinaryMember.getType())) {
            return ResultModel.error((ResultStatus)ResultStatus.PROJECTINFO_NO_LIMITS, (String)languageType);
        }
        Project project = this.projectService.findByProjectId(projectId);
        if (project == null) {
            return ResultModel.error((ResultStatus)ResultStatus.PROJECT_NO_EXIST, (String)languageType);
        }
        ResultModel projectResultModel = this.projectService.updateProjectStatus(user, project, projectMemberAddDelModel, languageType);
        project = (Project)projectResultModel.getData();
        project = this.projectService.findByProjectId(project.getId());
        project.setName(emojiConverter.toUnicode(project.getName()));
        project.setDescription(emojiConverter.toUnicode(StringUtils.isEmpty((Object)project.getDescription()) ? "" : project.getDescription()));
        return ResultModel.suc((Object)project);
    }
}

