/*
 * Decompiled with CFR 0.152.
 */
package com.ym.tlifang.api.controller.meeting;

import com.alibaba.dubbo.config.annotation.Reference;
import com.ym.tlifang.ResultModel;
import com.ym.tlifang.ResultStatus;
import com.ym.tlifang.api.authorization.annotation.Authorization;
import com.ym.tlifang.api.authorization.annotation.LanguageType;
import com.ym.tlifang.api.controller.BaseController;
import com.ym.tlifang.meeting.MeetingRoomEntity;
import com.ym.tlifang.service.meeting.MeetingRoomService;
import com.ym.tlifang.util.StringUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"meetingRoom"})
@Api(value="meetingRoom", description="\u4f1a\u8bae\u5ba4")
public class MeetingRoomController
extends BaseController {
    @Reference
    MeetingRoomService meetingRoomService;

    @PostMapping
    @ApiOperation(value="\u66f4\u65b0\u4f1a\u8bae\u5ba4")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<MeetingRoomEntity> addMeeting(@LanguageType String languageType, @RequestBody MeetingRoomEntity roomEntity) {
        if (StringUtils.isEmpty((Object)roomEntity) || StringUtils.isEmpty((Object)roomEntity.getCompanyId()) || StringUtils.isEmpty((Object)roomEntity.getName())) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        try {
            roomEntity = this.meetingRoomService.saveMeetingRoom(roomEntity);
            return ResultModel.suc((Object)roomEntity, (String)languageType);
        }
        catch (Exception e) {
            this.logger.info(e.getMessage());
            return ResultModel.error((ResultStatus)ResultStatus.SYS_ERROR, (String)languageType);
        }
    }

    @GetMapping(value={"/getList"})
    @ApiOperation(value="\u516c\u53f8\u4f1a\u8bae\u5ba4\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body"), @ApiImplicitParam(name="companyId", value="\u516c\u53f8id", required=true, dataType="long", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel getList(@LanguageType String languageType, Long companyId) {
        if (StringUtils.isEmpty((Object)companyId)) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        return ResultModel.suc((Object)this.meetingRoomService.findMeetingRooms(companyId), (String)languageType);
    }

    @DeleteMapping(value={"/{meetingRoomId}"})
    @ApiOperation(value="\u5220\u9664\u4f1a\u8bae\u5ba4")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body"), @ApiImplicitParam(name="meetingRoomId", value="\u4f1a\u8bae\u5ba4id", required=true, dataType="long", paramType="path")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel delete(@LanguageType String languageType, @PathVariable Long meetingRoomId) {
        if (StringUtils.isEmpty((Object)meetingRoomId)) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        return this.meetingRoomService.deleteMeetingRoom(meetingRoomId, languageType);
    }
}

