/*
 * Decompiled with CFR 0.152.
 */
package com.ym.tlifang.api.controller.company;

import com.alibaba.dubbo.config.annotation.Reference;
import com.github.binarywang.java.emoji.EmojiConverter;
import com.ym.tlifang.Constants;
import com.ym.tlifang.ResultModel;
import com.ym.tlifang.ResultStatus;
import com.ym.tlifang.api.authorization.annotation.Authorization;
import com.ym.tlifang.api.authorization.annotation.CurrentUser;
import com.ym.tlifang.api.authorization.annotation.LanguageType;
import com.ym.tlifang.api.controller.BaseController;
import com.ym.tlifang.company.Company;
import com.ym.tlifang.company.CompanyMemberInfo;
import com.ym.tlifang.company.CompanyUserRelation;
import com.ym.tlifang.model.company.CompanyInformationModel;
import com.ym.tlifang.model.company.CompanyModel;
import com.ym.tlifang.model.company.CompanyOwnerModel;
import com.ym.tlifang.model.company.DepartmentAddDelModel;
import com.ym.tlifang.model.company.PositionAddDel;
import com.ym.tlifang.service.attendance.AttendanceUserService;
import com.ym.tlifang.service.company.CompanyMemberInfoService;
import com.ym.tlifang.service.company.CompanyPositionService;
import com.ym.tlifang.service.company.CompanyService;
import com.ym.tlifang.service.company.CompanyUserRelationService;
import com.ym.tlifang.service.project.ProjectService;
import com.ym.tlifang.service.system.DictionaryService;
import com.ym.tlifang.service.user.UserService;
import com.ym.tlifang.system.Dictionary;
import com.ym.tlifang.user.User;
import com.ym.tlifang.util.PasswordEncoder;
import com.ym.tlifang.util.StringUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"company"})
@Api(value="company", description="\u56e2\u961f\u76f8\u5173")
public class CompanyController
extends BaseController {
    @Reference(timeout=6000)
    private CompanyService companyService;
    @Reference
    private CompanyMemberInfoService companyMemberInfoService;
    @Reference
    private CompanyUserRelationService companyUserRelationService;
    @Reference
    private UserService userService;
    @Reference
    private ProjectService projectService;
    @Reference
    private CompanyPositionService companyPositionService;
    @Reference
    private DictionaryService dictionaryService;
    @Reference
    private AttendanceUserService attendanceUserService;
    @Autowired
    private static EmojiConverter emojiConverter = EmojiConverter.getInstance();

    @PostMapping
    @ApiOperation(value="\u521b\u5efa\u56e2\u961f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="user", value="\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<Company> createCompany(@CurrentUser User user, @RequestBody Company company, @LanguageType String languageType) {
        if (StringUtils.isEmpty((Object)company.getName()) || StringUtils.isEmpty((Object)company.getCity()) || StringUtils.isEmpty((Object)company.getProvince()) || StringUtils.isEmpty((Object)company.getIndustry()) || StringUtils.isEmpty((Object)company.getDistrict())) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        int ownerCount = this.companyService.findByOwnerId(user.getId());
        if (ownerCount > 0) {
            return ResultModel.error((ResultStatus)ResultStatus.COMPANY_CAP, (String)languageType);
        }
        List companyLogoType = this.dictionaryService.findByApplicationTypeAndDelFlagFalse("companylogo_type");
        if (companyLogoType == null) {
            return ResultModel.error((ResultStatus)ResultStatus.PCOMPANYI_LOGO_NO_EXIST, (String)languageType);
        }
        company = this.companyService.createCompany(user, company, ((Dictionary)companyLogoType.get(0)).getLabelCh(), languageType);
        int CompanyCount = this.companyMemberInfoService.findByCompanyCount(user.getId());
        if (CompanyCount == 0) {
            return ResultModel.error((ResultStatus)ResultStatus.COMPANYMEMBERS_NO_EXIST, (String)languageType);
        }
        if (CompanyCount == 1) {
            user.setCurrentCompany(company.getId());
            this.userService.save(user);
        }
        company.setName(emojiConverter.toUnicode(company.getName()));
        company.setDescription(emojiConverter.toUnicode(StringUtils.isEmpty((Object)company.getDescription()) ? "" : company.getDescription()));
        CompanyOwnerModel ownerModel = new CompanyOwnerModel(company.getOwnerId(), user.getName(), user.getAvatar());
        company.setOwnerModel(ownerModel);
        return ResultModel.suc((Object)company);
    }

    @PutMapping(value={"/{companyId}/info"})
    @ApiOperation(value="\u4fee\u6539\u516c\u53f8\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="user", value="\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body"), @ApiImplicitParam(name="companyId", value="\u516c\u53f8id", required=true, dataType="Long", paramType="path")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<Company> updateCompanyInfo(@CurrentUser User user, @PathVariable Long companyId, @RequestBody Company company, @LanguageType String languageType) {
        if (StringUtils.isEmpty((Object)companyId)) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        Company companyInfo = this.companyService.findById(companyId);
        if (StringUtils.isEmpty((Object)companyInfo)) {
            return ResultModel.error((ResultStatus)ResultStatus.COMPANY_NO_EXIST, (String)languageType);
        }
        CompanyMemberInfo companyMemberInfo = this.companyMemberInfoService.findByCompanyIdAndUserIdAndStatus(companyId, user.getId(), Constants.AuditStatus.adopt.getType());
        if (companyMemberInfo == null) {
            return ResultModel.error((ResultStatus)ResultStatus.COMPANYMEMBERS_NO_EXIST, (String)languageType);
        }
        if (companyMemberInfo.getManager().equals(Constants.ManagerStatus.companyOrdinaryMember.getType())) {
            return ResultModel.error((ResultStatus)ResultStatus.COMPANY_NO_MAMNAGER, (String)languageType);
        }
        ResultModel companyResultModel = this.companyService.updateCompany(company, companyInfo);
        return companyResultModel;
    }

    @PutMapping
    @ApiOperation(value="\u8f6c\u8ba9\u56e2\u961f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="user", value="\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<Company> shiftCompany(@CurrentUser User user, @RequestBody CompanyModel companyModel, @LanguageType String languageType) {
        if (StringUtils.isEmpty((Object)companyModel.getCompanyId()) || StringUtils.isEmpty((Object)companyModel.getUserId()) || StringUtils.isEmpty((Object)companyModel.getPassword())) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        String encryptPassword = PasswordEncoder.encrypt((String)companyModel.getPassword(), (String)"ym2018");
        if (!user.getPassword().equals(encryptPassword)) {
            return ResultModel.error((ResultStatus)ResultStatus.PASSWORD_ERROR, (String)languageType);
        }
        Company company = this.companyService.findByOwnerIdAndId(user.getId(), companyModel.getCompanyId());
        if (company == null) {
            return ResultModel.error((ResultStatus)ResultStatus.COMPANY_NO_EXIST, (String)languageType);
        }
        if (company.getOwnerId().equals(companyModel.getUserId())) {
            return ResultModel.error((ResultStatus)ResultStatus.COMPANY_IS_OWNER, (String)languageType);
        }
        CompanyMemberInfo companyMemberInfo = this.companyMemberInfoService.findByCompanyIdAndUserIdAndStatus(companyModel.getCompanyId(), companyModel.getUserId(), Constants.AuditStatus.adopt.getType());
        if (companyMemberInfo == null) {
            return ResultModel.error((ResultStatus)ResultStatus.COMPANYMEMBERS_NO_EXIST, (String)languageType);
        }
        ResultModel companyResultModel = this.companyService.updateCompanyShift(user, company, companyModel, companyMemberInfo, languageType);
        return companyResultModel;
    }

    @DeleteMapping
    @ApiOperation(value="\u5220\u9664\u56e2\u961f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="user", value="\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body"), @ApiImplicitParam(name="companyId", value="\u516c\u53f8id", required=true, dataType="Long", paramType="query"), @ApiImplicitParam(name="password", value="\u5bc6\u7801", required=true, dataType="string", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<Company> delCompany(@CurrentUser User user, Long companyId, String password, @LanguageType String languageType) {
        if (StringUtils.isEmpty((Object)companyId) || StringUtils.isEmpty((Object)password)) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        String encryptPassword = PasswordEncoder.encrypt((String)password, (String)"ym2018");
        if (!user.getPassword().equals(encryptPassword)) {
            return ResultModel.error((ResultStatus)ResultStatus.PASSWORD_ERROR, (String)languageType);
        }
        Company company = this.companyService.findByOwnerIdAndId(user.getId(), companyId);
        if (company == null) {
            return ResultModel.error((ResultStatus)ResultStatus.COMPANY_NO_EXIST, (String)languageType);
        }
        ResultModel companyResultModel = this.companyService.deleteCompany(company, user, languageType);
        return companyResultModel;
    }

    @PostMapping(value={"/{companyId}/department/{departmentId}/user/{userId}"})
    @ApiOperation(value="\u6dfb\u52a0\u90e8\u95e8")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="user", value="\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body"), @ApiImplicitParam(name="companyId", value="\u516c\u53f8id", required=true, dataType="Long", paramType="path"), @ApiImplicitParam(name="departmentId", value="\u7236\u90e8\u95e8id", required=true, dataType="Long", paramType="path"), @ApiImplicitParam(name="userId", value="\u7528\u6237id", required=true, dataType="Long", paramType="path")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<Company> createDepartment(@CurrentUser User user, @PathVariable Long userId, @PathVariable Long companyId, @PathVariable Long departmentId, @RequestBody PositionAddDel positionAddDel, @LanguageType String languageType) {
        if (StringUtils.isEmpty((Object)positionAddDel.getDepartmentName())) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        CompanyMemberInfo companyMember = this.companyMemberInfoService.findByCompanyIdAndUserIdAndStatus(companyId, user.getId(), Constants.AuditStatus.adopt.getType());
        if (companyMember == null) {
            return ResultModel.error((ResultStatus)ResultStatus.COMPANYMEMBERS_NO_EXIST, (String)languageType);
        }
        if (companyMember.getManager().equals(Constants.ManagerStatus.companyOrdinaryMember.getType())) {
            return ResultModel.error((ResultStatus)ResultStatus.COMPANY_NO_MAMNAGER, (String)languageType);
        }
        Company company = this.companyService.findById(companyId);
        if (company == null) {
            return ResultModel.error((ResultStatus)ResultStatus.COMPANY_NO_EXIST, (String)languageType);
        }
        Company department = this.companyService.findById(departmentId);
        if (department == null) {
            return ResultModel.error((ResultStatus)ResultStatus.DEPARTMENT_OWNER_NO_EXIST, (String)languageType);
        }
        ResultModel departmentResultModel = this.companyService.createDepartment(company, positionAddDel, department, userId, languageType);
        Company departmentData = (Company)departmentResultModel.getData();
        departmentData.setName(emojiConverter.toUnicode(departmentData.getName()));
        return ResultModel.suc((Object)departmentData);
    }

    @PutMapping(value={"/{companyId}/department/{departmentId}/member"})
    @ApiOperation(value="\u90e8\u95e8\u6dfb\u52a0/\u5220\u9664\u6210\u5458")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="user", value="\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body"), @ApiImplicitParam(name="departmentId", value="\u90e8\u95e8id", required=true, dataType="Long", paramType="path"), @ApiImplicitParam(name="companyId", value="\u516c\u53f8id", required=true, dataType="Long", paramType="path")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<List<CompanyUserRelation>> addDelDepartmentMember(@CurrentUser User user, @RequestBody DepartmentAddDelModel departmentAddDelModel, @PathVariable Long departmentId, @PathVariable Long companyId, @LanguageType String languageType) {
        if (StringUtils.isEmpty((Object)departmentId) || StringUtils.isEmpty((Object)companyId)) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        CompanyMemberInfo companyMemberInfo = this.companyMemberInfoService.findByCompanyIdAndUserIdAndStatus(companyId, user.getId(), Constants.AuditStatus.adopt.getType());
        if (companyMemberInfo == null) {
            return ResultModel.error((ResultStatus)ResultStatus.COMPANYMEMBERS_NO_EXIST, (String)languageType);
        }
        if (companyMemberInfo.getManager().equals(Constants.ManagerStatus.companyOrdinaryMember.getType())) {
            return ResultModel.error((ResultStatus)ResultStatus.COMPANY_NO_MAMNAGER, (String)languageType);
        }
        ResultModel companyResultModel = this.companyService.updateDepartmentMember(departmentAddDelModel, companyId, departmentId, languageType);
        return companyResultModel;
    }

    @GetMapping(value={"/{companyId}/structure"})
    @ApiOperation(value="\u83b7\u53d6\u516c\u53f8\u7ec4\u7ec7\u67b6\u6784")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="user", value="\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body"), @ApiImplicitParam(name="companyId", value="\u516c\u53f8id", required=true, dataType="Long", paramType="path")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<Company> getStructure(@CurrentUser User user, @PathVariable Long companyId, @LanguageType String languageType) {
        CompanyMemberInfo companyMemberInfo = this.companyMemberInfoService.findByCompanyIdAndUserIdAndStatus(companyId, user.getId(), Constants.AuditStatus.adopt.getType());
        if (companyMemberInfo == null) {
            return ResultModel.error((ResultStatus)ResultStatus.COMPANYMEMBERS_NO_EXIST, (String)languageType);
        }
        Company company = this.companyService.findById(companyId);
        if (company == null) {
            return ResultModel.error((ResultStatus)ResultStatus.COMPANY_NO_EXIST, (String)languageType);
        }
        company.setName(emojiConverter.toUnicode(company.getName()));
        List companyUserRelations = this.companyUserRelationService.findAllByCompanyId(companyId);
        company.setMembers(companyUserRelations);
        List companyPositions = this.companyPositionService.findByCompanyIdAndDepartmentId(companyId, companyId);
        company.setPositions(new HashSet(companyPositions));
        return ResultModel.suc((Object)company);
    }

    @PutMapping(value={"/{companyId}/department/{departmentId}/user/{userId}"})
    @ApiOperation(value="\u4fee\u6539\u90e8\u95e8")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="user", value="\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body"), @ApiImplicitParam(name="companyId", value="\u516c\u53f8id", required=true, dataType="Long", paramType="path"), @ApiImplicitParam(name="departmentId", value="\u90e8\u95e8id", required=true, dataType="Long", paramType="path"), @ApiImplicitParam(name="userId", value="\u4e3b\u7ba1\u7528\u6237id", required=true, dataType="Long", paramType="path")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel modifyDepartment(@CurrentUser User user, @PathVariable Long companyId, @PathVariable Long departmentId, @PathVariable Long userId, @RequestBody Company updateDepartment, @LanguageType String languageType) {
        if (StringUtils.isEmpty((Object)companyId) || StringUtils.isEmpty((Object)departmentId) || StringUtils.isEmpty((Object)userId)) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        Company departmentInfo = this.companyService.findByDepartmentId(departmentId);
        if (departmentInfo == null) {
            return ResultModel.error((ResultStatus)ResultStatus.DEPARTMENT_OWNER_NO_EXIST, (String)languageType);
        }
        CompanyMemberInfo companyMemberInfo = this.companyMemberInfoService.findByCompanyIdAndUserIdAndStatus(companyId, user.getId(), Constants.AuditStatus.adopt.getType());
        if (companyMemberInfo == null) {
            return ResultModel.error((ResultStatus)ResultStatus.COMPANYMEMBERS_NO_EXIST, (String)languageType);
        }
        if (companyMemberInfo.getManager().equals(Constants.ManagerStatus.companyOrdinaryMember.getType())) {
            return ResultModel.error((ResultStatus)ResultStatus.COMPANY_NO_MAMNAGER, (String)languageType);
        }
        CompanyMemberInfo companyMemberInfoUser = this.companyMemberInfoService.findByCompanyIdAndUserIdAndStatus(companyId, userId, Constants.AuditStatus.adopt.getType());
        if (companyMemberInfoUser == null) {
            return ResultModel.error((ResultStatus)ResultStatus.COMPANYMEMBERS_NO_EXIST, (String)languageType);
        }
        ResultModel companyResultModel = this.companyService.updateDepartment(companyId, departmentId, userId, departmentInfo, updateDepartment, languageType);
        return companyResultModel;
    }

    @DeleteMapping(value={"/{companyId}/department/{departmentId}"})
    @ApiOperation(value="\u79fb\u9664\u90e8\u95e8")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="user", value="\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body"), @ApiImplicitParam(name="companyId", value="\u516c\u53f8id", required=true, dataType="Long", paramType="path"), @ApiImplicitParam(name="departmentId", value="\u90e8\u95e8id", required=true, dataType="Long", paramType="path")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<Company> delDepartment(@CurrentUser User user, @PathVariable Long companyId, @PathVariable Long departmentId, @LanguageType String languageType) {
        if (StringUtils.isEmpty((Object)departmentId) || StringUtils.isEmpty((Object)companyId)) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        Company company = this.companyService.findByDepartmentId(departmentId);
        if (StringUtils.isEmpty((Object)company)) {
            return ResultModel.error((ResultStatus)ResultStatus.DEPARTMENT_OWNER_NO_EXIST, (String)languageType);
        }
        CompanyMemberInfo companyMemberInfo = this.companyMemberInfoService.findByCompanyIdAndUserIdAndStatus(companyId, user.getId(), Constants.AuditStatus.adopt.getType());
        if (companyMemberInfo == null) {
            return ResultModel.error((ResultStatus)ResultStatus.COMPANYMEMBERS_NO_EXIST, (String)languageType);
        }
        if (companyMemberInfo.getManager().equals(Constants.ManagerStatus.companyOrdinaryMember.getType())) {
            return ResultModel.error((ResultStatus)ResultStatus.COMPANY_NO_MAMNAGER, (String)languageType);
        }
        ResultModel companyResultModel = this.companyService.deleteDepartment(companyId, departmentId, languageType);
        return companyResultModel;
    }

    @GetMapping(value={"/list"})
    @ApiOperation(value="\u516c\u53f8\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="user", value="\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<List<Company>> companyList(@CurrentUser User user, @LanguageType String languageType) {
        ArrayList<Company> companyList = new ArrayList<Company>();
        List companyMemberInfos = this.companyMemberInfoService.findByUserIdAndStatus(user.getId(), Constants.AuditStatus.adopt.getType());
        if (StringUtils.isEmpty((Object)companyMemberInfos)) {
            return ResultModel.error((ResultStatus)ResultStatus.COMPANYMEMBERS_NO_EXIST, (String)languageType);
        }
        for (CompanyMemberInfo memberInfo : companyMemberInfos) {
            memberInfo.getCompany().setName(emojiConverter.toUnicode(memberInfo.getCompany().getName()));
            memberInfo.getCompany().setDescription(emojiConverter.toUnicode(StringUtils.isEmpty((Object)memberInfo.getCompany().getDescription()) ? "" : memberInfo.getCompany().getDescription()));
            companyList.add(memberInfo.getCompany());
        }
        return ResultModel.suc(companyList);
    }

    @GetMapping(value={"/{companyId}/info"})
    @ApiOperation(value="\u516c\u53f8\u8be6\u60c5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="user", value="\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body"), @ApiImplicitParam(name="companyId", value="\u516c\u53f8id", required=true, dataType="Long", paramType="path")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<Company> companyInfo(@CurrentUser User user, @PathVariable Long companyId, @LanguageType String languageType) {
        if (StringUtils.isEmpty((Object)companyId)) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        if (companyId == -1L) {
            user.setCurrentCompany(null);
            this.userService.save(user);
            return ResultModel.ok();
        }
        CompanyMemberInfo companyMemberInfo = this.companyMemberInfoService.findByCompanyIdAndUserIdAndStatus(companyId, user.getId(), Constants.AuditStatus.adopt.getType());
        if (companyMemberInfo == null) {
            return ResultModel.error((ResultStatus)ResultStatus.COMPANYMEMBERS_NO_EXIST, (String)languageType);
        }
        Company company = this.companyService.findById(companyId);
        if (company == null) {
            return ResultModel.error((ResultStatus)ResultStatus.COMPANY_NO_EXIST, (String)languageType);
        }
        User userOwner = this.userService.findById(company.getOwnerId());
        if (userOwner == null) {
            return ResultModel.error((ResultStatus)ResultStatus.ACCOUNT_NO_EXIST, (String)languageType);
        }
        CompanyOwnerModel companyOwnerModel = new CompanyOwnerModel(userOwner.getId(), userOwner.getName(), userOwner.getAvatar());
        company.setOwnerModel(companyOwnerModel);
        company.setName(emojiConverter.toUnicode(company.getName()));
        company.setDescription(emojiConverter.toUnicode(StringUtils.isEmpty((Object)company.getDescription()) ? "" : company.getDescription()));
        company.setManager(companyMemberInfo.getManager());
        if (!companyId.equals(user.getCurrentCompany())) {
            user.setCurrentCompany(companyId);
            this.userService.save(user);
        }
        return ResultModel.suc((Object)company);
    }

    @GetMapping(value={"/{companyId}/information"})
    @ApiOperation(value="\u56e2\u961f\u8bbe\u7f6e\u603b\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="user", value="\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body"), @ApiImplicitParam(name="companyId", value="\u516c\u53f8id", required=true, dataType="Long", paramType="path")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<CompanyInformationModel> companyInformation(@CurrentUser User user, @PathVariable Long companyId, @LanguageType String languageType) {
        if (StringUtils.isEmpty((Object)companyId)) {
            return ResultModel.error((ResultStatus)ResultStatus.COMPANY_NO_EXIST, (String)languageType);
        }
        CompanyMemberInfo companyMemberInfo = this.companyMemberInfoService.findByCompanyIdAndUserIdAndStatus(companyId, user.getId(), Constants.AuditStatus.adopt.getType());
        if (StringUtils.isEmpty((Object)companyMemberInfo)) {
            return ResultModel.error((ResultStatus)ResultStatus.COMPANYMEMBERS_NO_EXIST, (String)languageType);
        }
        ResultModel companyInformationModelResultModel = this.companyService.queryCompanyInformation(companyId, languageType);
        return companyInformationModelResultModel;
    }
}

