/*
 * Decompiled with CFR 0.152.
 */
package com.ym.tlifang.api.controller.attendance;

import com.alibaba.dubbo.config.annotation.Reference;
import com.ym.tlifang.Constants;
import com.ym.tlifang.ResultModel;
import com.ym.tlifang.ResultStatus;
import com.ym.tlifang.api.authorization.annotation.Authorization;
import com.ym.tlifang.api.authorization.annotation.CurrentUser;
import com.ym.tlifang.api.authorization.annotation.LanguageType;
import com.ym.tlifang.api.controller.BaseController;
import com.ym.tlifang.attendance.AttendanceClasses;
import com.ym.tlifang.attendance.AttendanceHolidays;
import com.ym.tlifang.attendance.AttendanceTime;
import com.ym.tlifang.attendance.AttendanceUser;
import com.ym.tlifang.attendance.AttendanceUserRecord;
import com.ym.tlifang.attendance.AttendanceWeekday;
import com.ym.tlifang.attendance.AttendanceWorkday;
import com.ym.tlifang.model.attendance.AttendanceModel;
import com.ym.tlifang.model.attendance.AttendancePersonalDetailModel;
import com.ym.tlifang.service.attendance.AttendanceClassesService;
import com.ym.tlifang.service.attendance.AttendanceHolidaysService;
import com.ym.tlifang.service.attendance.AttendanceReportUserService;
import com.ym.tlifang.service.attendance.AttendanceTimeService;
import com.ym.tlifang.service.attendance.AttendanceUserRecordService;
import com.ym.tlifang.service.attendance.AttendanceUserService;
import com.ym.tlifang.service.attendance.AttendanceWeekdayService;
import com.ym.tlifang.service.attendance.AttendanceWifiService;
import com.ym.tlifang.service.attendance.AttendanceWorkdayService;
import com.ym.tlifang.service.company.CompanyService;
import com.ym.tlifang.service.company.CompanyUserRelationService;
import com.ym.tlifang.service.user.UserService;
import com.ym.tlifang.user.User;
import com.ym.tlifang.util.DateUtils;
import com.ym.tlifang.util.JsonUtil;
import com.ym.tlifang.util.StringUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"attendanceRecord"})
@Api(value="attendanceRecord", description="\u8003\u52e4\u8bb0\u5f55")
public class AttendanceUserRecordController
extends BaseController {
    @Reference
    private AttendanceUserService attendanceUserService;
    @Reference
    private AttendanceWorkdayService attendanceWorkdayService;
    @Reference
    private AttendanceTimeService attendanceTimeService;
    @Reference(timeout=30000, retries=-1)
    private AttendanceUserRecordService attendanceUserRecordService;
    @Reference
    private UserService userService;
    @Reference
    private AttendanceClassesService attendanceClassesService;
    @Reference
    private AttendanceWeekdayService attendanceWeekdayService;
    @Reference
    private CompanyUserRelationService companyUserRelationService;
    @Reference
    private CompanyService companyService;
    @Reference
    private AttendanceWifiService attendanceWifiService;
    @Reference
    private AttendanceReportUserService attendanceReportUserService;
    @Reference
    private AttendanceHolidaysService attendanceHolidaysService;

    @PostMapping
    @ApiOperation(value="\u8003\u52e4\u6253\u5361")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="companyId", value="\u516c\u53f8id", required=true, dataType="Long", paramType="query"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<AttendanceUserRecord> addRecord(@LanguageType String languageType, @CurrentUser User currentUser, HttpServletRequest request, Long companyId) throws ParseException {
        if (companyId == null) {
            companyId = currentUser.getCurrentCompany();
        }
        AttendanceUserRecord attendanceUserRecord = new AttendanceUserRecord();
        attendanceUserRecord.setUserId(currentUser.getId());
        AttendanceUser attendanceUser = this.attendanceUserService.findByUserIdAndDelFlagFalse(currentUser.getId(), companyId);
        if (attendanceUser == null) {
            return ResultModel.error((ResultStatus)ResultStatus.ATTENDCLASSES_NO_EXIST, (String)languageType);
        }
        AttendanceClasses attendanceClasses = this.attendanceClassesService.findByIdAndStatusTrue(attendanceUser.getClassesId());
        if (attendanceClasses == null) {
            return ResultModel.error((ResultStatus)ResultStatus.ATTENDCLASSES_NO_EXIST, (String)languageType);
        }
        String platform = request.getHeader("platform");
        if (platform == null) {
            return ResultModel.error((ResultStatus)ResultStatus.ATTENDENCE_RECORD, (String)languageType);
        }
        if (!attendanceClasses.getComputer().booleanValue() && "3".equals(platform)) {
            return ResultModel.error((ResultStatus)ResultStatus.ATTENDENCE_WEB, (String)languageType);
        }
        if (!attendanceClasses.getPhone().booleanValue() && ("1".equals(platform) || "2".equals(platform))) {
            return ResultModel.error((ResultStatus)ResultStatus.ATTENDENCE_APP, (String)languageType);
        }
        if ("3".equals(platform)) {
            attendanceUserRecord.setPcRecord(Boolean.valueOf(true));
        }
        Integer before = 0;
        Integer after = 0;
        attendanceUserRecord.setCompanyId(companyId);
        Date date = new Date();
        List timeList = this.attendanceWeekdayService.findByTypeTwo(attendanceUser.getClassesId(), date);
        ArrayList<String> attendanceTimes = new ArrayList<String>();
        if (StringUtils.isEmpty((Object)timeList) || timeList.size() == 0) {
            AttendanceHolidays attendanceHolidays;
            if (attendanceClasses.getLegal().booleanValue() && (attendanceHolidays = this.attendanceHolidaysService.findByDate(DateUtils.getDate())) != null) {
                return ResultModel.error((ResultStatus)ResultStatus.ATTENDWORKDAY_NO_EXIST, (String)languageType);
            }
            AttendanceWorkday attendanceWorkday = this.attendanceWorkdayService.findByClassesId(attendanceUser.getClassesId(), date);
            if (attendanceWorkday == null) {
                return ResultModel.error((ResultStatus)ResultStatus.ATTENDWORKDAY_NO_EXIST, (String)languageType);
            }
            before = attendanceWorkday.getBeforeTime() == null ? 0 : attendanceWorkday.getBeforeTime();
            after = attendanceWorkday.getAfterTime() == null ? 0 : attendanceWorkday.getAfterTime();
            List attendanceTimeList = attendanceWorkday.getAttendanceTimeList();
            for (AttendanceTime attendanceTime : attendanceTimeList) {
                attendanceTimes.add(attendanceTime.getBegin());
                attendanceTimes.add(attendanceTime.getEnd());
            }
        } else {
            for (Map map : timeList) {
                attendanceTimes.add(map.get("begin").toString());
                attendanceTimes.add(map.get("end").toString());
            }
        }
        SimpleDateFormat dateFm = new SimpleDateFormat("yyyy-MM-dd");
        String attendanceDate = dateFm.format(date);
        attendanceUserRecord.setAttendanceDate(attendanceDate);
        dateFm = new SimpleDateFormat("HH:mm:ss");
        String time = dateFm.format(date);
        attendanceUserRecord.setTime(time);
        Integer degree = this.attendanceUserRecordService.findDegree(currentUser.getId(), companyId, attendanceDate);
        if (degree >= attendanceTimes.size()) {
            return ResultModel.error((ResultStatus)ResultStatus.ATTENDRECORDNO_EXIST, (String)languageType);
        }
        List strings = this.attendanceUserRecordService.findStatusAndType(currentUser.getId(), attendanceTimes, date, degree, companyId, before, after);
        if (strings == null) {
            return ResultModel.error((ResultStatus)ResultStatus.ATTENDANCE_TIME_NOT_REACH, (String)languageType);
        }
        attendanceUserRecord.setNextType((String)strings.get(0));
        attendanceUserRecord.setStatus((String)strings.get(1));
        attendanceUserRecord.setSignResult((String)strings.get(2));
        attendanceUserRecord.setThroughTime(StringUtils.isEmpty(strings.get(3)) ? null : Integer.valueOf((String)strings.get(3)));
        attendanceUserRecord.setSignTime((String)attendanceTimes.get(degree));
        attendanceUserRecord = this.attendanceUserRecordService.save(attendanceUserRecord);
        attendanceUserRecord.setAllTimes(Integer.valueOf(degree + 2));
        return ResultModel.suc((Object)attendanceUserRecord, (String)languageType);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/{companyId}"})
    @ApiOperation(value="\u8003\u52e4\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="companyId", value="\u516c\u53f8id", required=true, dataType="Long", paramType="path"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<List<AttendanceUserRecord>> getOne(@LanguageType String languageType, @PathVariable Long companyId) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        List attendanceUserRecordList = this.attendanceUserRecordService.findByCompanyIdDate(companyId, sdf.format(new Date()));
        for (AttendanceUserRecord attendanceUserRecord : attendanceUserRecordList) {
            User user = this.userService.findOne(attendanceUserRecord.getUserId());
            attendanceUserRecord.setName(user.getName());
        }
        return ResultModel.suc((Object)attendanceUserRecordList, (String)languageType);
    }

    @RequestMapping(method={RequestMethod.GET})
    @ApiOperation(value="\u5f53\u65e5\u8003\u52e4\u65f6\u95f4")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<AttendanceModel> getList(@LanguageType String languageType, @CurrentUser User currentUser) throws Exception {
        AttendanceHolidays attendanceHolidays;
        AttendanceWeekday attendanceWeekday;
        Date date = new Date();
        AttendanceUser attendanceUser = this.attendanceUserService.findByUserIdAndDelFlagFalse(currentUser.getId(), currentUser.getCurrentCompany());
        if (attendanceUser == null) {
            return ResultModel.suc((Object)new AttendanceModel(Constants.AttendanceType.noClass.getType(), Constants.AttendanceType.noClass.getName(), null), (String)languageType);
        }
        AttendanceClasses attendanceClasses = this.attendanceClassesService.findByIdAndStatusTrue(attendanceUser.getClassesId());
        if (attendanceClasses == null) {
            return ResultModel.suc((Object)new AttendanceModel(Constants.AttendanceType.noStatus.getType(), Constants.AttendanceType.noStatus.getName(), null), (String)languageType);
        }
        List list = null;
        ArrayList<String> address = new ArrayList<String>();
        if (!StringUtils.isEmpty((Object)attendanceClasses.getPositionArray())) {
            list = (List)JsonUtil.jackson.readValue(attendanceClasses.getPositionArray(), List.class);
            for (Map map : list) {
                address.add(map.get("latitude").toString());
                address.add(map.get("longitude").toString());
                address.add(map.get("attendanceRange").toString());
            }
        }
        if ((attendanceWeekday = this.attendanceWeekdayService.findByType(attendanceUser.getClassesId(), date)) != null) {
            return ResultModel.suc((Object)new AttendanceModel(Constants.AttendanceType.noWork.getType(), Constants.AttendanceType.noWork.getName(), null), (String)languageType);
        }
        List attendanceTimeList = this.attendanceWeekdayService.findByTypeTwo(attendanceUser.getClassesId(), date);
        if (!StringUtils.isEmpty((Object)attendanceTimeList) && attendanceTimeList.size() != 0) {
            return ResultModel.suc((Object)new AttendanceModel(Constants.AttendanceType.work.getType(), Constants.AttendanceType.work.getName(), attendanceTimeList, address.size() == 0 ? "" : (String)address.get(0), address.size() == 0 ? "" : (String)address.get(1), address.size() == 0 ? "" : (String)address.get(2), attendanceClasses.getWifiArray() == null ? null : this.attendanceWifiService.findSomeWifi((List)JsonUtil.jackson.readValue(attendanceClasses.getWifiArray(), List.class))), (String)languageType);
        }
        if (attendanceClasses.getLegal().booleanValue() && (attendanceHolidays = this.attendanceHolidaysService.findByDate(DateUtils.getDate())) != null) {
            return ResultModel.suc((Object)new AttendanceModel(Constants.AttendanceType.noWork.getType(), Constants.AttendanceType.noWork.getName(), null), (String)languageType);
        }
        AttendanceWorkday attendanceWorkday = this.attendanceWorkdayService.findByClassesId(attendanceUser.getClassesId(), date);
        if (attendanceWorkday == null) {
            return ResultModel.suc((Object)new AttendanceModel(Constants.AttendanceType.noWork.getType(), Constants.AttendanceType.noWork.getName(), null), (String)languageType);
        }
        attendanceTimeList = attendanceWorkday.getAttendanceTimeList();
        return ResultModel.suc((Object)new AttendanceModel(Constants.AttendanceType.work.getType(), Constants.AttendanceType.work.getName(), attendanceTimeList, address.size() == 0 ? "" : (String)address.get(0), address.size() == 0 ? "" : (String)address.get(1), address.size() == 0 ? "" : (String)address.get(2), attendanceClasses.getWifiArray() == null ? null : this.attendanceWifiService.findSomeWifi((List)JsonUtil.jackson.readValue(attendanceClasses.getWifiArray(), List.class))), (String)languageType);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/record"})
    @ApiOperation(value="\u8003\u52e4\u72b6\u6001")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<AttendanceUserRecord> getRecordList(@LanguageType String languageType, @CurrentUser User currentUser) {
        AttendanceUserRecord attendanceUserRecord = this.attendanceUserRecordService.findByUserId(currentUser.getId(), currentUser.getCurrentCompany());
        return ResultModel.suc((Object)attendanceUserRecord, (String)languageType);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"web/record/date/id"})
    @ApiOperation(value="Web\u7aef-\u4e2a\u4eba\u67d0\u6708\u8003\u52e4\u8bb0\u5f55\u660e\u7ec6")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="id", value="\u7528\u6237id", required=false, dataType="Long", paramType="query"), @ApiImplicitParam(name="date", value="\u5e74\u6708", required=false, dataType="string", paramType="query"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<Map<String, Object>> getWebPersonRecord(@LanguageType String languageType, @CurrentUser User currentUser, Long id, String date) {
        if (StringUtils.isEmpty((Object)date)) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
            date = sdf.format(new Date());
        }
        if (StringUtils.isEmpty((Object)id)) {
            id = currentUser.getId();
        }
        return ResultModel.suc((Object)this.attendanceUserRecordService.findWebPersonRecord(id, currentUser.getCurrentCompany(), date), (String)languageType);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"app/record/date/id"})
    @ApiOperation(value="app\u7aef-\u4e2a\u4eba\u67d0\u6708\u8003\u52e4\u8bb0\u5f55\u660e\u7ec6")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="id", value="\u7528\u6237id", required=false, dataType="Long", paramType="query"), @ApiImplicitParam(name="date", value="\u5e74\u6708", required=false, dataType="string", paramType="query"), @ApiImplicitParam(name="companyId", value="\u516c\u53f8id", required=false, dataType="Long", paramType="query"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<List<AttendanceUserRecord>> getAppPersonRecord(@LanguageType String languageType, @CurrentUser User currentUser, Long id, String date, Long companyId) {
        if (StringUtils.isEmpty((Object)date)) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
            date = sdf.format(new Date());
        }
        if (StringUtils.isEmpty((Object)id)) {
            id = currentUser.getId();
        }
        if (currentUser.getCurrentCompany() == null) {
            return ResultModel.error((ResultStatus)ResultStatus.COMPANY_NO_EXIST, (String)languageType);
        }
        return ResultModel.suc((Object)this.attendanceUserRecordService.findAppPersonRecord(id, companyId == null ? currentUser.getCurrentCompany() : companyId, date), (String)languageType);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/getNotFormalDetail"})
    @ApiOperation(value="APP\u67e5\u770b\u4e2a\u4eba\u67d0\u6708\u8003\u52e4\u8fdf\u5230\u65e9\u9000\u7f3a\u52e4\u5f02\u5e38\u8be6\u60c5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="date", value="\u5e74\u6708", required=true, dataType="string", paramType="query"), @ApiImplicitParam(name="type", value="\u7c7b\u578b\uff0c4\uff1a\u8fdf\u5230\uff0c3\u65e9\u9000\uff0c2\u7f3a\u52e4", required=true, dataType="string", paramType="query"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<List<AttendancePersonalDetailModel>> getNotFormalDetail(@LanguageType String languageType, @CurrentUser User currentUser, String date, String type) throws Exception {
        if (type.equals("2")) {
            return this.attendanceReportUserService.findPersonalDetail(currentUser.getId(), currentUser.getCurrentCompany(), date, languageType);
        }
        return this.attendanceUserRecordService.findPersonalDetail(currentUser.getId(), currentUser.getCurrentCompany(), date, type, languageType);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/getRecord"})
    public ResultModel getRecord(@LanguageType String languageType, String date, Long companyId) throws Exception {
        return ResultModel.suc((Object)this.attendanceUserRecordService.findMonthRecord(companyId, date + "%", languageType), (String)languageType);
    }
}

