/*
 * Decompiled with CFR 0.152.
 */
package com.ym.tlifang.api.authorization.resolvers;

import com.alibaba.dubbo.config.annotation.Reference;
import com.ym.tlifang.api.authorization.annotation.CurrentUser;
import com.ym.tlifang.service.user.UserService;
import com.ym.tlifang.user.User;
import org.springframework.core.MethodParameter;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.springframework.web.multipart.support.MissingServletRequestPartException;

@Component
public class CurrentUserMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    @Reference(version="1.0.0")
    private UserService userService;

    public boolean supportsParameter(MethodParameter parameter) {
        return parameter.getParameterType().isAssignableFrom(User.class) && parameter.hasParameterAnnotation(CurrentUser.class);
    }

    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        String currentUserId = (String)webRequest.getAttribute("CURRENT_USER_ID", 0);
        if (currentUserId != null) {
            return this.userService.findOne(Long.valueOf(currentUserId));
        }
        throw new MissingServletRequestPartException("CURRENT_USER_ID");
    }
}

