/*
 * Decompiled with CFR 0.152.
 */
package com.ym.tlifang.service.task;

import com.alibaba.dubbo.config.annotation.Service;
import com.ym.tlifang.BaseEntity;
import com.ym.tlifang.PageInfo;
import com.ym.tlifang.ResultModel;
import com.ym.tlifang.ResultStatus;
import com.ym.tlifang.dao.task.TaskPanelDao;
import com.ym.tlifang.model.project.TaskPanelModel;
import com.ym.tlifang.model.project.TaskTagModel;
import com.ym.tlifang.service.AbstractBaseService;
import com.ym.tlifang.service.task.TaskPanelService;
import com.ym.tlifang.task.TaskPanel;
import com.ym.tlifang.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.lang3.StringEscapeUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
@Service(interfaceClass=TaskPanelService.class, timeout=30000, retries=-1)
public class TaskPanelServiceImpl
extends AbstractBaseService<TaskPanel, TaskPanelDao>
implements TaskPanelService {
    @PersistenceContext
    private EntityManager entityManager;

    public TaskPanel save(TaskPanel taskPanel) {
        return (TaskPanel)super.save((BaseEntity)taskPanel);
    }

    public Long findMaxSortByProjectId(Long projectId) {
        return ((TaskPanelDao)this.dao).findMaxSortByProjectId(projectId);
    }

    public TaskPanel findByPanelId(Long panelId) {
        return ((TaskPanelDao)this.dao).findByIdAndDelFlag(panelId, Boolean.valueOf(false));
    }

    public TaskPanel findByProjectIdAndType(Long projectId, String type) {
        return ((TaskPanelDao)this.dao).findByProjectIdAndTypeAndDelFlag(projectId, type, Boolean.valueOf(false));
    }

    public List<TaskPanel> findListByProjectIdOrderBySort(Long projectId) {
        return ((TaskPanelDao)this.dao).findByProjectIdAndDelFlagFalseOrderBySortAsc(projectId);
    }

    public ResultModel findByAllPaneAndTask(Long projectId, String status, Long assigneeId, Long tagsId, String taskName, Integer pageNo, Integer pageSize, String type, String languageType) {
        pageNo = StringUtils.isEmpty((Object)pageNo) ? 1 : pageNo;
        Page taskPanelPage = ((TaskPanelDao)this.dao).findByProjectIdAndDelFlagFalseOrderBySortAsc(projectId, (Pageable)new PageRequest(pageNo - 1, StringUtils.isEmpty((Object)pageSize) ? 10 : pageSize));
        PageInfo pageInfo = PageInfo.fromPage((Page)taskPanelPage);
        List taskPanels = pageInfo.getRows();
        List tasksAndPanels = this.entityManager.createNativeQuery(this.recodeTaskSQL(status, assigneeId, tagsId, taskName), TaskPanelModel.class).setParameter(1, (Object)projectId).getResultList();
        List tagList = this.entityManager.createNativeQuery(this.recodeTagSQL(), TaskTagModel.class).setParameter(1, (Object)projectId).getResultList();
        for (TaskPanel taskPanel : taskPanels) {
            ArrayList<TaskPanelModel> taskList = new ArrayList<TaskPanelModel>();
            for (TaskPanelModel taskPanelModel : tasksAndPanels) {
                if (taskPanelModel.getPanelId().equals(taskPanel.getId())) {
                    taskPanelModel.setTitle(StringEscapeUtils.unescapeJava((String)taskPanelModel.getTitle()));
                    taskPanelModel.setDescription(StringEscapeUtils.unescapeJava((String)taskPanelModel.getDescription()));
                    ArrayList<TaskTagModel> tags = new ArrayList<TaskTagModel>();
                    for (TaskTagModel taskTagModel : tagList) {
                        if (taskTagModel == null || !taskTagModel.getTaskId().equals(taskPanelModel.getTaskId())) continue;
                        tags.add(taskTagModel);
                    }
                    taskPanelModel.setTags(tags);
                    taskList.add(taskPanelModel);
                }
                taskPanel.setTaskList(taskList);
            }
        }
        this.entityManager.close();
        if (type != null && "1".equals(type)) {
            pageInfo.setRows(taskPanels);
            return ResultModel.suc((Object)pageInfo, (String)languageType);
        }
        return ResultModel.suc((Object)taskPanels, (String)languageType);
    }

    private String recodeTaskSQL(String status, Long assigneeId, Long tagsId, String taskName) {
        StringBuilder sql = new StringBuilder("select  tp.id as panel_id,\n                 t.id,                 t.id as task_id,\n                 t.type,\n                 t.company_id,\n                 t.project_id,\n                 t.creator_id,\n                 t.title,\n                 t.description,\n                 t.assignee_id,\n                 t.priority,\n                 t.date_start,\n                 t.date_due,\n                 t.status,\n                 t.`loop`,\n                 t.remind_date,\n                 u.id as user_id,\n                 u.name,\n                 u.avatar,\n                 (select count(t.task_id) from tlf_subtask t where t.task_id = tpr.task_id) as subtask_num,\n                 (select count(t.task_id)from tlf_subtask t where t.task_id = tpr.task_id and t.status = true) as subtask_complete_num\n                 from tlf_task_panel tp\n                 left join tlf_task_panel_relation tpr on tp.id = tpr.panel_id\n                 left join tlf_task t on tpr.task_id = t.id\n                 left join tlf_user u on t.assignee_id = u.id\n");
        StringBuilder condition = new StringBuilder(" where tp.project_id = ?\n            and tp.del_flag = false\n            and tpr.del_flag = false\n            and t.del_flag = false\n");
        StringBuilder orderBy = new StringBuilder(" order by tpr.sort desc ,tpr.update_date desc;");
        if (!StringUtils.isEmpty((Object)tagsId)) {
            sql = sql.append("left join tlf_task_label_relation tlr on t.id = tlr.task_id\n");
            condition = condition.append(" and tlr.tags_id = " + tagsId);
        }
        if (!StringUtils.isEmpty((Object)status)) {
            condition = condition.append(" and t.status = " + status);
        }
        if (!StringUtils.isEmpty((Object)assigneeId)) {
            condition = condition.append(" and t.assignee_id = " + assigneeId);
        }
        if (!StringUtils.isEmpty((Object)taskName)) {
            condition = condition.append(" and t.title like '%" + taskName + "%" + "' ");
        }
        return sql.append((CharSequence)condition.append((CharSequence)orderBy)).toString();
    }

    private String recodeTagSQL() {
        return "select tlr.id,\n       tlr.tags_id,\n       tlr.task_id,\n       tl.color,\n       tl.name\nfrom tlf_task t\n         left join tlf_task_label_relation tlr on t.id = tlr.task_id\n         left join tlf_project_task_label tl on tlr.tags_id = tl.id\nwhere t.project_id = ?\n  and t.del_flag = false and tlr.del_flag=false and tl.del_flag=false;";
    }

    public ResultModel updatePanelSort(List<Long> panelList, Long projectId) {
        TaskPanel taskPanelOne = ((TaskPanelDao)this.dao).findByIdAndDelFlag(panelList.get(0), Boolean.valueOf(false));
        TaskPanel taskPanelTwo = ((TaskPanelDao)this.dao).findByIdAndDelFlag(panelList.get(1), Boolean.valueOf(false));
        if (taskPanelOne == null || !taskPanelOne.getProjectId().equals(projectId)) {
            return ResultModel.error((ResultStatus)ResultStatus.TASKPANEL_NO_EXIST);
        }
        if (taskPanelTwo != null && !taskPanelTwo.getProjectId().equals(projectId)) {
            return ResultModel.error((ResultStatus)ResultStatus.TASKPANEL_NO_EXIST);
        }
        ((TaskPanelDao)this.dao).reduceSortAfterPanel(projectId, taskPanelOne.getSort());
        if (taskPanelTwo == null) {
            ((TaskPanelDao)this.dao).addSortAfterPanel(projectId, Long.valueOf(0L));
            ((TaskPanelDao)this.dao).updateSort(Long.valueOf(1L), taskPanelOne.getId());
        } else {
            Long sort = taskPanelTwo.getSort();
            if (sort > taskPanelOne.getSort()) {
                sort = sort - 1L;
            }
            ((TaskPanelDao)this.dao).addSortAfterPanel(projectId, sort);
            ((TaskPanelDao)this.dao).updateSort(Long.valueOf(sort + 1L), taskPanelOne.getId());
        }
        return ResultModel.success();
    }
}

