/*
 * Decompiled with CFR 0.152.
 */
package com.ym.tlifang.service.system;

import com.alibaba.dubbo.config.annotation.Service;
import com.ym.tlifang.Constants;
import com.ym.tlifang.PageInfo;
import com.ym.tlifang.approval.ApprovalTemplate;
import com.ym.tlifang.attendance.AttendanceOutside;
import com.ym.tlifang.dao.system.DynamicDao;
import com.ym.tlifang.model.sys.DynamicModel;
import com.ym.tlifang.proclamation.Proclamation;
import com.ym.tlifang.project.Project;
import com.ym.tlifang.service.AbstractBaseService;
import com.ym.tlifang.service.approval.ApprovalTemplateService;
import com.ym.tlifang.service.attendance.AttendanceOutsideService;
import com.ym.tlifang.service.file.FileFolderService;
import com.ym.tlifang.service.file.FileService;
import com.ym.tlifang.service.proclamation.ProclamationService;
import com.ym.tlifang.service.project.ProjectService;
import com.ym.tlifang.service.project.ProjectUserService;
import com.ym.tlifang.service.system.DynamicService;
import com.ym.tlifang.service.task.TaskService;
import com.ym.tlifang.service.task.subtask.SubtaskService;
import com.ym.tlifang.service.user.UserService;
import com.ym.tlifang.system.DynamicEntity;
import com.ym.tlifang.task.Task;
import com.ym.tlifang.task.subtask.Subtask;
import com.ym.tlifang.user.User;
import com.ym.tlifang.util.JsonUtil;
import com.ym.tlifang.util.StringUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
@Service(interfaceClass=DynamicService.class, timeout=100000, retries=-1)
public class DynamicServiceImpl
extends AbstractBaseService<DynamicEntity, DynamicDao>
implements DynamicService {
    Logger logger = LoggerFactory.getLogger(DynamicServiceImpl.class);
    @Autowired
    UserService userService;
    @Autowired
    FileService fileService;
    @Autowired
    FileFolderService fileFolderService;
    @Autowired
    ProjectService projectService;
    @Autowired
    ProjectUserService projectUserService;
    @Autowired
    TaskService taskService;
    @Autowired
    SubtaskService subtaskService;
    @Autowired
    ProclamationService proclamationService;
    @Autowired
    ApprovalTemplateService approvalTemplateService;
    @Autowired
    AttendanceOutsideService attendanceOutsideService;

    public DynamicEntity saveSendDynamic(DynamicEntity dynamicEntity) {
        dynamicEntity = (DynamicEntity)((DynamicDao)this.dao).save((Object)dynamicEntity);
        return dynamicEntity;
    }

    public DynamicEntity saveDynamic(Long userId, Constants.DynamicParentType parentType, Long parentTypeId, Constants.DynamicOriginatorType originatorType, Long originatorId, String content, Constants.DynamicActionType action, String contentEnglish) {
        DynamicEntity dynamicEntity = new DynamicEntity(userId, parentType.getType(), parentTypeId, originatorType.getType(), originatorId, content, action.getType(), contentEnglish);
        dynamicEntity = (DynamicEntity)((DynamicDao)this.dao).save((Object)dynamicEntity);
        return dynamicEntity;
    }

    public DynamicEntity saveUserDynamic(DynamicEntity dynamicEntity) {
        return (DynamicEntity)((DynamicDao)this.dao).save((Object)dynamicEntity);
    }

    public PageInfo findByParentTypeAndParentTypeId(Long userId, String parentType, Long parentTypeId, Integer pageNo, Integer pageSize, String languageType) {
        pageNo = StringUtils.isEmpty((Object)pageNo) ? 1 : pageNo;
        PageRequest pageable = new PageRequest(pageNo - 1, Integer.valueOf(StringUtils.isNullToZero((Object)pageSize)).intValue());
        Page page = null;
        page = Constants.LanguageType.US.getName().equals(languageType) ? ((DynamicDao)this.dao).findByParentTypeAndParentTypeIdAndContentEnglishNotNullAndDelFlagOrderByCreateDateDesc(parentType, parentTypeId, Boolean.valueOf(false), (Pageable)pageable) : ((DynamicDao)this.dao).findByParentTypeAndParentTypeIdAndDelFlagOrderByCreateDateDesc(parentType, parentTypeId, Boolean.valueOf(false), (Pageable)pageable);
        List dynamicEntityList = page.getContent();
        if (Constants.LanguageType.US.getName().equals(languageType)) {
            for (DynamicEntity dynamicEntity : dynamicEntityList) {
                dynamicEntity.setContent(dynamicEntity.getContentEnglish());
            }
        }
        PageInfo pageInfo = PageInfo.fromPage((Page)page);
        pageInfo.setRows(this.getDynamicList(dynamicEntityList, userId));
        return pageInfo;
    }

    public PageInfo findByParentTypeAndParentTypeIdAndOriginatorType(Long userId, String parentType, Long parentTypeId, String originatorType, Integer pageNo, Integer pageSize, String languageType) {
        pageNo = StringUtils.isEmpty((Object)pageNo) ? 1 : pageNo;
        PageRequest pageable = new PageRequest(pageNo - 1, Integer.valueOf(StringUtils.isNullToZero((Object)pageSize)).intValue());
        Page page = null;
        page = Constants.LanguageType.US.getName().equals(languageType) ? ((DynamicDao)this.dao).findByParentTypeAndParentTypeIdAndOriginatorTypeLikeAndDelFlagAndContentEnglishNotNullOrderByCreateDateDesc(parentType, parentTypeId, "%" + originatorType + "%", Boolean.valueOf(false), (Pageable)pageable) : ((DynamicDao)this.dao).findByParentTypeAndParentTypeIdAndOriginatorTypeLikeAndDelFlagOrderByCreateDateDesc(parentType, parentTypeId, "%" + originatorType + "%", Boolean.valueOf(false), (Pageable)pageable);
        List dynamicEntityList = page.getContent();
        if (Constants.LanguageType.US.getName().equals(languageType)) {
            for (DynamicEntity dynamicEntity : dynamicEntityList) {
                dynamicEntity.setContent(dynamicEntity.getContentEnglish());
            }
        }
        PageInfo pageInfo = PageInfo.fromPage((Page)page);
        pageInfo.setRows(this.getDynamicList(dynamicEntityList, userId));
        return pageInfo;
    }

    public PageInfo findByUserId(Long userId, Integer pageNo, Integer pageSize) {
        pageNo = StringUtils.isEmpty((Object)pageNo) ? 1 : pageNo;
        PageRequest pageable = new PageRequest(pageNo - 1, Integer.valueOf(StringUtils.isNullToZero((Object)pageSize)).intValue());
        Page page = ((DynamicDao)this.dao).findByUserIdAndDelFlagFalseOrderByCreateDateDesc(userId, (Pageable)pageable);
        PageInfo pageInfo = PageInfo.fromPage((Page)page);
        pageInfo.setRows(this.getDynamicList(page.getContent(), userId));
        return pageInfo;
    }

    public PageInfo findByUserIdAndCompanyId(Long userId, Long companyId, Integer pageNo, Integer pageSize, String languageType) {
        Integer pageNoSql = StringUtils.isEmpty((Object)pageNo) ? 1 : pageNo * pageSize - pageSize;
        List entityList = null;
        int total = 0;
        if (Constants.LanguageType.US.getName().equals(languageType)) {
            entityList = ((DynamicDao)this.dao).findByUserIdAndCompanyIdAllEnglish(userId, companyId, pageNoSql, pageSize);
            total = ((DynamicDao)this.dao).findByUserIdAndCompanyIdAllCountEnglish(userId, companyId);
            for (DynamicEntity dynamicEntity : entityList) {
                dynamicEntity.setContent(dynamicEntity.getContentEnglish());
            }
        } else {
            entityList = ((DynamicDao)this.dao).findByUserIdAndCompanyIdAll(userId, companyId, pageNoSql, pageSize);
            total = ((DynamicDao)this.dao).findByUserIdAndCompanyIdAllCount(userId, companyId);
        }
        PageInfo pageInfo = new PageInfo();
        pageInfo.setPages((total + pageSize - 1) / pageSize);
        pageInfo.setPageNo(pageNo.intValue());
        pageInfo.setTotal((long)total);
        pageInfo.setRows(this.getDynamicList(entityList, userId));
        return pageInfo;
    }

    public PageInfo findByUserIdAndCompanyIdAndProject(Long userId, Long companyId, Integer pageNo, Integer pageSize, String languageType) {
        Integer pageNoSql = StringUtils.isEmpty((Object)pageNo) ? 1 : pageNo * pageSize - pageSize;
        List entityList = null;
        int total = 0;
        if (Constants.LanguageType.US.getName().equals(languageType)) {
            entityList = ((DynamicDao)this.dao).findByUserIdAndCompanyIdAndProjectEnglish(userId, companyId, pageNoSql, pageSize);
            total = ((DynamicDao)this.dao).findByUserIdAndCompanyIdAndProjectCountEnglish(userId, companyId);
            for (DynamicEntity dynamicEntity : entityList) {
                dynamicEntity.setContent(dynamicEntity.getContentEnglish());
            }
        } else {
            entityList = ((DynamicDao)this.dao).findByUserIdAndCompanyIdAndProject(userId, companyId, pageNoSql, pageSize);
            total = ((DynamicDao)this.dao).findByUserIdAndCompanyIdAndProjectCount(userId, companyId);
        }
        PageInfo pageInfo = new PageInfo();
        pageInfo.setPages((total + pageSize - 1) / pageSize);
        pageInfo.setPageNo(pageNo.intValue());
        pageInfo.setTotal((long)total);
        pageInfo.setRows(this.getDynamicList(entityList, userId));
        return pageInfo;
    }

    private List<Map<String, Object>> getDynamicList(List<DynamicEntity> dynamicEntities, Long userId) {
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
        for (DynamicEntity dynamicEntity : dynamicEntities) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("id", dynamicEntity.getId());
            map.put("action", dynamicEntity.getAction());
            map.put("originator_type", dynamicEntity.getOriginatorType());
            map.put("content", dynamicEntity.getContent());
            map.put("create_time", dynamicEntity.getCreateDate());
            HashMap<String, Object> creatorMap = new HashMap<String, Object>();
            User user = dynamicEntity.getUser();
            creatorMap.put("name", user.getName());
            creatorMap.put("mobile", user.getMobile());
            creatorMap.put("email", user.getEmail());
            creatorMap.put("id", user.getId());
            map.put("creator", creatorMap);
            if (dynamicEntity.getParentType() != null) {
                Subtask subtask;
                if (Constants.DynamicParentType.project.getType().equals(dynamicEntity.getParentType())) {
                    Task task;
                    Project project = this.projectService.findByProjectIdNotFlag(dynamicEntity.getParentTypeId());
                    HashMap<String, Object> projectMap = new HashMap<String, Object>();
                    projectMap.put("id", project.getId());
                    projectMap.put("name", project.getName());
                    projectMap.put("company_id", project.getCompanyId());
                    map.put("project", projectMap);
                    if (Constants.DynamicOriginatorType.projectMember.getType().equals(dynamicEntity.getOriginatorType()) || Constants.DynamicOriginatorType.projectMember.getType().equals(dynamicEntity.getOriginatorType())) {
                        User paojectMember = dynamicEntity.getUser();
                        HashMap<String, Object> paojectMemberMap = new HashMap<String, Object>();
                        paojectMemberMap.put("id", paojectMember.getId());
                        paojectMemberMap.put("name", paojectMember.getName());
                        map.put("project_member", paojectMemberMap);
                    }
                    if (Constants.DynamicOriginatorType.task.getType().equals(dynamicEntity.getOriginatorType()) && !StringUtils.isEmpty((Object)(task = this.taskService.findByTaskId(dynamicEntity.getOriginatorId())))) {
                        HashMap<String, Object> taskMap = new HashMap<String, Object>();
                        taskMap.put("id", task.getId());
                        taskMap.put("name", StringEscapeUtils.unescapeJava((String)task.getTitle()));
                        taskMap.put("companyId", task.getCompanyId());
                        map.put("ori_task", taskMap);
                    }
                }
                if (Constants.DynamicParentType.company.getType().equals(dynamicEntity.getParentType())) {
                    if (Constants.DynamicOriginatorType.notice.getType().equals(dynamicEntity.getOriginatorType())) {
                        Proclamation proclamation = this.proclamationService.findById(dynamicEntity.getOriginatorId());
                        HashMap<String, Object> proclamationMap = new HashMap<String, Object>();
                        proclamationMap.put("id", proclamation.getId());
                        proclamationMap.put("name", proclamation.getName());
                        proclamationMap.put("companyId", proclamation.getCompanyId());
                        map.put("proclamation", proclamationMap);
                    }
                    if (Constants.DynamicOriginatorType.approval.getType().equals(dynamicEntity.getOriginatorType())) {
                        ApprovalTemplate approvalTemplate = this.approvalTemplateService.findByIdNotDelFlag(dynamicEntity.getOriginatorId());
                        HashMap<String, Object> approvalTemplateMap = new HashMap<String, Object>();
                        approvalTemplateMap.put("id", approvalTemplate.getId());
                        approvalTemplateMap.put("name", approvalTemplate.getName());
                        approvalTemplateMap.put("companyId", approvalTemplate.getCompanyId());
                        map.put("approval_template", approvalTemplateMap);
                    }
                    if (Constants.DynamicOriginatorType.companyManager.getType().equals(dynamicEntity.getOriginatorType())) {
                        User paojectMember = this.userService.findById(dynamicEntity.getOriginatorId());
                        HashMap<String, Object> companyManagerMap = new HashMap<String, Object>();
                        companyManagerMap.put("id", paojectMember.getId());
                        companyManagerMap.put("name", paojectMember.getName());
                        map.put("company_manager", companyManagerMap);
                    }
                    if (Constants.DynamicOriginatorType.attendanceOutside.getType().equals(dynamicEntity.getOriginatorType())) {
                        AttendanceOutside attendanceOutside = this.attendanceOutsideService.findById(dynamicEntity.getOriginatorId());
                        try {
                            HashMap<String, Long> attendanceOutsideMap = new HashMap<String, Long>();
                            attendanceOutsideMap.put("id", attendanceOutside.getId());
                            Map mapPosition = (Map)JsonUtil.jackson.readValue(attendanceOutside.getPosition(), Map.class);
                            attendanceOutsideMap.put("address", (Long)mapPosition.get("address"));
                            map.put("attendance_outside", attendanceOutsideMap);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
                if (Constants.DynamicParentType.task.getType().equals(dynamicEntity.getParentType()) && Constants.DynamicOriginatorType.subtask.getType().equals(dynamicEntity.getOriginatorType()) && !StringUtils.isEmpty((Object)(subtask = this.subtaskService.findBySubtask(dynamicEntity.getOriginatorId())))) {
                    HashMap<String, Object> subtaskMap = new HashMap<String, Object>(2);
                    subtaskMap.put("id", subtask.getId());
                    subtaskMap.put("name", subtask.getTitle());
                    map.put("subtaskInfo", subtaskMap);
                }
            }
            mapList.add(map);
        }
        return mapList;
    }

    public PageInfo<DynamicModel> findByTaskId(Long taskId, Integer pageNo, Integer pageSize, String languageType) {
        pageNo = StringUtils.isEmpty((Object)pageNo) ? 1 : pageNo;
        PageRequest pageable = new PageRequest(pageNo - 1, StringUtils.isEmpty((Object)pageSize) ? 10 : pageSize);
        PageInfo dynamicEntityPage = PageInfo.fromPage((Page)(Constants.LanguageType.US.getName().equals(languageType) ? ((DynamicDao)this.dao).findTaskDynamicEnglish(taskId, taskId.longValue(), (Pageable)pageable) : ((DynamicDao)this.dao).findTaskDynamic(taskId, taskId.longValue(), (Pageable)pageable)));
        PageInfo dynamicModelPageInfo = new PageInfo();
        List dynamicEntityList = dynamicEntityPage.getRows();
        ArrayList<DynamicModel> dynamicModels = new ArrayList<DynamicModel>();
        for (DynamicEntity dynamicEntity : dynamicEntityList) {
            User user = dynamicEntity.getUser();
            DynamicModel dynamicModel = new DynamicModel(user.getName(), Constants.LanguageType.US.getName().equals(languageType) ? dynamicEntity.getContentEnglish() : dynamicEntity.getContent(), dynamicEntity.getRemark(), user.getAvatar(), user.getMobile(), user.getEmail(), dynamicEntity.getCreateDate());
            dynamicModels.add(dynamicModel);
        }
        dynamicModelPageInfo.setPageNo(dynamicEntityPage.getPageNo());
        dynamicModelPageInfo.setPages(dynamicEntityPage.getPages());
        dynamicModelPageInfo.setTotal(dynamicEntityPage.getTotal());
        dynamicModelPageInfo.setRows(dynamicModels);
        return dynamicModelPageInfo;
    }

    public DynamicEntity saveTaskDynamic(Long userId, Constants.DynamicParentType parentType, Long parentTypeId, Constants.DynamicOriginatorType originatorType, Long originatorId, String content, Constants.DynamicActionType action, String remark, String contentEnglish) {
        DynamicEntity dynamicEntity = new DynamicEntity(userId, parentType.getType(), parentTypeId, originatorType.getType(), originatorId, content, action.getType(), contentEnglish);
        dynamicEntity.setRemark(remark);
        dynamicEntity = (DynamicEntity)((DynamicDao)this.dao).save((Object)dynamicEntity);
        return dynamicEntity;
    }
}

