/*
 * Decompiled with CFR 0.152.
 */
package com.ym.tlifang.service.statement;

import com.alibaba.dubbo.config.annotation.Service;
import com.ym.tlifang.BaseEntity;
import com.ym.tlifang.PageInfo;
import com.ym.tlifang.company.Company;
import com.ym.tlifang.dao.statement.ProjectStatisticsDao;
import com.ym.tlifang.project.Project;
import com.ym.tlifang.service.AbstractBaseService;
import com.ym.tlifang.service.company.CompanyService;
import com.ym.tlifang.service.project.ProjectService;
import com.ym.tlifang.service.statement.ProjectStatisticsService;
import com.ym.tlifang.service.user.UserService;
import com.ym.tlifang.statement.ProjectStatistics;
import com.ym.tlifang.user.User;
import com.ym.tlifang.util.StringUtils;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
@Service(interfaceClass=ProjectStatisticsService.class, timeout=30000, retries=-1)
public class ProjectStatisticsImpl
extends AbstractBaseService<ProjectStatistics, ProjectStatisticsDao>
implements ProjectStatisticsService {
    @Autowired
    private CompanyService companyService;
    @Autowired
    private UserService userService;
    @Autowired
    private ProjectService projectService;

    public ProjectStatistics save(ProjectStatistics projectStatistics) {
        return (ProjectStatistics)super.save((BaseEntity)projectStatistics);
    }

    public List<ProjectStatistics> findByCompanyIdAndDate(Long companyId, Long departmentId, String date) {
        List list;
        date = ((ProjectStatisticsDao)this.dao).findMaxRecordTimeByCompanyIdAndDate(companyId, date + "%");
        if (StringUtils.isEmpty((Object)departmentId)) {
            list = ((ProjectStatisticsDao)this.dao).findByCompanyIdAndDepartmentIdIsNotNullAndProjectIdIsNullAndUserIdIsNullAndRecordTimeAndDelFlagFalse(companyId, date);
            for (ProjectStatistics projectStatistics : list) {
                Company department = this.companyService.findByDepartmentId(projectStatistics.getDepartmentId());
                if (department == null) continue;
                projectStatistics.setDepartmentName(department.getName());
            }
        } else {
            list = ((ProjectStatisticsDao)this.dao).findByCompanyIdAndDepartmentIdAndUserIdIsNotNullAndRecordTimeAndDelFlagFalse(companyId, departmentId, date);
        }
        return list;
    }

    public PageInfo<ProjectStatistics> findMembersByCompanyIdAndDate(Long companyId, String date, Long departmentId, Integer pageNo, Integer pageSize) {
        pageNo = StringUtils.isEmpty((Object)pageNo) ? 1 : pageNo;
        PageRequest pageable = new PageRequest(pageNo - 1, StringUtils.isEmpty((Object)pageSize) ? 20 : pageSize);
        date = ((ProjectStatisticsDao)this.dao).findMaxRecordTimeByCompanyIdAndDate(companyId, date + "%");
        Page page = StringUtils.isEmpty((Object)departmentId) ? ((ProjectStatisticsDao)this.dao).findByCompanyIdAndRecordTimeAndUserIdIsNotNullOrderByProjectNumDesc(companyId, date, (Pageable)pageable) : ((ProjectStatisticsDao)this.dao).findByCompanyIdAndDepartmentIdAndRecordTimeAndUserIdIsNotNullOrderByProjectNumDesc(companyId, departmentId, date, (Pageable)pageable);
        List list = page.getContent();
        for (ProjectStatistics projectStatistics : list) {
            User user;
            Company department = this.companyService.findByDepartmentId(projectStatistics.getDepartmentId());
            if (department != null) {
                projectStatistics.setDepartmentName(department.getName());
            }
            if ((user = this.userService.findById(projectStatistics.getUserId())) == null) continue;
            projectStatistics.setUserName(user.getName());
            projectStatistics.setUserImage(user.getAvatar());
            projectStatistics.setUserSex(user.getSex());
        }
        return PageInfo.fromPage((Page)page);
    }

    public PageInfo<ProjectStatistics> findProjectsByCompanyId(Long companyId, Integer pageNo, Integer pageSize) {
        pageNo = StringUtils.isEmpty((Object)pageNo) ? 1 : pageNo;
        PageRequest pageable = new PageRequest(pageNo - 1, StringUtils.isEmpty((Object)pageSize) ? 20 : pageSize);
        String date = ((ProjectStatisticsDao)this.dao).findMaxRecordTimeByCompanyId(companyId);
        Page page = ((ProjectStatisticsDao)this.dao).findByCompanyIdAndRecordTimeAndProjectIdIsNotNullAndUserIdIsNullOrderByProjectNumDesc(companyId, date, (Pageable)pageable);
        List list = page.getContent();
        for (ProjectStatistics projectStatistics : list) {
            User user;
            Project project = this.projectService.findByProjectId(projectStatistics.getProjectId());
            if (project != null) {
                projectStatistics.setProjectName(project.getName());
            }
            if ((user = this.userService.findById(project.getOwnerId())) == null) continue;
            projectStatistics.setUserName(user.getName());
            projectStatistics.setUserImage(user.getAvatar());
            projectStatistics.setUserSex(user.getSex());
        }
        return PageInfo.fromPage((Page)page);
    }

    public ProjectStatistics findByCompanyId(Long companyId) {
        String date = ((ProjectStatisticsDao)this.dao).findMaxRecordTimeByCompanyId(companyId);
        ProjectStatistics projectStatistics = ((ProjectStatisticsDao)this.dao).findByCompanyIdAndRecordTimeAndDepartmentIdIsNullAndProjectIdIsNullAndUserIdIsNullAndDelFlagFalse(companyId, date);
        return projectStatistics == null ? new ProjectStatistics() : projectStatistics;
    }

    public ProjectStatistics findLastRecord(Long companyId, Long departmentId, String recordTime) {
        return ((ProjectStatisticsDao)this.dao).findByCompanyIdAndDepartmentIdAndUserIdIsNullAndProjectIdIsNullAndRecordTimeAndDelFlagFalse(companyId, departmentId, recordTime);
    }

    public ProjectStatistics findByLastRecord(Long companyId, Long departmentId, Long userId, String recordTime) {
        return ((ProjectStatisticsDao)this.dao).findByCompanyIdAndDepartmentIdAndUserIdAndProjectIdIsNullAndRecordTimeAndDelFlagFalse(companyId, departmentId, userId, recordTime);
    }

    public ProjectStatistics findProjectByLastRecord(Long companyId, Long projectId, String recordTime) {
        return ((ProjectStatisticsDao)this.dao).findByCompanyIdAndProjectIdAndRecordTimeAndDelFlagFalse(companyId, projectId, recordTime);
    }
}

