/*
 * Decompiled with CFR 0.152.
 */
package com.ym.tlifang.service.meeting;

import com.alibaba.dubbo.config.annotation.Service;
import com.ym.tlifang.Constants;
import com.ym.tlifang.PageInfo;
import com.ym.tlifang.dao.meeting.MeetingDao;
import com.ym.tlifang.dao.meeting.MeetingMemberDao;
import com.ym.tlifang.meeting.MeetingEntity;
import com.ym.tlifang.meeting.MeetingMemberEntity;
import com.ym.tlifang.model.meeting.MyMeetingModel;
import com.ym.tlifang.service.AbstractBaseService;
import com.ym.tlifang.service.meeting.MeetingMemberService;
import com.ym.tlifang.service.user.UserService;
import com.ym.tlifang.user.User;
import com.ym.tlifang.util.DateUtils;
import com.ym.tlifang.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Service(interfaceClass=MeetingMemberService.class, timeout=30000, retries=-1)
public class MeetingMemberServiceImpl
extends AbstractBaseService<MeetingMemberEntity, MeetingMemberDao>
implements MeetingMemberService {
    @Autowired
    UserService userService;
    @Autowired
    MeetingDao meetingDao;

    public Map<String, Object> saveMeetingMember(MeetingMemberEntity meetingMemberEntity) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        meetingMemberEntity = (MeetingMemberEntity)((MeetingMemberDao)this.dao).save((Object)meetingMemberEntity);
        map.put("meetingMemberEntity", meetingMemberEntity);
        User user = this.userService.findById(meetingMemberEntity.getMemberId());
        HashMap<String, String> memberMap = new HashMap<String, String>();
        memberMap.put("name", user.getName());
        memberMap.put("avatar", user.getAvatar());
        map.put("memberInfo", memberMap);
        return map;
    }

    public MeetingMemberEntity findById(Long meetingMemberId) {
        return ((MeetingMemberDao)this.dao).findByIdAndDelFlagIsFalse(meetingMemberId);
    }

    public List<Map<String, Object>> findByMeetingId(Long meetingId) {
        List memberEntities = ((MeetingMemberDao)this.dao).findByMeetingIdAndDelFlag(meetingId, Boolean.valueOf(false));
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
        for (MeetingMemberEntity memberEntity : memberEntities) {
            User user = this.userService.findById(memberEntity.getMemberId());
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("meetingMemberId", memberEntity.getId());
            map.put("id", memberEntity.getMemberId());
            map.put("name", user.getName());
            map.put("mobile", user.getMobile());
            map.put("avatar", user.getAvatar());
            mapList.add(map);
        }
        return mapList;
    }

    public List<MeetingMemberEntity> findByMeetingIds(Long meetingId) {
        return ((MeetingMemberDao)this.dao).findByMeetingIdAndDelFlag(meetingId, Boolean.valueOf(false));
    }

    public PageInfo findByCompanyIdAndMemberId(Long companyId, Long memberId, String status, Integer pageNo, Integer pageSize, String languageType) {
        Integer pageNoSql = StringUtils.isEmpty((Object)pageNo) ? 1 : pageNo * pageSize - pageSize;
        List list = new ArrayList();
        int total = 0;
        if ("0".equals(status)) {
            list = ((MeetingMemberDao)this.dao).getMyNotEndMeeting(companyId, memberId, pageNoSql, pageSize);
            total = ((MeetingMemberDao)this.dao).getMyNotEndMeetingCount(companyId, memberId);
        }
        if ("1".equals(status)) {
            list = ((MeetingMemberDao)this.dao).getMyEndMeeting(companyId, memberId, pageNoSql, pageSize);
            total = ((MeetingMemberDao)this.dao).getMyEndMeetingCount(companyId, memberId);
        }
        PageInfo pageInfo = new PageInfo();
        pageInfo.setPages((total + pageSize - 1) / pageSize);
        pageInfo.setPageNo(pageNo.intValue());
        pageInfo.setTotal((long)total);
        pageInfo.setRows(this.getMyMeetingModel(list, status, languageType));
        return pageInfo;
    }

    public PageInfo findMyInitiatorMeetingList(Long companyId, Long memberId, String status, Integer pageNo, Integer pageSize, String languageType) {
        Integer pageNoSql = StringUtils.isEmpty((Object)pageNo) ? 1 : pageNo * pageSize - pageSize;
        List list = new ArrayList();
        int total = 0;
        if ("0".equals(status)) {
            list = ((MeetingMemberDao)this.dao).getMyInitiatorNotEndMeeting(companyId, memberId, pageNoSql, pageSize);
            total = ((MeetingMemberDao)this.dao).getMyInitiatorNotEndMeetingCount(companyId, memberId);
        }
        if ("1".equals(status)) {
            list = ((MeetingMemberDao)this.dao).getMyInitiatorEndMeeting(companyId, memberId, pageNoSql, pageSize);
            total = ((MeetingMemberDao)this.dao).getMyInitiatorEndMeetingCount(companyId, memberId);
        }
        PageInfo pageInfo = new PageInfo();
        pageInfo.setPages((total + pageSize - 1) / pageSize);
        pageInfo.setPageNo(pageNo.intValue());
        pageInfo.setTotal((long)total);
        pageInfo.setRows(this.getMyMeetingModel(list, status, languageType));
        return pageInfo;
    }

    public int getMyNotEndMeetingCount(Long companyId, Long memberId) {
        return ((MeetingMemberDao)this.dao).getMyNotEndMeetingCount(companyId, memberId);
    }

    private List<Map<String, Object>> getMeetingList(List<MeetingMemberEntity> list) {
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
        for (MeetingMemberEntity entity : list) {
            User user = this.userService.findById(entity.getMemberId());
            MeetingEntity meetingEntity = this.meetingDao.findByIdAndDelFlag(entity.getMeetingId(), Boolean.valueOf(false));
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("id", meetingEntity.getId());
            map.put("title", meetingEntity.getTitle());
            map.put("initiatorId", meetingEntity.getInitiatorId());
            map.put("time", DateUtils.getBeginTimeBetweenEndTime((Date)meetingEntity.getBeginTime(), (Date)meetingEntity.getEndTime()));
            map.put("initiatorName", user.getName());
            map.put("address", meetingEntity.getAddress());
            map.put("createTime", meetingEntity.getCreateBy());
            mapList.add(map);
        }
        return mapList;
    }

    private List<MyMeetingModel> getMyMeetingModel(List<Object[]> list, String status, String languageType) {
        ArrayList<MyMeetingModel> myMeetingModels = new ArrayList<MyMeetingModel>();
        for (int i = 0; i < list.size(); ++i) {
            Object[] objects = list.get(i);
            MyMeetingModel myMeetingModel = new MyMeetingModel();
            myMeetingModel.setId(Long.valueOf(Long.parseLong(objects[0].toString())));
            myMeetingModel.setCompayId(Long.valueOf(Long.parseLong(objects[1].toString())));
            myMeetingModel.setTitle(objects[2].toString());
            myMeetingModel.setInitiatorId(Long.valueOf(Long.parseLong(objects[3].toString())));
            myMeetingModel.setBeginTime(DateUtils.parseDate((Object)objects[4].toString().substring(0, objects[4].toString().length() - 2)));
            myMeetingModel.setEndTime(DateUtils.parseDate((Object)objects[5].toString().substring(0, objects[5].toString().length() - 2)));
            myMeetingModel.setContent(objects[6].toString());
            myMeetingModel.setRoomName(objects[7] == null ? "" : objects[7].toString());
            myMeetingModel.setUserName(objects[8].toString());
            myMeetingModel.setUserAvatar(objects[9].toString());
            myMeetingModel.setDiscussCount(objects[10].toString());
            myMeetingModel.setEnclosureCount(objects[11].toString());
            myMeetingModel.setCreateTime(DateUtils.parseDate((Object)objects[12].toString().substring(0, objects[12].toString().length() - 2)));
            myMeetingModel.setStatus("0".equals(status) ? (DateUtils.isEffectiveDate((Date)new Date(), (Date)myMeetingModel.getBeginTime(), (Date)myMeetingModel.getEndTime()) ? (Constants.LanguageType.US.getName().equals(languageType) ? "Underway" : "\u8fdb\u884c\u4e2d") : (Constants.LanguageType.US.getName().equals(languageType) ? " Not yet start" : "\u672a\u5f00\u59cb")) : (Constants.LanguageType.US.getName().equals(languageType) ? "Completed" : "\u5df2\u5b8c\u6210"));
            myMeetingModels.add(myMeetingModel);
        }
        return myMeetingModels;
    }
}

