/*
 * Decompiled with CFR 0.152.
 */
package com.ym.tlifang.service.file;

import com.alibaba.dubbo.config.annotation.Service;
import com.ym.tlifang.ResultModel;
import com.ym.tlifang.ResultStatus;
import com.ym.tlifang.dao.file.FileFolderPowerDao;
import com.ym.tlifang.file.FileFolderEntity;
import com.ym.tlifang.file.FileFolderPowerEntity;
import com.ym.tlifang.model.file.FileFolderAdminInfoModel;
import com.ym.tlifang.model.file.FileFolderPowerInfoReturn;
import com.ym.tlifang.model.file.PowerUserInfo;
import com.ym.tlifang.model.file.SaveAddAndDelUserPower;
import com.ym.tlifang.model.file.SaveFileFolderPowerModel;
import com.ym.tlifang.model.file.UserPower;
import com.ym.tlifang.service.AbstractBaseService;
import com.ym.tlifang.service.company.CompanyUserRelationService;
import com.ym.tlifang.service.file.FileFolderPowerService;
import com.ym.tlifang.service.file.FileFolderService;
import com.ym.tlifang.service.project.ProjectService;
import com.ym.tlifang.service.project.ProjectUserService;
import com.ym.tlifang.user.User;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Service(interfaceClass=FileFolderPowerService.class, timeout=30000, retries=-1)
public class FileFolderPowerServiceImpl
extends AbstractBaseService<FileFolderPowerEntity, FileFolderPowerDao>
implements FileFolderPowerService {
    @Autowired
    private FileFolderService fileFolderService;
    @Autowired
    private CompanyUserRelationService companyUserRelationService;
    @Autowired
    private ProjectService projectService;
    @Autowired
    private ProjectUserService projectUserService;

    public List<FileFolderPowerEntity> findByUserIdAndPowerTypeAndDelFlagFalse(Long userId, String powerType, String status) {
        if ("1".equals(status)) {
            return ((FileFolderPowerDao)this.dao).findByUserIdAndPowerTypeAndDelFlagFalse(userId, powerType);
        }
        return ((FileFolderPowerDao)this.dao).findByUserIdAndPowerTypeNotAndDelFlagFalse(userId, powerType);
    }

    public FileFolderPowerEntity saveEntity(FileFolderPowerEntity fileFolderPowerEntity) {
        return (FileFolderPowerEntity)((FileFolderPowerDao)this.dao).save((Object)fileFolderPowerEntity);
    }

    public FileFolderPowerEntity findByFileFolderIdAndUserIdAndPowerTypeAndDelFlagFalse(Long fileFolderId, Long userId, String type) {
        return ((FileFolderPowerDao)this.dao).findByFileFolderIdAndUserIdAndPowerTypeAndDelFlagFalse(fileFolderId, userId, type);
    }

    public FileFolderPowerEntity findFirstByFileFolderIdAndPowerTypeNotAndDelFlagFalseOrderByPowerTypeAsc(Long fileFolderId, String type) {
        return ((FileFolderPowerDao)this.dao).findFirstByFileFolderIdAndPowerTypeNotAndDelFlagFalseOrderByPowerTypeAsc(fileFolderId, type);
    }

    public FileFolderPowerEntity findByFileFolderIdAndPowerTypeZeroAndDelFlagFalse(Long fileFolderId) {
        return ((FileFolderPowerDao)this.dao).findByFileFolderIdAndPowerTypeZeroAndDelFlagFalse(fileFolderId, "0");
    }

    public FileFolderAdminInfoModel findAdminUserByFileFolderIdAndPowerType(Long fileFolderId) {
        List objectModel = ((FileFolderPowerDao)this.dao).findAdminUserByFileFolderIdAndPowerType(fileFolderId);
        if (objectModel != null || objectModel.get(0) != null) {
            Object[] objects = (Object[])objectModel.get(0);
            return new FileFolderAdminInfoModel(Long.valueOf(objects[0].toString()), objects[1] != null ? objects[1].toString() : null, objects[2] != null ? objects[2].toString() : null);
        }
        return null;
    }

    public List<FileFolderPowerEntity> findByFileFolderIdAndDelFlagFalse(Long fileFolderId) {
        return ((FileFolderPowerDao)this.dao).findByFileFolderIdAndDelFlagFalse(fileFolderId);
    }

    public FileFolderPowerEntity findByFileFolderIdAndUserIdAndDelFlagFalse(Long fileFolderId, Long userId) {
        return ((FileFolderPowerDao)this.dao).findByFileFolderIdAndUserIdAndDelFlagFalse(fileFolderId, userId);
    }

    public Boolean delFileFolderPower(Long fileFolderId, Long userId) {
        return ((FileFolderPowerDao)this.dao).delFileFolderPower(fileFolderId, userId) > 0;
    }

    public void deleteFolderPower(Long id) {
        ((FileFolderPowerDao)this.dao).delete((Serializable)id);
    }

    public int saveOrUpdateFileFolderPower(Long id, Long updateUserId, String type) {
        return ((FileFolderPowerDao)this.dao).saveOrUpdateFileFolderPower(id, updateUserId, type);
    }

    public ResultModel updateUser(Long userId, SaveAddAndDelUserPower saveAddAndDelUserPower, String languageType) {
        FileFolderPowerEntity fileFolderPower;
        FileFolderEntity fileFolderEntity = this.fileFolderService.findByIdAndParentId(saveAddAndDelUserPower.getFileFolderId(), Long.valueOf(0L), Boolean.valueOf(false));
        if (fileFolderEntity == null) {
            return ResultModel.error((ResultStatus)ResultStatus.FILE_FOLDER_NO_EXIST, (String)languageType);
        }
        FileFolderPowerEntity fileFolderPowerEntity = this.findByFileFolderIdAndUserIdAndDelFlagFalse(saveAddAndDelUserPower.getFileFolderId(), userId);
        if (fileFolderPowerEntity == null) {
            return ResultModel.error((ResultStatus)ResultStatus.FILE_FOLDER_POWER_USER_NO_EXIST, (String)languageType);
        }
        if ("2".equals(fileFolderPowerEntity.getPowerType())) {
            return ResultModel.error((ResultStatus)ResultStatus.FILE_FOLDER_ADMIN_NO_EXIST, (String)languageType);
        }
        if (saveAddAndDelUserPower.getAddUserIds() != null) {
            for (Long addUserId : saveAddAndDelUserPower.getAddUserIds()) {
                fileFolderPower = this.findByFileFolderIdAndUserIdAndDelFlagFalse(saveAddAndDelUserPower.getFileFolderId(), addUserId);
                if (fileFolderPower != null) {
                    return ResultModel.error((ResultStatus)ResultStatus.FILE_FOLDER_POWER_USER_EXIST, (String)languageType);
                }
                if ("1".equals(fileFolderEntity.getType()) && !addUserId.equals(userId)) {
                    Boolean flag = this.companyUserRelationService.findFlagByUserIdAndCompanyId(addUserId, fileFolderEntity.getKeyId());
                    if (!flag.booleanValue()) {
                        return ResultModel.error((ResultStatus)ResultStatus.COMPANYMEMBERS_NO_EXIST, (String)languageType);
                    }
                    ((FileFolderPowerDao)this.dao).save((Object)new FileFolderPowerEntity(addUserId, "1", fileFolderEntity.getId(), userId, userId));
                    continue;
                }
                if (!"2".equals(fileFolderEntity.getType()) || addUserId.equals(userId)) continue;
                Boolean flagTwo = this.projectService.findByProjectIdAndCompanyId(fileFolderEntity.getKeyId());
                Boolean aBoolean = this.projectUserService.findByUserIdAndProjectId(addUserId, fileFolderEntity.getKeyId());
                if (!flagTwo.booleanValue() || !aBoolean.booleanValue()) {
                    return ResultModel.error((ResultStatus)ResultStatus.PROJECTINFO_NO_EXIST, (String)languageType);
                }
                ((FileFolderPowerDao)this.dao).save((Object)new FileFolderPowerEntity(addUserId, "1", fileFolderEntity.getId(), userId, userId));
            }
        }
        if (saveAddAndDelUserPower.getDelUserIds() != null) {
            for (Long delUserId : saveAddAndDelUserPower.getDelUserIds()) {
                if (userId.equals(delUserId)) {
                    return ResultModel.error((ResultStatus)ResultStatus.FILE_FOLDER_POWER_ADMIN_CONNOT_EXIST, (String)languageType);
                }
                fileFolderPower = this.findByFileFolderIdAndUserIdAndDelFlagFalse(saveAddAndDelUserPower.getFileFolderId(), delUserId);
                if (fileFolderPower == null) {
                    return ResultModel.error((ResultStatus)ResultStatus.FILE_FOLDER_POWER_USER_NO_EXIST, (String)languageType);
                }
                if ("0".equals(fileFolderPower.getPowerType())) {
                    return ResultModel.error((ResultStatus)ResultStatus.FILE_FOLDER_POWER_ADMIN_CONNOT_EXIST, (String)languageType);
                }
                this.delFileFolderPower(saveAddAndDelUserPower.getFileFolderId(), delUserId);
            }
        }
        ArrayList<PowerUserInfo> powerUserInfos = new ArrayList<PowerUserInfo>();
        List objectList = ((FileFolderPowerDao)this.dao).powerUserInfo(saveAddAndDelUserPower.getFileFolderId());
        if (objectList != null) {
            for (int i = 0; i < objectList.size(); ++i) {
                Object[] object = (Object[])objectList.get(i);
                PowerUserInfo powerUserInfo = new PowerUserInfo(Long.valueOf(object[0].toString()), object[1].toString(), object[2] != null ? object[2].toString() : null, object[3].toString());
                powerUserInfos.add(powerUserInfo);
            }
        }
        return ResultModel.suc(powerUserInfos);
    }

    public ResultModel updateUserPower(Long userId, SaveFileFolderPowerModel saveFileFolderPowerModel, String languageType) throws Exception {
        FileFolderEntity fileFolderEntity = this.fileFolderService.findByIdAndParentId(saveFileFolderPowerModel.getFileFolderId(), Long.valueOf(0L), Boolean.valueOf(false));
        if (fileFolderEntity == null) {
            return ResultModel.error((ResultStatus)ResultStatus.FILE_FOLDER_NO_EXIST, (String)languageType);
        }
        FileFolderPowerEntity fileFolderPowerEntity = this.findByFileFolderIdAndUserIdAndDelFlagFalse(saveFileFolderPowerModel.getFileFolderId(), userId);
        if (fileFolderPowerEntity == null) {
            return ResultModel.error((ResultStatus)ResultStatus.FILE_FOLDER_POWER_USER_NO_EXIST, (String)languageType);
        }
        if ("2".equals(fileFolderPowerEntity.getPowerType())) {
            return ResultModel.error((ResultStatus)ResultStatus.FILE_FOLDER_ADMIN_NO_EXIST, (String)languageType);
        }
        FileFolderPowerEntity fileFolderPowerAdmin = this.findByFileFolderIdAndPowerTypeZeroAndDelFlagFalse(saveFileFolderPowerModel.getFileFolderId());
        if (fileFolderPowerAdmin == null) {
            return ResultModel.error((ResultStatus)ResultStatus.FILE_FOLDER_POWER_ADMIN_NO_EXIST, (String)languageType);
        }
        UserPower one = null;
        UserPower two = null;
        for (UserPower userPower : saveFileFolderPowerModel.getUserPowerList()) {
            if (fileFolderPowerAdmin.getUserId().equals(userId)) {
                if (userPower.getPowerType().equals("0") && !userPower.getUserId().equals(userId)) {
                    if (one == null) {
                        one = userPower;
                        continue;
                    }
                    return ResultModel.error((ResultStatus)ResultStatus.SYS_ERROR, (String)languageType);
                }
                if (userPower.getUserId().equals(userId) && !userPower.getPowerType().equals("0")) {
                    if (two == null) {
                        two = userPower;
                        continue;
                    }
                    return ResultModel.error((ResultStatus)ResultStatus.SYS_ERROR, (String)languageType);
                }
                fileFolderPowerEntity = this.findByFileFolderIdAndUserIdAndDelFlagFalse(saveFileFolderPowerModel.getFileFolderId(), userPower.getUserId());
                if (fileFolderPowerEntity == null) {
                    return ResultModel.error((ResultStatus)ResultStatus.FILE_FOLDER_POWER_USER_NO_EXIST, (String)languageType);
                }
                this.saveOrUpdateFileFolderPower(fileFolderPowerEntity.getId(), userPower.getUserId(), userPower.getPowerType());
                continue;
            }
            if (fileFolderPowerAdmin.getUserId().equals(userId)) continue;
            fileFolderPowerEntity = this.findByFileFolderIdAndUserIdAndDelFlagFalse(saveFileFolderPowerModel.getFileFolderId(), userPower.getUserId());
            if (fileFolderPowerEntity == null) {
                return ResultModel.error((ResultStatus)ResultStatus.FILE_FOLDER_POWER_USER_NO_EXIST, (String)languageType);
            }
            this.saveOrUpdateFileFolderPower(fileFolderPowerEntity.getId(), userId, userPower.getPowerType());
        }
        if (one != null || two != null) {
            if (one != null && two != null) {
                fileFolderPowerEntity = this.findByFileFolderIdAndUserIdAndDelFlagFalse(saveFileFolderPowerModel.getFileFolderId(), one.getUserId());
                if (fileFolderPowerEntity == null) {
                    return ResultModel.error((ResultStatus)ResultStatus.FILE_FOLDER_POWER_USER_NO_EXIST, (String)languageType);
                }
                this.saveOrUpdateFileFolderPower(fileFolderPowerEntity.getId(), userId, one.getPowerType());
                fileFolderPowerEntity = this.findByFileFolderIdAndUserIdAndDelFlagFalse(saveFileFolderPowerModel.getFileFolderId(), two.getUserId());
                if (fileFolderPowerEntity == null) {
                    return ResultModel.error((ResultStatus)ResultStatus.FILE_FOLDER_POWER_USER_NO_EXIST, (String)languageType);
                }
                this.saveOrUpdateFileFolderPower(fileFolderPowerEntity.getId(), userId, two.getPowerType());
            } else {
                throw new Exception();
            }
        }
        return ResultModel.ok();
    }

    public ResultModel<FileFolderPowerInfoReturn> userPowerInfo(User user, Long fileFolderId, String languageType) {
        FileFolderPowerInfoReturn fileFolderPowerInfoReturn = new FileFolderPowerInfoReturn();
        FileFolderEntity fileFolderEntity = this.fileFolderService.findByIdAndParentId(fileFolderId, Long.valueOf(0L), Boolean.valueOf(false));
        if (fileFolderEntity == null) {
            return ResultModel.error((ResultStatus)ResultStatus.FILE_FOLDER_NO_EXIST, (String)languageType);
        }
        fileFolderPowerInfoReturn.setFileFolderId(fileFolderId);
        fileFolderPowerInfoReturn.setFileFolderName(fileFolderEntity.getName());
        FileFolderAdminInfoModel folderAdminInfoModel = this.findAdminUserByFileFolderIdAndPowerType(fileFolderEntity.getId());
        fileFolderPowerInfoReturn.setAdminId(folderAdminInfoModel.getId());
        fileFolderPowerInfoReturn.setAdminAvatar(folderAdminInfoModel.getAvatar());
        fileFolderPowerInfoReturn.setAdminName(folderAdminInfoModel.getName());
        List objectList = ((FileFolderPowerDao)this.dao).powerUserInfo(fileFolderId);
        if (objectList != null) {
            ArrayList<PowerUserInfo> powerUserInfos = new ArrayList<PowerUserInfo>();
            for (int i = 0; i < objectList.size(); ++i) {
                Object[] object = (Object[])objectList.get(i);
                PowerUserInfo powerUserInfo = new PowerUserInfo(Long.valueOf(object[0].toString()), object[1].toString(), object[2] != null ? object[2].toString() : null, object[3].toString());
                powerUserInfos.add(powerUserInfo);
            }
            fileFolderPowerInfoReturn.setPowerUserInfoList(powerUserInfos);
        }
        return ResultModel.suc((Object)fileFolderPowerInfoReturn);
    }

    public ResultModel exitFileFolder(Long userId, Long fileFolderId, String languageType) {
        FileFolderEntity fileFolderEntity = this.fileFolderService.findByIdAndParentId(fileFolderId, Long.valueOf(0L), Boolean.valueOf(false));
        if (fileFolderEntity == null) {
            return ResultModel.error((ResultStatus)ResultStatus.FILE_FOLDER_NO_EXIST, (String)languageType);
        }
        FileFolderPowerEntity fileFolderPowerEntity = ((FileFolderPowerDao)this.dao).findByFileFolderIdAndUserIdAndDelFlagFalse(fileFolderId, userId);
        if ("0".equals(fileFolderPowerEntity.getPowerType())) {
            return ResultModel.error((ResultStatus)ResultStatus.FILE_FOLDER_POWER_ADMIN_CONNOT_EXIST, (String)languageType);
        }
        ((FileFolderPowerDao)this.dao).delete((Object)fileFolderPowerEntity);
        return ResultModel.ok();
    }

    public ResultModel setFileFolderPower() {
        List allFirstFileFolders = this.fileFolderService.findAllFirstFileFolder();
        ArrayList<FileFolderPowerEntity> fileFolderPowerEntities = new ArrayList<FileFolderPowerEntity>();
        for (Object[] allFirstFileFolder : allFirstFileFolders) {
            FileFolderPowerEntity fileFolderPowerEntity = new FileFolderPowerEntity();
            fileFolderPowerEntity.setPowerType("0");
            fileFolderPowerEntity.setFileFolderId(Long.valueOf(allFirstFileFolder[0].toString()));
            fileFolderPowerEntity.setUserId(allFirstFileFolder[1] == null ? Long.valueOf(allFirstFileFolder[2].toString()) : Long.valueOf(allFirstFileFolder[1].toString()));
            fileFolderPowerEntity.setCreateBy(fileFolderPowerEntity.getUserId());
            fileFolderPowerEntities.add(fileFolderPowerEntity);
        }
        ((FileFolderPowerDao)this.dao).save(fileFolderPowerEntities);
        return ResultModel.ok();
    }
}

