/*
 * Decompiled with CFR 0.152.
 */
package com.ym.tlifang.service.company;

import com.alibaba.dubbo.config.annotation.Service;
import com.ym.tlifang.BaseEntity;
import com.ym.tlifang.ResultModel;
import com.ym.tlifang.ResultStatus;
import com.ym.tlifang.company.Company;
import com.ym.tlifang.company.CompanyPosition;
import com.ym.tlifang.company.CompanyUserRelation;
import com.ym.tlifang.dao.company.CompanyPositionDao;
import com.ym.tlifang.model.company.PositionAddDel;
import com.ym.tlifang.service.AbstractBaseService;
import com.ym.tlifang.service.company.CompanyPositionService;
import com.ym.tlifang.service.company.CompanyService;
import com.ym.tlifang.service.company.CompanyUserRelationService;
import java.util.HashSet;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Service(interfaceClass=CompanyPositionService.class, timeout=30000, retries=-1)
public class CompanyPositionServiceImpl
extends AbstractBaseService<CompanyPosition, CompanyPositionDao>
implements CompanyPositionService {
    @Autowired
    private CompanyUserRelationService companyUserRelationService;
    @Autowired
    private CompanyService companyService;

    public CompanyPosition findByIdAndCompanyIdAndDepartmentIdAndDelFlag(Long positionId, Long companyId, Long departmentId) {
        return ((CompanyPositionDao)this.dao).findByIdAndCompanyIdAndDepartmentIdAndDelFlag(positionId, companyId, departmentId, false);
    }

    public CompanyPosition findByCompanyIdAndDepartmentIdAndName(Long companyId, Long departmentId, String positionName) {
        return ((CompanyPositionDao)this.dao).findByCompanyIdAndDepartmentIdAndNameAndDelFlagFalse(companyId, departmentId, positionName);
    }

    public CompanyPosition findByCompanyIdAndDepartmentIdAndId(Long companyId, Long departmentId, Long positionId) {
        return ((CompanyPositionDao)this.dao).findByCompanyIdAndDepartmentIdAndIdAndDelFlagFalse(companyId, departmentId, positionId);
    }

    public List<CompanyPosition> findByCompanyIdAndDepartmentId(Long companyId, Long departmentId) {
        return ((CompanyPositionDao)this.dao).findByCompanyIdAndDepartmentIdAndDelFlagFalse(companyId, departmentId);
    }

    public List<CompanyPosition> findByCompanyIdAndDelFlagFalse(Long companyId) {
        return ((CompanyPositionDao)this.dao).findByCompanyIdAndDelFlagFalse(companyId);
    }

    public CompanyPosition findByCompanyIdAndMongodbId(Long companyId, String mongodbId) {
        return ((CompanyPositionDao)this.dao).findByCompanyIdAndMongodbId(companyId, mongodbId);
    }

    public ResultModel<CompanyPosition> updatePosition(PositionAddDel positionAddDel, Long companyId, String languageType) {
        if (positionAddDel.getAddPosition() != null) {
            String[] stringArray = positionAddDel.getAddPosition();
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String addPosition = stringArray[i];
                CompanyPosition companyPositionName = this.findByCompanyIdAndDepartmentIdAndName(companyId, positionAddDel.getDepartmentId(), addPosition);
                if (companyPositionName != null) {
                    return ResultModel.error((ResultStatus)ResultStatus.POSITION_REPEAT_EXIST, (String)languageType);
                }
                CompanyPosition companyPosition = new CompanyPosition(companyId, positionAddDel.getDepartmentId(), addPosition);
                this.save((BaseEntity)companyPosition);
            }
        }
        if (positionAddDel.getDelPosition() != null) {
            for (Long delPosition : positionAddDel.getDelPosition()) {
                CompanyPosition companyPosition;
                List companyUserRelations = this.companyUserRelationService.findByPositionIdAndDelFlagFalse(delPosition);
                if (companyUserRelations != null) {
                    for (CompanyUserRelation companyUserRelation : companyUserRelations) {
                        companyUserRelation.setPositionId(null);
                        this.companyUserRelationService.save(companyUserRelation);
                    }
                }
                if ((companyPosition = this.findByIdAndCompanyIdAndDepartmentIdAndDelFlag(delPosition, companyId, positionAddDel.getDepartmentId())) == null) {
                    return ResultModel.error((ResultStatus)ResultStatus.POSITION_NO_EXIST, (String)languageType);
                }
                companyPosition.setDelFlag(Boolean.valueOf(true));
                this.save((BaseEntity)companyPosition);
            }
        }
        Company company = null;
        company = companyId.equals(positionAddDel.getDepartmentId()) ? this.companyService.findById(companyId) : this.companyService.findByDepartmentId(positionAddDel.getDepartmentId());
        List companyUserRelations = this.companyUserRelationService.findByCompanyIdAndDepartmentId(companyId, positionAddDel.getDepartmentId());
        company.setMembers(companyUserRelations);
        List companyPositions = this.findByCompanyIdAndDepartmentId(companyId, positionAddDel.getDepartmentId());
        company.setPositions(new HashSet(companyPositions));
        return ResultModel.suc((Object)company);
    }

    public ResultModel<CompanyUserRelation> updatePositionSetting(CompanyUserRelation companyUserRelation, CompanyPosition companyPosition) {
        companyUserRelation.setPositionId(companyPosition.getId());
        this.companyUserRelationService.save(companyUserRelation);
        Company company = this.companyService.findById(companyUserRelation.getCompanyId());
        List companyUserRelations = this.companyUserRelationService.findByCompanyIdAndDepartmentId(companyUserRelation.getCompanyId(), companyUserRelation.getDepartmentId());
        company.setMembers(companyUserRelations);
        return ResultModel.suc((Object)company);
    }
}

