/*
 * Decompiled with CFR 0.152.
 */
package com.ym.tlifang.service.attendance;

import com.alibaba.dubbo.config.annotation.Service;
import com.ym.tlifang.BaseEntity;
import com.ym.tlifang.Constants;
import com.ym.tlifang.attendance.AttendanceHolidays;
import com.ym.tlifang.attendance.AttendanceTime;
import com.ym.tlifang.attendance.AttendanceWeekday;
import com.ym.tlifang.attendance.AttendanceWorkday;
import com.ym.tlifang.dao.attendance.AttendanceWorkdayDao;
import com.ym.tlifang.service.AbstractBaseService;
import com.ym.tlifang.service.attendance.AttendanceHolidaysService;
import com.ym.tlifang.service.attendance.AttendanceTimeService;
import com.ym.tlifang.service.attendance.AttendanceWeekdayService;
import com.ym.tlifang.service.attendance.AttendanceWorkdayService;
import com.ym.tlifang.util.DateUtils;
import com.ym.tlifang.util.StringUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Service(interfaceClass=AttendanceWorkdayService.class, timeout=30000, retries=-1)
public class AttendanceWorkdayServiceImpl
extends AbstractBaseService<AttendanceWorkday, AttendanceWorkdayDao>
implements AttendanceWorkdayService {
    @Autowired
    private AttendanceWeekdayService attendanceWeekdayService;
    @Autowired
    private AttendanceTimeService attendanceTimeService;
    @Autowired
    private AttendanceHolidaysService attendanceHolidaysService;

    public AttendanceWorkday save(AttendanceWorkday attendanceWorkday) {
        return (AttendanceWorkday)super.save((BaseEntity)attendanceWorkday);
    }

    public List<AttendanceWorkday> findByClassesIdAndDelFlagFalse(Long classesId) {
        return ((AttendanceWorkdayDao)this.dao).findByClassesIdAndDelFlagFalse(classesId);
    }

    public AttendanceWorkday findByClassesId(Long classesId, Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        String workday = Integer.valueOf(cal.get(7)).toString();
        if (Constants.WorkdayType.attendMon.getType().equals(workday)) {
            return ((AttendanceWorkdayDao)this.dao).findByClassesIdAndDelFlagFalseAndMonTrue(classesId);
        }
        if (Constants.WorkdayType.attendTue.getType().equals(workday)) {
            return ((AttendanceWorkdayDao)this.dao).findByClassesIdAndDelFlagFalseAndTueTrue(classesId);
        }
        if (Constants.WorkdayType.attendWed.getType().equals(workday)) {
            return ((AttendanceWorkdayDao)this.dao).findByClassesIdAndDelFlagFalseAndWedTrue(classesId);
        }
        if (Constants.WorkdayType.attendThu.getType().equals(workday)) {
            return ((AttendanceWorkdayDao)this.dao).findByClassesIdAndDelFlagFalseAndThuTrue(classesId);
        }
        if (Constants.WorkdayType.attendFri.getType().equals(workday)) {
            return ((AttendanceWorkdayDao)this.dao).findByClassesIdAndDelFlagFalseAndFriTrue(classesId);
        }
        if (Constants.WorkdayType.attendSat.getType().equals(workday)) {
            return ((AttendanceWorkdayDao)this.dao).findByClassesIdAndDelFlagFalseAndSatTrue(classesId);
        }
        if (Constants.WorkdayType.attendSun.getType().equals(workday)) {
            return ((AttendanceWorkdayDao)this.dao).findByClassesIdAndDelFlagFalseAndSunTrue(classesId);
        }
        return null;
    }

    public List<String> getRemind(Long classId, Date date, String remind, Boolean downRemand, Boolean isNow, Boolean legal, int number) {
        List<String> strings = new ArrayList<String>();
        List timeList = this.attendanceWeekdayService.findByTypeTwo(classId, date);
        if (StringUtils.isEmpty((Object)timeList) || timeList.size() == 0) {
            AttendanceWorkday attendanceWorkday;
            AttendanceWeekday attendanceWeekday = this.attendanceWeekdayService.findByType(classId, date);
            AttendanceHolidays attendanceHolidays = null;
            if (legal.booleanValue()) {
                attendanceHolidays = this.attendanceHolidaysService.findByDate(DateUtils.formatDate((Date)date, (Object[])new Object[]{"yyyy-MM-dd"}));
            }
            if (attendanceWeekday == null && attendanceHolidays == null && (attendanceWorkday = this.findByClassesId(classId, date)) != null) {
                List attendanceTimeList = this.attendanceTimeService.findByWorkdayIdAndDelFlagFalse(attendanceWorkday.getId());
                ArrayList<String> times = new ArrayList<String>();
                for (AttendanceTime attendanceTime : attendanceTimeList) {
                    times.add(attendanceTime.getBegin());
                    times.add(attendanceTime.getEnd());
                }
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                String day = sdf.format(date);
                if (isNow.booleanValue()) {
                    for (int i = 0; i < times.size(); ++i) {
                        try {
                            sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
                            Date dateTwo = sdf.parse(day + " " + (String)times.get(i));
                            if (i % 2 == 0) {
                                GregorianCalendar calendar = new GregorianCalendar();
                                calendar.setTime(dateTwo);
                                ((Calendar)calendar).add(12, Integer.valueOf(remind));
                                dateTwo = calendar.getTime();
                                if (dateTwo.getTime() <= date.getTime()) continue;
                                strings.add(sdf.format(dateTwo));
                                strings.add(i + 1 + "");
                            } else {
                                if (!downRemand.booleanValue() || dateTwo.getTime() <= date.getTime()) continue;
                                strings.add(day + " " + (String)times.get(i));
                                strings.add(i + 1 + "");
                            }
                            break;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                } else {
                    strings.add(DateUtils.formatDateTime((Date)DateUtils.addDateMinute((Date)DateUtils.parseDate((Object)(day + " " + (String)times.get(0))), (int)Integer.valueOf(remind))));
                    strings.add("1");
                }
            }
        } else {
            ArrayList<String> attendanceTimes = new ArrayList<String>();
            for (Map map : timeList) {
                attendanceTimes.add(map.get("begin").toString());
                attendanceTimes.add(map.get("end").toString());
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            String day = sdf.format(date);
            if (isNow.booleanValue()) {
                for (int i = 0; i < attendanceTimes.size(); ++i) {
                    try {
                        sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
                        Date dateTwo = sdf.parse(day + " " + (String)attendanceTimes.get(i));
                        if (i / 2 == 0) {
                            GregorianCalendar calendar = new GregorianCalendar();
                            calendar.setTime(dateTwo);
                            ((Calendar)calendar).add(12, Integer.valueOf(remind));
                            dateTwo = calendar.getTime();
                            if (dateTwo.getTime() <= date.getTime()) continue;
                            strings.add(sdf.format(dateTwo));
                            strings.add(String.valueOf(i + 1));
                        } else {
                            if (!downRemand.booleanValue() || dateTwo.getTime() <= date.getTime()) continue;
                            strings.add(day + " " + (String)attendanceTimes.get(i));
                            strings.add(i + 1 + "");
                        }
                        break;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            } else {
                strings.add(DateUtils.formatDateTime((Date)DateUtils.addDateMinute((Date)DateUtils.parseDate((Object)(day + " " + (String)attendanceTimes.get(0))), (int)Integer.valueOf(remind))));
                strings.add("1");
            }
        }
        if (strings.size() == 0) {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(date);
            ((Calendar)calendar).add(5, 1);
            date = calendar.getTime();
            if (++number < 32) {
                strings = this.getRemind(classId, date, remind, downRemand, Boolean.valueOf(false), legal, number);
            }
        }
        return strings;
    }

    public Map<String, AttendanceWorkday> getAllWorkDay(Long classesId) {
        HashMap<String, AttendanceWorkday> map = new HashMap<String, AttendanceWorkday>();
        AttendanceWorkday attendanceWorkdayMon = ((AttendanceWorkdayDao)this.dao).findByClassesIdAndDelFlagFalseAndMonTrue(classesId);
        map.put(Constants.WorkdayType.attendMon.getType(), attendanceWorkdayMon);
        AttendanceWorkday attendanceWorkdayTue = ((AttendanceWorkdayDao)this.dao).findByClassesIdAndDelFlagFalseAndTueTrue(classesId);
        map.put(Constants.WorkdayType.attendTue.getType(), attendanceWorkdayTue);
        AttendanceWorkday attendanceWorkdayWed = ((AttendanceWorkdayDao)this.dao).findByClassesIdAndDelFlagFalseAndWedTrue(classesId);
        map.put(Constants.WorkdayType.attendWed.getType(), attendanceWorkdayWed);
        AttendanceWorkday attendanceWorkdayThu = ((AttendanceWorkdayDao)this.dao).findByClassesIdAndDelFlagFalseAndThuTrue(classesId);
        map.put(Constants.WorkdayType.attendThu.getType(), attendanceWorkdayThu);
        AttendanceWorkday attendanceWorkdayFri = ((AttendanceWorkdayDao)this.dao).findByClassesIdAndDelFlagFalseAndFriTrue(classesId);
        map.put(Constants.WorkdayType.attendFri.getType(), attendanceWorkdayFri);
        AttendanceWorkday attendanceWorkdaySat = ((AttendanceWorkdayDao)this.dao).findByClassesIdAndDelFlagFalseAndSatTrue(classesId);
        map.put(Constants.WorkdayType.attendSat.getType(), attendanceWorkdaySat);
        AttendanceWorkday attendanceWorkdaySun = ((AttendanceWorkdayDao)this.dao).findByClassesIdAndDelFlagFalseAndSunTrue(classesId);
        map.put(Constants.WorkdayType.attendSun.getType(), attendanceWorkdaySun);
        return map;
    }

    public void deleteAllWorkDay(Long classId) {
        ((AttendanceWorkdayDao)this.dao).deleteAllBy(classId);
    }

    public List<AttendanceWorkday> saveAll(List<AttendanceWorkday> attendanceWorkdays) {
        return ((AttendanceWorkdayDao)this.dao).save(attendanceWorkdays);
    }
}

