/*
 * Decompiled with CFR 0.152.
 */
package com.ym.tlifang.service.attendance;

import com.alibaba.dubbo.config.annotation.Service;
import com.ym.tlifang.BaseEntity;
import com.ym.tlifang.attendance.AttendanceWeekday;
import com.ym.tlifang.dao.attendance.AttendanceWeekdayDao;
import com.ym.tlifang.service.AbstractBaseService;
import com.ym.tlifang.service.attendance.AttendanceHolidaysService;
import com.ym.tlifang.service.attendance.AttendanceUserRecordService;
import com.ym.tlifang.service.attendance.AttendanceWeekdayService;
import com.ym.tlifang.service.attendance.AttendanceWorkdayService;
import com.ym.tlifang.util.JsonUtil;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Service(interfaceClass=AttendanceWeekdayService.class, timeout=30000, retries=-1)
public class AttendanceWeekdayServiceImpl
extends AbstractBaseService<AttendanceWeekday, AttendanceWeekdayDao>
implements AttendanceWeekdayService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private AttendanceWorkdayService attendanceWorkdayService;
    @Autowired
    private AttendanceUserRecordService attendanceUserRecordService;
    @Autowired
    AttendanceHolidaysService attendanceHolidaysService;

    public AttendanceWeekday save(AttendanceWeekday attendanceWeekday) {
        return (AttendanceWeekday)super.save((BaseEntity)attendanceWeekday);
    }

    public List<AttendanceWeekday> findByClassId(Long classesId, Date dates) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String date = sdf.format(dates);
        return ((AttendanceWeekdayDao)this.dao).findByClassesIdAndDateAfterAndDelFlagFalse(classesId, date);
    }

    public AttendanceWeekday findByType(Long classesId, Date dates) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String date = sdf.format(dates);
        return ((AttendanceWeekdayDao)this.dao).findByClassesIdAndDateAndTypeAndDelFlagFalse(classesId, date, "1");
    }

    public List findByTypeTwo(Long classesId, Date dates) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String date = sdf.format(dates);
        AttendanceWeekday attendanceWeekday = ((AttendanceWeekdayDao)this.dao).findByClassesIdAndDateAndTypeAndDelFlagFalse(classesId, date, "2");
        if (attendanceWeekday != null) {
            try {
                List list = (List)JsonUtil.jackson.readValue(attendanceWeekday.getTimeArray(), List.class);
                return list;
            }
            catch (IOException e) {
                e.printStackTrace();
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    public List<AttendanceWeekday> findLegal(Long classesId) {
        return ((AttendanceWeekdayDao)this.dao).findByClassesIdAndTypeAndDelFlagFalse(classesId, "3");
    }

    public AttendanceWeekday findWorkday(Long classesId, String date, String type) {
        return ((AttendanceWeekdayDao)this.dao).findByClassesIdAndDateAndTypeAndDelFlagFalse(classesId, date, type);
    }

    public List<AttendanceWeekday> findToday(Long classesId, Date dates) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String date = sdf.format(dates);
        return ((AttendanceWeekdayDao)this.dao).findByClassesIdAndDateAndDelFlagFalse(classesId, date);
    }
}

