/*
 * Decompiled with CFR 0.152.
 */
package com.ym.tlifang.service.attendance;

import com.alibaba.dubbo.config.annotation.Service;
import com.ym.tlifang.BaseEntity;
import com.ym.tlifang.PageInfo;
import com.ym.tlifang.ResultModel;
import com.ym.tlifang.attendance.AttendanceReportUser;
import com.ym.tlifang.dao.attendance.AttendanceReportUserDao;
import com.ym.tlifang.model.attendance.AttendancePersonalDetailModel;
import com.ym.tlifang.model.attendance.GetNewMonthCountModel;
import com.ym.tlifang.model.statistics.MemberStatisticsModel;
import com.ym.tlifang.service.AbstractBaseService;
import com.ym.tlifang.service.attendance.AttendanceReportUserService;
import com.ym.tlifang.service.company.CompanyUserRelationService;
import com.ym.tlifang.util.DateUtils;
import com.ym.tlifang.util.JsonUtil;
import com.ym.tlifang.util.StringUtils;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Service(interfaceClass=AttendanceReportUserService.class, timeout=30000, retries=-1)
public class AttendanceReportUserServiceImpl
extends AbstractBaseService<AttendanceReportUser, AttendanceReportUserDao>
implements AttendanceReportUserService {
    @Autowired
    CompanyUserRelationService companyUserRelationService;
    @PersistenceContext
    private EntityManager entityManager;

    public AttendanceReportUser save(AttendanceReportUser attendanceReportUser) {
        return (AttendanceReportUser)super.save((BaseEntity)attendanceReportUser);
    }

    public List<AttendanceReportUser> findByReportUser(Long reportId) {
        return ((AttendanceReportUserDao)this.dao).findByReportIdOrderByDepartName(reportId);
    }

    public AttendanceReportUser findByReportIdAndUserId(Long companyId, Long userId, String date) {
        return ((AttendanceReportUserDao)this.dao).findCompanyIdAndUserId(companyId, userId, date);
    }

    public Integer findMonthPeople(Long companyId, String date) {
        return ((AttendanceReportUserDao)this.dao).findMonthPeople(companyId, date);
    }

    public Integer findMonthSignOut(Long companyId, String date) {
        return ((AttendanceReportUserDao)this.dao).findMonthSignOut(companyId, date);
    }

    public Integer findMonthFail(Long companyId, String date) {
        return ((AttendanceReportUserDao)this.dao).findMonthFail(companyId, date);
    }

    public List<MemberStatisticsModel> findMemberStatisticsByCompany(Long companyId, Long departmentId, Integer intervalType, String startTime, String endTime, Integer pageNo, Integer pageSize) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        Calendar calendar = Calendar.getInstance();
        switch (intervalType) {
            case 1: {
                startTime = DateUtils.formatDate((Date)sdf.parse(startTime), (Object[])new Object[]{"yyyy-MM-dd"});
                calendar.setTime(sdf.parse(endTime));
                calendar.set(5, calendar.getActualMaximum(5));
                endTime = DateUtils.formatDate((Date)calendar.getTime(), (Object[])new Object[]{"yyyy-MM-dd"});
                break;
            }
            case 2: {
                sdf = new SimpleDateFormat("yyyy");
                startTime = DateUtils.formatDateTime((Date)sdf.parse(startTime));
                if (DateFormatUtils.format((Date)new Date(), (String)"yyyy").equals(endTime)) {
                    endTime = new SimpleDateFormat("yyyy-MM-dd").format(DateUtils.addDateNum((Date)new Date(), (int)-1));
                    break;
                }
                calendar.setTime(sdf.parse(endTime));
                calendar.set(2, 11);
                calendar.roll(5, -1);
                endTime = DateUtils.formatDateTime((Date)calendar.getTime());
                break;
            }
        }
        Integer num = this.companyUserRelationService.findNumberOfMembers(companyId, departmentId);
        PageInfo pageInfo = new PageInfo();
        pageInfo.setPageNo(StringUtils.isEmpty((Object)pageNo) ? 1 : pageNo);
        pageInfo.setPages((int)Math.ceil((double)num.intValue() / (double)pageSize.intValue()));
        pageNo = StringUtils.isEmpty((Object)pageNo) || pageNo.equals(1) ? 0 : (pageNo - 1) * pageSize - 1;
        ArrayList<MemberStatisticsModel> memberStatisticsList = new ArrayList<MemberStatisticsModel>();
        memberStatisticsList.add((MemberStatisticsModel)pageInfo);
        List result = ((AttendanceReportUserDao)this.dao).findMemberStatistics(companyId, departmentId, startTime, endTime, pageNo, pageSize);
        for (Object[] row : result) {
            MemberStatisticsModel memberStatisticsModel = new MemberStatisticsModel();
            memberStatisticsModel.setUserId(Long.valueOf(row[0].toString()));
            memberStatisticsModel.setUserName(row[1].toString());
            memberStatisticsModel.setUserAvatar(row[2].toString());
            memberStatisticsModel.setCompanyId(Long.valueOf(row[3].toString()));
            memberStatisticsModel.setDepartmentId(Long.valueOf(row[4].toString()));
            memberStatisticsModel.setDepartmentName(row[5].toString());
            memberStatisticsModel.setSignedNum(Integer.valueOf(row[6] == null ? 0 : Integer.valueOf(row[6].toString())));
            memberStatisticsModel.setSignBackNum(Integer.valueOf(row[7] == null ? 0 : Integer.valueOf(row[7].toString())));
            memberStatisticsModel.setLaterNum(Integer.valueOf(row[8] == null ? 0 : Integer.valueOf(row[8].toString())));
            memberStatisticsModel.setEarlyNum(Integer.valueOf(row[9] == null ? 0 : Integer.valueOf(row[9].toString())));
            memberStatisticsModel.setAbsenteeismNum(Integer.valueOf(row[10] == null ? 0 : row[10].toString().split(",").length));
            memberStatisticsModel.setOutsideNum(Integer.valueOf(row[11] == null ? 0 : Integer.valueOf(row[11].toString())));
            memberStatisticsModel.setApproveNum(Integer.valueOf(row[12].toString()));
            memberStatisticsModel.setProjectNum(Integer.valueOf(row[13].toString()));
            memberStatisticsModel.setTaskNum(Integer.valueOf(row[14] == null ? 0 : Integer.valueOf(row[14].toString())));
            memberStatisticsModel.setMeetingNum(Integer.valueOf(row[15].toString()));
            memberStatisticsModel.setReportUseMum(Integer.valueOf(row[16].toString()));
            memberStatisticsList.add(memberStatisticsModel);
        }
        return memberStatisticsList;
    }

    public ResultModel<List<AttendancePersonalDetailModel>> findPersonalDetail(Long userId, Long companyId, String lastDay, String languageType) throws Exception {
        List objectList = ((AttendanceReportUserDao)this.dao).findAttendanceFail(companyId, userId, lastDay);
        ArrayList<AttendancePersonalDetailModel> attendancePersonalDetailModelList = new ArrayList<AttendancePersonalDetailModel>();
        for (Object[] objects : objectList) {
            List failAttendance = (List)JsonUtil.jackson.readValue(objects[1].toString(), List.class);
            for (Integer day : failAttendance) {
                AttendancePersonalDetailModel attendancePersonalDetailModel = new AttendancePersonalDetailModel();
                attendancePersonalDetailModel.setDate(lastDay + "-" + (day < 10 ? "0" + day : day));
                if (attendancePersonalDetailModel.getDate().equals(DateUtils.getDate())) continue;
                attendancePersonalDetailModelList.add(attendancePersonalDetailModel);
            }
        }
        return ResultModel.suc(attendancePersonalDetailModelList, (String)languageType);
    }

    public PageInfo<GetNewMonthCountModel> findNewAttendanceCount(String date, Long companyId, String userName, String departName, Integer pageNo) {
        if (!StringUtils.isEmpty((Object)departName)) {
            departName = "%" + departName + "%";
        }
        String sql = "SELECT\n a.id AS id,\n a.user_name ,\n a.depart_name,\n a.user_id,\n a.attendance_times,\n a.attendance_success,\n a.fail_attendance_array,\n a.leave_num,\n a.later_num,\n a.early_num,\n a.retroactive_num, a.outside_Times AS outside_times,\n c.avatar\nFROM\n `tlf_attendance_report_user` a\nLEFT JOIN tlf_attendance_report b ON a.report_id = b.id\nLEFT JOIN tlf_user c ON a.user_id = c.id\nWHERE\n b.date = ?1\nAND b.company_id = ?2\nAND (\n CASE\n WHEN ?3 IS NULL THEN\n  1 = 1\n ELSE\n  a.user_name = ?3\n END\n)\nAND (\n CASE\n WHEN ?4 IS NULL THEN\n  1 = 1\n ELSE\n  a.depart_name like ?4\n END\n) limit ?5,10";
        List getNewMonthCountModels = this.entityManager.createNativeQuery(sql, GetNewMonthCountModel.class).setParameter(1, (Object)date).setParameter(2, (Object)companyId).setParameter(3, (Object)userName).setParameter(4, (Object)departName).setParameter(5, (Object)(10 * (pageNo - 1))).getResultList();
        for (GetNewMonthCountModel getNewMonthCountModel : getNewMonthCountModels) {
            try {
                getNewMonthCountModel.setFailAttendanceNum(Integer.valueOf(((List)JsonUtil.jackson.readValue(getNewMonthCountModel.getFailAttendanceArray(), List.class)).size()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        PageInfo getNewMonthCountModelPageInfo = new PageInfo();
        getNewMonthCountModelPageInfo.setRows(getNewMonthCountModels);
        getNewMonthCountModelPageInfo.setPageNo(pageNo.intValue());
        Integer total = ((AttendanceReportUserDao)this.dao).findAttendanceNum(date, companyId, userName, departName);
        getNewMonthCountModelPageInfo.setTotal((long)total.intValue());
        getNewMonthCountModelPageInfo.setPages(total / 10 + 1);
        return getNewMonthCountModelPageInfo;
    }
}

