/*
 * Decompiled with CFR 0.152.
 */
package com.ym.tlifang.service.approval;

import com.alibaba.dubbo.config.annotation.Service;
import com.ym.tlifang.BaseEntity;
import com.ym.tlifang.approval.ApprovalTemplate;
import com.ym.tlifang.approval.ApprovalTemplateForm;
import com.ym.tlifang.approval.ApprovalTemplateFormType;
import com.ym.tlifang.dao.approval.ApprovalTemplateDao;
import com.ym.tlifang.service.AbstractBaseService;
import com.ym.tlifang.service.approval.ApprovalTemplateFormService;
import com.ym.tlifang.service.approval.ApprovalTemplateFormTypeService;
import com.ym.tlifang.service.approval.ApprovalTemplateService;
import com.ym.tlifang.util.StringUtils;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Service(interfaceClass=ApprovalTemplateService.class, timeout=30000, retries=-1)
public class ApprovalTemplateServiceImpl
extends AbstractBaseService<ApprovalTemplate, ApprovalTemplateDao>
implements ApprovalTemplateService {
    @Autowired
    private ApprovalTemplateFormService approvalTemplateFormService;
    @Autowired
    private ApprovalTemplateFormTypeService approvalTemplateFormTypeService;

    public ApprovalTemplate save(ApprovalTemplate approvalTemplate) {
        return (ApprovalTemplate)super.save((BaseEntity)approvalTemplate);
    }

    public ApprovalTemplate findById(Long templateId) {
        return ((ApprovalTemplateDao)this.dao).findByIdAndDelFlagFalse(templateId);
    }

    public ApprovalTemplate findByIdNotDelFlag(Long templateId) {
        return ((ApprovalTemplateDao)this.dao).findById(templateId);
    }

    public ApprovalTemplate findByOne(Long templateId) {
        return ((ApprovalTemplateDao)this.dao).findById(templateId);
    }

    public List<ApprovalTemplate> findByCompanyId(Long companyId) {
        return ((ApprovalTemplateDao)this.dao).findByCompanyIdAndDelFlagFalse(companyId);
    }

    public List<ApprovalTemplate> findByCompanyIdAndState(Long companyId, String state) {
        return ((ApprovalTemplateDao)this.dao).findByCompanyIdAndStateAndDelFlagFalse(companyId, state);
    }

    public void saveInitTemplate(Long companyId, String languageType) {
        List approvalTemplates = ((ApprovalTemplateDao)this.dao).findByCompanyIdIsNullAndDelFlagFalse();
        for (ApprovalTemplate approvalTemplate : approvalTemplates) {
            ApprovalTemplate template = new ApprovalTemplate();
            template.init(approvalTemplate);
            template.setEnName(approvalTemplate.getEnName());
            template.setCompanyId(companyId);
            template.setDefaultis("1");
            template = (ApprovalTemplate)super.save((BaseEntity)template);
            List approvalTemplateFormList = approvalTemplate.getApprovalTemplateFormSet();
            if (StringUtils.isEmpty((Object)approvalTemplateFormList)) continue;
            for (ApprovalTemplateForm approvalTemplateForm : approvalTemplateFormList) {
                ApprovalTemplateForm templateForm = new ApprovalTemplateForm();
                templateForm.init(approvalTemplateForm);
                templateForm.setEnName(approvalTemplateForm.getEnName());
                templateForm.setTemplateId(template.getId());
                templateForm = this.approvalTemplateFormService.save(templateForm);
                List approvalTemplateFormTypeSet = approvalTemplateForm.getApprovalTemplateFormTypeSet();
                if (StringUtils.isEmpty((Object)approvalTemplateFormTypeSet)) continue;
                for (ApprovalTemplateFormType approvalTemplateFormType : approvalTemplateFormTypeSet) {
                    ApprovalTemplateFormType templateFormType = new ApprovalTemplateFormType(templateForm.getId(), approvalTemplateFormType.getLabel(), approvalTemplateFormType.getValue(), approvalTemplateFormType.getType());
                    templateFormType.setEnName(approvalTemplateFormType.getEnName());
                    this.approvalTemplateFormTypeService.save(templateFormType);
                }
            }
        }
    }

    public ApprovalTemplate findByMongodbId(String mongodbId) {
        return ((ApprovalTemplateDao)this.dao).findByMongodbId(mongodbId);
    }

    public ApprovalTemplate findByCompanyIdAndStateAndSign(Long companyId, String state, String sign) {
        List list = ((ApprovalTemplateDao)this.dao).findByCompanyIdAndStateAndSignAndDelFlagFalse(companyId, state, sign);
        return list == null || list.size() == 0 ? null : (ApprovalTemplate)list.get(0);
    }

    public List<Long> findByTypeAndDelFlagFalse(String type) {
        return ((ApprovalTemplateDao)this.dao).findByTypeAndDelFlagFalse(type);
    }
}

