/*
 * Decompiled with CFR 0.152.
 */
package com.ym.tlifang.service.agenda;

import com.alibaba.dubbo.config.annotation.Service;
import com.ym.tlifang.BaseEntity;
import com.ym.tlifang.Constants;
import com.ym.tlifang.agenda.Agenda;
import com.ym.tlifang.dao.agenda.AgendaDao;
import com.ym.tlifang.service.AbstractBaseService;
import com.ym.tlifang.service.agenda.AgendaService;
import com.ym.tlifang.service.user.UserService;
import com.ym.tlifang.user.User;
import com.ym.tlifang.util.DateUtils;
import com.ym.tlifang.util.StringUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

@Component
@Service(interfaceClass=AgendaService.class, timeout=30000, retries=-1)
public class AgendaServiceImpl
extends AbstractBaseService<Agenda, AgendaDao>
implements AgendaService {
    @Autowired
    private StringRedisTemplate redis;
    @Autowired
    private AgendaService agendaService;
    @Autowired
    private UserService userService;

    public Agenda save(Agenda entity) {
        return (Agenda)super.save((BaseEntity)entity);
    }

    public Agenda saveAgenda(Agenda agenda) {
        agenda = (Agenda)((AgendaDao)this.dao).save((Object)agenda);
        String key = Constants.SCHEDULE_AGENDA + agenda.getId();
        String remind = agenda.getRemind();
        Date date = this.getRemind(agenda, remind);
        this.redis.boundValueOps((Object)key).set((Object)key);
        this.redis.boundValueOps((Object)key).expireAt(date);
        return agenda;
    }

    public Agenda findById(Long id) {
        return ((AgendaDao)this.dao).findByIdAndDelFlagFalse(id);
    }

    public Map<String, List> findUserMonthAgendaList(Long companyId, Long userId, String dateString) {
        List agendaList = null;
        HashSet<Date> dateSet = new HashSet<Date>();
        HashMap<String, List> map = new HashMap<String, List>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        agendaList = StringUtils.isEmpty((Object)companyId) ? ((AgendaDao)this.dao).findUserMonthAgendaList(userId, dateString) : ((AgendaDao)this.dao).findUserMonthAgendaListCompany(companyId, userId, dateString);
        for (Agenda agenda : agendaList) {
            try {
                List list = DateUtils.getBetweenDates((Date)sdf.parse(agenda.getStartTime()), (Date)sdf.parse(agenda.getEndTime()));
                for (Date date : list) {
                    if (!DateUtils.sameMonth((Date)date, (Date)DateUtils.parseDate((Object)dateString))) continue;
                    dateSet.add(date);
                }
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        for (Date date : dateSet) {
            ArrayList<Agenda> dayAgendaList = new ArrayList<Agenda>();
            for (Agenda agendaObject : agendaList) {
                boolean containflag;
                Date startTime = null;
                Date endTime = null;
                try {
                    startTime = sdf.parse(agendaObject.getStartTime());
                    endTime = sdf.parse(agendaObject.getEndTime());
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                if (!(containflag = DateUtils.isEffectiveDate((Date)date, (Date)startTime, endTime))) continue;
                User user = this.userService.findById(agendaObject.getUserId());
                agendaObject.setUser(user);
                dayAgendaList.add(agendaObject);
            }
            String keyDate = sdf.format(date);
            map.put(keyDate, dayAgendaList);
        }
        return map;
    }

    public List<Agenda> findByDelFlagFalse() {
        return ((AgendaDao)this.dao).findByDelFlagFalse();
    }

    public boolean setNextNoticeTimeScheduleAgenda(Long agendaId) {
        Agenda oldAgenda = ((AgendaDao)this.dao).findByIdAndDelFlagFalse(agendaId);
        if (oldAgenda != null) {
            if (Constants.LoopTaskType.noRepeat.getType().equals(oldAgenda.getRecur())) {
                return false;
            }
            Agenda newAgenda = oldAgenda;
            Map mapTime = this.getAgendaNextTime(oldAgenda);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
            newAgenda.setStartTime(sdf.format((Date)mapTime.get("startTime")));
            newAgenda.setEndTime(sdf.format((Date)mapTime.get("endTime")));
            newAgenda.setId(null);
            newAgenda = this.agendaService.saveAgenda(newAgenda);
            String key = Constants.SCHEDULE_AGENDA + newAgenda.getId();
            String remind = newAgenda.getRemind();
            Date date = this.getRemind(newAgenda, remind);
            if (!this.redis.hasKey((Object)key).booleanValue()) {
                this.redis.boundValueOps((Object)key).set((Object)key);
                this.redis.boundValueOps((Object)key).expireAt(date);
            }
            return true;
        }
        return false;
    }

    public Map<String, Date> getAgendaNextTime(Agenda oldAgenda) {
        HashMap<String, Date> map = new HashMap<String, Date>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        Date startTime = null;
        Date endTime = null;
        try {
            startTime = sdf.parse(oldAgenda.getStartTime());
            endTime = sdf.parse(oldAgenda.getEndTime());
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        if (Constants.LoopTaskType.everyday.getType().equals(oldAgenda.getRecur())) {
            map.put("startTime", DateUtils.addDateNum((Date)startTime, (int)1));
            map.put("endTime", DateUtils.addDateNum((Date)endTime, (int)1));
        }
        if (Constants.LoopTaskType.weekly.getType().equals(oldAgenda.getRecur())) {
            map.put("startTime", DateUtils.addDateNum((Date)startTime, (int)7));
            map.put("endTime", DateUtils.addDateNum((Date)endTime, (int)7));
        }
        if (Constants.LoopTaskType.manthly.getType().equals(oldAgenda.getRecur())) {
            map.put("startTime", DateUtils.addDateMonth((Date)startTime, (int)1));
            map.put("endTime", DateUtils.addDateMonth((Date)endTime, (int)1));
        }
        if (Constants.LoopTaskType.yearly.getType().equals(oldAgenda.getRecur())) {
            map.put("startTime", DateUtils.addDateYear((Date)startTime, (int)1));
            map.put("endTime", DateUtils.addDateYear((Date)endTime, (int)1));
        }
        return map;
    }

    public Date getRemind(Agenda newAgenda, String remind) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        String startString = newAgenda.getStartTime();
        String endString = newAgenda.getEndTime();
        Date startDate = null;
        Date endDate = null;
        Date returnDate = null;
        try {
            startDate = sdf.parse(startString);
            endDate = sdf.parse(endString);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        if (Constants.AgendaRemind.noRemind.getType().equals(remind)) {
            return endDate;
        }
        if (Constants.AgendaRemind.going.getType().equals(remind)) {
            return startDate;
        }
        if (Constants.AgendaRemind.tenMiuteAgo.getType().equals(remind)) {
            returnDate = DateUtils.addDateMinute((Date)startDate, (int)-10);
        }
        if (Constants.AgendaRemind.halfHourAgo.getType().equals(remind)) {
            returnDate = DateUtils.addDateMinute((Date)startDate, (int)-30);
        }
        if (Constants.AgendaRemind.oneHourAgo.getType().equals(remind)) {
            returnDate = DateUtils.addDateHour((Date)startDate, (int)1);
        }
        if (Constants.AgendaRemind.oneDayAgo.getType().equals(remind)) {
            returnDate = DateUtils.addDateNum((Date)startDate, (int)1);
        }
        if (Constants.AgendaRemind.twoDayAgo.getType().equals(remind)) {
            returnDate = DateUtils.addDateNum((Date)startDate, (int)2);
        }
        if (Constants.AgendaRemind.onWeekAgo.getType().equals(remind)) {
            returnDate = DateUtils.addDateWeek((Date)startDate, (int)1);
        }
        return returnDate;
    }
}

