/*
 * Decompiled with CFR 0.152.
 */
package com.ym.tlifang;

import com.alibaba.dubbo.spring.boot.annotation.EnableDubboConfiguration;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import org.springframework.aop.framework.autoproxy.BeanNameAutoProxyCreator;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.data.jpa.repository.config.EnableJpaAuditing;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.transaction.interceptor.TransactionInterceptor;

@SpringBootApplication
@EnableDubboConfiguration
@EnableTransactionManagement
@EnableJpaAuditing
public class OaServiceApplication {
    private static CountDownLatch countDownLatch = new CountDownLatch(1);

    @Bean(name={"transactionInterceptor"})
    public TransactionInterceptor transactionInterceptor(PlatformTransactionManager platformTransactionManager) {
        TransactionInterceptor transactionInterceptor = new TransactionInterceptor();
        transactionInterceptor.setTransactionManager(platformTransactionManager);
        Properties transactionAttributes = new Properties();
        transactionAttributes.setProperty("insert*", "PROPAGATION_REQUIRED,-Throwable");
        transactionAttributes.setProperty("save*", "PROPAGATION_REQUIRED,-Throwable");
        transactionAttributes.setProperty("add*", "PROPAGATION_REQUIRED,-Throwable");
        transactionAttributes.setProperty("create*", "PROPAGATION_REQUIRED,-Throwable");
        transactionAttributes.setProperty("update*", "PROPAGATION_REQUIRED,-Throwable");
        transactionAttributes.setProperty("modify*", "PROPAGATION_REQUIRED,-Throwable");
        transactionAttributes.setProperty("delete*", "PROPAGATION_REQUIRED,-Throwable");
        transactionAttributes.setProperty("reduce*", "PROPAGATION_REQUIRED,-Throwable");
        transactionAttributes.setProperty("select*", "PROPAGATION_REQUIRED,-Throwable,readOnly");
        transactionAttributes.setProperty("query*", "PROPAGATION_REQUIRED,-Throwable,readOnly");
        transactionAttributes.setProperty("get*", "PROPAGATION_REQUIRED,-Throwable,readOnly");
        transactionAttributes.setProperty("find*", "PROPAGATION_REQUIRED,-Throwable,readOnly");
        transactionAttributes.setProperty("count*", "PROPAGATION_REQUIRED,-Throwable,readOnly");
        transactionAttributes.setProperty("check*", "PROPAGATION_REQUIRED,-Throwable");
        transactionAttributes.setProperty("do*", "PROPAGATION_REQUIRED,-Throwable");
        transactionAttributes.setProperty("pay*", "PROPAGATION_REQUIRED,-Throwable");
        transactionInterceptor.setTransactionAttributes(transactionAttributes);
        return transactionInterceptor;
    }

    @Bean
    public BeanNameAutoProxyCreator transactionAutoProxy() {
        BeanNameAutoProxyCreator transactionAutoProxy = new BeanNameAutoProxyCreator();
        transactionAutoProxy.setProxyTargetClass(true);
        transactionAutoProxy.setBeanNames(new String[]{"*ServiceImpl"});
        transactionAutoProxy.setInterceptorNames(new String[]{"transactionInterceptor"});
        return transactionAutoProxy;
    }

    public static void main(String[] args) throws InterruptedException {
        SpringApplication.run(OaServiceApplication.class, (String[])args).registerShutdownHook();
        countDownLatch.await();
    }
}

