/*
 * Decompiled with CFR 0.152.
 */
package com.ym.tlifang.api.redis;

import com.ym.tlifang.api.redis.RedisUtil;
import com.ym.tlifang.model.notice.NoticeModel;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class MessageService {
    private static Logger logger = LoggerFactory.getLogger(MessageService.class);
    @Autowired
    private RedisTemplate<String, String> redisTemplate;
    @Autowired
    private RedisUtil redisUtil;
    @Value(value="${channelname}")
    private String channelName;
    @Value(value="${queuename}")
    private String queueName;

    public void sendTopicMessage(NoticeModel noticeModel, Boolean flag) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (flag.booleanValue()) {
            map.put("action", "sendSysMsg");
        } else {
            map.put("action", "updateSysMsg");
        }
        map.put("data", (String)noticeModel);
        JSONObject json = new JSONObject(map);
        this.redisTemplate.convertAndSend(this.channelName, (Object)json.toString());
    }

    public void sendTopicMessage(String message) {
        this.redisTemplate.convertAndSend(this.channelName, (Object)message);
    }

    public void dealMsg() {
        String message = this.redisUtil.rightPop(this.queueName, 1L, TimeUnit.MINUTES);
        if (message != null) {
            logger.info("redis--queue:" + this.queueName + "  body:" + message);
        }
    }

    public void sendQueueMessage(String message) {
        this.redisUtil.leftPush(this.queueName, message);
    }
}

