/*
 * Decompiled with CFR 0.152.
 */
package com.ym.tlifang.api.controller.sys;

import com.alibaba.dubbo.config.annotation.Reference;
import com.ym.tlifang.Constants;
import com.ym.tlifang.ResultModel;
import com.ym.tlifang.ResultStatus;
import com.ym.tlifang.api.authorization.annotation.Authorization;
import com.ym.tlifang.api.authorization.annotation.CurrentUser;
import com.ym.tlifang.api.authorization.annotation.LanguageType;
import com.ym.tlifang.api.controller.BaseController;
import com.ym.tlifang.service.user.UserService;
import com.ym.tlifang.user.User;
import com.ym.tlifang.util.DateUtils;
import com.ym.tlifang.util.HttpUtils;
import com.ym.tlifang.util.RandomCodeUtil;
import com.ym.tlifang.util.StringUtils;
import com.ym.tlifang.util.sms.SendCloudUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"smsCodes"})
@Api(value="smsCodes", description="\u9a8c\u8bc1\u7801")
public class SmsCodeController
extends BaseController {
    private static String ENCODING = "UTF-8";
    @Reference
    private UserService userService;
    @Autowired
    private StringRedisTemplate redis;

    @GetMapping
    @ApiOperation(value="\u83b7\u53d6\u9a8c\u8bc1\u7801", notes="\u9a8c\u8bc1\u7801\u9ed8\u8ba4\uff1a666666")
    @ApiImplicitParams(value={@ApiImplicitParam(name="mobile", value="\u624b\u673a\u53f7\u7801", required=true, dataType="string", paramType="query"), @ApiImplicitParam(name="areaCode", value="\u533a\u53f7\uff08\u9ed8\u8ba486\uff09", required=false, dataType="string", paramType="query"), @ApiImplicitParam(name="type", value="\u9a8c\u8bc1\u7801\u7c7b\u578b 1\u6ce8\u518c 2\u5fd8\u8bb0\u5bc6\u7801 3\u7ed1\u5b9a\u65b0\u624b\u673a 4\u5fae\u4fe1\u7ed1\u5b9a\u65b0\u624b\u673a", required=true, dataType="string", paramType="query"), @ApiImplicitParam(name="imageCode", value="\u56fe\u6587\u9a8c\u8bc1\u7801", required=false, dataType="string", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    public ResultModel getSmsCode(String mobile, Integer type, String areaCode, String imageCode, HttpServletRequest request, @LanguageType String languageType) {
        if (areaCode == null) {
            areaCode = Constants.CHINA_AREACODE;
        }
        if (StringUtils.isEmpty((Object)mobile) || StringUtils.isEmpty((Object)type)) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        ResultModel resultModel = this.checkImageCode(imageCode, type, mobile, request, languageType);
        if (resultModel != null) {
            return resultModel;
        }
        Integer smsCodeCount = StringUtils.isEmpty((Object)this.redis.boundValueOps((Object)(Constants.SMSCODE_COUNT + areaCode + mobile + "_" + type)).get()) ? 0 : Integer.valueOf((String)this.redis.boundValueOps((Object)(Constants.SMSCODE_COUNT + areaCode + mobile + "_" + type)).get());
        if (smsCodeCount >= Constants.SMSCODE_MAX_COUNT) {
            return ResultModel.error((ResultStatus)ResultStatus.SMS_EXCEED_TIME, (String)languageType);
        }
        User queryUser = this.userService.findByEmailOrMobile(mobile, areaCode);
        if (type.equals(Constants.SmsType.mobileActivity.getTypeId()) || type.equals(Constants.SmsType.mobileRebind.getTypeId())) {
            if (queryUser != null) {
                return ResultModel.error((ResultStatus)ResultStatus.MOBILE_EXIST, (String)languageType);
            }
        } else if (type.equals(Constants.SmsType.resetPassword.getTypeId())) {
            if (queryUser == null) {
                return ResultModel.error((ResultStatus)ResultStatus.MOBILE_NO_EXIST, (String)languageType);
            }
        } else if (!type.equals(Constants.SmsType.wechatmobileRebind.getTypeId())) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        String smsCode = StringUtils.createData((int)6);
        this.logger.error("\u624b\u673a\u53f7 {}, \u9a8c\u8bc1\u7801 {}", (Object)mobile, (Object)smsCode);
        this.redis.boundValueOps((Object)(Constants.SMSCODE + areaCode + mobile + "_" + type)).set((Object)smsCode, 15L, TimeUnit.MINUTES);
        smsCodeCount = smsCodeCount + 1;
        this.redis.boundValueOps((Object)(Constants.SMSCODE_COUNT + areaCode + mobile + "_" + type)).set((Object)smsCodeCount.toString());
        this.redis.boundValueOps((Object)(Constants.SMSCODE_COUNT + areaCode + mobile + "_" + type)).expireAt(DateUtils.dayEnd((Date)new Date()));
        return ResultModel.ok();
    }

    public String sendSms(String text, String mobile) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("apikey", "7b04928caf221bf56e924f2e3506dbba");
        params.put("text", text);
        params.put("mobile", mobile);
        return HttpUtils.post((String)"https://sms.yunpian.com/v2/sms/single_send.json", params);
    }

    @GetMapping(value={"image"})
    @ApiOperation(value="\u83b7\u53d6\u56fe\u6587\u9a8c\u8bc1\u7801")
    @ApiImplicitParams(value={@ApiImplicitParam(name="mobile", value="\u624b\u673a\u53f7\u7801", required=true, dataType="string", paramType="query"), @ApiImplicitParam(name="type", value="\u9a8c\u8bc1\u7801\u7c7b\u578b 1\u6ce8\u518c 2\u5fd8\u8bb0\u5bc6\u7801 3\u7ed1\u5b9a\u65b0\u624b\u673a", required=true, dataType="string", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    public ResultModel getImageCode(String mobile, Integer type, @LanguageType String languageType) {
        if (StringUtils.isEmpty((Object)mobile) || StringUtils.isEmpty((Object)type)) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            String code = RandomCodeUtil.getStringRandom((int)4);
            map.put("canvasURL", RandomCodeUtil.baseBegin + RandomCodeUtil.imageToBase64((int)130, (int)50, (String)code));
            this.redis.boundValueOps((Object)(Constants.IMAGECODE + mobile + "_" + type)).set((Object)code, 1L, TimeUnit.MINUTES);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ResultModel.suc(map);
    }

    public ResultModel checkImageCode(String imageCode, Integer type, String mobile, HttpServletRequest request, @LanguageType String languageType) {
        String platform;
        String userImageCode = (String)this.redis.boundValueOps((Object)(Constants.IMAGECODE + mobile + "_" + type)).get();
        if ((type.equals(Constants.SmsType.mobileActivity.getTypeId()) || type.equals(Constants.SmsType.resetPassword.getTypeId())) && (platform = StringUtils.isNullToZero((Object)request.getHeader("platform"))).equals("3")) {
            if (StringUtils.isEmpty((Object)imageCode)) {
                return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
            }
            if (StringUtils.isEmpty((Object)userImageCode)) {
                return ResultModel.error((ResultStatus)ResultStatus.IMAGECODE_NO_EXIST, (String)languageType);
            }
            if (!userImageCode.toLowerCase().equals(imageCode.toLowerCase())) {
                return ResultModel.error((ResultStatus)ResultStatus.IMAGECODE_ERROR, (String)languageType);
            }
        }
        return null;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"email"})
    @ApiOperation(value="\u53d1\u9001\u90ae\u7bb1\u9a8c\u8bc1\u7801", notes="\u9a8c\u8bc1\u7801\u9ed8\u8ba4\uff1a666666")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="email", value="\u90ae\u7bb1", required=true, dataType="string", paramType="query"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel getEmailSmsCode(@CurrentUser User currentUser, String email, @LanguageType String languageType) {
        Integer smsCodeCount = StringUtils.isEmpty((Object)this.redis.boundValueOps((Object)(Constants.SMSCODE_COUNT + email)).get()) ? 0 : Integer.valueOf((String)this.redis.boundValueOps((Object)(Constants.SMSCODE_COUNT + email)).get());
        if (smsCodeCount >= Constants.SMSCODE_MAX_COUNT) {
            return ResultModel.error((ResultStatus)ResultStatus.SMS_EXCEED_TIME, (String)languageType);
        }
        String smsCode = StringUtils.createData((int)6);
        this.redis.boundValueOps((Object)(Constants.SMSCODE + email)).set((Object)smsCode, 15L, TimeUnit.MINUTES);
        try {
            SendCloudUtil.sendEmailTemplate((String)email, (String)currentUser.getName(), (String)smsCode);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        smsCodeCount = smsCodeCount + 1;
        this.redis.boundValueOps((Object)(Constants.SMSCODE_COUNT + email)).set((Object)smsCodeCount.toString());
        this.redis.boundValueOps((Object)(Constants.SMSCODE_COUNT + email)).expireAt(DateUtils.dayEnd((Date)new Date()));
        return ResultModel.ok();
    }
}

