/*
 * Decompiled with CFR 0.152.
 */
package com.ym.tlifang.api.controller.sys;

import com.alibaba.dubbo.config.annotation.Reference;
import com.ym.tlifang.Constants;
import com.ym.tlifang.ResultModel;
import com.ym.tlifang.ResultStatus;
import com.ym.tlifang.api.authorization.annotation.Authorization;
import com.ym.tlifang.api.authorization.annotation.CurrentUser;
import com.ym.tlifang.api.authorization.annotation.LanguageType;
import com.ym.tlifang.file.FileEntity;
import com.ym.tlifang.file.FileFolderPowerEntity;
import com.ym.tlifang.model.file.UpdateFileNameModel;
import com.ym.tlifang.project.Project;
import com.ym.tlifang.service.file.FileFolderPowerService;
import com.ym.tlifang.service.file.FileService;
import com.ym.tlifang.service.project.ProjectService;
import com.ym.tlifang.service.system.EnclosureService;
import com.ym.tlifang.system.EnclosureEntity;
import com.ym.tlifang.user.User;
import com.ym.tlifang.util.AmazonStorageUtil;
import com.ym.tlifang.util.StringUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.File;
import java.io.IOException;
import java.net.URLDecoder;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"amazonS3"})
@Api(value="amazonS3", description="\u4e9a\u9a6c\u900a\u4e91\u5b58\u50a8")
public class AmazonStorageController {
    @Reference
    EnclosureService enclosureService;
    @Reference
    FileService fileService;
    @Reference
    FileFolderPowerService fileFolderPowerService;
    @Reference
    ProjectService projectService;

    @PostMapping(value={"/enclosure"})
    @ApiOperation(value="\u9644\u4ef6\u4e0a\u4f20")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="type", value="\u7c7b\u578b 1\u4f1a\u8bae\u4e3b\u4f53  2\u4f1a\u8bae\u8bc4\u8bba 3\u4efb\u52a1\u63cf\u8ff0 4\u4efb\u52a1\u8bc4\u8bba 5\u6c47\u62a5 6\u5916\u52e4\u6253\u5361 7\u5ba1\u6279\u9644\u4ef6", required=true, dataType="Integer", paramType="body"), @ApiImplicitParam(name="keyId", value="\u7c7b\u578b\u4e3b\u952e", required=false, dataType="Long", paramType="body"), @ApiImplicitParam(name="createBy", value="\u521b\u5efa\u8005ID", required=true, dataType="Long", paramType="body"), @ApiImplicitParam(name="companyId", value="\u516c\u53f8Id", required=false, dataType="Long", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel uploadAttachmentToS3(@CurrentUser User currentUser, @LanguageType String languageType, @RequestParam(value="file") MultipartFile multfile, EnclosureEntity enclosure) throws IOException {
        if (StringUtils.isEmpty((Object)enclosure.getType())) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        String decodeName = URLDecoder.decode(multfile.getOriginalFilename(), "UTF-8");
        if (!StringUtils.isEmpty((Object)enclosure.getKeyId())) {
            decodeName = this.enclosureService.repeatAttachmentCheck(enclosure.getType(), enclosure.getKeyId(), enclosure.getCreateBy(), decodeName);
        }
        File file = AmazonStorageUtil.multfile2file((MultipartFile)multfile);
        String url = AmazonStorageUtil.uploadToS3((String)Constants.AMAZON_S3_BUCKET_NAME_ENCLOSURE, (File)file, (String)decodeName);
        file.delete();
        if (StringUtils.isEmpty((Object)url)) {
            return ResultModel.error((ResultStatus)ResultStatus.UPLOAD_FAILED, (String)languageType);
        }
        enclosure.setUrl(url);
        enclosure.setDownloadUrl(url);
        enclosure.setName(decodeName);
        enclosure.setSize(Long.valueOf(multfile.getSize()));
        enclosure.setCdnBucket(Constants.AMAZON_S3_BUCKET_NAME_ENCLOSURE);
        enclosure.setCreateBy(currentUser.getId());
        return ResultModel.suc((Object)this.enclosureService.save(enclosure));
    }

    @PostMapping(value={"/file/{parentId}"})
    @ApiOperation(value="(\u65b0)\u6587\u4ef6\u4e0a\u4f20")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="type", value="\u7c7b\u578b 1\u516c\u53f8 2\u9879\u76ee 3\u4e2a\u4eba", required=true, dataType="Integer", paramType="body"), @ApiImplicitParam(name="keyId", value="\u7c7b\u578b\u4e3b\u952e", required=true, dataType="Long", paramType="body"), @ApiImplicitParam(name="createBy", value="\u521b\u5efa\u8005ID", required=true, dataType="Long", paramType="body"), @ApiImplicitParam(name="companyId", value="\u516c\u53f8Id", required=false, dataType="Long", paramType="body"), @ApiImplicitParam(name="folderId", value="\u6587\u4ef6\u5939id", required=true, dataType="Long", paramType="body"), @ApiImplicitParam(name="parentId", value="\u9876\u7ea7\u6587\u4ef6\u5939id", required=true, dataType="Long", paramType="path")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel newUploadFileToS3(@CurrentUser User currentUser, @LanguageType String languageType, @PathVariable Long parentId, @RequestParam(value="file") MultipartFile multfile, FileEntity fileEntity) throws IOException {
        if (StringUtils.isEmpty((Object)fileEntity.getType()) || StringUtils.isEmpty((Object)fileEntity.getKeyId()) || StringUtils.isEmpty((Object)fileEntity.getFolderId())) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        FileFolderPowerEntity fileFolderPower = this.fileFolderPowerService.findByFileFolderIdAndUserIdAndDelFlagFalse(parentId, currentUser.getId());
        if (fileFolderPower == null || "2".equals(fileFolderPower.getPowerType())) {
            return ResultModel.error((ResultStatus)ResultStatus.FILE_FOLDER_POWER_ADMIN_NO_EXIST, (String)languageType);
        }
        FileEntity fileEntity1 = this.fileService.findByNameAndFolderIdAndTypeAndKeyId(fileEntity.getName(), fileEntity.getFolderId(), fileEntity.getType(), fileEntity.getKeyId());
        if (fileEntity1 != null) {
            return ResultModel.error((ResultStatus)ResultStatus.FILE_NAME_EXIST, (String)languageType);
        }
        String decodeName = URLDecoder.decode(multfile.getOriginalFilename(), "UTF-8");
        String fileName = this.fileService.repeatFileCheck(fileEntity.getKeyId(), fileEntity.getType(), fileEntity.getFolderId(), decodeName);
        File file = AmazonStorageUtil.multfile2file((MultipartFile)multfile);
        String url = AmazonStorageUtil.uploadToS3((String)Constants.AMAZON_S3_BUCKET_NAME_FILES, (File)file, (String)fileName);
        file.delete();
        if (StringUtils.isEmpty((Object)url)) {
            return ResultModel.error((ResultStatus)ResultStatus.UPLOAD_FAILED, (String)languageType);
        }
        if (fileEntity.getId() == null) {
            if (Constants.FileType.team.getType().equals(fileEntity.getType())) {
                fileEntity.setCompanyId(fileEntity.getKeyId());
            } else if (Constants.FileType.project.getType().equals(fileEntity.getType())) {
                Project project = this.projectService.findByProjectId(fileEntity.getKeyId());
                if (project == null) {
                    return ResultModel.error((ResultStatus)ResultStatus.PROJECT_NO_EXIST, (String)languageType);
                }
                if (project.getCompanyId() != null) {
                    fileEntity.setCompanyId(project.getCompanyId());
                }
            }
            fileEntity.setUrl(url);
            fileEntity.setDownloadUrl(url);
            fileEntity.setName(fileName);
            fileEntity.setCreateBy(currentUser.getId());
            fileEntity.setUpdateBy(fileEntity.getCreateBy());
            fileEntity.setCdnBucket(Constants.AMAZON_S3_BUCKET_NAME_FILES);
            fileEntity.setSize(Long.valueOf(multfile.getSize()));
            return ResultModel.suc((Object)this.fileService.save(fileEntity));
        }
        return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
    }

    @PostMapping(value={"/file"})
    @ApiOperation(value="\u6587\u4ef6\u4e0a\u4f20")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="type", value="\u7c7b\u578b 1\u516c\u53f8 2\u9879\u76ee 3\u4e2a\u4eba", required=true, dataType="Integer", paramType="body"), @ApiImplicitParam(name="keyId", value="\u7c7b\u578b\u4e3b\u952e", required=true, dataType="Long", paramType="body"), @ApiImplicitParam(name="createBy", value="\u521b\u5efa\u8005ID", required=true, dataType="Long", paramType="body"), @ApiImplicitParam(name="companyId", value="\u516c\u53f8Id", required=false, dataType="Long", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel uploadFileToS3(@CurrentUser User currentUser, @LanguageType String languageType, @RequestParam(value="file") MultipartFile multfile, FileEntity fileEntity) throws IOException {
        return ResultModel.error((ResultStatus)ResultStatus.FILE_PAGES_NOT_SUPPORT_ACCESS, (String)languageType);
    }

    @PutMapping(value={"newFile/rename"})
    @ApiOperation(value="(\u65b0)\u6587\u4ef6/\u91cd\u547d\u540d")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel newRenameFile(@CurrentUser User user, @LanguageType String languageType, @RequestBody UpdateFileNameModel updateFileNameModel) {
        FileEntity fileEntity1;
        if (StringUtils.isEmpty((Object)updateFileNameModel.getFileId()) || StringUtils.isEmpty((Object)updateFileNameModel.getFileName())) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        FileFolderPowerEntity fileFolderPower = this.fileFolderPowerService.findByFileFolderIdAndUserIdAndDelFlagFalse(updateFileNameModel.getRootParentId(), user.getId());
        if (fileFolderPower == null && !"2".equals(fileFolderPower.getPowerType())) {
            return ResultModel.error((ResultStatus)ResultStatus.FILE_FOLDER_POWER_ADMIN_NO_EXIST, (String)languageType);
        }
        FileEntity file = this.fileService.findById(updateFileNameModel.getFileId());
        if (StringUtils.isEmpty((Object)file)) {
            return ResultModel.error((ResultStatus)ResultStatus.FILE_NO_EXIST, (String)languageType);
        }
        if (!file.getName().equals(updateFileNameModel.getFileName()) && (fileEntity1 = this.fileService.findByNameAndFolderIdAndTypeAndKeyId(updateFileNameModel.getFileName(), file.getFolderId(), file.getType(), file.getKeyId())) != null) {
            return ResultModel.error((ResultStatus)ResultStatus.FILE_NAME_EXIST, (String)languageType);
        }
        if (!AmazonStorageUtil.rename((String)file.getName(), (String)file.getCdnBucket(), (String)updateFileNameModel.getFileName())) {
            return ResultModel.error((ResultStatus)ResultStatus.RENAME_FAILED, (String)languageType);
        }
        String url = AmazonStorageUtil.getUrlFromS3((String)file.getCdnBucket(), (String)updateFileNameModel.getFileName());
        file.setUrl(url);
        file.setDownloadUrl(url);
        file.setName(updateFileNameModel.getFileName());
        return ResultModel.suc((Object)this.fileService.save(file));
    }

    @PutMapping(value={"file/rename/{id}/{newFileName}"})
    @ApiOperation(value="\u6587\u4ef6/\u91cd\u547d\u540d")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="id", value="\u6587\u4ef6Id", required=true, dataType="Long", paramType="path"), @ApiImplicitParam(name="newFileName", value="\u65b0\u7684\u6587\u4ef6\u540d", required=true, dataType="String", paramType="path")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel renameFile(@LanguageType String languageType, @PathVariable Long id, @PathVariable String newFileName) {
        return ResultModel.error((ResultStatus)ResultStatus.FILE_PAGES_NOT_SUPPORT_ACCESS, (String)languageType);
    }

    @PostMapping(value={"/upload"})
    @ApiOperation(value="\u901a\u7528\u4e0a\u4f20\u63a5\u53e3")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel uploadToS3(@LanguageType String languageType, @RequestParam(value="file") MultipartFile multfile) throws IOException {
        File file = AmazonStorageUtil.multfile2file((MultipartFile)multfile);
        String url = AmazonStorageUtil.uploadToS3((String)Constants.AMAZON_S3_BUCKET_NAME, (File)file, (String)multfile.getOriginalFilename());
        file.delete();
        if (StringUtils.isEmpty((Object)url)) {
            return ResultModel.error((ResultStatus)ResultStatus.UPLOAD_FAILED, (String)languageType);
        }
        return ResultModel.suc((Object)url);
    }

    @PostMapping(value={"/addFile"})
    @ApiOperation(value="\uff08\u65b0\u4e2a\u4eba\uff09\u65b0\u589e\u6587\u4ef6")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body"), @ApiImplicitParam(name="type", value="\u7c7b\u578b 1\u516c\u53f8 2\u9879\u76ee 3\u4e2a\u4eba", required=true, dataType="Integer", paramType="body"), @ApiImplicitParam(name="keyId", value="\u7c7b\u578b\u4e3b\u952e", required=true, dataType="Long", paramType="body"), @ApiImplicitParam(name="createBy", value="\u521b\u5efa\u8005ID", required=true, dataType="Long", paramType="body"), @ApiImplicitParam(name="companyId", value="\u516c\u53f8Id", required=false, dataType="Long", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<FileEntity> addFile(@CurrentUser User currentUser, @RequestParam(value="file") MultipartFile multfile, FileEntity fileEntity, @LanguageType String languageType) throws IOException {
        if (StringUtils.isEmpty((Object)fileEntity.getType()) || StringUtils.isEmpty((Object)fileEntity.getKeyId())) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        FileEntity fileEntity1 = this.fileService.findByNameAndFolderIdAndTypeAndKeyId(fileEntity.getName(), fileEntity.getFolderId() == null || fileEntity.getFolderId() == 0L ? null : fileEntity.getFolderId(), fileEntity.getType(), fileEntity.getKeyId());
        if (fileEntity1 != null) {
            return ResultModel.error((ResultStatus)ResultStatus.FILE_NAME_EXIST, (String)languageType);
        }
        String decodeName = URLDecoder.decode(multfile.getOriginalFilename(), "UTF-8");
        String fileName = this.fileService.repeatFileCheck(fileEntity.getKeyId(), fileEntity.getType(), fileEntity.getFolderId(), decodeName);
        File file = AmazonStorageUtil.multfile2file((MultipartFile)multfile);
        String url = AmazonStorageUtil.uploadToS3((String)Constants.AMAZON_S3_BUCKET_NAME_FILES, (File)file, (String)fileName);
        file.delete();
        if (StringUtils.isEmpty((Object)url)) {
            return ResultModel.error((ResultStatus)ResultStatus.UPLOAD_FAILED, (String)languageType);
        }
        if (fileEntity.getId() == null) {
            Project project;
            if (Constants.FileType.team.getType().equals(fileEntity.getType())) {
                return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
            }
            if (Constants.FileType.project.getType().equals(fileEntity.getType()) && (project = this.projectService.findByProjectId(fileEntity.getKeyId())) == null) {
                return ResultModel.error((ResultStatus)ResultStatus.PROJECT_NO_EXIST, (String)languageType);
            }
        } else {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        fileEntity.setUrl(url);
        fileEntity.setDownloadUrl(url);
        fileEntity.setName(fileName);
        fileEntity.setCreateBy(currentUser.getId());
        fileEntity.setUpdateBy(fileEntity.getCreateBy());
        fileEntity.setCdnBucket(Constants.AMAZON_S3_BUCKET_NAME_FILES);
        fileEntity.setSize(Long.valueOf(multfile.getSize()));
        fileEntity.setFolderId(fileEntity.getFolderId() == null || fileEntity.getFolderId() == 0L ? null : fileEntity.getFolderId());
        return ResultModel.suc((Object)this.fileService.save(fileEntity));
    }
}

