/*
 * Decompiled with CFR 0.152.
 */
package com.ym.tlifang.api.controller.proclamation;

import com.alibaba.dubbo.config.annotation.Reference;
import com.ym.tlifang.Constants;
import com.ym.tlifang.PageInfo;
import com.ym.tlifang.ResultModel;
import com.ym.tlifang.ResultStatus;
import com.ym.tlifang.api.authorization.annotation.Authorization;
import com.ym.tlifang.api.authorization.annotation.CurrentUser;
import com.ym.tlifang.api.authorization.annotation.LanguageType;
import com.ym.tlifang.api.controller.BaseController;
import com.ym.tlifang.company.CompanyMemberInfo;
import com.ym.tlifang.proclamation.Proclamation;
import com.ym.tlifang.proclamation.ProclamationRemind;
import com.ym.tlifang.service.company.CompanyMemberInfoService;
import com.ym.tlifang.service.proclamation.ProclamationRemindService;
import com.ym.tlifang.service.proclamation.ProclamationService;
import com.ym.tlifang.service.push.XgPushService;
import com.ym.tlifang.service.system.NoticeService;
import com.ym.tlifang.service.user.UserService;
import com.ym.tlifang.user.User;
import com.ym.tlifang.util.StringUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.ArrayList;
import java.util.List;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"proclamation"})
@Api(value="proclamation", description="\u516c\u544a\u76f8\u5173")
public class ProclamationController
extends BaseController {
    @Reference
    private ProclamationService proclamationService;
    @Reference
    private CompanyMemberInfoService companyMemberInfoService;
    @Reference
    ProclamationRemindService proclamationRemindService;
    @Reference
    private NoticeService noticeService;
    @Reference
    private UserService userService;
    @Reference
    private XgPushService xgPushService;

    @PostMapping
    @ApiOperation(value="\u521b\u5efa\u516c\u544a")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="user", value="\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<Proclamation> createProclamation(@LanguageType String languageType, @CurrentUser User user, @RequestBody Proclamation proclamation) {
        if (StringUtils.isEmpty((Object)proclamation.getCompanyId()) || StringUtils.isEmpty((Object)proclamation.getName()) || StringUtils.isEmpty((Object)proclamation.getContent()) || StringUtils.isEmpty((Object)proclamation.getPromulgatorId()) || StringUtils.isEmpty((Object)proclamation.getAddUserIds()) || StringUtils.isEmpty((Object)proclamation.getSourceId()) || StringUtils.isEmpty((Object)proclamation.getType()) || StringUtils.isEmpty((Object)proclamation.getStatus())) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        Long[] addUserIds = proclamation.getAddUserIds();
        CompanyMemberInfo companyMemberInfo = this.companyMemberInfoService.findByCompanyIdAndUserIdAndStatus(proclamation.getCompanyId(), user.getId(), Constants.AuditStatus.adopt.getType());
        if (companyMemberInfo.getManager().equals(Constants.ManagerStatus.companyOrdinaryMember.getType())) {
            return ResultModel.error((ResultStatus)ResultStatus.COMPANY_NO_MAMNAGER, (String)languageType);
        }
        if (!proclamation.getPromulgatorId().equals(user.getId())) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        proclamation = this.proclamationRemindService.createProclamation(proclamation, addUserIds);
        return ResultModel.suc((Object)proclamation, (String)languageType);
    }

    @PutMapping
    @ApiOperation(value="\u4fee\u6539\u8349\u7a3f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="user", value="\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<Proclamation> updateProclamation(@LanguageType String languageType, @CurrentUser User user, @RequestBody Proclamation proclamation) {
        Proclamation proclamationInfo = this.proclamationService.findByIdAndPromulgatorIdAndDelFlagFalse(proclamation.getId(), user.getId());
        if (StringUtils.isEmpty((Object)proclamationInfo)) {
            return ResultModel.error((ResultStatus)ResultStatus.COMPANY_NO_PUBLISH, (String)languageType);
        }
        if (proclamationInfo.getStatus().equals(Constants.ProclamationStatus.publish.getType())) {
            return ResultModel.error((ResultStatus)ResultStatus.COMPANY_PUBLISH, (String)languageType);
        }
        proclamationInfo = this.proclamationService.updateDrafts(proclamation, proclamationInfo);
        return ResultModel.suc((Object)proclamationInfo, (String)languageType);
    }

    @GetMapping(value={"/{proclamationId}/info"})
    @ApiOperation(value="\u516c\u544a\u8be6\u60c5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="user", value="\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body"), @ApiImplicitParam(name="proclamationId", value="\u516c\u544aid", required=true, dataType="Long", paramType="path")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<Proclamation> infoProclamation(@LanguageType String languageType, @CurrentUser User user, @PathVariable Long proclamationId) {
        if (StringUtils.isEmpty((Object)proclamationId)) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        Proclamation proclamation = this.proclamationService.findByIdAndDelFlagFalse(proclamationId);
        ProclamationRemind proclamationRemind = this.proclamationRemindService.findByProclamationIdAndUserIdAndDelFlagFalse(proclamationId, user.getId());
        if (proclamationRemind != null) {
            proclamationRemind.setStatus("1");
            this.proclamationRemindService.save(proclamationRemind);
        }
        ArrayList<Long> userList = new ArrayList<Long>();
        List proclamationRemindList = this.proclamationRemindService.findByProclamationIdAndDelFlagFalse(proclamationId);
        for (ProclamationRemind proclamationUser : proclamationRemindList) {
            userList.add(proclamationUser.getUserId());
        }
        proclamation.setProclamationUserList(userList);
        return ResultModel.suc((Object)proclamation, (String)languageType);
    }

    @GetMapping(value={"/{companyId}/list"})
    @ApiOperation(value="\u516c\u544a\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="user", value="\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body"), @ApiImplicitParam(name="companyId", value="\u516c\u53f8id", required=true, dataType="Long", paramType="path"), @ApiImplicitParam(name="pageNo", value="\u9875\u7801", required=false, dataType="Integer", paramType="query"), @ApiImplicitParam(name="pageSize", value="\u6bcf\u9875\u663e\u793a\u6570\u91cf", required=false, dataType="Integer", paramType="query"), @ApiImplicitParam(name="type", value="\u7c7b\u578b(0,\u4f01\u4e1a\u65b0\u95fb\uff0c1\u3001\u4e8b\u7269\u901a\u77e5, 2\u3001\u5168\u90e8\uff08\u4e0d\u5305\u62ec\u8349\u7a3f\u7bb1\uff09)", required=false, dataType="string", paramType="query"), @ApiImplicitParam(name="status", value="\u72b6\u6001\uff080\u3001\u5b58\u4e3a\u8349\u7a3f\uff0c1\u3001\u53d1\u5e03\uff09", required=true, dataType="string", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<PageInfo<Proclamation>> listProclamation(@LanguageType String languageType, @CurrentUser User user, @PathVariable Long companyId, Integer pageNo, Integer pageSize, String type, String status) {
        if (StringUtils.isEmpty((Object)companyId) || StringUtils.isEmpty((Object)status)) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        if (StringUtils.isEmpty((Object)type) && !status.equals("0")) {
            return ResultModel.error((ResultStatus)ResultStatus.COMPANY_PUBLISH, (String)languageType);
        }
        PageInfo pageInfo = this.proclamationRemindService.findByUserIdAndCompanyIdAndDelFlagFalse(user.getId(), companyId, status, type, pageNo, pageSize);
        return ResultModel.suc((Object)pageInfo, (String)languageType);
    }

    @DeleteMapping(value={"/{proclamationId}"})
    @ApiOperation(value="\u5220\u9664\u516c\u544a")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="user", value="\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body"), @ApiImplicitParam(name="proclamationId", value="\u516c\u544aid", required=true, dataType="Long", paramType="path")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<Proclamation> delProclamation(@LanguageType String languageType, @CurrentUser User user, @PathVariable Long proclamationId) {
        Proclamation proclamation = this.proclamationService.findByIdAndDelFlagFalse(proclamationId);
        if (proclamation == null) {
            return ResultModel.error((ResultStatus)ResultStatus.COMPANY_NO_PUBLISH, (String)languageType);
        }
        if (!user.getId().equals(proclamation.getPromulgatorId())) {
            return ResultModel.error((ResultStatus)ResultStatus.PUBLISH_NO_OWNER, (String)languageType);
        }
        return this.proclamationService.delPro(proclamation, languageType);
    }
}

