/*
 * Decompiled with CFR 0.152.
 */
package com.ym.tlifang.api.controller.note;

import com.alibaba.dubbo.config.annotation.Reference;
import com.ym.tlifang.ResultModel;
import com.ym.tlifang.ResultStatus;
import com.ym.tlifang.api.authorization.annotation.Authorization;
import com.ym.tlifang.api.authorization.annotation.CurrentUser;
import com.ym.tlifang.api.authorization.annotation.LanguageType;
import com.ym.tlifang.api.controller.BaseController;
import com.ym.tlifang.note.Note;
import com.ym.tlifang.note.NoteBook;
import com.ym.tlifang.service.note.NoteBookService;
import com.ym.tlifang.service.note.NoteService;
import com.ym.tlifang.user.User;
import com.ym.tlifang.util.StringUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"notebook"})
@Api(value="notebook", description="\u7b14\u8bb0\u672c\u76f8\u5173")
public class NoteBookController
extends BaseController {
    @Reference
    private NoteBookService noteBookService;
    @Reference
    private NoteService noteService;

    @PostMapping
    @ApiOperation(value="\u65b0\u5efa\u7b14\u8bb0\u672c")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="user", value="\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<NoteBook> createNoteBook(@LanguageType String languageType, @CurrentUser User user, @RequestBody NoteBook noteBook) {
        if (StringUtils.isEmpty((Object)noteBook.getName())) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        noteBook.setOwnerId(user.getId());
        noteBook = this.noteBookService.save(noteBook);
        noteBook.setUser(user);
        noteBook.setNumbers(Integer.valueOf(0));
        return ResultModel.suc((Object)noteBook, (String)languageType);
    }

    @PutMapping
    @ApiOperation(value="\u4fee\u6539\u7b14\u8bb0\u672c")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="user", value="\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<NoteBook> updateNoteBook(@LanguageType String languageType, @CurrentUser User user, @RequestBody NoteBook noteBook) {
        if (StringUtils.isEmpty((Object)noteBook.getName())) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        NoteBook noteBookUser = this.noteBookService.findByOwnerIdAndIdAndDelFlagFalse(user.getId(), noteBook.getId());
        if (StringUtils.isEmpty((Object)noteBookUser)) {
            return ResultModel.error((ResultStatus)ResultStatus.NOTEBOOK_NO_EXIST, (String)languageType);
        }
        if (!StringUtils.isEmpty((Object)noteBook.getName())) {
            noteBookUser.setName(noteBook.getName());
        }
        noteBookUser = this.noteBookService.save(noteBookUser);
        noteBookUser.setUser(user);
        return ResultModel.suc((Object)noteBookUser, (String)languageType);
    }

    @GetMapping
    @ApiOperation(value="\u7b14\u8bb0\u672c\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="user", value="\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<List<NoteBook>> listNoteBook(@LanguageType String languageType, @CurrentUser User user) {
        List noteBookList = this.noteBookService.findByOwnerIdAndDelFlagFalseOrderByUpdateDateDesc(user.getId());
        return ResultModel.suc((Object)noteBookList, (String)languageType);
    }

    @DeleteMapping
    @ApiOperation(value="\u5220\u9664\u7b14\u8bb0\u672c")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="user", value="\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body"), @ApiImplicitParam(name="noteBookId", value="\u7b14\u8bb0\u672cid", required=true, dataType="Long", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<NoteBook> delNoteBook(@LanguageType String languageType, @CurrentUser User user, Long noteBookId) {
        if (StringUtils.isEmpty((Object)noteBookId)) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        List noteBookList = this.noteBookService.findByOwnerIdAndDelFlagFalseOrderByUpdateDateDesc(user.getId());
        if (noteBookList == null) {
            return ResultModel.error((ResultStatus)ResultStatus.NOTEBOOK_NO_EXIST, (String)languageType);
        }
        if (noteBookList.size() == 1) {
            return ResultModel.error((ResultStatus)ResultStatus.NOTEBOOK_ONE_EXIST, (String)languageType);
        }
        NoteBook noteBook = this.noteBookService.findByOwnerIdAndIdAndDelFlagFalse(user.getId(), noteBookId);
        if (StringUtils.isEmpty((Object)noteBook)) {
            return ResultModel.error((ResultStatus)ResultStatus.NOTEBOOK_NO_EXIST, (String)languageType);
        }
        List noteList = this.noteService.findByNotebookIdAndDelFlagFalse(noteBookId);
        if (!StringUtils.isEmpty((Object)noteList)) {
            for (Note note : noteList) {
                note.setDelFlag(Boolean.valueOf(true));
                this.noteService.save(note);
            }
        }
        noteBook.setDelFlag(Boolean.valueOf(true));
        this.noteBookService.save(noteBook);
        return ResultModel.ok((String)languageType);
    }
}

