/*
 * Decompiled with CFR 0.152.
 */
package com.ym.tlifang.api.controller.file;

import com.alibaba.dubbo.config.annotation.Reference;
import com.ym.tlifang.Constants;
import com.ym.tlifang.ResultModel;
import com.ym.tlifang.ResultStatus;
import com.ym.tlifang.api.authorization.annotation.Authorization;
import com.ym.tlifang.api.authorization.annotation.CurrentUser;
import com.ym.tlifang.api.authorization.annotation.LanguageType;
import com.ym.tlifang.api.controller.BaseController;
import com.ym.tlifang.file.FileEntity;
import com.ym.tlifang.file.FileFolderEntity;
import com.ym.tlifang.model.file.DeleteFileAndFileFolderModel;
import com.ym.tlifang.model.file.MoveFileAndFileFolderModel;
import com.ym.tlifang.model.file.SeachPersonalModel;
import com.ym.tlifang.model.file.UpdateFileFolderNameModel;
import com.ym.tlifang.model.file.UpdateFileNameModel;
import com.ym.tlifang.project.Project;
import com.ym.tlifang.service.file.FileFolderService;
import com.ym.tlifang.service.file.FileService;
import com.ym.tlifang.service.file.QiNiuService;
import com.ym.tlifang.service.project.ProjectService;
import com.ym.tlifang.user.User;
import com.ym.tlifang.util.AmazonStorageUtil;
import com.ym.tlifang.util.QiNiuUtil;
import com.ym.tlifang.util.StringUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import java.util.Map;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"personalFileAndFolder"})
@Api(value="personalFileAndFolder", description="\u4e2a\u4eba\u6587\u4ef6\u548c\u6587\u4ef6\u5939\u76f8\u5173")
public class PersonalFileAndFolderController
extends BaseController {
    @Reference
    private FileService fileService;
    @Reference
    private FileFolderService fileFolderService;
    @Reference
    private ProjectService projectService;
    @Reference
    private QiNiuService qiNiuService;

    @PostMapping(value={"/addFolder"})
    @ApiOperation(value="\uff08\u65b0\u4e2a\u4eba\uff09\u65b0\u5efa\u6587\u4ef6\u5939")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<FileFolderEntity> addFolder(@CurrentUser User currentUser, @RequestBody FileFolderEntity fileFolderEntity, @LanguageType String languageType) {
        if (StringUtils.isEmpty((Object)fileFolderEntity) || StringUtils.isEmpty((Object)fileFolderEntity.getName()) || StringUtils.isEmpty((Object)fileFolderEntity.getType()) || StringUtils.isEmpty((Object)fileFolderEntity.getKeyId())) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        FileFolderEntity validerFileFolderName = this.fileFolderService.findByKeyIdAndTypeAndParentIdAndName(fileFolderEntity.getKeyId(), fileFolderEntity.getType(), fileFolderEntity.getParentId(), fileFolderEntity.getName());
        if (validerFileFolderName != null) {
            return ResultModel.error((ResultStatus)ResultStatus.FILE_FOLDER_NAME_EXIST, (String)languageType);
        }
        FileFolderEntity fileFolderParent = this.fileFolderService.findById(fileFolderEntity.getParentId());
        fileFolderEntity.setParentIds(fileFolderEntity.getParentId() == null || fileFolderEntity.getParentId() == 0L ? null : (fileFolderParent.getParentIds() == null ? "," + fileFolderEntity.getParentId() + "," : fileFolderParent.getParentIds() + "," + fileFolderEntity.getParentId() + ","));
        fileFolderEntity.setCreateBy(currentUser.getId());
        fileFolderEntity.setUpdateBy(currentUser.getId());
        fileFolderEntity = this.fileFolderService.sava(fileFolderEntity);
        return ResultModel.suc((Object)fileFolderEntity);
    }

    @PutMapping(value={"/updateFolderName"})
    @ApiOperation(value="\uff08\u65b0\u4e2a\u4eba\uff09\u4fee\u6539\u6587\u4ef6\u5939\u540d\u79f0")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<FileFolderEntity> updateFolderName(@CurrentUser User currentUser, @RequestBody UpdateFileFolderNameModel updateFileFolderNameModel, @LanguageType String languageType) {
        if (StringUtils.isEmpty((Object)updateFileFolderNameModel) || StringUtils.isEmpty((Object)updateFileFolderNameModel.getFileFolderId()) || StringUtils.isEmpty((Object)updateFileFolderNameModel.getFileFolderName())) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        FileFolderEntity entity = this.fileFolderService.findById(updateFileFolderNameModel.getFileFolderId());
        if (entity == null) {
            return ResultModel.error((ResultStatus)ResultStatus.FILE_FOLDER_NO_EXIST, (String)languageType);
        }
        FileFolderEntity validerFileFolderName = this.fileFolderService.findByKeyIdAndTypeAndParentIdAndName(entity.getKeyId(), entity.getType(), entity.getParentId(), updateFileFolderNameModel.getFileFolderName());
        if (validerFileFolderName != null) {
            return ResultModel.error((ResultStatus)ResultStatus.FILE_FOLDER_NAME_EXIST, (String)languageType);
        }
        entity.setName(updateFileFolderNameModel.getFileFolderName());
        entity.setUpdateBy(currentUser.getId());
        entity = this.fileFolderService.sava(entity);
        return ResultModel.suc((Object)entity);
    }

    @PostMapping(value={"/addFile"})
    @ApiOperation(value="\uff08\u65b0\u4e2a\u4eba\uff09\u65b0\u589e\u6587\u4ef6")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<FileEntity> addFile(@CurrentUser User currentUser, @RequestBody FileEntity fileEntity, @LanguageType String languageType) {
        if (StringUtils.isEmpty((Object)fileEntity) || StringUtils.isEmpty((Object)fileEntity.getName()) || StringUtils.isEmpty((Object)fileEntity.getUrl()) || StringUtils.isEmpty((Object)fileEntity.getType()) || StringUtils.isEmpty((Object)fileEntity.getKeyId()) || StringUtils.isEmpty((Object)fileEntity.getSize()) || StringUtils.isEmpty((Object)fileEntity.getMimetype())) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        FileEntity fileEntity1 = this.fileService.findByNameAndFolderIdAndTypeAndKeyId(fileEntity.getName(), fileEntity.getFolderId() == null || fileEntity.getFolderId() == 0L ? null : fileEntity.getFolderId(), fileEntity.getType(), fileEntity.getKeyId());
        if (fileEntity1 != null) {
            return ResultModel.error((ResultStatus)ResultStatus.FILE_NAME_EXIST, (String)languageType);
        }
        if (fileEntity.getId() == null) {
            Project project;
            if (Constants.FileType.team.getType().equals(fileEntity.getType())) {
                return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
            }
            if (Constants.FileType.project.getType().equals(fileEntity.getType()) && (project = this.projectService.findByProjectId(fileEntity.getKeyId())) == null) {
                return ResultModel.error((ResultStatus)ResultStatus.PROJECT_NO_EXIST, (String)languageType);
            }
        }
        fileEntity.setCdnBucket(this.qiNiuService.getQiNiuModel().getBucket());
        fileEntity.setCreateBy(currentUser.getId());
        fileEntity.setUpdateBy(currentUser.getId());
        fileEntity.setFolderId(fileEntity.getFolderId() == null || fileEntity.getFolderId() == 0L ? null : fileEntity.getFolderId());
        fileEntity = this.fileService.sava(fileEntity);
        return ResultModel.suc((Object)fileEntity);
    }

    @PutMapping(value={"/updateFileName"})
    @ApiOperation(value="(\u65b0\u4e2a\u4eba)\u4fee\u6539\u6587\u4ef6\u540d")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<FileEntity> updateFileName(@CurrentUser User currentUser, @RequestBody UpdateFileNameModel updateFileNameModel, @LanguageType String languageType) {
        FileEntity fileEntity1;
        if (StringUtils.isEmpty((Object)updateFileNameModel) || StringUtils.isEmpty((Object)updateFileNameModel.getFileId()) || StringUtils.isEmpty((Object)updateFileNameModel.getFileName())) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        FileEntity oldFileEntity = this.fileService.findById(updateFileNameModel.getFileId());
        if (oldFileEntity == null) {
            return ResultModel.error((ResultStatus)ResultStatus.FILE_NO_EXIST, (String)languageType);
        }
        if (!oldFileEntity.getName().equals(updateFileNameModel.getFileName()) && (fileEntity1 = this.fileService.findByNameAndFolderIdAndTypeAndKeyId(updateFileNameModel.getFileName(), oldFileEntity.getFolderId(), oldFileEntity.getType(), oldFileEntity.getKeyId())) != null) {
            return ResultModel.error((ResultStatus)ResultStatus.FILE_NAME_EXIST, (String)languageType);
        }
        if (oldFileEntity.getCdnKey().equals(this.qiNiuService.getQiNiuModel().getBucket())) {
            if (QiNiuUtil.updateFileName((FileEntity)oldFileEntity, (String)updateFileNameModel.getFileName()).booleanValue()) {
                oldFileEntity.setCdnKey(oldFileEntity.getCdnKey().split("/")[0] + "/" + updateFileNameModel.getFileName());
                oldFileEntity.setUrl(Constants.QINIU_ADDRESS + oldFileEntity.getCdnKey());
                oldFileEntity.setDownloadUrl(oldFileEntity.getUrl() + Constants.QINIU_LAST_ADDRESS);
            }
        } else if (AmazonStorageUtil.rename((String)oldFileEntity.getCdnKey(), (String)oldFileEntity.getName(), (String)updateFileNameModel.getFileName())) {
            String url = AmazonStorageUtil.getUrlFromS3((String)oldFileEntity.getCdnKey(), (String)updateFileNameModel.getFileName());
            oldFileEntity.setUrl(url);
            oldFileEntity.setDownloadUrl(url);
        }
        oldFileEntity.setName(updateFileNameModel.getFileName());
        oldFileEntity.setUpdateBy(currentUser.getId());
        oldFileEntity = this.fileService.sava(oldFileEntity);
        return ResultModel.suc((Object)oldFileEntity);
    }

    @PutMapping(value={"/searchFileFolder"})
    @ApiOperation(value="(\u65b0\u4e2a\u4eba)\u641c\u7d22\u6587\u4ef6\u6216\u6587\u4ef6\u5939")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel searchFileFolder(@CurrentUser User user, @RequestBody SeachPersonalModel seachPersonalModel, @LanguageType String languageType) {
        if (StringUtils.isEmpty((Object)seachPersonalModel.getKeyId()) || StringUtils.isEmpty((Object)seachPersonalModel.getType()) || StringUtils.isEmpty((Object)seachPersonalModel.getName())) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        Map typeAndName = this.fileFolderService.findByKeyIdAndTypeAndName(seachPersonalModel.getKeyId(), seachPersonalModel.getType(), seachPersonalModel.getName());
        return ResultModel.suc((Object)typeAndName);
    }

    @GetMapping(value={"/{keyId}/fileFolderTree/{type}"})
    @ApiOperation(value="(\u65b0\u4e2a\u4eba)\u83b7\u53d6\u6587\u4ef6\u5939\u76ee\u5f55\u6811")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="keyId", value="\u7c7b\u578b\u4e3b\u952eid", required=true, dataType="Long", paramType="path"), @ApiImplicitParam(name="type", value="\u7c7b\u578b 2\u9879\u76ee 3\u4e2a\u4eba", required=true, dataType="string", paramType="path"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<List<FileFolderEntity>> fileFolderTree(@CurrentUser User user, @PathVariable Long keyId, @PathVariable String type, @LanguageType String languageType) {
        if (!user.getId().equals(keyId) || StringUtils.isEmpty((Object)type)) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        return this.fileFolderService.folderPersonalTree(user.getId(), keyId, type, languageType);
    }

    @GetMapping(value={"/{parentId}/keyId/{keyId}/type/{type}"})
    @ApiOperation(value="(\u65b0\u4e2a\u4eba) \u83b7\u53d6\u6587\u4ef6\u5939\u53ca\u6587\u4ef6")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body"), @ApiImplicitParam(name="keyId", value="\u7c7b\u578b\u4e3b\u952eid", required=true, dataType="Long", paramType="path"), @ApiImplicitParam(name="type", value="\u9879\u76ee2 \u4e2a\u4eba3", required=true, dataType="Strng", paramType="path"), @ApiImplicitParam(name="parentId", value="\u7236\u7ea7\u6587\u4ef6\u5939id(\u6839\u8282\u70b9\u4f200)", required=true, dataType="Long", paramType="path")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel getFileAndFolderInfo(@CurrentUser User user, @PathVariable Long keyId, @PathVariable Long parentId, @PathVariable String type, @LanguageType String languageType) {
        if (StringUtils.isEmpty((Object)keyId) || StringUtils.isEmpty((Object)parentId) || StringUtils.isEmpty((Object)type)) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        return this.fileFolderService.getFileAndFolderInfo(user, keyId, parentId, type, languageType);
    }

    @DeleteMapping(value={"/del"})
    @ApiOperation(value="(\u65b0\u4e2a\u4eba)\u6279\u91cf\u5220\u9664\u6587\u4ef6\u548c\u6587\u4ef6\u5939")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel deleteFile(@CurrentUser User currentUser, @RequestBody DeleteFileAndFileFolderModel model, @LanguageType String languageType) {
        if (model == null || StringUtils.isEmpty((Object)model.getKeyId()) || StringUtils.isEmpty((Object)model.getType())) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        return this.fileService.delPersonalFileAndFileFolder(model.getFiles(), model.getDirs(), model.getType(), model.getKeyId(), currentUser, languageType);
    }

    @PutMapping(value={"/move"})
    @ApiOperation(value="(\u65b0\u4e2a\u4eba)\u6279\u91cf\u79fb\u52a8\u6587\u4ef6\u548c\u6587\u4ef6\u5939")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel moveFileAndFileFolder(@RequestBody MoveFileAndFileFolderModel moveFileAndFileFolderModel, @CurrentUser User currentUser, @LanguageType String languageType) {
        if (moveFileAndFileFolderModel == null) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        FileFolderEntity destDirFileFolderEntity = this.fileFolderService.findById(moveFileAndFileFolderModel.getDestDir());
        if (destDirFileFolderEntity == null && moveFileAndFileFolderModel.getDestDir() != 0L) {
            return ResultModel.error((ResultStatus)ResultStatus.FILE_FOLDER_ORIGINAL_NO_EXIST, (String)languageType);
        }
        return this.fileService.modifyFileAndFileFolder(moveFileAndFileFolderModel.getFiles(), moveFileAndFileFolderModel.getDirs(), moveFileAndFileFolderModel.getDestDir(), currentUser, languageType);
    }
}

