/*
 * Decompiled with CFR 0.152.
 */
package com.ym.tlifang.api.controller.file;

import com.alibaba.dubbo.config.annotation.Reference;
import com.ym.tlifang.Constants;
import com.ym.tlifang.ResultModel;
import com.ym.tlifang.ResultStatus;
import com.ym.tlifang.api.authorization.annotation.Authorization;
import com.ym.tlifang.api.authorization.annotation.CurrentUser;
import com.ym.tlifang.api.authorization.annotation.LanguageType;
import com.ym.tlifang.company.CompanyMemberInfo;
import com.ym.tlifang.file.FileFolderEntity;
import com.ym.tlifang.file.FileFolderPowerEntity;
import com.ym.tlifang.model.file.AddRootFileFolderModel;
import com.ym.tlifang.model.file.UpdateFileFolderNameModel;
import com.ym.tlifang.model.file.ValidateFolderNameModel;
import com.ym.tlifang.project.ProjectUser;
import com.ym.tlifang.service.company.CompanyMemberInfoService;
import com.ym.tlifang.service.file.FileFolderPowerService;
import com.ym.tlifang.service.file.FileFolderService;
import com.ym.tlifang.service.project.ProjectUserService;
import com.ym.tlifang.user.User;
import com.ym.tlifang.util.StringUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"fileFolders"})
@Api(value="fileFolders", description="\u6587\u4ef6\u5939\u76f8\u5173")
public class FileFolderController {
    @Reference
    private FileFolderService fileFolderService;
    @Reference
    private CompanyMemberInfoService memberInfoService;
    @Reference
    private ProjectUserService projectUserService;
    @Reference
    private FileFolderPowerService fileFolderPowerService;

    @PostMapping(value={"addRoot"})
    @ApiOperation(value="\uff08\u65b0\uff09\u65b0\u589e\u6700\u9876\u5c42\u6587\u4ef6\u5939")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<FileFolderEntity> addRootFileFolder(@CurrentUser User user, @RequestBody AddRootFileFolderModel addRootFileFolderModel, @LanguageType String languageType) throws Exception {
        if (StringUtils.isEmpty((Object)addRootFileFolderModel) || StringUtils.isEmpty((Object)addRootFileFolderModel.getFileFolderName()) || StringUtils.isEmpty((Object)addRootFileFolderModel.getType()) || StringUtils.isEmpty((Object)addRootFileFolderModel.getKeyId()) || StringUtils.isEmpty((Object)addRootFileFolderModel.getAdminId()) || !user.getId().equals(addRootFileFolderModel.getAdminId())) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        FileFolderEntity validerFileFolderName = this.fileFolderService.findByKeyIdAndTypeAndParentIdAndName(addRootFileFolderModel.getKeyId(), addRootFileFolderModel.getType(), Long.valueOf(0L), addRootFileFolderModel.getFileFolderName());
        if (validerFileFolderName != null) {
            return ResultModel.error((ResultStatus)ResultStatus.FILE_FOLDER_NAME_EXIST, (String)languageType);
        }
        return this.fileFolderService.addRootFileFolder(addRootFileFolderModel, languageType);
    }

    @PostMapping(value={"/{parentId}/addChild"})
    @ApiOperation(value="\uff08\u65b0\uff09\u65b0\u589e\u5b50\u6587\u4ef6\u5939")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body"), @ApiImplicitParam(name="parentId", value="\u9876\u7ea7\u6587\u4ef6\u5939id", required=true, dataType="Long", paramType="path")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<FileFolderEntity> addChildFileFolder(@CurrentUser User currentUser, @RequestBody FileFolderEntity fileFolderEntity, @PathVariable Long parentId, @LanguageType String languageType) {
        if (StringUtils.isEmpty((Object)fileFolderEntity) || StringUtils.isEmpty((Object)fileFolderEntity.getName()) || StringUtils.isEmpty((Object)fileFolderEntity.getParentId()) || StringUtils.isEmpty((Object)parentId) || StringUtils.isEmpty((Object)fileFolderEntity.getType()) || StringUtils.isEmpty((Object)fileFolderEntity.getKeyId())) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        FileFolderEntity validerFileFolderName = this.fileFolderService.findByKeyIdAndTypeAndParentIdAndName(fileFolderEntity.getKeyId(), fileFolderEntity.getType(), fileFolderEntity.getParentId(), fileFolderEntity.getName());
        if (validerFileFolderName != null) {
            return ResultModel.error((ResultStatus)ResultStatus.FILE_FOLDER_NAME_EXIST, (String)languageType);
        }
        FileFolderPowerEntity fileFolderPowerEntity = this.fileFolderPowerService.findByFileFolderIdAndUserIdAndDelFlagFalse(parentId, currentUser.getId());
        if (StringUtils.isEmpty((Object)fileFolderPowerEntity) || "2".equals(fileFolderPowerEntity.getPowerType())) {
            return ResultModel.error((ResultStatus)ResultStatus.FILE_FOLDER_ADMIN_NO_EXIST, (String)languageType);
        }
        FileFolderEntity fileFolderParent = this.fileFolderService.findById(fileFolderEntity.getParentId());
        fileFolderEntity.setParentIds(fileFolderParent.getParentIds() == null ? "," + fileFolderEntity.getParentId() + "," : fileFolderParent.getParentIds() + "," + fileFolderEntity.getParentId() + ",");
        fileFolderEntity.setCreateBy(currentUser.getId());
        fileFolderEntity.setUpdateBy(currentUser.getId());
        fileFolderEntity = this.fileFolderService.sava(fileFolderEntity);
        return ResultModel.suc((Object)fileFolderEntity);
    }

    @PostMapping
    @ApiOperation(value="\u65b0\u589e\u6587\u4ef6\u5939")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<FileFolderEntity> addFileFolder(@RequestBody FileFolderEntity fileFolderEntity, @CurrentUser User currentUser, @LanguageType String languageType) {
        return ResultModel.error((ResultStatus)ResultStatus.FILE_PAGES_NOT_SUPPORT_ACCESS, (String)languageType);
    }

    @PutMapping(value={"/updateName"})
    @ApiOperation(value="(\u65b0)\u4fee\u6539\u6587\u4ef6\u5939\u540d\u79f0")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<FileFolderEntity> newUpdateFileFolder(@RequestBody UpdateFileFolderNameModel updateFileFolderNameModel, @CurrentUser User currentUser, @LanguageType String languageType) {
        if (StringUtils.isEmpty((Object)updateFileFolderNameModel) || StringUtils.isEmpty((Object)updateFileFolderNameModel.getRootParentId()) || StringUtils.isEmpty((Object)updateFileFolderNameModel.getFileFolderId()) || StringUtils.isEmpty((Object)updateFileFolderNameModel.getFileFolderName())) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        return this.fileFolderService.newUpdateFileFolder(currentUser.getId(), updateFileFolderNameModel, languageType);
    }

    @PutMapping
    @ApiOperation(value="\u4fee\u6539\u6587\u4ef6\u5939\u540d\u79f0")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<FileFolderEntity> updateFileFolder(@RequestBody FileFolderEntity fileFolderEntity, @CurrentUser User currentUser, @LanguageType String languageType) {
        return ResultModel.error((ResultStatus)ResultStatus.FILE_PAGES_NOT_SUPPORT_ACCESS, (String)languageType);
    }

    @GetMapping
    @ApiOperation(value="\u9a8c\u8bc1\u6587\u4ef6\u5939\u540d\u79f0\u662f\u5426\u5b58\u5728")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel findFileFolderName(@RequestBody ValidateFolderNameModel validateFolderNameModel, @LanguageType String languageType) {
        if (validateFolderNameModel == null || StringUtils.isEmpty((Object)validateFolderNameModel.getName()) || StringUtils.isEmpty((Object)validateFolderNameModel.getId())) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        FileFolderEntity entity = this.fileFolderService.findById(validateFolderNameModel.getId());
        FileFolderEntity newFileFolderEntity = this.fileFolderService.findByKeyIdAndTypeAndParentIdAndName(entity.getKeyId(), entity.getType(), entity.getParentId(), validateFolderNameModel.getName());
        if (newFileFolderEntity != null) {
            return ResultModel.error((ResultStatus)ResultStatus.FILE_FOLDER_NAME_EXIST, (String)languageType);
        }
        return ResultModel.ok();
    }

    @GetMapping(value={"/{parentId}/newFileFolderTree"})
    @ApiOperation(value="(\u65b0)\u83b7\u53d6\u6587\u4ef6\u5939\u76ee\u5f55\u6811")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="parentId", value="\u6700\u9876\u5c42\u6587\u4ef6\u5939id", required=true, dataType="Long", paramType="path"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<List<FileFolderEntity>> newFileFolderTree(@CurrentUser User user, @PathVariable Long parentId, @LanguageType String languageType) {
        if (StringUtils.isEmpty((Object)parentId)) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        return this.fileFolderService.fileFolderTree(user.getId(), parentId, languageType);
    }

    @GetMapping(value={"/{keyId}/fileFolderTree/{type}"})
    @ApiOperation(value="\u83b7\u53d6\u6587\u4ef6\u5939\u76ee\u5f55\u6811")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="keyId", value="\u7c7b\u578b\u4e3b\u952eid", required=true, dataType="Long", paramType="path"), @ApiImplicitParam(name="type", value="\u7c7b\u578b 1\u516c\u53f8 2\u9879\u76ee 3\u4e2a\u4eba", required=true, dataType="string", paramType="path"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<List<FileFolderEntity>> fileFolderTree(@PathVariable Long keyId, @PathVariable String type, @LanguageType String languageType) {
        return ResultModel.error((ResultStatus)ResultStatus.FILE_PAGES_NOT_SUPPORT_ACCESS, (String)languageType);
    }

    private ResultModel vaildateFileFolder(FileFolderEntity fileFolderEntity, FileFolderEntity oldFileFolderEntity, User currentUser, @LanguageType String languageType) {
        if (Constants.FileType.team.getType().equals(fileFolderEntity.getType())) {
            CompanyMemberInfo companyMemberInfo = this.memberInfoService.findByCompanyIdAndUserIdAndStatus(oldFileFolderEntity.getKeyId(), currentUser.getId(), Constants.AuditStatus.adopt.getType());
            if (companyMemberInfo == null) {
                return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
            }
            if ((Constants.ManagerStatus.companyManager.getType().equals(companyMemberInfo.getManager()) || Constants.ManagerStatus.companyOrdinaryMember.getType().equals(companyMemberInfo.getManager())) && !currentUser.getId().equals(oldFileFolderEntity.getCreateBy())) {
                return ResultModel.error((ResultStatus)ResultStatus.FILE_FOLDER_ONLY_UPDATE_OWN, (String)languageType);
            }
        }
        if (Constants.FileType.project.getType().equals(fileFolderEntity.getType())) {
            ProjectUser projectUser = this.projectUserService.findByUserIdAndProjectIdAndDelFlagFalse(currentUser.getId(), oldFileFolderEntity.getKeyId(), languageType);
            if (projectUser == null) {
                return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
            }
            if ((Constants.TypeStatus.projectManager.getType().equals(projectUser.getType()) || Constants.TypeStatus.projectOrdinaryMember.getType().equals(projectUser.getType())) && !currentUser.getId().equals(oldFileFolderEntity.getCreateBy())) {
                return ResultModel.error((ResultStatus)ResultStatus.FILE_FOLDER_ONLY_UPDATE_OWN, (String)languageType);
            }
        }
        return ResultModel.ok();
    }
}

