/*
 * Decompiled with CFR 0.152.
 */
package com.ym.tlifang.api.controller.attendance;

import com.alibaba.dubbo.config.annotation.Reference;
import com.ym.tlifang.ResultModel;
import com.ym.tlifang.ResultStatus;
import com.ym.tlifang.api.authorization.annotation.Authorization;
import com.ym.tlifang.api.authorization.annotation.CurrentUser;
import com.ym.tlifang.api.authorization.annotation.LanguageType;
import com.ym.tlifang.api.controller.BaseController;
import com.ym.tlifang.attendance.AttendanceClasses;
import com.ym.tlifang.attendance.AttendanceWeekday;
import com.ym.tlifang.service.attendance.AttendanceClassesService;
import com.ym.tlifang.service.attendance.AttendanceWeekdayService;
import com.ym.tlifang.service.company.CompanyMemberInfoService;
import com.ym.tlifang.user.User;
import com.ym.tlifang.util.StringUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"attendanceWeekday"})
@Api(value="attendanceWeekday", description="\u7279\u6b8a\u5de5\u4f5c\u65e5")
public class AttendanceWeekdayController
extends BaseController {
    @Reference
    private AttendanceWeekdayService attendanceWeekdayService;
    @Reference
    private AttendanceClassesService attendanceClassesService;
    @Reference
    private CompanyMemberInfoService companyMemberInfoService;

    @RequestMapping(method={RequestMethod.GET}, value={"/{classesId}"})
    @ApiOperation(value="\u67e5\u770b\u7279\u6b8a\u5de5\u4f5c\u65e5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="classesId", value="\u73ed\u6b21id", required=true, dataType="Long", paramType="path"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<List<AttendanceWeekday>> getOne(@LanguageType String languageType, @PathVariable Long classesId) {
        List attendanceWeekdayList = this.attendanceWeekdayService.findByClassId(classesId, new Date());
        return ResultModel.suc((Object)attendanceWeekdayList, (String)languageType);
    }

    @PostMapping
    @ApiOperation(value="\u4fdd\u5b58\u7279\u6b8a\u5de5\u4f5c\u65e5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<List<List<AttendanceWeekday>>> addAttendanceWeekday(@LanguageType String languageType, @RequestBody List<List<AttendanceWeekday>> attendanceWeekdays, @CurrentUser User currentUser) {
        Boolean bl = this.companyMemberInfoService.havePower(currentUser.getCurrentCompany(), currentUser.getId());
        if (bl.booleanValue()) {
            return ResultModel.error((ResultStatus)ResultStatus.ATTENDENCE_NO_EXIST, (String)languageType);
        }
        List attendanceClassesList = this.attendanceClassesService.findByCompanyIdAndDelFlagFalse(currentUser.getCurrentCompany());
        for (AttendanceClasses attendanceClasses : attendanceClassesList) {
            List attendanceWeekdayAll = this.attendanceWeekdayService.findByClassId(attendanceClasses.getId(), new Date());
            for (AttendanceWeekday attendanceWeekday : attendanceWeekdayAll) {
                if (!"1".equals(attendanceWeekday.getType()) && !"2".equals(attendanceWeekday.getType())) continue;
                attendanceWeekday.setDelFlag(Boolean.valueOf(true));
                attendanceWeekday = this.attendanceWeekdayService.save(attendanceWeekday);
            }
        }
        for (List list : attendanceWeekdays) {
            for (AttendanceWeekday attendanceWeekday : list) {
                if (StringUtils.isEmpty((Object)attendanceWeekday) || StringUtils.isEmpty((Object)attendanceWeekday.getClassesId()) || StringUtils.isEmpty((Object)attendanceWeekday.getApellation()) || StringUtils.isEmpty((Object)attendanceWeekday.getDate()) || StringUtils.isEmpty((Object)attendanceWeekday.getType())) {
                    return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
                }
                if ("2".equals(attendanceWeekday.getType()) && StringUtils.isEmpty((Object)attendanceWeekday.getTimeArray())) {
                    return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
                }
                AttendanceClasses attendanceClasses = this.attendanceClassesService.findById(attendanceWeekday.getClassesId());
                if (attendanceClasses == null) {
                    return ResultModel.error((ResultStatus)ResultStatus.ATTENDCLASSES_NO_EXIST, (String)languageType);
                }
                if (!attendanceClasses.getCompanyId().equals(currentUser.getCurrentCompany())) {
                    return ResultModel.error((ResultStatus)ResultStatus.ATTENDENCE_NO_EXIST, (String)languageType);
                }
                attendanceWeekday = this.attendanceWeekdayService.save(attendanceWeekday);
            }
        }
        return ResultModel.suc(attendanceWeekdays, (String)languageType);
    }

    @RequestMapping(method={RequestMethod.GET})
    @ApiOperation(value="\u67e5\u770b\u6240\u6709\u7279\u6b8a\u5de5\u4f5c\u65e5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<List<List<AttendanceWeekday>>> getOne(@LanguageType String languageType, @CurrentUser User currentUser) {
        List attendanceClassesList = this.attendanceClassesService.findByCompanyIdAndDelFlagFalse(currentUser.getCurrentCompany());
        ArrayList attendanceWeekdays = new ArrayList();
        for (AttendanceClasses attendanceClasses : attendanceClassesList) {
            List attendanceWeekdayList = this.attendanceWeekdayService.findByClassId(attendanceClasses.getId(), new Date());
            List attendanceWeekdayListThree = this.attendanceWeekdayService.findToday(attendanceClasses.getId(), new Date());
            ArrayList<AttendanceWeekday> attendanceWeekdayListTwo = new ArrayList<AttendanceWeekday>();
            if (attendanceWeekdayListThree.size() != 0) {
                for (AttendanceWeekday attendanceWeekday : attendanceWeekdayListThree) {
                    if (!"1".equals(attendanceWeekday.getType()) && !"2".equals(attendanceWeekday.getType())) continue;
                    attendanceWeekdayListTwo.add(attendanceWeekday);
                }
            }
            if (attendanceWeekdayList.size() != 0) {
                for (AttendanceWeekday attendanceWeekday : attendanceWeekdayList) {
                    if (!"1".equals(attendanceWeekday.getType()) && !"2".equals(attendanceWeekday.getType())) continue;
                    attendanceWeekdayListTwo.add(attendanceWeekday);
                }
            }
            attendanceWeekdays.add(attendanceWeekdayListTwo);
        }
        return ResultModel.suc(attendanceWeekdays, (String)languageType);
    }
}

