/*
 * Decompiled with CFR 0.152.
 */
package com.ym.tlifang.api.controller.attendance;

import com.alibaba.dubbo.config.annotation.Reference;
import com.ym.tlifang.Constants;
import com.ym.tlifang.ResultModel;
import com.ym.tlifang.ResultStatus;
import com.ym.tlifang.api.authorization.annotation.Authorization;
import com.ym.tlifang.api.authorization.annotation.CurrentUser;
import com.ym.tlifang.api.authorization.annotation.LanguageType;
import com.ym.tlifang.api.controller.BaseController;
import com.ym.tlifang.attendance.AttendanceClasses;
import com.ym.tlifang.attendance.AttendanceTime;
import com.ym.tlifang.attendance.AttendanceUser;
import com.ym.tlifang.attendance.AttendanceWifi;
import com.ym.tlifang.attendance.AttendanceWorkday;
import com.ym.tlifang.company.CompanyMemberInfo;
import com.ym.tlifang.service.attendance.AttendanceClassesService;
import com.ym.tlifang.service.attendance.AttendanceHolidaysService;
import com.ym.tlifang.service.attendance.AttendanceTimeService;
import com.ym.tlifang.service.attendance.AttendanceUserService;
import com.ym.tlifang.service.attendance.AttendanceWeekdayService;
import com.ym.tlifang.service.attendance.AttendanceWifiService;
import com.ym.tlifang.service.attendance.AttendanceWorkdayService;
import com.ym.tlifang.service.company.CompanyMemberInfoService;
import com.ym.tlifang.service.company.CompanyService;
import com.ym.tlifang.service.push.XgPushService;
import com.ym.tlifang.service.user.UserService;
import com.ym.tlifang.user.User;
import com.ym.tlifang.util.JsonUtil;
import com.ym.tlifang.util.StringUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.ArrayList;
import java.util.List;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"attendanceClasses"})
@Api(value="attendanceClasses", description="\u73ed\u6b21")
public class AttendanceClassesController
extends BaseController {
    @Reference
    private CompanyService companyService;
    @Reference
    private AttendanceClassesService attendanceClassesService;
    @Reference
    private AttendanceUserService attendanceUserService;
    @Reference
    private AttendanceWorkdayService attendanceWorkdayService;
    @Reference
    private AttendanceTimeService attendanceTimeService;
    @Reference
    private AttendanceHolidaysService attendanceHolidaysService;
    @Reference
    private AttendanceWeekdayService attendanceWeekdayService;
    @Reference
    private CompanyMemberInfoService companyMemberInfoService;
    @Reference
    private UserService userService;
    @Reference
    private XgPushService xgPushService;
    @Reference
    private AttendanceWifiService attendanceWifiService;

    @PostMapping
    @ApiOperation(value="\u4fdd\u5b58\u73ed\u6b21")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<AttendanceClasses> addAttendanceClasses(@LanguageType String languageType, @CurrentUser User currentUser, @RequestBody AttendanceClasses attendanceClasses) throws Exception {
        AttendanceClasses attendanceClassesTwo;
        if (StringUtils.isEmpty((Object)attendanceClasses) || StringUtils.isEmpty((Object)currentUser.getCurrentCompany()) || StringUtils.isEmpty((Object)attendanceClasses.getClassName()) || StringUtils.isEmpty((Object)attendanceClasses.getWhetherMendSign()) || StringUtils.isEmpty((Object)attendanceClasses.getRemind()) || StringUtils.isEmpty((Object)attendanceClasses.getCompanyMemberInfoList()) || StringUtils.isEmpty((Object)attendanceClasses.getWorkdayList()) || StringUtils.isEmpty((Object)attendanceClasses.getTimeList()) || StringUtils.isEmpty((Object)attendanceClasses.getStatus()) || StringUtils.isEmpty((Object)attendanceClasses.getLegal())) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        Boolean bl = this.companyMemberInfoService.havePower(currentUser.getCurrentCompany(), currentUser.getId());
        if (bl.booleanValue()) {
            return ResultModel.error((ResultStatus)ResultStatus.ATTENDENCE_NO_EXIST, (String)languageType);
        }
        if (attendanceClasses.getId() != null && !(attendanceClassesTwo = this.attendanceClassesService.findById(attendanceClasses.getId())).getCompanyId().equals(currentUser.getCurrentCompany())) {
            return ResultModel.error((ResultStatus)ResultStatus.ATTENDENCE_NO_EXIST, (String)languageType);
        }
        if (attendanceClasses.getWifiIds() != null) {
            attendanceClasses.setWifiArray(JsonUtil.jackson.writeValueAsString((Object)attendanceClasses.getWifiIds()));
        }
        attendanceClasses.setCompanyId(currentUser.getCurrentCompany());
        List userArray = attendanceClasses.getCompanyMemberInfoList();
        List workdayList = attendanceClasses.getWorkdayList();
        List timeLists = attendanceClasses.getTimeList();
        attendanceClasses = this.attendanceClassesService.save(attendanceClasses);
        this.attendanceTimeService.deleteAllClassTime(attendanceClasses.getId());
        this.attendanceWorkdayService.deleteAllWorkDay(attendanceClasses.getId());
        this.attendanceUserService.deleteAllUser(attendanceClasses.getId());
        for (CompanyMemberInfo companyMemberInfo : userArray) {
            AttendanceUser attendanceUser = this.attendanceUserService.findByUserIdAndDelFlagFalse(companyMemberInfo.getUserId(), currentUser.getCurrentCompany());
            if (attendanceUser != null) {
                attendanceUser.setDelFlag(Boolean.valueOf(true));
                this.attendanceUserService.save(attendanceUser);
            }
            attendanceUser = new AttendanceUser();
            attendanceUser.setClassesId(attendanceClasses.getId());
            attendanceUser.setUserId(companyMemberInfo.getUserId());
            attendanceUser.setCompanyId(currentUser.getCurrentCompany());
            this.attendanceUserService.save(attendanceUser);
        }
        for (AttendanceWorkday attendanceWorkday : workdayList) {
            attendanceWorkday.setClassesId(attendanceClasses.getId());
        }
        workdayList = this.attendanceWorkdayService.saveAll(workdayList);
        for (int i = 0; i < workdayList.size(); ++i) {
            List timeList = (List)timeLists.get(i);
            for (AttendanceTime attendanceTime : timeList) {
                attendanceTime.setClassesId(attendanceClasses.getId());
                attendanceTime.setWorkdayId(((AttendanceWorkday)workdayList.get(i)).getId());
            }
            this.attendanceTimeService.saveAll(timeList);
        }
        if (attendanceClasses.getStatus().booleanValue()) {
            this.attendanceClassesService.setNextNoticeTimeScheduleTask(currentUser.getCurrentCompany(), attendanceClasses.getId());
        }
        return ResultModel.suc((Object)attendanceClasses, (String)languageType);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/{companyId}"})
    @ApiOperation(value="\u73ed\u6b21\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="companyId", value="\u516c\u53f8id", required=true, dataType="Long", paramType="path"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<List<AttendanceClasses>> getOne(@LanguageType String languageType, @PathVariable Long companyId) {
        List attendanceClassesList = this.attendanceClassesService.findByCompanyIdAndDelFlagFalse(companyId);
        for (AttendanceClasses attendanceClasses : attendanceClassesList) {
            ArrayList<List> attendanceTimes = new ArrayList<List>();
            List attendanceWorkdayList = this.attendanceWorkdayService.findByClassesIdAndDelFlagFalse(attendanceClasses.getId());
            for (AttendanceWorkday attendanceWorkday : attendanceWorkdayList) {
                attendanceTimes.add(attendanceWorkday.getAttendanceTimeList());
            }
            attendanceClasses.setWorkdayList(attendanceWorkdayList);
            attendanceClasses.setTimeList(attendanceTimes);
        }
        return ResultModel.suc((Object)attendanceClassesList, (String)languageType);
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"/class/{classId}"})
    @ApiOperation(value="\u5220\u9664\u73ed\u6b21")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="classId", value="\u73ed\u6b21id", required=true, dataType="Long", paramType="path"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel deleteClasses(@LanguageType String languageType, @CurrentUser User currentUser, @PathVariable Long classId) {
        Boolean bl = this.companyMemberInfoService.havePower(currentUser.getCurrentCompany(), currentUser.getId());
        if (bl.booleanValue()) {
            return ResultModel.error((ResultStatus)ResultStatus.ATTENDENCE_NO_EXIST, (String)languageType);
        }
        AttendanceClasses attendanceClasses = this.attendanceClassesService.findById(classId);
        if (attendanceClasses == null) {
            return ResultModel.error((ResultStatus)ResultStatus.ATTENDCLASSES_NO_EXIST, (String)languageType);
        }
        if (!currentUser.getCurrentCompany().equals(attendanceClasses.getCompanyId())) {
            return ResultModel.error((ResultStatus)ResultStatus.ATTENDENCE_NO_EXIST, (String)languageType);
        }
        if (!attendanceClasses.getCompanyId().equals(currentUser.getCurrentCompany())) {
            return ResultModel.error((ResultStatus)ResultStatus.ATTENDENCE_NO_EXIST, (String)languageType);
        }
        attendanceClasses.setDelFlag(Boolean.valueOf(true));
        attendanceClasses = this.attendanceClassesService.save(attendanceClasses);
        List attendanceUserList = this.attendanceUserService.findByClassesId(classId);
        for (Object attendanceUser : attendanceUserList) {
            attendanceUser.setDelFlag(Boolean.valueOf(true));
            attendanceUser = this.attendanceUserService.save((AttendanceUser)attendanceUser);
        }
        List attendanceWorkdayList = this.attendanceWorkdayService.findByClassesIdAndDelFlagFalse(classId);
        for (AttendanceWorkday attendanceWorkday : attendanceWorkdayList) {
            attendanceWorkday.setDelFlag(Boolean.valueOf(true));
            attendanceWorkday = this.attendanceWorkdayService.save(attendanceWorkday);
        }
        List attendanceTimeList = this.attendanceTimeService.findByClassesIdAndDelFlagFalse(classId);
        for (AttendanceTime attendanceTime : attendanceTimeList) {
            attendanceTime.setDelFlag(Boolean.valueOf(true));
            attendanceTime = this.attendanceTimeService.save(attendanceTime);
        }
        return ResultModel.ok((String)languageType);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/class/{classId}"})
    @ApiOperation(value="\u67e5\u770b\u5355\u4e2a\u73ed\u6b21")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="classId", value="\u73ed\u6b21id", required=true, dataType="Long", paramType="path"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<AttendanceClasses> getClasses(@LanguageType String languageType, @CurrentUser User currentUser, @PathVariable Long classId) throws Exception {
        AttendanceClasses attendanceClasses = this.attendanceClassesService.findById(classId);
        ArrayList<List> attendanceTimes = new ArrayList<List>();
        List attendanceWorkdayList = this.attendanceWorkdayService.findByClassesIdAndDelFlagFalse(attendanceClasses.getId());
        for (AttendanceWorkday attendanceWorkday : attendanceWorkdayList) {
            attendanceTimes.add(attendanceWorkday.getAttendanceTimeList());
        }
        List attendanceUserList = this.attendanceUserService.findByClassesId(attendanceClasses.getId());
        ArrayList<CompanyMemberInfo> companyMemberInfoList = new ArrayList<CompanyMemberInfo>();
        for (AttendanceUser attendanceUser : attendanceUserList) {
            CompanyMemberInfo companyMemberInfo = this.companyMemberInfoService.findByCompanyIdAndUserIdAndStatus(currentUser.getCurrentCompany(), attendanceUser.getUserId(), Constants.AuditStatus.adopt.getType());
            if (companyMemberInfo == null) continue;
            User user = companyMemberInfo.getUser();
            companyMemberInfo.setAvatar(user.getAvatar());
            companyMemberInfo.setName(user.getName());
            companyMemberInfoList.add(companyMemberInfo);
        }
        attendanceClasses.setCompanyMemberInfoList(companyMemberInfoList);
        attendanceClasses.setWorkdayList(attendanceWorkdayList);
        attendanceClasses.setTimeList(attendanceTimes);
        if (attendanceClasses.getWifiArray() != null) {
            attendanceClasses.setWifiList(this.attendanceWifiService.findSomeWifi((List)JsonUtil.jackson.readValue(attendanceClasses.getWifiArray(), List.class)));
            ArrayList<Integer> wifiIds = new ArrayList<Integer>();
            for (AttendanceWifi attendanceWifi : attendanceClasses.getWifiList()) {
                wifiIds.add(attendanceWifi.getId().intValue());
            }
            attendanceClasses.setWifiIds(wifiIds);
        }
        return ResultModel.suc((Object)attendanceClasses, (String)languageType);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/id/status"})
    @ApiOperation(value="\u4fee\u6539\u8003\u52e4\u72b6\u6001")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="id", value="\u73ed\u6b21id", required=false, dataType="Long", paramType="query"), @ApiImplicitParam(name="status", value="\u5f00\u542f\u72b6\u6001", required=false, dataType="Boolean", paramType="query"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel updateStatus(@LanguageType String languageType, Long id, Boolean status) {
        AttendanceClasses attendanceClasses = this.attendanceClassesService.findById(id);
        if (attendanceClasses == null) {
            return ResultModel.error((ResultStatus)ResultStatus.ATTENDCLASSES_NO_EXIST, (String)languageType);
        }
        attendanceClasses.setStatus(status);
        attendanceClasses = this.attendanceClassesService.save(attendanceClasses);
        if (status.booleanValue()) {
            this.attendanceClassesService.setNextNoticeTimeScheduleTask(attendanceClasses.getCompanyId(), attendanceClasses.getId());
        }
        return ResultModel.ok((String)languageType);
    }
}

