/*
 * Decompiled with CFR 0.152.
 */
package com.ym.tlifang.api.controller.agenda;

import com.alibaba.dubbo.config.annotation.Reference;
import com.ym.tlifang.Constants;
import com.ym.tlifang.ResultModel;
import com.ym.tlifang.ResultStatus;
import com.ym.tlifang.agenda.Agenda;
import com.ym.tlifang.api.authorization.annotation.Authorization;
import com.ym.tlifang.api.authorization.annotation.CurrentUser;
import com.ym.tlifang.api.authorization.annotation.LanguageType;
import com.ym.tlifang.api.controller.BaseController;
import com.ym.tlifang.service.agenda.AgendaService;
import com.ym.tlifang.service.meeting.MeetingService;
import com.ym.tlifang.service.push.XgPushService;
import com.ym.tlifang.service.task.TaskService;
import com.ym.tlifang.service.user.UserService;
import com.ym.tlifang.user.User;
import com.ym.tlifang.util.DateUtils;
import com.ym.tlifang.util.StringUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"agenda"})
@Api(value="agenda", description="\u65e5\u7a0b")
public class AgendaController
extends BaseController {
    @Reference
    private AgendaService agendaService;
    @Reference
    private MeetingService meetingService;
    @Reference
    private TaskService taskService;
    @Reference
    private UserService userService;
    @Reference
    private XgPushService xgPushService;

    @PostMapping
    @ApiOperation(value="\u65b0\u589e\u65e5\u7a0b")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="agenda", value="\u65e5\u7a0b", required=true, dataType="agenda", paramType="body"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<Agenda> addAgenda(@LanguageType String languageType, @CurrentUser User currentUser, @RequestBody Agenda agenda) {
        boolean isTrue;
        if (StringUtils.isEmpty((Object)agenda) || StringUtils.isEmpty((Object)agenda.getTitle()) || StringUtils.isEmpty((Object)agenda.getStartTime()) || StringUtils.isEmpty((Object)agenda.getEndTime())) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        agenda.setUserId(currentUser.getId());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        double days = 0.0;
        Date startTime = null;
        Date endTime = null;
        try {
            startTime = sdf.parse(agenda.getStartTime());
            endTime = sdf.parse(agenda.getEndTime());
            days = DateUtils.getDistanceOfTwoDate((Date)startTime, (Date)endTime);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        boolean bl = isTrue = Constants.LoopTaskType.everyday.getType().equals(agenda.getRecur()) && days > 0.0 || Constants.LoopTaskType.weekly.getType().equals(agenda.getRecur()) && days > 7.0 || Constants.LoopTaskType.manthly.getType().equals(agenda.getRecur()) && days > 31.0;
        if (isTrue) {
            return ResultModel.error((ResultStatus)ResultStatus.SET_ERROR, (String)languageType);
        }
        Date date = new Date();
        if (DateUtils.compareDate((Date)date, (Date)startTime) == 1) {
            return ResultModel.error((ResultStatus)ResultStatus.TIME_ERROR_LESS, (String)languageType);
        }
        if (DateUtils.compareDate((Date)startTime, (Date)endTime) == 1) {
            return ResultModel.error((ResultStatus)ResultStatus.TIME_ERROR_MORE, (String)languageType);
        }
        agenda = this.agendaService.saveAgenda(agenda);
        return ResultModel.suc((Object)agenda, (String)languageType);
    }

    @DeleteMapping(value={"/{id}"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="id", value="\u65e5\u7a0bid", required=true, dataType="Long", paramType="path")})
    @ApiOperation(value="\u5220\u9664\u65e5\u7a0b")
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel deleteAgenda(@LanguageType String languageType, @PathVariable Long id) {
        Agenda agenda = this.agendaService.findById(id);
        if (StringUtils.isEmpty((Object)agenda)) {
            return ResultModel.error((ResultStatus)ResultStatus.AGENDA_HAS__NO_EXIST, (String)languageType);
        }
        agenda.setDelFlag(Boolean.valueOf(true));
        this.agendaService.saveAgenda(agenda);
        return ResultModel.ok((String)languageType);
    }

    @PutMapping(value={"/{id}"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="id", value="\u65e5\u7a0bid", required=true, dataType="Long", paramType="path"), @ApiImplicitParam(name="agenda", value="\u65e5\u7a0b", required=true, dataType="agenda", paramType="body")})
    @ApiOperation(value="\u4fee\u6539\u65e5\u7a0b")
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<Agenda> updateAgenda(@LanguageType String languageType, @PathVariable Long id, @RequestBody Agenda agenda) {
        if (StringUtils.isEmpty((Object)agenda) || StringUtils.isEmpty((Object)agenda.getTitle()) || StringUtils.isEmpty((Object)agenda.getStartTime()) || StringUtils.isEmpty((Object)agenda.getEndTime())) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        Agenda oldAgenda = this.agendaService.findById(id);
        if (StringUtils.isEmpty((Object)oldAgenda)) {
            return ResultModel.error((ResultStatus)ResultStatus.AGENDA_HAS__NO_EXIST, (String)languageType);
        }
        if (!StringUtils.isEmpty((Object)agenda)) {
            oldAgenda.setTitle(agenda.getTitle());
            oldAgenda.setStartTime(agenda.getStartTime());
            oldAgenda.setEndTime(agenda.getEndTime());
            oldAgenda.setImportance(agenda.getImportance());
            oldAgenda.setRemind(agenda.getRemind());
            oldAgenda.setRecur(agenda.getRecur());
            this.agendaService.saveAgenda(oldAgenda);
        }
        return ResultModel.suc((Object)oldAgenda, (String)languageType);
    }

    @GetMapping(value={"/queryLists"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="companyId", value="\u516c\u53f8id", required=false, dataType="Long", paramType="query"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237(\u53ef\u4e0d\u4f20)", required=false, dataType="user", paramType="body"), @ApiImplicitParam(name="dateString", value="\u65e5\u671f 2018-02-03", required=true, dataType="string", paramType="query"), @ApiImplicitParam(name="type", value="\u7c7b\u578b 0\u5168\u90e8 1\u65e5\u7a0b 2\u4f1a\u8bae 3\u4efb\u52a1", required=true, dataType="string", paramType="query")})
    @ApiOperation(value="\u83b7\u53d6\u4f1a\u8bae\uff0c\u4efb\u52a1\uff0c\u65e5\u7a0b\u96c6\u5408")
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel countUserCurrentMonthMeeting(@LanguageType String languageType, Long companyId, @CurrentUser User currentUser, String dateString, String type) {
        Map meetingMap = new HashMap();
        Map agendaMap = new HashMap();
        Map taskMap = new HashMap();
        HashMap resultMap = new HashMap();
        if (StringUtils.isNotBlank((String)type) && Constants.AgendaMeetingTask.agenda.getType().equals(type)) {
            agendaMap = this.agendaService.findUserMonthAgendaList(companyId, currentUser.getId(), dateString);
            resultMap.put("agendaMap", agendaMap);
            return ResultModel.suc(resultMap, (String)languageType);
        }
        if (StringUtils.isNotBlank((String)type) && Constants.AgendaMeetingTask.meeting.getType().equals(type)) {
            if (!StringUtils.isEmpty((Object)companyId)) {
                meetingMap = this.meetingService.findUserMonthMeetingList(companyId, currentUser.getId(), dateString);
            }
            resultMap.put("meetingMap", meetingMap);
            return ResultModel.suc(resultMap, (String)languageType);
        }
        if (StringUtils.isNotBlank((String)type) && Constants.AgendaMeetingTask.task.getType().equals(type)) {
            taskMap = this.taskService.findByCompanyIdAndCreatorIdAndDate(companyId, currentUser.getId(), dateString);
            resultMap.put("taskMap", taskMap);
            return ResultModel.suc(resultMap, (String)languageType);
        }
        if (!StringUtils.isEmpty((Object)companyId)) {
            meetingMap = this.meetingService.findUserMonthMeetingList(companyId, currentUser.getId(), dateString);
        }
        agendaMap = this.agendaService.findUserMonthAgendaList(companyId, currentUser.getId(), dateString);
        taskMap = this.taskService.findByCompanyIdAndCreatorIdAndDate(companyId, currentUser.getId(), dateString);
        resultMap.put("agendaMap", agendaMap);
        resultMap.put("meetingMap", meetingMap);
        resultMap.put("taskMap", taskMap);
        return ResultModel.suc(resultMap, (String)languageType);
    }
}

