/*
 * Decompiled with CFR 0.152.
 */
package com.ym.tlifang.service.workreport;

import com.alibaba.dubbo.config.annotation.Service;
import com.github.binarywang.java.emoji.EmojiConverter;
import com.ym.tlifang.BaseEntity;
import com.ym.tlifang.PageInfo;
import com.ym.tlifang.dao.workreport.WorkReportDao;
import com.ym.tlifang.service.AbstractBaseService;
import com.ym.tlifang.service.workreport.WorkReportService;
import com.ym.tlifang.util.StringUtils;
import com.ym.tlifang.workreport.WorkReport;
import java.util.List;
import org.apache.commons.lang3.StringEscapeUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
@Service(interfaceClass=WorkReportService.class, timeout=10000, retries=-1)
public class WorkReportServiceImpl
extends AbstractBaseService<WorkReport, WorkReportDao>
implements WorkReportService {
    @Autowired
    private static EmojiConverter emojiConverter = EmojiConverter.getInstance();

    public WorkReport save(WorkReport workReport) {
        return (WorkReport)super.save((BaseEntity)workReport);
    }

    public List<WorkReport> copyTo(Long detailId) {
        return ((WorkReportDao)this.dao).findByDetailIdAndReceiveTypeFalseAndDelFlagFalse(detailId);
    }

    public PageInfo<WorkReport> mailbox(Long companyId, Long userId, String type, Integer pageNo, Integer pageSize) {
        pageNo = StringUtils.isEmpty((Object)pageNo) ? 1 : pageNo;
        PageRequest pageable = new PageRequest(pageNo - 1, StringUtils.isEmpty((Object)pageSize) ? 10 : pageSize);
        PageInfo pageInfo = "0".equals(type) ? PageInfo.fromPage((Page)((WorkReportDao)this.dao).findByCompanyIdAndReceiveIdAndSendOutTrueAndDelFlagFalseOrderByCreateDateDesc(companyId, userId, (Pageable)pageable)) : ("1".equals(type) ? PageInfo.fromPage((Page)((WorkReportDao)this.dao).findByCompanyIdAndSendIdAndSendOutTrueAndReceiveTypeTrueAndTabTrueAndDelFlagFalseOrderByCreateDateDesc(companyId, userId, (Pageable)pageable)) : ("2".equals(type) ? PageInfo.fromPage((Page)((WorkReportDao)this.dao).findByCompanyIdAndSendIdAndSendOutFalseAndReceiveTypeTrueAndTabTrueAndDelFlagFalseOrderByCreateDateDesc(companyId, userId, (Pageable)pageable)) : ("3".equals(type) ? PageInfo.fromPage((Page)((WorkReportDao)this.dao).findByCompanyIdAndReceiveIdAndLookedAndSendOutTrueAndDelFlagFalseOrderByCreateDateDesc(companyId, userId, Boolean.valueOf(false), (Pageable)pageable)) : ("4".equals(type) ? PageInfo.fromPage((Page)((WorkReportDao)this.dao).findByCompanyIdAndReceiveIdAndLookedAndSendOutTrueAndDelFlagFalseOrderByCreateDateDesc(companyId, userId, Boolean.valueOf(true), (Pageable)pageable)) : PageInfo.fromPage((Page)((WorkReportDao)this.dao).findByCompanyIdAndReceiveIdAndReceiveTypeFalseAndSendOutTrueAndDelFlagFalseOrderByCreateDateDesc(companyId, userId, (Pageable)pageable))))));
        List workReports = pageInfo.getRows();
        for (WorkReport workReport : workReports) {
            workReport.getWorkReportDetail().setTheme(StringEscapeUtils.unescapeJava((String)workReport.getWorkReportDetail().getTheme()));
            workReport.getWorkReportDetail().setContent(StringEscapeUtils.unescapeJava((String)workReport.getWorkReportDetail().getContent()));
        }
        pageInfo.setRows(workReports);
        return pageInfo;
    }

    public WorkReport receive(Long detailId) {
        return ((WorkReportDao)this.dao).findByDetailIdAndReceiveTypeTrueAndTabTrueAndDelFlagFalse(detailId);
    }

    public WorkReport findByIdAndDelFlagFalse(Long id) {
        return ((WorkReportDao)this.dao).findByIdAndDelFlagFalse(id);
    }

    public int countByCompanyIdAndReceiveIdAndSendOutTrueAndLookedFalseAndDelFlagFalse(Long companyId, Long receiveId) {
        int count = ((WorkReportDao)this.dao).countByCompanyIdAndReceiveIdAndSendOutTrueAndLookedFalseAndDelFlagFalse(companyId, receiveId);
        return count;
    }

    public List<WorkReport> findTabTwo(Long detailId) {
        return ((WorkReportDao)this.dao).findByDetailIdAndReceiveTypeTrueAndTabFalseAndStatusNullAndDelFlagFalse(detailId);
    }

    public List<WorkReport> findAllReceive(Long detailId) {
        return ((WorkReportDao)this.dao).findByDetailIdAndStatusNullAndReceiveTypeTrueAndDelFlagFalse(detailId);
    }

    public List<WorkReport> findByIdInAndDelFlagFalse(List<Long> ids) {
        return ((WorkReportDao)this.dao).findByIdInAndDelFlagFalse(ids);
    }
}

