/*
 * Decompiled with CFR 0.152.
 */
package com.ym.tlifang.service.task;

import com.alibaba.dubbo.config.annotation.Service;
import com.ym.tlifang.BaseEntity;
import com.ym.tlifang.Constants;
import com.ym.tlifang.PageInfo;
import com.ym.tlifang.ResultModel;
import com.ym.tlifang.ResultStatus;
import com.ym.tlifang.dao.task.TaskDao;
import com.ym.tlifang.model.project.ProjectTaskStatisticsModel;
import com.ym.tlifang.model.task.TaskCountModel;
import com.ym.tlifang.model.user.UserModel;
import com.ym.tlifang.service.AbstractBaseService;
import com.ym.tlifang.service.task.TaskConcernService;
import com.ym.tlifang.service.task.TaskPanelRelationService;
import com.ym.tlifang.service.task.TaskService;
import com.ym.tlifang.service.task.subtask.SubtaskService;
import com.ym.tlifang.service.user.UserService;
import com.ym.tlifang.task.Task;
import com.ym.tlifang.task.TaskConcern;
import com.ym.tlifang.task.TaskPanelRelation;
import com.ym.tlifang.user.User;
import com.ym.tlifang.util.DateUtils;
import com.ym.tlifang.util.StringUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringEscapeUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

@Component
@Service(interfaceClass=TaskService.class, timeout=100000, retries=-1)
public class TaskServiceImpl
extends AbstractBaseService<Task, TaskDao>
implements TaskService {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private UserService userService;
    @Autowired
    private TaskConcernService taskConcernService;
    @Autowired
    private TaskPanelRelationService taskPanelRelationService;
    @Autowired
    private StringRedisTemplate redis;
    @Autowired
    private SubtaskService subtaskService;
    @Autowired
    private TaskService taskService;

    public Task save(Task task) {
        return (Task)super.save((BaseEntity)task);
    }

    public Task findOne(Long taskId) {
        return (Task)((TaskDao)this.dao).findOne((Serializable)taskId);
    }

    public Task findByTaskId(Long taskId) {
        return ((TaskDao)this.dao).findById(taskId, Boolean.valueOf(false));
    }

    public List<Task> findByTypeAndStatusAndCreatorIdOrAssigneeId(Long companyId, String status, Long userId, String sortType) {
        List taskList = null;
        taskList = StringUtils.isEmpty((Object)sortType) ? (StringUtils.isEmpty((Object)companyId) ? ((TaskDao)this.dao).findByUserIdAndTaskStatusSort(userId, status) : ((TaskDao)this.dao).findByUserIdAndTaskStatusAndCompanyIdSort(userId, status, companyId)) : (StringUtils.isEmpty((Object)companyId) ? ((TaskDao)this.dao).findByUserIdAndTaskStatus(userId, status) : ((TaskDao)this.dao).findByUserIdAndTaskStatusAndCompanyId(userId, status, companyId));
        if (taskList != null) {
            for (Task task : taskList) {
                task.setAssignee(UserModel.getUserModel((User)this.userService.findById(task.getAssigneeId())));
                task.setTitle(StringEscapeUtils.unescapeJava((String)task.getTitle()));
                task.setDescription(StringEscapeUtils.unescapeJava((String)task.getDescription()));
            }
        }
        return taskList;
    }

    public void updateLoop(Long taskId, String loop) {
        ((TaskDao)this.dao).updateLoop(taskId, loop);
    }

    public Integer countByProjectIdAndUpdateDateAndDelFlagFalse(Long projectId) {
        return ((TaskDao)this.dao).countByProjectIdAndUpdateDateAndDelFlagFalse(projectId);
    }

    public Integer countByProjectIdAndStatusAndDelFlagFalse(Long projectId, String status) {
        return ((TaskDao)this.dao).countByProjectIdAndStatusAndDelFlagFalse(projectId, status);
    }

    public Integer countByProjectIdAndDelFlagFalse(Long projectId) {
        return ((TaskDao)this.dao).countByProjectIdAndDelFlagFalse(projectId);
    }

    public void updateTaskStatus(Long taskId, Task oldTask, Task newTask, String loop) {
        JSONObject loopTask;
        Object type;
        if (StringUtils.isNotBlank((String)loop) && (StringUtils.isEmpty((Object)(type = (loopTask = new JSONObject(loop)).get("type"))) || !type.toString().equals(Constants.LoopTaskType.noRepeat.getType()))) {
            newTask.setLoop(null);
            newTask.setStatus("0");
            newTask.setCreateDate(new Date());
            newTask.setUpdateDate(new Date());
            newTask.setDateDue(!StringUtils.isEmpty((Object)oldTask.getDateDue()) ? this.calculationDateDue(oldTask.getDateDue(), loopTask) : null);
            newTask.setTaskLabelRelationList(null);
            newTask = (Task)super.save((BaseEntity)newTask);
            this.updateLoop(newTask.getId(), loop);
            List taskConcerns = this.taskConcernService.findListByTaskId(taskId);
            for (TaskConcern data : taskConcerns) {
                TaskConcern taskConcern = new TaskConcern(newTask.getId(), data.getUserId(), data.getStatus(), data.getSort());
                taskConcern.setTaskStatus(data.getTaskStatus());
                this.taskConcernService.save(taskConcern);
            }
            TaskPanelRelation oldTaskPanelRelation = this.taskPanelRelationService.findByTaskId(taskId, Boolean.valueOf(false));
            if (!StringUtils.isEmpty((Object)oldTaskPanelRelation)) {
                TaskPanelRelation newTaskPanelRelation = new TaskPanelRelation(oldTaskPanelRelation.getPanelId(), newTask.getId(), oldTaskPanelRelation.getSort());
                this.taskPanelRelationService.save(newTaskPanelRelation);
            }
        }
    }

    public Map<String, Object> findByCompanyIdAndCreatorIdAndDate(Long companyId, Long userId, String date) {
        List dateList = null;
        List taskList = null;
        if (StringUtils.isEmpty((Object)companyId)) {
            dateList = ((TaskDao)this.dao).findUserMonthDateList(userId, date);
            if (dateList != null && dateList.size() > 0) {
                taskList = ((TaskDao)this.dao).findListByDate(userId, date);
            }
        } else {
            dateList = ((TaskDao)this.dao).findUserMonthDateListByCompanyId(userId, companyId, date);
            if (dateList != null && dateList.size() > 0) {
                taskList = ((TaskDao)this.dao).findListByCompanyIdAndDate(userId, companyId, date);
            }
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String dateStr : dateList) {
            ArrayList<Task> dataTaskList = new ArrayList<Task>();
            for (Task task : taskList) {
                if (!DateUtils.isSameDay((Date)DateUtils.parseDate((Object)dateStr), (Date)task.getDateStart())) continue;
                User user = this.userService.findById(task.getCreatorId());
                task.setUser(user);
                dataTaskList.add(task);
            }
            map.put(dateStr, dataTaskList);
        }
        return map;
    }

    public List<Task> findByCompanyIdAndAssigneeIdAndStatusAndDelFlagFalse(Long companyId, Long assigneeId, String status) {
        return ((TaskDao)this.dao).findByCompanyIdAndAssigneeIdAndStatusAndDelFlagFalse(companyId, assigneeId, status);
    }

    public List<Task> findByCompanyIdAndStatusAndDelFlagFalse(Long companyId, String status) {
        return ((TaskDao)this.dao).findByCompanyIdAndStatusAndDelFlagFalse(companyId, status);
    }

    public Task findByMongodbId(String mongodbId) {
        return ((TaskDao)this.dao).findByMongodbId(mongodbId);
    }

    public ResultModel<Task> updateRemind(Long taskId, String date, String languageType) throws ParseException {
        Date remindDate = StringUtils.isEmpty((Object)date) ? null : DateUtils.getDateByUnixTimestamp((Long)Long.valueOf(date));
        Task task = this.findByTaskId(taskId);
        if (StringUtils.isEmpty((Object)task)) {
            return ResultModel.error((ResultStatus)ResultStatus.TASK_NO_EXIST, (String)languageType);
        }
        task.setRemindDate(remindDate);
        task = (Task)super.save((BaseEntity)task);
        if (!StringUtils.isEmpty((Object)task.getRemindDate()) && task.getRemindDate().after(new Date())) {
            String key = Constants.SCHEDULE_TASK + task.getId();
            if (!this.redis.hasKey((Object)key).booleanValue()) {
                this.redis.boundValueOps((Object)key).set((Object)key);
                this.redis.boundValueOps((Object)key).expireAt(task.getRemindDate());
            } else {
                this.redis.boundValueOps((Object)key).expireAt(task.getRemindDate());
            }
        }
        return ResultModel.suc((Object)task, (String)languageType);
    }

    public Long findByDepartId(Long departmentId) {
        return (long)((TaskDao)this.dao).findByDepartId(departmentId);
    }

    public Long findCompete(Long departmentId) {
        return (long)((TaskDao)this.dao).findByDepartIdAndCompete(departmentId);
    }

    public Long findOverDue(Long departmentId, Date date) {
        return (long)((TaskDao)this.dao).findOverDue(departmentId, date);
    }

    public Long findByUserStatus(Long companyId, Long assigneeId, String status) {
        return (long)((TaskDao)this.dao).countByCompanyIdAndAssigneeIdAndStatusAndDelFlagFalse(companyId, assigneeId, status);
    }

    public Long findByUserStatusDate(Long companyId, Long assigneeId, String status, Date date) {
        return (long)((TaskDao)this.dao).countByCompanyIdAndAssigneeIdAndStatusAndDateDueBeforeAndDelFlagFalse(companyId, assigneeId, status, date);
    }

    public Long findByDepartIdAndAll(Long departmentId) {
        return ((TaskDao)this.dao).findByDepartIdAndAll(departmentId);
    }

    public Long countOverdueNumByProjectId(Long projectId, Date date) {
        return ((TaskDao)this.dao).countOverdueNumByProjectId(projectId, date);
    }

    public PageInfo<Task> findByWorkPage(Long companyId, String status, Long userId, Integer pageNo, Integer pageSize) {
        pageNo = StringUtils.isEmpty((Object)pageNo) ? 1 : pageNo;
        PageRequest pageable = new PageRequest(pageNo - 1, StringUtils.isEmpty((Object)pageSize) ? 10 : pageSize);
        PageInfo pageInfo = StringUtils.isEmpty((Object)companyId) ? PageInfo.fromPage((Page)((TaskDao)this.dao).findByUserIdAndTaskStatusPage(userId, status, (Pageable)pageable)) : PageInfo.fromPage((Page)((TaskDao)this.dao).findByUserIdAndTaskStatusAndCompanyIdPage(userId, status, companyId, (Pageable)pageable));
        List tasks = pageInfo.getRows();
        for (Task task : tasks) {
            task.setAssignee(UserModel.getUserModel((User)this.userService.findById(task.getAssigneeId())));
            task.setTitle(StringEscapeUtils.unescapeJava((String)task.getTitle()));
            task.setDescription(StringEscapeUtils.unescapeJava((String)task.getDescription()));
            task.setSubtaskNum(this.subtaskService.countByTaskId(task.getId()));
            task.setSubtaskCompleteNum(this.subtaskService.countByTaskIdAndStatus(task.getId(), Constants.Subtask.complete.getType()));
        }
        pageInfo.setRows(tasks);
        return pageInfo;
    }

    public ResultModel<PageInfo<Task>> findByAppProjectIdAndTaskNameLike(Integer pageNo, Integer pageSize, Long projectId, String taskName, String languageType) {
        pageNo = StringUtils.isEmpty((Object)pageNo) ? 1 : pageNo;
        PageRequest pageable = new PageRequest(pageNo - 1, StringUtils.isEmpty((Object)pageSize) ? 10 : pageSize);
        PageInfo taskPageInfo = PageInfo.fromPage((Page)((TaskDao)this.dao).findByProjectIdAndTitleLikeAndDelFlagFalseOrderByCreateDateDesc(projectId, taskName, (Pageable)pageable));
        ArrayList<Task> taskList = new ArrayList<Task>();
        for (Task task : taskPageInfo.getRows()) {
            task.setProject(null);
            task.setAssignee(UserModel.getUserModel((User)this.userService.findById(task.getAssigneeId())));
            task.setTitle(StringEscapeUtils.unescapeJava((String)task.getTitle()));
            task.setDescription(StringEscapeUtils.unescapeJava((String)task.getDescription()));
            task.setSubtaskNum(this.subtaskService.countByTaskId(task.getId()));
            task.setSubtaskCompleteNum(this.subtaskService.countByTaskIdAndStatus(task.getId(), Constants.Subtask.complete.getType()));
            taskList.add(task);
        }
        taskPageInfo.setRows(taskList);
        return ResultModel.suc((Object)taskPageInfo, (String)languageType);
    }

    public ResultModel<ProjectTaskStatisticsModel> findByTaskStatistics(Long projectId) {
        List taskStatistics = ((TaskDao)this.dao).findByTaskStatistics(projectId);
        ProjectTaskStatisticsModel taskModel = new ProjectTaskStatisticsModel();
        taskModel.setProjectId(projectId);
        for (Object[] h : taskStatistics) {
            taskModel.setYesterdayNewNum(Integer.valueOf(Integer.parseInt(h[0].toString())));
            taskModel.setYesterdayCompletedNum(Integer.valueOf(Integer.parseInt(h[1].toString())));
            taskModel.setProjectTaskNum(Integer.valueOf(Integer.parseInt(h[2].toString())));
            taskModel.setCompletedNum(Integer.valueOf(Integer.parseInt(h[3].toString())));
            taskModel.setUnfinishedNum(Integer.valueOf(Integer.parseInt(h[4].toString())));
            taskModel.setOverdueNum(Integer.valueOf(Integer.parseInt(h[5].toString())));
            taskModel.setOverdueCompletedNum(Integer.valueOf(Integer.parseInt(h[6].toString())));
        }
        BigDecimal finishRate = BigDecimal.valueOf(0L);
        if (taskModel.getProjectTaskNum() != 0) {
            finishRate = BigDecimal.valueOf(Double.valueOf(taskModel.getCompletedNum().intValue()) / (double)taskModel.getProjectTaskNum().intValue());
        }
        taskModel.setFinishRate(finishRate);
        BigDecimal overdueRate = BigDecimal.valueOf(0L);
        if (taskModel.getProjectTaskNum() != 0) {
            overdueRate = BigDecimal.valueOf(Double.valueOf(taskModel.getOverdueNum().intValue()) / (double)taskModel.getProjectTaskNum().intValue());
        }
        taskModel.setOverdueRate(overdueRate);
        return ResultModel.suc((Object)taskModel);
    }

    public Date calculationDateDue(Date oldDateDue, JSONObject loopTask) {
        Date dateDue = new Date();
        switch (loopTask.getInt("type")) {
            case 1: {
                dateDue = DateUtils.addDateNum((Date)oldDateDue, (int)1);
                break;
            }
            case 2: {
                dateDue = DateUtils.addDateWeek((Date)oldDateDue, (int)1);
                break;
            }
            case 3: {
                dateDue = DateUtils.getNextMonth((Date)oldDateDue);
                break;
            }
            case 4: {
                dateDue = DateUtils.addDateYear((Date)oldDateDue, (int)1);
                break;
            }
            case 5: {
                String week = DateUtils.getDateWeek((Date)oldDateDue);
                if (!("Fri".equals(week) || "Sat".equals(week) || "Sun".equals(week))) {
                    dateDue = DateUtils.addDateNum((Date)oldDateDue, (int)1);
                    break;
                }
                Calendar cal = Calendar.getInstance();
                cal.setTime(DateUtils.getThisWeekMonday((Date)oldDateDue));
                cal.add(5, 7);
                dateDue = cal.getTime();
                break;
            }
            case 6: {
                JSONArray info = loopTask.getJSONArray("info");
                Integer now = Constants.ZERO_INTEGER;
                Calendar calendar = Calendar.getInstance();
                calendar.setFirstDayOfWeek(2);
                calendar.setTime(oldDateDue);
                if (Constants.LoopTaskType.customWeekly.getType().equals(loopTask.getString("customType"))) {
                    now = calendar.get(7) - 1 == 0 ? 7 : calendar.get(7) - 1;
                    dateDue = this.customWeeklyDeadline(calendar, info, now);
                }
                if (!Constants.LoopTaskType.customManthly.getType().equals(loopTask.getString("customType"))) break;
                now = calendar.get(5);
                dateDue = this.customManthlyDeadline(calendar, info, now, oldDateDue);
                break;
            }
            default: {
                dateDue = null;
            }
        }
        return dateDue;
    }

    Date customWeeklyDeadline(Calendar calendar, JSONArray info, Integer now) {
        int firstArray = 0;
        boolean nextArray = true;
        int maxArray = info.length() - 1;
        int l = info.length() - 1;
        for (int i = 0; i <= l; ++i) {
            if (info.getInt(i) > now) {
                calendar.add(5, info.getInt(i) - now);
                break;
            }
            if (now < info.getInt(maxArray)) continue;
            calendar.add(5, 7);
            calendar.add(5, info.getInt(firstArray) - now);
            break;
        }
        return calendar.getTime();
    }

    Date customManthlyDeadline(Calendar calendar, JSONArray info, Integer now, Date oldDateDue) {
        int firstArray = 0;
        boolean nextArray = true;
        int maxArray = info.length() - 1;
        int l = info.length() - 1;
        for (int i = 0; i <= l; ++i) {
            if (info.getInt(i) > now) {
                calendar.add(5, info.getInt(i) - now);
                if (DateUtils.formatDate((Date)calendar.getTime(), (Object[])new Object[]{"yyyy-MM"}).equals(DateUtils.formatDate((Date)oldDateDue, (Object[])new Object[]{"yyyy-MM"}))) break;
                calendar.set(5, info.getInt(firstArray));
                break;
            }
            if (now < info.getInt(maxArray)) continue;
            calendar.set(5, info.getInt(firstArray));
            calendar.setTime(DateUtils.getNextMonth((Date)calendar.getTime()));
            break;
        }
        return calendar.getTime();
    }

    public PageInfo taskCount(String date, Long projectId, Integer pageNo, Integer pages) {
        Integer pageNoSql = StringUtils.isEmpty((Object)pageNo) ? 1 : pageNo;
        List list = new ArrayList();
        PageInfo pageInfo = new PageInfo();
        int total = 0;
        list = ((TaskDao)this.dao).taskCount(date, projectId, pageNoSql, pages);
        total = ((TaskDao)this.dao).taskStatisticsCount(projectId);
        if (list != null && list.size() > 0) {
            pageInfo.setPages((total + pages - 1) / pages);
            pageInfo.setPageNo(pageNo.intValue());
            pageInfo.setTotal((long)total);
            pageInfo.setRows(this.taskCountList(list));
        }
        return pageInfo;
    }

    public int taskStatisticsCount(Long projectId) {
        return ((TaskDao)this.dao).taskStatisticsCount(projectId);
    }

    private List<TaskCountModel> taskCountList(List<Object[]> list) {
        ArrayList<TaskCountModel> taskCountModels = new ArrayList<TaskCountModel>();
        for (int i = 0; i < list.size(); ++i) {
            Object[] objects = list.get(i);
            TaskCountModel taskCountModel = new TaskCountModel();
            taskCountModel.setName(objects[0].toString());
            taskCountModel.setNofinish(Long.valueOf(Long.parseLong(objects[1].toString())));
            taskCountModel.setFinish(Long.valueOf(Long.parseLong(objects[2].toString())));
            taskCountModel.setTaskCounts(Long.valueOf(Long.parseLong(objects[3].toString())));
            taskCountModel.setDue(BigDecimal.valueOf(Double.parseDouble(objects[4].toString())));
            taskCountModel.setDueRate(BigDecimal.valueOf(Double.parseDouble(objects[5].toString())));
            taskCountModels.add(taskCountModel);
        }
        return taskCountModels;
    }

    public List<Task> findByIdInAAndDelFlagFalse(List<Long> ids) {
        return ((TaskDao)this.dao).findByIdInAndDelFlagFalse(ids);
    }
}

