/*
 * Decompiled with CFR 0.152.
 */
package com.ym.tlifang.service.statement;

import com.alibaba.dubbo.config.annotation.Service;
import com.ym.tlifang.BaseEntity;
import com.ym.tlifang.PageInfo;
import com.ym.tlifang.company.Company;
import com.ym.tlifang.dao.statement.TaskStatisticsDao;
import com.ym.tlifang.service.AbstractBaseService;
import com.ym.tlifang.service.company.CompanyService;
import com.ym.tlifang.service.statement.TaskStatisticsService;
import com.ym.tlifang.service.user.UserService;
import com.ym.tlifang.statement.TaskStatistics;
import com.ym.tlifang.user.User;
import com.ym.tlifang.util.StringUtils;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
@Service(interfaceClass=TaskStatisticsService.class, timeout=30000, retries=-1)
public class TaskStatisticsServiceImpl
extends AbstractBaseService<TaskStatistics, TaskStatisticsDao>
implements TaskStatisticsService {
    @Autowired
    private CompanyService companyService;
    @Autowired
    private UserService userService;

    public TaskStatistics save(TaskStatistics taskStatistics) {
        return (TaskStatistics)super.save((BaseEntity)taskStatistics);
    }

    public List<TaskStatistics> findByCompanyIdAndDate(Long companyId, String date) {
        date = ((TaskStatisticsDao)this.dao).findMaxRecordTimeByCompanyIdAndDate(companyId, date + "%");
        List list = ((TaskStatisticsDao)this.dao).findByCompanyIdAndDepartmentIdIsNotNullAndUserIdIsNullAndRecordTimeAndDelFlagFalse(companyId, date);
        for (TaskStatistics taskStatistics : list) {
            Company department = this.companyService.findByDepartmentId(taskStatistics.getDepartmentId());
            if (department == null) continue;
            taskStatistics.setDepartmentName(department.getName());
        }
        return list;
    }

    public PageInfo<TaskStatistics> findMembersByCompanyIdAndDate(Long companyId, String date, Long departmentId, Integer pageNo, Integer pageSize) {
        pageNo = StringUtils.isEmpty((Object)pageNo) ? 1 : pageNo;
        PageRequest pageable = new PageRequest(pageNo - 1, StringUtils.isEmpty((Object)pageSize) ? 20 : pageSize);
        date = ((TaskStatisticsDao)this.dao).findMaxRecordTimeByCompanyIdAndDate(companyId, date + "%");
        Page page = StringUtils.isEmpty((Object)departmentId) ? ((TaskStatisticsDao)this.dao).findByCompanyIdAndRecordTimeAndUserIdIsNotNullOrderByTaskNumDesc(companyId, date, (Pageable)pageable) : ((TaskStatisticsDao)this.dao).findByCompanyIdAndDepartmentIdAndRecordTimeAndUserIdIsNotNullOrderByTaskNumDesc(companyId, departmentId, date, (Pageable)pageable);
        List list = page.getContent();
        for (TaskStatistics taskStatistics : list) {
            User user;
            Company department = this.companyService.findByDepartmentId(taskStatistics.getDepartmentId());
            if (department != null) {
                taskStatistics.setDepartmentName(department.getName());
            }
            if ((user = this.userService.findById(taskStatistics.getUserId())) == null) continue;
            taskStatistics.setUserName(user.getName());
            taskStatistics.setUserImage(user.getAvatar());
            taskStatistics.setUserSex(user.getSex());
        }
        return PageInfo.fromPage((Page)page);
    }

    public TaskStatistics findLastRecord(Long companyId, Long departmentId, String recordTime) {
        return ((TaskStatisticsDao)this.dao).findByCompanyIdAndDepartmentIdAndUserIdNullAndRecordTime(companyId, departmentId, recordTime);
    }

    public TaskStatistics findLastRecordByUser(Long companyId, Long departmentId, Long userId, String recordTime) {
        return ((TaskStatisticsDao)this.dao).findByCompanyIdAndDepartmentIdAndUserIdAndRecordTime(companyId, departmentId, userId, recordTime);
    }
}

