/*
 * Decompiled with CFR 0.152.
 */
package com.ym.tlifang.service.push.umeng;

import com.ym.tlifang.service.push.umeng.UmengNotification;
import java.util.Arrays;
import java.util.HashSet;
import org.json.JSONObject;

public abstract class IOSNotification
extends UmengNotification {
    protected static final HashSet<String> APS_KEYS = new HashSet<String>(Arrays.asList("alert", "badge", "sound", "content-available"));

    public boolean setPredefinedKeyValue(String key, Object value) throws Exception {
        if (ROOT_KEYS.contains(key)) {
            this.rootJson.put(key, value);
        } else if (APS_KEYS.contains(key)) {
            JSONObject apsJson = null;
            JSONObject payloadJson = null;
            if (this.rootJson.has("payload")) {
                payloadJson = this.rootJson.getJSONObject("payload");
            } else {
                payloadJson = new JSONObject();
                this.rootJson.put("payload", (Object)payloadJson);
            }
            if (payloadJson.has("aps")) {
                apsJson = payloadJson.getJSONObject("aps");
            } else {
                apsJson = new JSONObject();
                payloadJson.put("aps", (Object)apsJson);
            }
            apsJson.put(key, value);
        } else if (POLICY_KEYS.contains(key)) {
            JSONObject policyJson = null;
            if (this.rootJson.has("policy")) {
                policyJson = this.rootJson.getJSONObject("policy");
            } else {
                policyJson = new JSONObject();
                this.rootJson.put("policy", (Object)policyJson);
            }
            policyJson.put(key, value);
        } else {
            if (key == "payload" || key == "aps" || key == "policy") {
                throw new Exception("You don't need to set value for " + key + " , just set values for the sub keys in it.");
            }
            throw new Exception("Unknownd key: " + key);
        }
        return true;
    }

    public boolean setCustomizedField(String key, String value) throws Exception {
        JSONObject payloadJson = null;
        if (this.rootJson.has("payload")) {
            payloadJson = this.rootJson.getJSONObject("payload");
        } else {
            payloadJson = new JSONObject();
            this.rootJson.put("payload", (Object)payloadJson);
        }
        payloadJson.put(key, (Object)value);
        return true;
    }

    public void setAlert(String token) throws Exception {
        this.setPredefinedKeyValue("alert", (Object)token);
    }

    public void setAlert(String title, String subtitle, String body) throws Exception {
        JSONObject object = new JSONObject();
        object.put("title", (Object)title);
        object.put("subtitle", (Object)subtitle);
        object.put("body", (Object)body);
        this.setPredefinedKeyValue("alert", (Object)object);
    }

    public void setBadge(Integer badge) throws Exception {
        this.setPredefinedKeyValue("badge", (Object)badge);
    }

    public void setSound(String sound) throws Exception {
        this.setPredefinedKeyValue("sound", (Object)sound);
    }

    public void setContentAvailable(Integer contentAvailable) throws Exception {
        this.setPredefinedKeyValue("content-available", (Object)contentAvailable);
    }
}

