/*
 * Decompiled with CFR 0.152.
 */
package com.ym.tlifang.service.job.statement;

import com.ym.tlifang.Constants;
import com.ym.tlifang.company.Company;
import com.ym.tlifang.company.CompanyMemberInfo;
import com.ym.tlifang.company.CompanyUserRelation;
import com.ym.tlifang.service.company.CompanyMemberInfoService;
import com.ym.tlifang.service.company.CompanyService;
import com.ym.tlifang.service.company.CompanyUserRelationService;
import com.ym.tlifang.service.statement.TaskStatisticsService;
import com.ym.tlifang.service.task.TaskService;
import com.ym.tlifang.statement.TaskStatistics;
import com.ym.tlifang.util.DateUtils;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class TaskStatisticsJob {
    @Autowired
    private TaskStatisticsService taskStatisticsService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private CompanyService companyService;
    @Autowired
    private CompanyMemberInfoService companyMemberInfoService;
    @Autowired
    private CompanyUserRelationService companyUserRelationService;
    @Autowired
    private StringRedisTemplate redisTemplate;

    @Scheduled(cron="0 30 2 * * ?")
    public void count() {
        String key = "TaskScheduledLock";
        String value = "df2lian";
        if (this.redisTemplate.opsForValue().setIfAbsent((Object)key, (Object)value).booleanValue()) {
            this.redisTemplate.expire((Object)key, 10L, TimeUnit.MINUTES);
            System.out.println("\u5b9a\u65f6\u5668\u5f00\u59cb\u6267\u884c*******************");
            String lastDayStr = DateUtils.getYearMonthStr((Date)DateUtils.addDateNum((Date)new Date(), (int)-1), (String)"day");
            List companyIds = this.companyService.findCompanyIds();
            for (Long companyId : companyIds) {
                List departmentList = this.companyService.findByParentIdAndDelFlagFalse(companyId);
                TaskStatistics taskStatistics = null;
                for (Company department : departmentList) {
                    taskStatistics = this.taskStatisticsService.findLastRecord(companyId, department.getId(), lastDayStr);
                    if (taskStatistics == null) {
                        taskStatistics = new TaskStatistics();
                    }
                    taskStatistics.setRecordTime(lastDayStr);
                    taskStatistics.setOngoingNum(this.taskService.findByDepartId(department.getId()));
                    taskStatistics.setCompletedNum(this.taskService.findCompete(department.getId()));
                    taskStatistics.setOverdueNum(this.taskService.findOverDue(department.getId(), DateUtils.parseDate((Object)lastDayStr)));
                    taskStatistics.setTaskNum(Long.valueOf(taskStatistics.getCompletedNum() + taskStatistics.getOngoingNum()));
                    taskStatistics.setCompanyId(companyId);
                    taskStatistics.setDepartmentId(department.getId());
                    BigDecimal delayRate = BigDecimal.valueOf(0L);
                    if (taskStatistics.getTaskNum() != 0L) {
                        delayRate = BigDecimal.valueOf(Double.valueOf(taskStatistics.getOverdueNum().longValue()) / (double)taskStatistics.getTaskNum().longValue());
                    }
                    taskStatistics.setDelayRate(delayRate);
                    this.taskStatisticsService.save(taskStatistics);
                }
                List companyMemberInfoList = this.companyMemberInfoService.findByCompanyIdAndStatus(companyId, Constants.AuditStatus.adopt.getType());
                for (CompanyMemberInfo companyMemberInfo : companyMemberInfoList) {
                    for (Company department : departmentList) {
                        CompanyUserRelation companyUserRelation = this.companyUserRelationService.findByUserIdAndCompanyIdAndDepartmentId(companyMemberInfo.getUserId(), companyId, department.getId());
                        if (companyUserRelation == null) continue;
                        taskStatistics = this.taskStatisticsService.findLastRecordByUser(companyId, department.getId(), companyMemberInfo.getUserId(), lastDayStr);
                        if (taskStatistics == null) {
                            taskStatistics = new TaskStatistics();
                        }
                        taskStatistics.setOngoingNum(this.taskService.findByUserStatus(companyId, companyMemberInfo.getUserId(), "0"));
                        taskStatistics.setCompletedNum(this.taskService.findByUserStatus(companyId, companyMemberInfo.getUserId(), "1"));
                        taskStatistics.setOverdueNum(this.taskService.findByUserStatusDate(companyId, companyMemberInfo.getUserId(), "0", DateUtils.parseDate((Object)lastDayStr)));
                        taskStatistics.setTaskNum(Long.valueOf(taskStatistics.getCompletedNum() + taskStatistics.getOngoingNum()));
                        BigDecimal delayRate = BigDecimal.valueOf(0L);
                        if (taskStatistics.getTaskNum() != 0L) {
                            delayRate = BigDecimal.valueOf(Double.valueOf(taskStatistics.getOverdueNum().longValue()) / (double)taskStatistics.getTaskNum().longValue());
                        }
                        taskStatistics.setDelayRate(delayRate);
                        taskStatistics.setCompanyId(companyId);
                        taskStatistics.setDepartmentId(department.getId());
                        taskStatistics.setUserId(companyMemberInfo.getUserId());
                        taskStatistics.setRecordTime(lastDayStr);
                        this.taskStatisticsService.save(taskStatistics);
                    }
                }
            }
        }
    }
}

