/*
 * Decompiled with CFR 0.152.
 */
package com.ym.tlifang.service.approval;

import com.alibaba.dubbo.config.annotation.Service;
import com.ym.tlifang.BaseEntity;
import com.ym.tlifang.Constants;
import com.ym.tlifang.PageInfo;
import com.ym.tlifang.approval.ApprovalTemplate;
import com.ym.tlifang.approval.ApprovalTemplateFlow;
import com.ym.tlifang.approval.ApprovalUserApply;
import com.ym.tlifang.attendance.AttendanceClasses;
import com.ym.tlifang.attendance.AttendanceTime;
import com.ym.tlifang.attendance.AttendanceUser;
import com.ym.tlifang.attendance.AttendanceUserRecord;
import com.ym.tlifang.attendance.AttendanceWorkday;
import com.ym.tlifang.dao.approval.ApprovalUserApplyDao;
import com.ym.tlifang.model.approval.ApprovalUserApplyAll;
import com.ym.tlifang.model.approval.DealTimeModel;
import com.ym.tlifang.model.approval.LeaveModel;
import com.ym.tlifang.model.approval.StatisticsListModel;
import com.ym.tlifang.model.approval.StatisticsModel;
import com.ym.tlifang.service.AbstractBaseService;
import com.ym.tlifang.service.approval.ApprovalTemplateFlowSortService;
import com.ym.tlifang.service.approval.ApprovalTemplateService;
import com.ym.tlifang.service.approval.ApprovalUserApplyFormService;
import com.ym.tlifang.service.approval.ApprovalUserApplyService;
import com.ym.tlifang.service.attendance.AttendanceClassesService;
import com.ym.tlifang.service.attendance.AttendanceHolidaysService;
import com.ym.tlifang.service.attendance.AttendanceTimeService;
import com.ym.tlifang.service.attendance.AttendanceUserRecordService;
import com.ym.tlifang.service.attendance.AttendanceUserService;
import com.ym.tlifang.service.attendance.AttendanceWeekdayService;
import com.ym.tlifang.service.attendance.AttendanceWorkdayService;
import com.ym.tlifang.service.user.UserService;
import com.ym.tlifang.util.DateUtils;
import com.ym.tlifang.util.StringUtils;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
@Service(interfaceClass=ApprovalUserApplyService.class, timeout=30000, retries=-1)
public class ApprovalUserApplyServiceImpl
extends AbstractBaseService<ApprovalUserApply, ApprovalUserApplyDao>
implements ApprovalUserApplyService {
    @Autowired
    private ApprovalTemplateFlowSortService approvalTemplateFlowSortService;
    @Autowired
    private ApprovalTemplateService approvalTemplateService;
    @Autowired
    private AttendanceUserRecordService attendanceUserRecordService;
    @Autowired
    private AttendanceTimeService attendanceTimeService;
    @Autowired
    private AttendanceWeekdayService attendanceWeekdayService;
    @Autowired
    private AttendanceWorkdayService attendanceWorkdayService;
    @Autowired
    private AttendanceUserService attendanceUserService;
    @Autowired
    private AttendanceClassesService attendanceClassesService;
    @Autowired
    private ApprovalUserApplyFormService approvalUserApplyFormService;
    @Autowired
    private UserService userService;
    @Autowired
    private AttendanceHolidaysService attendanceHolidaysService;

    public ApprovalUserApply save(ApprovalUserApply approvalUserApply) {
        return (ApprovalUserApply)super.save((BaseEntity)approvalUserApply);
    }

    public Map findByUserIdAndCompanyIdAndType(Long userId, Long companyId, String type, Integer pageNo, Integer pageSize, String languageType) {
        pageNo = StringUtils.isEmpty((Object)pageNo) ? 1 : pageNo;
        PageRequest pageable = new PageRequest(pageNo - 1, Integer.valueOf(StringUtils.isNullToZero((Object)pageSize)).intValue());
        Page page = "1".equals(type) ? ((ApprovalUserApplyDao)this.dao).findProcessedByUserIdAndCompanyId(userId, companyId, Constants.ApplyStatus.applyDoing.getType(), Constants.ApplyStatus.applyTurnBatch.getType(), (Pageable)pageable) : ("3".equals(type) ? ((ApprovalUserApplyDao)this.dao).findAllByUserIdAndCompanyId(userId, companyId, (Pageable)pageable) : ((ApprovalUserApplyDao)this.dao).findUntreatedByUserIdAndCompanyId(userId, companyId, Constants.ApplyStatus.applyDoing.getType(), Constants.ApplyStatus.applyTurnBatch.getType(), (Pageable)pageable));
        List list = page.getContent();
        for (ApprovalUserApply apply : list) {
            List approvalTemplateFlows = this.approvalTemplateFlowSortService.findByApplyId(apply.getId());
            for (ApprovalTemplateFlow approvalTemplateFlow : approvalTemplateFlows) {
                approvalTemplateFlow.setApprovalUserApply(null);
                approvalTemplateFlow.setUser(null);
            }
            apply.setSteps(approvalTemplateFlows);
            ApprovalTemplate template = apply.getApprovalTemplate();
            if (template != null) {
                template.setApprovalTemplateFormSet(null);
                if (Constants.LanguageType.US.getName().equals(languageType) && template.getEnName() != null) {
                    template.setName(template.getEnName());
                }
            }
            apply.setApprovalTemplate(template);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("applyList", list);
        map.put("total", page.getTotalElements());
        return map;
    }

    public Map findApprovalUserIdAndCompanyIdAndType(Long userId, Long companyId, String type, Integer pageNo, Integer pageSize, String languageType) {
        pageNo = StringUtils.isEmpty((Object)pageNo) ? 1 : pageNo;
        PageRequest pageable = new PageRequest(pageNo - 1, Integer.valueOf(StringUtils.isNullToZero((Object)pageSize)).intValue());
        Page page = null;
        List allList = null;
        int total = 0;
        if ("1".equals(type)) {
            page = ((ApprovalUserApplyDao)this.dao).findApprovaledByParams(userId, companyId, Constants.ApplyStatus.applyWithdraw.getType(), Constants.ApplyStatus.applyInterrupt.getType(), (Pageable)pageable);
        } else if ("2".equals(type)) {
            page = ((ApprovalUserApplyDao)this.dao).findApprovalCopyByParams(userId, companyId, (Pageable)pageable);
        } else if ("3".equals(type)) {
            allList = ((ApprovalUserApplyDao)this.dao).findALLByParams(userId, companyId, Integer.valueOf(StringUtils.isEmpty((Object)pageNo) ? 1 : pageNo * pageSize - pageSize), pageSize);
            total = ((ApprovalUserApplyDao)this.dao).findAllCountByParams(userId, companyId);
        } else {
            page = ((ApprovalUserApplyDao)this.dao).findApprovalingByParams(userId, companyId, Constants.ApplyStatus.applyDoing.getType(), Constants.ApplyStatus.applyTurnBatch.getType(), (Pageable)pageable);
        }
        List list = new ArrayList();
        if ("3".equals(type)) {
            if (allList != null && allList.size() > 0) {
                list = this.getObjectList(allList);
            }
        } else {
            list = page.getContent();
        }
        for (ApprovalUserApply apply : list) {
            if (allList != null && allList.size() > 0) {
                apply.setUser(this.userService.findById(apply.getUserId()));
                apply.setApprovalTemplate(this.approvalTemplateService.findById(apply.getTemplateId()));
            }
            List approvalTemplateFlows = this.approvalTemplateFlowSortService.findByApplyId(apply.getId());
            for (ApprovalTemplateFlow approvalTemplateFlow : approvalTemplateFlows) {
                approvalTemplateFlow.setApprovalUserApply(null);
                approvalTemplateFlow.setUser(null);
            }
            apply.setSteps(approvalTemplateFlows);
            ApprovalTemplate template = apply.getApprovalTemplate();
            if (template != null) {
                if (Constants.LanguageType.US.getName().equals(languageType) && template.getEnName() != null) {
                    template.setName(template.getEnName());
                }
                template.setApprovalTemplateFormSet(null);
            }
            apply.setApprovalTemplate(template);
        }
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put("applyList", (Serializable)((Object)list));
        if (total > 0) {
            map.put("total", Integer.valueOf(total));
        } else {
            map.put("total", Long.valueOf(page == null ? 0L : page.getTotalElements()));
        }
        return map;
    }

    public Map findApprovalUserIdAndCompanyId(Long userId, Long companyId, Long type, Integer pageNo, Integer pageSize, String languageType) {
        pageNo = StringUtils.isEmpty((Object)pageNo) ? 1 : pageNo;
        List allList = null;
        int total = 0;
        if (type == 0L) {
            allList = ((ApprovalUserApplyDao)this.dao).findAllByZero(userId, companyId, Integer.valueOf(StringUtils.isEmpty((Object)pageNo) ? 1 : pageNo * pageSize - pageSize), pageSize);
            total = ((ApprovalUserApplyDao)this.dao).findAllByZeroCount(userId, companyId);
        } else if (type == 1L) {
            allList = ((ApprovalUserApplyDao)this.dao).findAllByOne(userId, companyId, Integer.valueOf(StringUtils.isEmpty((Object)pageNo) ? 1 : pageNo * pageSize - pageSize), pageSize);
            total = ((ApprovalUserApplyDao)this.dao).findAllByOneCount(userId, companyId);
        } else {
            allList = ((ApprovalUserApplyDao)this.dao).findAllBy(userId, companyId, Integer.valueOf(StringUtils.isEmpty((Object)pageNo) ? 1 : pageNo * pageSize - pageSize), pageSize);
            total = ((ApprovalUserApplyDao)this.dao).findAllByCount(userId, companyId);
        }
        List objectAllList = new ArrayList();
        if (allList != null && allList.size() > 0) {
            objectAllList = this.getObjectAllList(allList);
            for (ApprovalUserApplyAll applyAll : objectAllList) {
                if (applyAll.getTemplateEnglishName() == null || applyAll.getTemplateEnglishName() == null || !Constants.LanguageType.US.getName().equals(languageType) || applyAll.getTemplateEnglishName() == null) continue;
                applyAll.setTemplateName(applyAll.getTemplateEnglishName());
            }
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("applyList", objectAllList);
        map.put("total", total);
        return map;
    }

    private List<ApprovalUserApply> getObjectList(List<Object[]> list) {
        ArrayList<ApprovalUserApply> approvalUserApplies = new ArrayList<ApprovalUserApply>();
        for (int i = 0; i < list.size(); ++i) {
            Object[] objects = list.get(i);
            ApprovalUserApply approvalUserApply = new ApprovalUserApply();
            approvalUserApply.setId(Long.valueOf(objects[0].toString()));
            approvalUserApply.setUserId(Long.valueOf(objects[1].toString()));
            approvalUserApply.setTemplateId(Long.valueOf(objects[2].toString()));
            approvalUserApply.setCurrentProcessId(Long.valueOf(objects[3].toString()));
            approvalUserApply.setState(objects[4].toString());
            approvalUserApply.setContent(objects[5].toString());
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                Date dateOne = simpleDateFormat.parse(objects[6].toString());
                approvalUserApply.setCreateDate(dateOne);
                Date dateTwo = simpleDateFormat.parse(objects[7].toString());
                approvalUserApply.setUpdateDate(dateTwo);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            approvalUserApply.setDelFlag(Boolean.valueOf(Boolean.getBoolean(objects[8].toString())));
            approvalUserApplies.add(approvalUserApply);
        }
        return approvalUserApplies;
    }

    private List<ApprovalUserApplyAll> getObjectAllList(List<Object[]> allList) {
        ArrayList<ApprovalUserApplyAll> approvalUserApplyAlls = new ArrayList<ApprovalUserApplyAll>();
        for (int i = 0; i < allList.size(); ++i) {
            Object[] objects = allList.get(i);
            ApprovalUserApplyAll approvalUserApplyAll = new ApprovalUserApplyAll();
            approvalUserApplyAll.setId(Long.valueOf(objects[0].toString()));
            approvalUserApplyAll.setUserId(Long.valueOf(objects[1].toString()));
            approvalUserApplyAll.setTemplateId(Long.valueOf(objects[2].toString()));
            approvalUserApplyAll.setCurrentProcessId(Long.valueOf(objects[3].toString()));
            approvalUserApplyAll.setState(objects[4].toString());
            approvalUserApplyAll.setContent(objects[5].toString());
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                Date dateOne = simpleDateFormat.parse(objects[6].toString());
                approvalUserApplyAll.setCreateDate(dateOne);
                Date dateTwo = simpleDateFormat.parse(objects[7].toString());
                approvalUserApplyAll.setUpdateDate(dateTwo);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            approvalUserApplyAll.setDelFlag(Boolean.valueOf(Boolean.getBoolean(objects[8].toString())));
            approvalUserApplyAll.setTemplateName(objects[9].toString());
            approvalUserApplyAll.setTemplateEnglishName(objects[10] != null ? objects[10].toString() : "");
            approvalUserApplyAll.setUserName(objects[11].toString());
            approvalUserApplyAll.setAvatar(objects[12] == null ? null : objects[12].toString());
            approvalUserApplyAll.setMarking(Long.valueOf(objects[13].toString()));
            approvalUserApplyAlls.add(approvalUserApplyAll);
        }
        return approvalUserApplyAlls;
    }

    public List<ApprovalUserApply> findByUserIdAndCompanyIdAndContent(Long userId, Long companyId, String content) {
        return ((ApprovalUserApplyDao)this.dao).findByUserIdAndCompanyIdAndContentLike(userId, companyId, "%" + content + "%");
    }

    public List<ApprovalUserApply> findByTemplateId(Long templateId) {
        return ((ApprovalUserApplyDao)this.dao).findByTemplateId(templateId);
    }

    public ApprovalUserApply findByApplyId(Long applyId) {
        return ((ApprovalUserApplyDao)this.dao).findByIdAndDelFlagFalse(applyId);
    }

    public Object findMapByApplyId(Long applyId) {
        return ((ApprovalUserApplyDao)this.dao).findMapByApplyId(applyId);
    }

    public int findApprovalByParamsCount(Long userId, Long companyId, String allotState, String turnState) {
        return ((ApprovalUserApplyDao)this.dao).findApprovalByParamsCount(userId, companyId, allotState, turnState);
    }

    public void updateByApplyId(Long currentProcessId, Long applyId) {
        ((ApprovalUserApplyDao)this.dao).updateByApplyId(currentProcessId, applyId);
    }

    public void updateRecord(Long userId, Long companyId, Long applyId) {
        AttendanceClasses attendanceClasses;
        List list = this.approvalUserApplyFormService.findByApplyId(applyId, Constants.TemplateFormType.datetime.getType());
        String date = list == null || list.size() == 0 ? null : (String)list.get(0);
        Date dates = DateUtils.parseDate(date);
        AttendanceUser attendanceUser = this.attendanceUserService.findByUserIdAndDelFlagFalse(userId, companyId);
        if (!StringUtils.isEmpty((Object)attendanceUser) && (attendanceClasses = this.attendanceClassesService.findById(attendanceUser.getClassesId())).getWhetherMendSign().booleanValue() && attendanceClasses.getStatus().booleanValue()) {
            List timeList = this.attendanceWeekdayService.findByTypeTwo(attendanceUser.getClassesId(), dates);
            ArrayList<String> attendanceTimes = new ArrayList<String>();
            if (StringUtils.isEmpty((Object)timeList) || timeList.size() == 0) {
                AttendanceWorkday attendanceWorkday = this.attendanceWorkdayService.findByClassesId(attendanceUser.getClassesId(), dates);
                if (attendanceWorkday != null) {
                    List attendanceTimeList = this.attendanceTimeService.findByWorkdayIdAndDelFlagFalse(attendanceWorkday.getId());
                    for (AttendanceTime attendanceTime : attendanceTimeList) {
                        attendanceTimes.add(attendanceTime.getBegin());
                        attendanceTimes.add(attendanceTime.getEnd());
                    }
                }
            } else {
                for (Map maps : timeList) {
                    attendanceTimes.add(maps.get("begin").toString());
                    attendanceTimes.add(maps.get("end").toString());
                }
            }
            AttendanceUserRecord attendanceUserRecord = new AttendanceUserRecord();
            date = DateUtils.formatDate((Date)dates, (Object[])new Object[]{"yyyy-MM-dd"});
            attendanceUserRecord.setAttendanceDate(date);
            Integer degree = this.attendanceUserRecordService.findDegree(attendanceUser.getUserId(), attendanceUser.getCompanyId(), date);
            if (degree < attendanceTimes.size()) {
                attendanceUserRecord.setStatus("\u51c6\u65f6");
                attendanceUserRecord.setTime((String)attendanceTimes.get(degree));
                if (attendanceTimes.size() - degree == 1) {
                    attendanceUserRecord.setNextType("2");
                    Integer times = this.attendanceUserRecordService.findSuccessTime(attendanceUser.getUserId(), date, attendanceUser.getCompanyId());
                    if (times.equals(degree)) {
                        attendanceUserRecord.setStatus("\u51fa\u52e4");
                    }
                } else {
                    attendanceUserRecord.setNextType(degree % 2 == 0 ? "0" : "1");
                }
                attendanceUserRecord.setSignResult("0");
                attendanceUserRecord.setCompanyId(attendanceUser.getCompanyId());
                attendanceUserRecord.setUserId(attendanceUser.getUserId());
                this.attendanceUserRecordService.save(attendanceUserRecord);
            }
        }
    }

    public PageInfo<StatisticsListModel> findByStatisticsList(StatisticsModel statisticsModel, Long companyId) throws ParseException {
        int pageNo = StringUtils.isEmpty((Object)statisticsModel.getPageNo()) ? 1 : statisticsModel.getPageNo();
        PageRequest pageable = new PageRequest(statisticsModel.getPageNo() - 1, Integer.valueOf(StringUtils.isNullToZero((Object)statisticsModel.getPageSize())).intValue());
        PageInfo listModels = new PageInfo();
        PageInfo pageInfo = null;
        if (StringUtils.isEmpty((Object)statisticsModel.getUserId()) && StringUtils.isEmpty((Object)statisticsModel.getBeginTime()) && StringUtils.isEmpty((Object)statisticsModel.getEndTime())) {
            pageInfo = PageInfo.fromPage((Page)((ApprovalUserApplyDao)this.dao).findByTemplateIdAndState(companyId, Constants.ApplyStatus.applyThrough.getType(), (Pageable)pageable));
        }
        if (statisticsModel.getEndTime() != null && statisticsModel.getBeginTime() != null && statisticsModel.getUserId() == null) {
            pageInfo = PageInfo.fromPage((Page)((ApprovalUserApplyDao)this.dao).findByTemplateIdAndStateAndDate(companyId, Constants.ApplyStatus.applyThrough.getType(), statisticsModel.getBeginTime(), statisticsModel.getEndTime(), (Pageable)pageable));
        }
        if (!StringUtils.isEmpty((Object)statisticsModel.getUserId()) && statisticsModel.getBeginTime() == null && statisticsModel.getEndTime() == null) {
            pageInfo = PageInfo.fromPage((Page)((ApprovalUserApplyDao)this.dao).findByTemplateIdAndStateAndUserId(companyId, Constants.ApplyStatus.applyThrough.getType(), statisticsModel.getUserId(), (Pageable)pageable));
        }
        if (!StringUtils.isEmpty((Object)statisticsModel.getUserId()) && statisticsModel.getBeginTime() != null && statisticsModel.getEndTime() != null) {
            pageInfo = PageInfo.fromPage((Page)((ApprovalUserApplyDao)this.dao).findByTemplateIdAndStateAndUserIdAndTime(companyId, Constants.ApplyStatus.applyThrough.getType(), statisticsModel.getUserId(), statisticsModel.getBeginTime(), statisticsModel.getEndTime(), (Pageable)pageable));
        }
        if (pageInfo == null) {
            return listModels;
        }
        List list = pageInfo.getRows();
        ArrayList<StatisticsListModel> models = new ArrayList<StatisticsListModel>();
        for (ApprovalUserApply approvalUserApply : list) {
            StatisticsListModel statisticsListModel = new StatisticsListModel(approvalUserApply.getId(), approvalUserApply.getUserId(), approvalUserApply.getUser().getName(), approvalUserApply.getUser().getAvatar(), approvalUserApply.getState(), approvalUserApply.getApprovalTemplate().getName(), approvalUserApply.getContent(), approvalUserApply.getCreateDate());
            models.add(statisticsListModel);
        }
        listModels.setRows(models);
        listModels.setPages(pageInfo.getPages());
        listModels.setPageNo(pageInfo.getPageNo());
        listModels.setTotal(pageInfo.getTotal());
        return listModels;
    }

    public Double findTime(String timeOne, String timeTwo, Long userId, Long companyId) {
        LeaveModel leaveModel = new LeaveModel();
        leaveModel.setStart(DateUtils.parseDate((Object)timeOne));
        leaveModel.setEnd(DateUtils.parseDate((Object)timeTwo));
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        AttendanceUser attendanceUser = this.attendanceUserService.findByUserIdAndDelFlagFalse(userId, companyId);
        if (attendanceUser == null) {
            return 0.0;
        }
        AttendanceClasses attendanceClasses = this.attendanceClassesService.findByIdAndStatusTrue(attendanceUser.getClassesId());
        if (attendanceClasses == null) {
            return 0.0;
        }
        List attendanceHolidays = null;
        if (attendanceClasses.getLegal().booleanValue()) {
            attendanceHolidays = this.attendanceHolidaysService.findHolidays();
        }
        List attendanceWeekdays = this.attendanceWeekdayService.findByClassId(attendanceClasses.getId(), this.addDateNum(leaveModel.getStart(), -1));
        Map allWorkDay = this.attendanceWorkdayService.getAllWorkDay(attendanceClasses.getId());
        List dealTimeModels = this.deal(leaveModel);
        long minute = 0L;
        for (DealTimeModel dealTimeModel : dealTimeModels) {
            List attendanceTimes = this.attendanceUserRecordService.getAttendanceTime(DateUtils.parseDate((Object)dealTimeModel.getDay()), attendanceClasses, attendanceHolidays, attendanceWeekdays, allWorkDay);
            if (attendanceTimes == null) continue;
            for (AttendanceTime timeModel : attendanceTimes) {
                String end;
                String start = dealTimeModel.getStartTime().compareTo(timeModel.getBegin()) > 0 ? dealTimeModel.getStartTime() : timeModel.getBegin();
                if (start.compareTo(end = dealTimeModel.getEndTime().compareTo(timeModel.getEnd()) > 0 ? timeModel.getEnd() : dealTimeModel.getEndTime()) >= 0) continue;
                try {
                    minute += (simpleDateFormat.parse(dealTimeModel.getDay() + " " + end).getTime() - simpleDateFormat.parse(dealTimeModel.getDay() + " " + start).getTime()) / 60000L;
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
        }
        return (double)minute / 60.0;
    }

    public List<DealTimeModel> deal(LeaveModel leaveModel) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat simpleDateFormatTwo = new SimpleDateFormat("HH:mm");
        Date date = leaveModel.getStart();
        ArrayList<DealTimeModel> dealTimeModels = new ArrayList<DealTimeModel>();
        int days = 0;
        try {
            days = (int)((simpleDateFormat.parse(simpleDateFormat.format(leaveModel.getEnd())).getTime() - simpleDateFormat.parse(simpleDateFormat.format(leaveModel.getStart())).getTime()) / 86400000L);
            for (int i = 0; i <= days; ++i) {
                DealTimeModel dealTimeModel = new DealTimeModel();
                dealTimeModel.setStartTime("00:00");
                dealTimeModel.setEndTime("24:00");
                if (i == 0) {
                    dealTimeModel.setStartTime(simpleDateFormatTwo.format(leaveModel.getStart()));
                }
                if (i == days) {
                    dealTimeModel.setEndTime(simpleDateFormatTwo.format(leaveModel.getEnd()));
                }
                dealTimeModel.setDay(simpleDateFormat.format(date));
                date = this.addDateNum(date, 1);
                dealTimeModels.add(dealTimeModel);
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return dealTimeModels;
    }

    public Date addDateNum(Date date, int num) {
        GregorianCalendar ca = new GregorianCalendar();
        ca.setTime(date);
        ((Calendar)ca).add(5, num);
        date = ca.getTime();
        return date;
    }
}

