/*
 * Decompiled with CFR 0.152.
 */
package com.ym.tlifang.dao.meeting;

import com.ym.tlifang.dao.BaseDao;
import com.ym.tlifang.meeting.MeetingEntity;
import java.util.Date;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface MeetingDao
extends BaseDao<MeetingEntity> {
    public MeetingEntity findByIdAndDelFlag(Long var1, Boolean var2);

    public MeetingEntity findByIdAndDelFlagIsFalse(Long var1);

    public Page<MeetingEntity> findByCompanyIdAndDelFlagOrderByCreateDateDesc(Long var1, Boolean var2, Pageable var3);

    @Query(value="select  DISTINCT DATE_FORMAT(tm.begin_time,'%Y-%m-%d')  from tlf_meeting_member tmm  LEFT JOIN tlf_meeting tm on tm.id = tmm.meeting_id where tmm.company_id = :companyId and tmm.member_id = :memberId and tmm.del_flag = 0 and tm.del_flag = 0 and  date_format(tm.begin_time,'%Y-%m')=date_format(:monthStr,'%Y-%m')", nativeQuery=true)
    public List<Object> findUserMonthDateList(@Param(value="companyId") Long var1, @Param(value="memberId") Long var2, @Param(value="monthStr") String var3);

    @Query(value="select tm.id, tm.company_id, tm.initiator_id, tm.begin_time, tm.end_time, tm.create_date, tu.name, tu.avatar, tm.title from tlf_meeting_member tmm LEFT JOIN tlf_meeting tm on tm.id = tmm.meeting_id LEFT JOIN tlf_user tu on tu.id = tm.Initiator_id where tmm.company_id = :companyId and tmm.member_id = :memberId and tmm.del_flag = 0 and tm.del_flag = 0 and  date_format(tm.begin_time,'%Y-%m')=date_format(:monthStr,'%Y-%m')", nativeQuery=true)
    public List<Object> findUserMonthMeetingList(@Param(value="companyId") Long var1, @Param(value="memberId") Long var2, @Param(value="monthStr") String var3);

    public List<MeetingEntity> findByCompanyIdAndMeetingRoomIdAndLoopSignNotAndDelFlagFalseAndEndTimeGreaterThan(Long var1, Long var2, String var3, Date var4);

    public List<MeetingEntity> findByCompanyIdAndMeetingRoomIdAndDelFlagFalseAndEndTimeGreaterThanEqual(Long var1, Long var2, Date var3);

    @Query(value="select id, type, meetingId, userId, name, url, mimetype, content, createDate from(select id, '1' as type, key_id as meetingId ,create_by as userId,   name,  url,  mimetype, '' as content, create_date as createDate, size from tlf_enclosure where type = 2 union select id, '2' as type, meeting_id as meetingId, user_id as userId, '' as name, '' as url, '' as mimetype, content, create_date as createDate, ''as size from tlf_meeting_discuss ) a where meetingId = :meetingId ORDER BY createDate desc", nativeQuery=true)
    public List<Object[]> getMeetingDynamic(@Param(value="meetingId") Long var1);

    @Query(value="select  count(1)  from tlf_meeting_member tmm  LEFT JOIN tlf_meeting tm on tm.id = tmm.meeting_id where tmm.company_id = :companyId and tmm.member_id = :memberId and tmm.del_flag = 0 and tm.del_flag = 0", nativeQuery=true)
    public int getMemberCompanyMeetingCount(@Param(value="companyId") Long var1, @Param(value="memberId") Long var2);
}

