/*
 * Decompiled with CFR 0.152.
 */
package com.ym.tlifang.api.controller.wechat;

import com.alibaba.dubbo.config.annotation.Reference;
import com.github.binarywang.java.emoji.EmojiConverter;
import com.ym.tlifang.Constants;
import com.ym.tlifang.ResultModel;
import com.ym.tlifang.ResultStatus;
import com.ym.tlifang.api.authorization.annotation.LanguageType;
import com.ym.tlifang.api.config.weChatConfig;
import com.ym.tlifang.api.controller.BaseController;
import com.ym.tlifang.model.user.LoginModel;
import com.ym.tlifang.service.user.UserService;
import com.ym.tlifang.service.wechat.ThirdUserService;
import com.ym.tlifang.user.TokenModel;
import com.ym.tlifang.user.User;
import com.ym.tlifang.util.HttpUtils;
import com.ym.tlifang.util.IpUtil;
import com.ym.tlifang.util.JsonUtil;
import com.ym.tlifang.util.PasswordEncoder;
import com.ym.tlifang.util.StringUtils;
import com.ym.tlifang.wechat.ThirdUser;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.binary.Base64;
import org.apache.poi.ss.formula.functions.T;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(value={"wechat"})
@Api(value="wechat", description="\u5fae\u4fe1\u767b\u5f55\u76f8\u5173")
public class ThirdUserController
extends BaseController {
    @Reference
    private ThirdUserService thirdUserService;
    @Autowired
    private weChatConfig chatConfig;
    @Autowired
    private StringRedisTemplate redis;
    @Reference
    private UserService userService;
    @Autowired
    private static EmojiConverter emojiConverter = EmojiConverter.getInstance();
    public static boolean initialized = false;

    @GetMapping(value={"/mini/get"})
    @ApiOperation(value="\u8bf7\u6c42\u63a5\u53e3(\u5c0f\u7a0b\u5e8f)")
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @ApiImplicitParams(value={@ApiImplicitParam(name="code", value="\u5fae\u4fe1code", required=true, dataType="string", paramType="query"), @ApiImplicitParam(name="state", value="\u5f53\u524d\u9875\u9762", required=true, dataType="string", paramType="query"), @ApiImplicitParam(name="encryptedData", value="\u52a0\u5bc6\u6570\u636e\u5305", required=true, dataType="string", paramType="query"), @ApiImplicitParam(name="iv", value="\u504f\u79fb\u91cf", required=true, dataType="string", paramType="query")})
    public ResultModel<T> miniCallBackUrl(@LanguageType String languageType, String code, String state, String encryptedData, String iv, HttpServletRequest request) throws IOException, InvalidAlgorithmParameterException {
        if (StringUtils.isEmpty((Object)code)) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        String openMiniUrl = String.format("https://api.weixin.qq.com/sns/jscode2session?appid=%s&secret=%s&js_code=%s&grant_type=authorization_code", this.chatConfig.getMiniwxOpenAppid(), this.chatConfig.getMiniwxOpenAppsecret(), code);
        String wechatUserInfo = HttpUtils.get((String)openMiniUrl);
        Map wechatUserMap = (Map)JsonUtil.jackson.readValue(wechatUserInfo, Map.class);
        String result = ThirdUserController.decrypt((String)encryptedData, (String)String.valueOf(wechatUserMap.get("session_key")), (String)iv, (String)"UTF-8");
        if (StringUtils.isEmpty((Object)result)) {
            return ResultModel.error((ResultStatus)ResultStatus.WXUSER_ERROR, (String)languageType);
        }
        Map userMap = (Map)JsonUtil.jackson.readValue(result, Map.class);
        ThirdUser thirdUser = this.thirdUserService.findByUnionIdAndTypeAndDelFlagFalse(String.valueOf(userMap.get("unionId")), Constants.ThirdUserType.wechat.getType());
        if (StringUtils.isEmpty((Object)thirdUser)) {
            TokenModel tokenModel = new TokenModel();
            thirdUser = new ThirdUser(String.valueOf(userMap.get("openId")), String.valueOf(userMap.get("unionId")), emojiConverter.toUnicode(String.valueOf(userMap.get("nickName"))), String.valueOf(userMap.get("avatarUrl")), String.valueOf(userMap.get("country")), null, String.valueOf(wechatUserMap.get("city")), state, Constants.ThirdUserType.wechat.getType(), Boolean.FALSE, String.valueOf(wechatUserMap.get("language")), String.valueOf(wechatUserMap.get("province")));
            tokenModel.setThirdUser(thirdUser);
            return ResultModel.suc((Object)tokenModel);
        }
        User user = this.userService.findById(Long.valueOf(thirdUser.getUserId()));
        if (StringUtils.isEmpty((Object)user)) {
            return ResultModel.error((ResultStatus)ResultStatus.ACCOUNT_NO_EXIST, (String)languageType);
        }
        LoginModel userModel = new LoginModel(user.getMobile(), null);
        thirdUser.setCurrentPage(state);
        thirdUser.setSessionKey(String.valueOf(wechatUserMap.get("session_key")));
        thirdUser.setBundling(Boolean.TRUE);
        thirdUser.setName(emojiConverter.toUnicode(thirdUser.getName()));
        return this.userService.loginUser(userModel, thirdUser, request.getHeader("platform"), IpUtil.getIpAddr((HttpServletRequest)request), user.getPushToken(), languageType);
    }

    @PostMapping(value={"/add"})
    @ApiOperation(value="\u7ed1\u5b9a\u7528\u6237")
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @ApiImplicitParams(value={})
    public ResultModel<T> addUser(@LanguageType String languageType, @RequestBody ThirdUser thirdUser, HttpServletRequest request) throws IOException {
        if (StringUtils.isEmpty((Object)thirdUser.getMobile()) || StringUtils.isEmpty((Object)thirdUser) || StringUtils.isEmpty((Object)thirdUser.getOpenId()) || StringUtils.isEmpty((Object)thirdUser.getUnionId()) || StringUtils.isEmpty((Object)thirdUser.getSmsCode()) || StringUtils.isEmpty((Object)thirdUser.getName())) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        ResultModel resultModel = this.userService.checkSmsCode(thirdUser.getSmsCode(), Constants.SmsType.wechatmobileRebind.getTypeId(), thirdUser.getMobile(), languageType);
        if (resultModel != null) {
            return resultModel;
        }
        User user = this.userService.findByMobile(thirdUser.getMobile());
        if (StringUtils.isEmpty((Object)user)) {
            return ResultModel.error((ResultStatus)ResultStatus.ACCOUNT_NO_EXIST, (String)languageType);
        }
        if (this.thirdUserService.countByUserIdAndDelFlagFalse(user.getId()).booleanValue()) {
            return ResultModel.error((ResultStatus)ResultStatus.ACCOUNT_ALREAD_BIND, (String)languageType);
        }
        if (thirdUser.getPassWord() != null && thirdUser != null) {
            String encryptPassword = PasswordEncoder.encrypt((String)thirdUser.getPassWord(), (String)"ym2018");
            if (!user.getPassword().equals(encryptPassword)) {
                return ResultModel.error((ResultStatus)ResultStatus.PASSWORD_ERROR, (String)languageType);
            }
        }
        thirdUser.setUserId(user.getId());
        thirdUser.setType(Constants.ThirdUserType.wechat.getType());
        thirdUser.setBundling(Boolean.TRUE);
        thirdUser.setName(emojiConverter.toAlias(thirdUser.getName()));
        thirdUser = this.thirdUserService.save(thirdUser);
        LoginModel userModel = new LoginModel(user.getMobile(), null);
        thirdUser.setCurrentPage(thirdUser.getCurrentPage());
        thirdUser.setName(emojiConverter.toUnicode(thirdUser.getName()));
        return this.userService.loginUser(userModel, thirdUser, request.getHeader("platform"), IpUtil.getIpAddr((HttpServletRequest)request), null, languageType);
    }

    public static String decrypt(String encryptedData, String sessionKey, String iv, String encodingFormat) throws InvalidAlgorithmParameterException {
        ThirdUserController.initialize();
        Base64 base64 = new Base64();
        String data = encryptedData.replaceAll(" ", "+");
        String ivstr = iv.replaceAll(" ", "+");
        byte[] dataByte = base64.decode(data);
        byte[] keyByte = base64.decode(sessionKey);
        byte[] ivByte = base64.decode(ivstr);
        int base = 16;
        if (keyByte.length % base != 0) {
            int groups = keyByte.length / base + (keyByte.length % base != 0 ? 1 : 0);
            byte[] temp = new byte[groups * base];
            Arrays.fill(temp, (byte)0);
            System.arraycopy(keyByte, 0, temp, 0, keyByte.length);
            keyByte = temp;
        }
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS7Padding");
            SecretKeySpec sKeySpec = new SecretKeySpec(keyByte, "AES");
            cipher.init(2, (Key)sKeySpec, ThirdUserController.generateIV((byte[])ivByte));
            byte[] resultbyte = cipher.doFinal(dataByte);
            if (null != resultbyte && resultbyte.length > 0) {
                String result = new String(resultbyte, encodingFormat);
                return result;
            }
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (NoSuchPaddingException e) {
            e.printStackTrace();
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        catch (IllegalBlockSizeException e) {
            e.printStackTrace();
        }
        catch (BadPaddingException e) {
            e.printStackTrace();
        }
        catch (NoSuchProviderException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void initialize() {
        if (initialized) {
            return;
        }
        Security.addProvider((Provider)new BouncyCastleProvider());
        initialized = true;
    }

    public static AlgorithmParameters generateIV(byte[] iv) throws Exception {
        AlgorithmParameters params = AlgorithmParameters.getInstance("AES");
        params.init(new IvParameterSpec(iv));
        return params;
    }
}

