/*
 * Decompiled with CFR 0.152.
 */
package com.ym.tlifang.api.controller.task;

import com.alibaba.dubbo.config.annotation.Reference;
import com.ym.tlifang.Constants;
import com.ym.tlifang.ResultModel;
import com.ym.tlifang.ResultStatus;
import com.ym.tlifang.api.authorization.annotation.Authorization;
import com.ym.tlifang.api.authorization.annotation.LanguageType;
import com.ym.tlifang.api.controller.BaseController;
import com.ym.tlifang.project.ProjectTaskLabel;
import com.ym.tlifang.service.project.ProjectTaskLabelService;
import com.ym.tlifang.service.task.TaskLabelRelationService;
import com.ym.tlifang.service.task.TaskService;
import com.ym.tlifang.task.Task;
import com.ym.tlifang.task.TaskLabelRelation;
import com.ym.tlifang.util.StringUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"taskLabels"})
@Api(value="taskLabels", description="\u4efb\u52a1\u6807\u7b7e")
public class TaskLabelController
extends BaseController {
    @Reference
    private TaskService taskService;
    @Reference
    private TaskLabelRelationService taskLabelRelationService;
    @Reference
    private ProjectTaskLabelService projectTaskLabelService;

    @PostMapping(value={"/{taskId}/projectLabel/{tagsId}"})
    @ApiOperation(value="\u6dfb\u52a0\u4efb\u52a1\u6807\u7b7e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<TaskLabelRelation> addTaskLabel(@LanguageType String languageType, @PathVariable Long taskId, @PathVariable Long tagsId) {
        if (StringUtils.isEmpty((Object)taskId) || StringUtils.isEmpty((Object)tagsId)) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        Task task = this.taskService.findByTaskId(taskId);
        if (task == null) {
            return ResultModel.error((ResultStatus)ResultStatus.TASK_NO_EXIST, (String)languageType);
        }
        if (Constants.TaskType.taskComplete.getType().equals(task.getStatus())) {
            return ResultModel.error((ResultStatus)ResultStatus.TASK_NOT_MODIFY, (String)languageType);
        }
        ProjectTaskLabel projectTaskLabel = this.projectTaskLabelService.findById(tagsId);
        if (projectTaskLabel == null) {
            return ResultModel.error((ResultStatus)ResultStatus.PROJECT_LABEL_NO_EXIST, (String)languageType);
        }
        String taskLabelRelationId = this.taskLabelRelationService.findIdByTaskIdAndTagsIdAndDelFlag(taskId, tagsId, Boolean.valueOf(false));
        if (StringUtils.isNotBlank((String)taskLabelRelationId)) {
            return ResultModel.error((ResultStatus)ResultStatus.TASK_LABEL_RELATION_EXIST, (String)languageType);
        }
        TaskLabelRelation taskLabelRelation = new TaskLabelRelation();
        taskLabelRelationId = this.taskLabelRelationService.findIdByTaskIdAndTagsIdAndDelFlag(taskId, tagsId, Boolean.valueOf(true));
        if (StringUtils.isEmpty((Object)taskLabelRelationId)) {
            taskLabelRelation.setTaskId(taskId);
            taskLabelRelation.setTagsId(tagsId);
            taskLabelRelation = this.taskLabelRelationService.save(taskLabelRelation);
        } else {
            taskLabelRelation.setTaskId(taskId);
            taskLabelRelation.setTagsId(tagsId);
            taskLabelRelation.setDelFlag(Boolean.valueOf(false));
            this.taskLabelRelationService.updateById(Long.valueOf(taskLabelRelationId), Boolean.valueOf(false));
        }
        taskLabelRelation.setProjectTaskLabel(this.projectTaskLabelService.findById(tagsId));
        return ResultModel.suc((Object)taskLabelRelation, (String)languageType);
    }

    @DeleteMapping(value={"/{taskId}/projectLabel/{tagsId}"})
    @ApiOperation(value="\u79fb\u9664\u4efb\u52a1\u6807\u7b7e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel deleteTaskLabel(@LanguageType String languageType, @PathVariable Long taskId, @PathVariable Long tagsId) {
        if (StringUtils.isEmpty((Object)taskId) || StringUtils.isEmpty((Object)tagsId)) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        if (Constants.TaskType.taskComplete.getType().equals(this.taskService.findOne(taskId).getStatus())) {
            return ResultModel.error((ResultStatus)ResultStatus.TASK_NOT_MODIFY, (String)languageType);
        }
        String taskLabelRelationId = this.taskLabelRelationService.findIdByTaskIdAndTagsIdAndDelFlag(taskId, tagsId, Boolean.valueOf(false));
        if (StringUtils.isEmpty((Object)taskLabelRelationId)) {
            return ResultModel.error((ResultStatus)ResultStatus.TASK_LABEL_RELATION_NO_EXIST, (String)languageType);
        }
        this.taskLabelRelationService.updateById(Long.valueOf(taskLabelRelationId), Boolean.valueOf(true));
        return ResultModel.ok((String)languageType);
    }
}

