/*
 * Decompiled with CFR 0.152.
 */
package com.ym.tlifang.api.controller.meeting;

import com.alibaba.dubbo.config.annotation.Reference;
import com.ym.tlifang.ResultModel;
import com.ym.tlifang.ResultStatus;
import com.ym.tlifang.api.authorization.annotation.Authorization;
import com.ym.tlifang.api.authorization.annotation.CurrentUser;
import com.ym.tlifang.api.authorization.annotation.LanguageType;
import com.ym.tlifang.api.controller.BaseController;
import com.ym.tlifang.meeting.MeetingEntity;
import com.ym.tlifang.model.meeting.MeetingDynamicModel;
import com.ym.tlifang.model.meeting.ValidateMeetingRoomTimeModel;
import com.ym.tlifang.service.meeting.MeetingService;
import com.ym.tlifang.service.push.XgPushService;
import com.ym.tlifang.service.user.UserService;
import com.ym.tlifang.user.User;
import com.ym.tlifang.util.DateUtils;
import com.ym.tlifang.util.StringUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"meeting"})
@Api(value="meeting", description="\u4f1a\u8bae")
public class MeetingController
extends BaseController {
    @Reference
    MeetingService meetingService;
    @Reference
    private UserService userService;
    @Reference
    private XgPushService xgPushService;
    @Autowired
    private StringRedisTemplate redis;

    @PostMapping
    @ApiOperation(value="\u65b0\u589e\u4f1a\u8bae")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<MeetingEntity> addMeeting(@LanguageType String languageType, @RequestBody MeetingEntity meetingEntity, @CurrentUser User currentUser) {
        if (StringUtils.isEmpty((Object)meetingEntity) || StringUtils.isEmpty((Object)meetingEntity.getTitle()) || StringUtils.isEmpty((Object)meetingEntity.getCompanyId()) || StringUtils.isEmpty((Object)meetingEntity.getBeginTime()) || StringUtils.isEmpty((Object)meetingEntity.getEndTime()) || StringUtils.isEmpty((Object)meetingEntity.getContent()) || StringUtils.isEmpty((Object)meetingEntity.getMeetingRoomId()) || StringUtils.isEmpty((Object)meetingEntity.getMemberIds()) || StringUtils.isEmpty((Object)meetingEntity.getLoopSign())) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        int dateCompareFlag = DateUtils.compareDate((Date)new Date(), (Date)meetingEntity.getBeginTime());
        if (dateCompareFlag != -1) {
            return ResultModel.error((ResultStatus)ResultStatus.MEETING_BEGINTIME_NEWTIME_COMPARE, (String)languageType);
        }
        int dateFlag = DateUtils.compareDate((Date)meetingEntity.getBeginTime(), (Date)meetingEntity.getEndTime());
        if (dateFlag != -1) {
            return ResultModel.error((ResultStatus)ResultStatus.MEETING_BEGINTIME_COMPARE_ENDTIME, (String)languageType);
        }
        ResultModel resultModel = this.meetingService.validateMeetingRoomTime(null, meetingEntity.getCompanyId(), meetingEntity.getMeetingRoomId(), meetingEntity.getBeginTime(), meetingEntity.getEndTime(), languageType);
        if (resultModel.getStatus() != 200) {
            return resultModel;
        }
        meetingEntity.setInitiatorId(currentUser.getId());
        meetingEntity.setUpdateBy(currentUser.getId());
        meetingEntity.setCreateBy(currentUser.getId());
        return ResultModel.suc((Object)this.meetingService.saveMeeting(meetingEntity), (String)languageType);
    }

    @PutMapping
    @ApiOperation(value="\u4fee\u6539\u4f1a\u8bae")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel updateMeeting(@LanguageType String languageType, @RequestBody MeetingEntity meetingEntity, @CurrentUser User currentUser) {
        if (StringUtils.isEmpty((Object)meetingEntity) || StringUtils.isEmpty((Object)meetingEntity.getTitle()) || StringUtils.isEmpty((Object)meetingEntity.getBeginTime()) || StringUtils.isEmpty((Object)meetingEntity.getEndTime()) || StringUtils.isEmpty((Object)meetingEntity.getAddress()) || StringUtils.isEmpty((Object)meetingEntity.getContent()) || StringUtils.isEmpty((Object)meetingEntity.getLoopSign()) || StringUtils.isEmpty((Object)meetingEntity.getMeetingRoomId())) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        int dateFlag = DateUtils.compareDate((Date)meetingEntity.getBeginTime(), (Date)meetingEntity.getEndTime());
        if (dateFlag != -1) {
            return ResultModel.error((ResultStatus)ResultStatus.MEETING_BEGINTIME_COMPARE_ENDTIME, (String)languageType);
        }
        MeetingEntity oldMeeting = this.meetingService.findByMeetingId(meetingEntity.getId());
        if (!Objects.equals(oldMeeting.getInitiatorId(), currentUser.getId())) {
            return ResultModel.error((ResultStatus)ResultStatus.MEETING_SPONSOR_UPDATE, (String)languageType);
        }
        if (DateUtils.compareDate((Date)oldMeeting.getEndTime(), (Date)new Date()) < 0 && !meetingEntity.getLoopSign().equals(oldMeeting.getLoopSign())) {
            return ResultModel.error((ResultStatus)ResultStatus.MEETING_TIME_NOT_UPDATE_LOOP, (String)languageType);
        }
        ResultModel resultModel = this.meetingService.validateMeetingRoomTime(meetingEntity.getId(), meetingEntity.getCompanyId(), meetingEntity.getMeetingRoomId(), meetingEntity.getBeginTime(), meetingEntity.getEndTime(), languageType);
        if (resultModel.getStatus() != 200) {
            return resultModel;
        }
        meetingEntity.setUpdateBy(currentUser.getId());
        return ResultModel.suc((Object)this.meetingService.updateMeeting(meetingEntity), (String)languageType);
    }

    @GetMapping
    @ApiOperation(value="\u4f1a\u8bae\u8be6\u60c5\u57fa\u7840\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body"), @ApiImplicitParam(name="meetingId", value="\u4f1a\u8baeid", required=true, dataType="long", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel get(@LanguageType String languageType, Long meetingId) {
        if (StringUtils.isEmpty((Object)meetingId)) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        return ResultModel.suc((Object)this.meetingService.findById(meetingId), (String)languageType);
    }

    @GetMapping(value={"/getList"})
    @ApiOperation(value="\u516c\u53f8\u4f1a\u8bae\u5217\u8868-\u6682\u65f6\u65e0\u7528")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body"), @ApiImplicitParam(name="companyId", value="\u516c\u53f8id", required=true, dataType="long", paramType="query"), @ApiImplicitParam(name="pageNo", value="\u5206\u9875\u9875\u7801", required=true, dataType="Integer", paramType="query"), @ApiImplicitParam(name="pages", value="\u5206\u9875\u6761\u6570", required=true, dataType="Integer", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel getList(@LanguageType String languageType, Long companyId, Integer pageNo, Integer pages) {
        if (StringUtils.isEmpty((Object)companyId)) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        return ResultModel.suc((Object)this.meetingService.findByCompanyIdDesc(companyId, pageNo, pages), (String)languageType);
    }

    @GetMapping(value={"/findUserMonthMeetingList"})
    @ApiOperation(value="\u83b7\u53d6\u516c\u53f8\u548c\u6211\u76f8\u5173\u7684\u4f1a\u8bae\u65e5\u7a0b")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body"), @ApiImplicitParam(name="companyId", value="\u516c\u53f8id", required=true, dataType="Long", paramType="query"), @ApiImplicitParam(name="memberId", value="\u7528\u6237id", required=true, dataType="Long", paramType="query"), @ApiImplicitParam(name="monthStr", value="\u6708\u4efd\u5b57\u7b26\u4e32\uff08eg:2018-04-01\u5c31\u662f\u67e5\u8be2\u56db\u6708\u4efd\u7684\u6570\u636e\uff09", required=true, dataType="Long", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<MeetingEntity> findUserCurrentMonthMeetingList(@LanguageType String languageType, Long companyId, Long memberId, String monthStr) {
        if (companyId == null || memberId == null) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        return ResultModel.suc((Object)this.meetingService.findUserMonthMeetingList(companyId, memberId, monthStr), (String)languageType);
    }

    @PostMapping(value={"/validateMeetingRoomTime"})
    @ApiOperation(value="\u9a8c\u8bc1\u4f1a\u8bae\u5ba4\u65f6\u95f4")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel validateMeetingRoomTime(@LanguageType String languageType, @RequestBody ValidateMeetingRoomTimeModel model) {
        if (model == null || model.getCompanyId() == null || model.getMeetingRoomId() == null) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        return this.meetingService.validateMeetingRoomTime(null, model.getCompanyId(), model.getMeetingRoomId(), model.getBeginTime(), model.getEndTime(), languageType);
    }

    @GetMapping(value={"/getMeetingDynamic"})
    @ApiOperation(value="\u83b7\u53d6\u4f1a\u8bae\u52a8\u6001")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body"), @ApiImplicitParam(name="meetingId", value="\u4f1a\u8baeid", required=true, dataType="long", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<List<MeetingDynamicModel>> getMeetingDynamic(@LanguageType String languageType, Long meetingId) {
        if (StringUtils.isEmpty((Object)meetingId)) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        return ResultModel.suc((Object)this.meetingService.getMeetingDynamic(meetingId), (String)languageType);
    }

    @DeleteMapping
    @ApiOperation(value="\u5220\u9664\u4f1a\u8bae")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel delete(@LanguageType String languageType, @RequestBody Long[] meetingIds, @CurrentUser User currentUser) {
        if (StringUtils.isEmpty((Object)meetingIds)) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        return this.meetingService.deleteMeeting(meetingIds, currentUser.getId(), languageType);
    }
}

