/*
 * Decompiled with CFR 0.152.
 */
package com.ym.tlifang.api.controller.attendance;

import com.alibaba.dubbo.config.annotation.Reference;
import com.ym.tlifang.Constants;
import com.ym.tlifang.PageInfo;
import com.ym.tlifang.ResultModel;
import com.ym.tlifang.ResultStatus;
import com.ym.tlifang.api.authorization.annotation.Authorization;
import com.ym.tlifang.api.authorization.annotation.CurrentUser;
import com.ym.tlifang.api.authorization.annotation.LanguageType;
import com.ym.tlifang.api.controller.BaseController;
import com.ym.tlifang.attendance.AttendanceReport;
import com.ym.tlifang.attendance.AttendanceReportUser;
import com.ym.tlifang.excel.ExportExcel;
import com.ym.tlifang.model.attendance.DayCountDetailModel;
import com.ym.tlifang.model.attendance.DayCountModel;
import com.ym.tlifang.model.attendance.GetNewMonthCountModel;
import com.ym.tlifang.model.attendance.MonthCountModel;
import com.ym.tlifang.service.attendance.AttendanceDayCountService;
import com.ym.tlifang.service.attendance.AttendanceDayTotalService;
import com.ym.tlifang.service.attendance.AttendanceOutsideService;
import com.ym.tlifang.service.attendance.AttendanceReportService;
import com.ym.tlifang.service.attendance.AttendanceReportUserService;
import com.ym.tlifang.service.attendance.AttendanceUserRecordService;
import com.ym.tlifang.service.company.CompanyMemberInfoService;
import com.ym.tlifang.user.User;
import com.ym.tlifang.util.DateUtils;
import com.ym.tlifang.util.JsonUtil;
import com.ym.tlifang.util.JwtUtil;
import com.ym.tlifang.util.StringUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Row;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"attendanceReport"})
@Api(value="attendanceReport", description="\u8003\u52e4\u7edf\u8ba1")
public class AttendanceReportController
extends BaseController {
    @Reference
    private AttendanceReportService attendanceReportService;
    @Reference
    private AttendanceReportUserService attendanceReportUserService;
    @Reference
    private AttendanceOutsideService attendanceOutsideService;
    @Reference
    private CompanyMemberInfoService companyMemberInfoService;
    @Reference
    private AttendanceDayTotalService attendanceDayTotalService;
    @Reference
    private AttendanceDayCountService attendanceDayCountService;
    @Reference
    private AttendanceUserRecordService attendanceUserRecordService;

    @GetMapping(value={"/export"})
    @ApiOperation(value="\u8003\u52e4\u7edf\u8ba1\u8868-\u5bfc\u51fa")
    @ApiImplicitParams(value={@ApiImplicitParam(name="date", value="\u65e5\u671f", required=true, dataType="string", paramType="query"), @ApiImplicitParam(name="companyId", value="\u516c\u53f8id", required=true, dataType="long", paramType="query"), @ApiImplicitParam(name="token", value="token\u4e32", required=true, dataType="string", paramType="query"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    public ResultModel addRecord(String languageType, String token, HttpServletResponse response, String date, Long companyId) throws Exception {
        Long userId = Long.valueOf(JwtUtil.checkTokenRtnUserId((String)token));
        Boolean bl = this.companyMemberInfoService.havePower(companyId, userId);
        if (bl.booleanValue()) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        List attendanceReportList = this.attendanceReportService.findReportList(companyId, date);
        if (attendanceReportList.size() == 0) {
            return ResultModel.error((ResultStatus)ResultStatus.ATTENDENCE_COUNT, (String)languageType);
        }
        Boolean firstTime = true;
        ExportExcel exportExcel = null;
        Row row = null;
        for (AttendanceReport attendanceReport : attendanceReportList) {
            if (firstTime.booleanValue()) {
                ArrayList<String> strings = new ArrayList<String>();
                strings.add(Constants.LanguageType.US.getName().equals(languageType) ? "          Department          " : "          \u6240\u5c5e\u90e8\u95e8          ");
                strings.add(Constants.LanguageType.US.getName().equals(languageType) ? "Name" : "\u59d3\u540d");
                Integer i = 1;
                while (i < attendanceReport.getDayTimes() + 1) {
                    DateTimeFormatter df;
                    Object attendanceReportDate = attendanceReport.getDate();
                    String dates = (String)attendanceReportDate + "-" + (i < 10 ? "0" + i.toString() : i.toString()) + " 00:00:00";
                    LocalDateTime localDateTime = LocalDateTime.parse(dates, df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
                    int value = localDateTime.getDayOfWeek().getValue();
                    if (value == 6) {
                        strings.add("\u516d");
                    } else if (value == 7) {
                        strings.add("\u65e5");
                    } else if (i < 10) {
                        strings.add("0" + i.toString());
                    } else {
                        strings.add(i.toString());
                    }
                    attendanceReportDate = i;
                    i = i + 1;
                    Integer n = i;
                }
                strings.add(Constants.LanguageType.US.getName().equals(languageType) ? "Day of attendance" : "\u5e94\u51fa\u52e4\u5929\u6570");
                strings.add(Constants.LanguageType.US.getName().equals(languageType) ? "Actual attendance days" : "\u5b9e\u9645\u51fa\u52e4\u5929\u6570");
                strings.add(Constants.LanguageType.US.getName().equals(languageType) ? "Number of hours off" : "\u8bf7\u5047\u65f6\u6570");
                strings.add(Constants.LanguageType.US.getName().equals(languageType) ? "Lateness" : "\u8fdf\u5230\u6b21\u6570");
                strings.add(Constants.LanguageType.US.getName().equals(languageType) ? "The late time" : "\u8fdf\u5230\u65f6\u957f(\u5206\u949f)");
                strings.add(Constants.LanguageType.US.getName().equals(languageType) ? "Early retirement times" : "\u65e9\u9000\u6b21\u6570");
                strings.add(Constants.LanguageType.US.getName().equals(languageType) ? "The early time" : "\u65e9\u9000\u65f6\u957f(\u5206\u949f)");
                strings.add(Constants.LanguageType.US.getName().equals(languageType) ? "Overtime hours" : "\u52a0\u73ed\u65f6\u957f");
                exportExcel = new ExportExcel(attendanceReport.getDate() + (Constants.LanguageType.US.getName().equals(languageType) ? "Attendance statistics" : "\u8003\u52e4\u7edf\u8ba1"), strings, "0", attendanceReport.getDayTimes());
                row = exportExcel.addRow();
                row.setHeightInPoints(100.0f);
                firstTime = false;
            }
            Map mapList = this.attendanceUserRecordService.findMonthRecord(companyId, date + "%", languageType);
            Map totalAbnormalTimeOne = this.attendanceUserRecordService.findTotalAbnormalTime(companyId, date + "%", "4");
            Map totalAbnormalTime = this.attendanceUserRecordService.findTotalAbnormalTime(companyId, date + "%", "3");
            for (AttendanceReportUser attendanceReportUser : attendanceReport.getAttendanceReportUserList()) {
                List restList = (List)JsonUtil.jackson.readValue(attendanceReportUser.getRestArray(), List.class);
                List earlyArray = (List)JsonUtil.jackson.readValue(attendanceReportUser.getEarlyArray(), List.class);
                List laterArray = (List)JsonUtil.jackson.readValue(attendanceReportUser.getLaterArray(), List.class);
                List failAttendance = (List)JsonUtil.jackson.readValue(attendanceReportUser.getFailAttendanceArray(), List.class);
                exportExcel.addCellColor(row, 0, null, attendanceReportUser.getDepartName());
                exportExcel.addCellColor(row, 1, null, attendanceReportUser.getUserName());
                for (Object integer : restList) {
                    exportExcel.addCellColor(row, 1 + (Integer)integer, null, "/");
                }
                for (Object integer : failAttendance) {
                    exportExcel.addCellColor(row, 1 + (Integer)integer, null, Constants.LanguageType.US.getName().equals(languageType) ? "Not clock in" : "\u672a\u6253\u5361");
                }
                Map stringListMap = (Map)mapList.get(attendanceReportUser.getUserId().toString());
                if (stringListMap != null) {
                    Object integer;
                    integer = stringListMap.keySet().iterator();
                    while (integer.hasNext()) {
                        String key = (String)integer.next();
                        List stringList = (List)stringListMap.get(key);
                        StringBuffer stringBuffer = new StringBuffer();
                        for (String str : stringList) {
                            stringBuffer.append(str + "\n");
                        }
                        exportExcel.addCellColor(row, 1 + Integer.valueOf(key), null, stringBuffer.toString());
                    }
                }
                exportExcel.addCellColor(row, attendanceReport.getDayTimes() + 2, null, attendanceReportUser.getAttendanceTimes().toString());
                exportExcel.addCellColor(row, attendanceReport.getDayTimes() + 3, null, attendanceReportUser.getAttendanceSuccess().toString());
                exportExcel.addCellColor(row, attendanceReport.getDayTimes() + 4, null, attendanceReportUser.getLeaveNum().toString());
                exportExcel.addCellColor(row, attendanceReport.getDayTimes() + 5, null, attendanceReportUser.getLaterNum().toString());
                Integer integerOne = (Integer)totalAbnormalTimeOne.get(attendanceReportUser.getUserId());
                if (integerOne != null) {
                    exportExcel.addCellColor(row, attendanceReport.getDayTimes() + 6, null, integerOne.toString());
                } else {
                    exportExcel.addCellColor(row, attendanceReport.getDayTimes() + 6, null, "0");
                }
                exportExcel.addCellColor(row, attendanceReport.getDayTimes() + 7, null, attendanceReportUser.getEarlyNum().toString());
                Integer integer = (Integer)totalAbnormalTime.get(attendanceReportUser.getUserId());
                if (integer != null) {
                    exportExcel.addCellColor(row, attendanceReport.getDayTimes() + 8, null, integer.toString());
                } else {
                    exportExcel.addCellColor(row, attendanceReport.getDayTimes() + 8, null, "0");
                }
                exportExcel.addCellColor(row, attendanceReport.getDayTimes() + 9, null, attendanceReportUser.getAddWork().toString());
                row = exportExcel.addRow();
                row.setHeightInPoints(100.0f);
            }
        }
        row = exportExcel.addRow();
        row.setHeightInPoints(100.0f);
        exportExcel.addCellColor(row, 0, "7", Constants.LanguageType.US.getName().equals(languageType) ? "Holiday:" : "\u5047\u65e5:");
        exportExcel.addCellColor(row, 1, "7", "/");
        exportExcel.addListCellColor();
        String fileName = date + (Constants.LanguageType.US.getName().equals(languageType) ? "Attendance statistics" : "\u8003\u52e4\u7edf\u8ba1") + ".xlsx";
        exportExcel.write(response, fileName).dispose();
        return ResultModel.ok((String)languageType);
    }

    @GetMapping(value={"/count"})
    @ApiOperation(value="\u8003\u52e4\u6253\u5361\u90e8\u5206-\u7edf\u8ba1")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="monthDate", value="\u5e74\u6708", required=false, dataType="string", paramType="query"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<AttendanceReportUser> addRecord(@LanguageType String languageType, @CurrentUser User currentUser, String monthDate) throws Exception {
        AttendanceReportUser attendanceReportUser;
        String date = DateUtils.formatDate((Date)new Date(), (Object[])new Object[]{"yyyy-MM"});
        if (!StringUtils.isEmpty((Object)monthDate)) {
            date = monthDate;
        }
        if ((attendanceReportUser = this.attendanceReportUserService.findByReportIdAndUserId(currentUser.getCurrentCompany(), currentUser.getId(), date)) == null) {
            attendanceReportUser = new AttendanceReportUser();
            attendanceReportUser.setLaterNum(Integer.valueOf(0));
            attendanceReportUser.setEarlyNum(Integer.valueOf(0));
            attendanceReportUser.setAttendanceTimes(Integer.valueOf(0));
            attendanceReportUser.setOutsideTimes(Integer.valueOf(0));
            attendanceReportUser.setAttendanceSuccess(Integer.valueOf(0));
            attendanceReportUser.setFailAttendanceTimes(Integer.valueOf(0));
            attendanceReportUser.setAttendanceTimes(Integer.valueOf(0));
        } else {
            attendanceReportUser.setOutsideTimes(this.attendanceOutsideService.personMonth(currentUser.getCurrentCompany(), currentUser.getId(), date));
            List failAttendanceList = (List)JsonUtil.jackson.readValue(attendanceReportUser.getFailAttendanceArray(), List.class);
            attendanceReportUser.setFailAttendanceTimes(Integer.valueOf(failAttendanceList.size()));
        }
        return ResultModel.suc((Object)attendanceReportUser, (String)languageType);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/record/count"})
    @ApiOperation(value="\u8003\u52e4\u7edf\u8ba1")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<List<AttendanceReportUser>> getRecordAll(@LanguageType String languageType, @CurrentUser User currentUser) throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        List attendanceReportList = this.attendanceReportService.findReportList(currentUser.getCurrentCompany(), sdf.format(new Date()));
        if (attendanceReportList.size() == 0) {
            attendanceReportList = this.attendanceReportService.findReportList(currentUser.getCurrentCompany(), sdf.format(DateUtils.addDateNum((Date)new Date(), (int)-1)));
        }
        ArrayList<AttendanceReportUser> attendanceReportUsers = new ArrayList<AttendanceReportUser>();
        for (AttendanceReport attendanceReport : attendanceReportList) {
            List attendanceReportUserList = this.attendanceReportUserService.findByReportUser(attendanceReport.getId());
            for (AttendanceReportUser attendanceReportUser : attendanceReportUserList) {
                List failAttendanceList = (List)JsonUtil.jackson.readValue(attendanceReportUser.getFailAttendanceArray(), List.class);
                attendanceReportUser.setFailAttendanceTimes(Integer.valueOf(failAttendanceList.size()));
                attendanceReportUser.setSex(attendanceReportUser.getUser().getSex());
                attendanceReportUser.setAvatar(attendanceReportUser.getUser().getAvatar());
                attendanceReportUsers.add(attendanceReportUser);
            }
        }
        return ResultModel.suc(attendanceReportUsers, (String)languageType);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/record/count/month"})
    @ApiOperation(value="\u8003\u52e4\u6708\u7edf\u8ba1")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="monthDate", value="\u5e74\u6708", required=true, dataType="string", paramType="query"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<MonthCountModel> getMonthCount(@LanguageType String languageType, @CurrentUser User currentUser, String monthDate) throws Exception {
        if (currentUser.getCurrentCompany() == null || StringUtils.isEmpty((Object)monthDate)) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        return this.attendanceDayTotalService.findMonthCount(currentUser.getCurrentCompany(), monthDate, languageType);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/record/count/day"})
    @ApiOperation(value="\u8003\u52e4\u65e5\u7edf\u8ba1")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="dayDate", value="\u5e74\u6708\u65e5", required=true, dataType="string", paramType="query"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<DayCountModel> getDayCount(@LanguageType String languageType, @CurrentUser User currentUser, String dayDate) throws Exception {
        if (currentUser.getCurrentCompany() == null || StringUtils.isEmpty((Object)dayDate)) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        return this.attendanceDayTotalService.findDayCount(currentUser.getCurrentCompany(), dayDate, languageType);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/record/count/dayDetail"})
    @ApiOperation(value="\u8003\u52e4\u65e5\u7edf\u8ba1\u8be6\u60c5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="dayDate", value="\u5e74\u6708\u65e5", required=true, dataType="string", paramType="query"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<List<DayCountDetailModel>> getDayCountDetail(@LanguageType String languageType, @CurrentUser User currentUser, String dayDate) throws Exception {
        if (currentUser.getCurrentCompany() == null || StringUtils.isEmpty((Object)dayDate)) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        return this.attendanceDayCountService.findByCompanyIdAndRecordDate(currentUser.getCurrentCompany(), dayDate, languageType);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/record/countTwo"})
    @ApiOperation(value="\u8003\u52e4\u7edf\u8ba1(2019/7/18\u65b0\u9700\u6c42\u7248)")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body"), @ApiImplicitParam(name="date", value="\u5e74\u6708", required=false, dataType="string", paramType="query"), @ApiImplicitParam(name="userName", value="\u4eba\u540d", required=false, dataType="string", paramType="query"), @ApiImplicitParam(name="departName", value="\u90e8\u95e8\u540d", required=false, dataType="string", paramType="query"), @ApiImplicitParam(name="pageNo", value="\u9875\u7801", required=false, dataType="int", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    public ResultModel<PageInfo<GetNewMonthCountModel>> getRecord(@LanguageType String languageType, @CurrentUser User currentUser, String date, String userName, String departName, Integer pageNo) throws Exception {
        if (StringUtils.isEmpty((Object)date)) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
            date = sdf.format(new Date());
        }
        if (StringUtils.isEmpty((Object)pageNo)) {
            pageNo = 1;
        }
        return ResultModel.suc((Object)this.attendanceReportUserService.findNewAttendanceCount(date, currentUser.getCurrentCompany(), userName, departName, pageNo));
    }
}

