/*
 * Decompiled with CFR 0.152.
 */
package com.ym.tlifang.service.meeting;

import com.alibaba.dubbo.config.annotation.Service;
import com.ym.tlifang.ResultModel;
import com.ym.tlifang.ResultStatus;
import com.ym.tlifang.dao.meeting.MeetingRoomDao;
import com.ym.tlifang.meeting.MeetingRoomEntity;
import com.ym.tlifang.service.AbstractBaseService;
import com.ym.tlifang.service.meeting.MeetingRoomService;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@Service(interfaceClass=MeetingRoomService.class, timeout=30000, retries=-1)
public class MeetingRoomServiceImpl
extends AbstractBaseService<MeetingRoomEntity, MeetingRoomDao>
implements MeetingRoomService {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    public List<MeetingRoomEntity> findMeetingRooms(Long companyId) {
        return ((MeetingRoomDao)this.dao).findByCompanyIdAndDelFlagFalse(companyId);
    }

    public MeetingRoomEntity saveMeetingRoom(MeetingRoomEntity meetingRoomEntity) {
        if (meetingRoomEntity.getId() != null) {
            MeetingRoomEntity entity = ((MeetingRoomDao)this.dao).findByIdAndDelFlagIsFalse(meetingRoomEntity.getId());
            entity.setDetailExplain(meetingRoomEntity.getDetailExplain());
            entity.setName(meetingRoomEntity.getName());
            entity.setEquipment(meetingRoomEntity.getEquipment());
            entity.setPeople(meetingRoomEntity.getPeople());
            entity.setUpdateDate(new Date());
            return (MeetingRoomEntity)((MeetingRoomDao)this.dao).save((Object)entity);
        }
        return (MeetingRoomEntity)((MeetingRoomDao)this.dao).save((Object)meetingRoomEntity);
    }

    public ResultModel deleteMeetingRoom(Long meetingRoomId, String languageType) {
        MeetingRoomEntity meetingRoomEntity = ((MeetingRoomDao)this.dao).findByIdAndDelFlagIsFalse(meetingRoomId);
        if (meetingRoomEntity == null) {
            return ResultModel.error((ResultStatus)ResultStatus.MEETING_ROOM_NO_EXIST, (String)languageType);
        }
        int meetingCount = ((MeetingRoomDao)this.dao).getMeetingRoomWhetherOccupy(meetingRoomId);
        if (meetingCount > 0) {
            return ResultModel.error((ResultStatus)ResultStatus.MEETING_ROOM_NOT_DELETE, (String)languageType);
        }
        meetingRoomEntity.setDelFlag(Boolean.valueOf(true));
        ((MeetingRoomDao)this.dao).save((Object)meetingRoomEntity);
        return ResultModel.ok((String)languageType);
    }
}

