/*
 * Decompiled with CFR 0.152.
 */
package com.ym.tlifang.service.company;

import com.alibaba.dubbo.config.annotation.Service;
import com.ym.tlifang.Constants;
import com.ym.tlifang.ResultModel;
import com.ym.tlifang.ResultStatus;
import com.ym.tlifang.approval.ApprovalTemplate;
import com.ym.tlifang.attendance.AttendanceUser;
import com.ym.tlifang.company.Company;
import com.ym.tlifang.company.CompanyMemberInfo;
import com.ym.tlifang.company.CompanyUserRelation;
import com.ym.tlifang.dao.company.CompanyMemberInfoDao;
import com.ym.tlifang.file.FileFolderPowerEntity;
import com.ym.tlifang.model.company.AccountSearchModel;
import com.ym.tlifang.project.Project;
import com.ym.tlifang.project.ProjectUser;
import com.ym.tlifang.service.AbstractBaseService;
import com.ym.tlifang.service.approval.ApprovalTemplateService;
import com.ym.tlifang.service.attendance.AttendanceUserService;
import com.ym.tlifang.service.company.CompanyMemberInfoService;
import com.ym.tlifang.service.company.CompanyService;
import com.ym.tlifang.service.company.CompanyUserRelationService;
import com.ym.tlifang.service.file.FileFolderPowerService;
import com.ym.tlifang.service.project.ProjectService;
import com.ym.tlifang.service.project.ProjectUserService;
import com.ym.tlifang.service.push.XgPushService;
import com.ym.tlifang.service.system.DynamicService;
import com.ym.tlifang.service.system.NoticeService;
import com.ym.tlifang.service.task.TaskConcernService;
import com.ym.tlifang.service.task.TaskService;
import com.ym.tlifang.service.user.UserService;
import com.ym.tlifang.task.Task;
import com.ym.tlifang.task.TaskConcern;
import com.ym.tlifang.user.User;
import com.ym.tlifang.util.JsonUtil;
import com.ym.tlifang.util.StringUtils;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Service(interfaceClass=CompanyMemberInfoService.class, timeout=100000, retries=-1)
public class CompanyMemberInfoServiceImpl
extends AbstractBaseService<CompanyMemberInfo, CompanyMemberInfoDao>
implements CompanyMemberInfoService {
    Logger logger = LoggerFactory.getLogger(CompanyMemberInfoService.class);
    @Autowired
    private CompanyUserRelationService companyUserRelationService;
    @Autowired
    private NoticeService noticeService;
    @Autowired
    private DynamicService dynamicService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private TaskConcernService taskConcernService;
    @Autowired
    private ProjectUserService projectUserService;
    @Autowired
    private CompanyService companyService;
    @Autowired
    private UserService userService;
    @Autowired
    private AttendanceUserService attendanceUserService;
    @Autowired
    private ApprovalTemplateService approvalTemplateService;
    @Autowired
    private XgPushService xgPushService;
    @Autowired
    private FileFolderPowerService fileFolderPowerService;
    @Autowired
    private ProjectService projectService;

    public CompanyMemberInfo save(CompanyMemberInfo companyMemberInfo) {
        return (CompanyMemberInfo)((CompanyMemberInfoDao)this.dao).save((Object)companyMemberInfo);
    }

    public CompanyMemberInfo findByCompanyIdAndUserIdAndStatus(Long companyId, Long userId, String status) {
        return ((CompanyMemberInfoDao)this.dao).findByCompanyIdAndUserIdAndStatusAndDelFlagFalse(companyId, userId, status);
    }

    public String findManagerByCompanyIdAndUserIdAndStatus(Long companyId, Long userId, String status) {
        return ((CompanyMemberInfoDao)this.dao).findManagerByCompanyIdAndUserIdAndStatus(companyId, userId, status);
    }

    public List<CompanyMemberInfo> findByCompanyId(Long companyId) {
        return ((CompanyMemberInfoDao)this.dao).findByCompanyIdAndDelFlagFalse(companyId);
    }

    public List<CompanyMemberInfo> findByCompanyIdAndStatus(Long companyId, String status) {
        return ((CompanyMemberInfoDao)this.dao).findByCompanyIdAndStatusAndDelFlagFalse(companyId, status);
    }

    public CompanyMemberInfo findByIdAndDelFlag(Long companyMemberId) {
        return ((CompanyMemberInfoDao)this.dao).findByIdAndDelFlag(companyMemberId, false);
    }

    public List<CompanyMemberInfo> findByUserIdAndStatus(Long userId, String status) {
        return ((CompanyMemberInfoDao)this.dao).findByUserIdAndStatusAndDelFlagFalse(userId, status);
    }

    public Boolean havePower(Long companyId, Long userId) {
        CompanyMemberInfo companyMemberInfo = ((CompanyMemberInfoDao)this.dao).findByCompanyIdAndUserIdAndStatusAndDelFlagFalse(companyId, userId, Constants.AuditStatus.adopt.getType());
        if (companyMemberInfo == null) {
            return true;
        }
        if ("0".equals(companyMemberInfo.getManager())) {
            return true;
        }
        return false;
    }

    public AccountSearchModel queryInfo(User user, Boolean isMember) {
        AccountSearchModel accountSearchModel = new AccountSearchModel(user.getId(), user.getName(), user.getEmail(), user.getMobile(), user.getAvatar(), isMember);
        return accountSearchModel;
    }

    public ResultModel<CompanyMemberInfo> createMember(Company company, User addUser) {
        CompanyMemberInfo companyMemberInfo = new CompanyMemberInfo(addUser.getId(), company.getId(), addUser.getEmail(), addUser.getMobile(), "1");
        this.save(companyMemberInfo);
        CompanyUserRelation companyUserRelation = new CompanyUserRelation(addUser.getId(), company.getId(), company.getId());
        this.companyUserRelationService.save(companyUserRelation);
        return ResultModel.ok();
    }

    public Company createCompanyMemberInfo(User user, Company company, Long userId) {
        CompanyMemberInfo companyMemberInfo = new CompanyMemberInfo(user.getId(), company.getId(), user.getEmail(), user.getMobile(), Constants.AuditStatus.AuditMember.getType());
        this.save(companyMemberInfo);
        CompanyUserRelation companyUserRelation = new CompanyUserRelation(user.getId(), company.getId(), company.getId());
        this.companyUserRelationService.save(companyUserRelation);
        List userIdList = this.findByParams(company.getId(), Constants.ManagerStatus.companyOwner.getType(), Constants.ManagerStatus.companyManager.getType());
        for (Long uId : userIdList) {
            HashMap<String, Object> mapTwo = new HashMap<String, Object>();
            mapTwo.put("companyId", company.getId());
            mapTwo.put("action", "\u7533\u8bf7\u52a0\u5165");
            mapTwo.put("msg", user.getName() + Constants.NoticeContent.applyCompany.getName() + company.getName());
            mapTwo.put("msgEn", user.getName() + Constants.NoticeContent.applyCompany.getNameEnglish() + company.getName());
            try {
                this.noticeService.saveSendNotice(uId, Constants.NoticeParentType.company, Constants.NoticeType.applyAdd, Constants.Originator.member, user.getId(), mapTwo, "2");
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
                e.printStackTrace();
            }
        }
        return company;
    }

    public ResultModel<Company> updateAuditCompanyMember(User user, CompanyMemberInfo companyMemberInfo, String status, String languageType) {
        if (status.equals(Constants.AuditStatus.adopt.getType())) {
            companyMemberInfo.setStatus(status);
            companyMemberInfo = this.save(companyMemberInfo);
            int companyCount = this.findByCompanyCount(companyMemberInfo.getUserId());
            if (companyCount == 1) {
                User userInfo = this.userService.findById(companyMemberInfo.getUserId());
                if (userInfo == null) {
                    return ResultModel.error((ResultStatus)ResultStatus.ACCOUNT_NO_EXIST, (String)languageType);
                }
                userInfo.setCurrentCompany(companyMemberInfo.getCompanyId());
                this.userService.save(userInfo);
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("companyId", companyMemberInfo.getCompanyId());
            map.put("action", "\u52a0\u5165\u56e2\u961f");
            map.put("msg", Constants.NoticeContent.wishAddCompany.getName() + companyMemberInfo.getCompany().getName() + Constants.NoticeContent.startWork.getName());
            map.put("msgEn", Constants.NoticeContent.wishAddCompany.getNameEnglish() + companyMemberInfo.getCompany().getName() + Constants.NoticeContent.startWork.getNameEnglish());
            try {
                this.noticeService.saveSendNotice(companyMemberInfo.getUserId(), Constants.NoticeParentType.company, Constants.NoticeType.companySetInfo, Constants.Originator.member, companyMemberInfo.getUserId(), map, "1");
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
                e.printStackTrace();
            }
            List userIdList = this.findByParams(companyMemberInfo.getCompanyId(), Constants.ManagerStatus.companyOwner.getType(), Constants.ManagerStatus.companyManager.getType());
            for (Long uId : userIdList) {
                HashMap<String, Object> mapTwo = new HashMap<String, Object>();
                mapTwo.put("companyId", companyMemberInfo.getCompanyId());
                mapTwo.put("action", "\u6210\u5458\u52a0\u5165");
                mapTwo.put("msg", Constants.NoticeContent.welcome.getName() + companyMemberInfo.getUser().getName() + Constants.NoticeContent.addCompany.getName() + companyMemberInfo.getCompany().getName());
                mapTwo.put("msgEn", Constants.NoticeContent.welcome.getNameEnglish() + companyMemberInfo.getUser().getName() + Constants.NoticeContent.addCompany.getNameEnglish() + companyMemberInfo.getCompany().getName());
                try {
                    this.noticeService.saveSendNotice(uId, Constants.NoticeParentType.company, Constants.NoticeType.companyAdd, Constants.Originator.member, companyMemberInfo.getUserId(), mapTwo, "2");
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                    e.printStackTrace();
                }
            }
            this.dynamicService.saveDynamic(companyMemberInfo.getUserId(), Constants.DynamicParentType.company, companyMemberInfo.getCompanyId(), Constants.DynamicOriginatorType.onboarding, user.getId(), Constants.DynamicType.addCompany.getName(), Constants.DynamicActionType.companyMember, Constants.DynamicType.addCompany.getNameEnglish());
        } else if (status.equals(Constants.AuditStatus.reject.getType())) {
            CompanyUserRelation companyUserRelation = this.companyUserRelationService.findByUserIdAndCompanyIdAndDepartmentId(companyMemberInfo.getUserId(), companyMemberInfo.getCompanyId(), companyMemberInfo.getCompanyId());
            if (companyUserRelation == null) {
                return ResultModel.error((ResultStatus)ResultStatus.COMPANYMEMBERS_NO_EXIST, (String)languageType);
            }
            companyUserRelation.setDelFlag(Boolean.valueOf(true));
            this.companyUserRelationService.save(companyUserRelation);
            companyMemberInfo.setStatus(Constants.AuditStatus.reject.getType());
            companyMemberInfo.setDelFlag(Boolean.valueOf(true));
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("companyId", companyMemberInfo.getCompanyId());
            map.put("action", "\u62d2\u7edd\u52a0\u5165");
            map.put("msg", Constants.NoticeContent.rejectYouAddCompany.getName() + companyMemberInfo.getCompany().getName());
            map.put("msgEn", Constants.NoticeContent.rejectYouAddCompany.getNameEnglish() + companyMemberInfo.getCompany().getName());
            try {
                this.noticeService.saveSendNotice(companyMemberInfo.getUserId(), Constants.NoticeParentType.company, Constants.NoticeType.rejectAdd, Constants.Originator.member, companyMemberInfo.getUserId(), map, "1");
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
                e.printStackTrace();
            }
            this.save(companyMemberInfo);
        }
        return ResultModel.ok();
    }

    public CompanyMemberInfo updateCompanyMember(CompanyMemberInfo oldCompanyMemberInfo, CompanyMemberInfo companyMemberInfo) {
        if (!StringUtils.isEmpty((Object)companyMemberInfo.getEmail())) {
            oldCompanyMemberInfo.setEmail(companyMemberInfo.getEmail());
        }
        if (!StringUtils.isEmpty((Object)companyMemberInfo.getMobile())) {
            oldCompanyMemberInfo.setMobile(companyMemberInfo.getMobile());
        }
        if (!StringUtils.isEmpty((Object)companyMemberInfo.getManager())) {
            oldCompanyMemberInfo.setManager(companyMemberInfo.getManager());
        }
        if (!StringUtils.isEmpty((Object)companyMemberInfo.getWorkers())) {
            oldCompanyMemberInfo.setWorkers(companyMemberInfo.getWorkers());
        }
        CompanyMemberInfo memberInfo = this.save(oldCompanyMemberInfo);
        return memberInfo;
    }

    public ResultModel<CompanyMemberInfo> deleteCompanyMember(User user, User companyMember, CompanyMemberInfo companyMemberInfo, String languageType) {
        List tasks;
        List taskList;
        AttendanceUser attendanceUser;
        List projectUserList;
        List fileFolderPowerNoAdminList;
        List fileFolderPowerEntityList = this.fileFolderPowerService.findByUserIdAndPowerTypeAndDelFlagFalse(companyMemberInfo.getUserId(), "0", "1");
        if (fileFolderPowerEntityList.size() > 0) {
            for (Object fileFolderPowerEntity : fileFolderPowerEntityList) {
                FileFolderPowerEntity folderPowerTypeOneList = this.fileFolderPowerService.findFirstByFileFolderIdAndPowerTypeNotAndDelFlagFalseOrderByPowerTypeAsc(fileFolderPowerEntity.getFileFolderId(), "0");
                if (folderPowerTypeOneList == null) continue;
                folderPowerTypeOneList.setPowerType("0");
                folderPowerTypeOneList.setUpdateBy(user.getId());
                folderPowerTypeOneList.setUpdateDate(new Date());
                this.fileFolderPowerService.saveEntity(folderPowerTypeOneList);
                this.fileFolderPowerService.delFileFolderPower(fileFolderPowerEntity.getFileFolderId(), fileFolderPowerEntity.getUserId());
            }
        }
        if ((fileFolderPowerNoAdminList = this.fileFolderPowerService.findByUserIdAndPowerTypeAndDelFlagFalse(companyMemberInfo.getUserId(), "0", "2")).size() > 0) {
            for (Object fileFolderPowerEntity : fileFolderPowerNoAdminList) {
                this.fileFolderPowerService.delFileFolderPower(fileFolderPowerEntity.getFileFolderId(), fileFolderPowerEntity.getUserId());
            }
        }
        if (!StringUtils.isEmpty((Object)(projectUserList = this.projectUserService.findByUserIdAndCompanyIdAndDelFlagFalse(companyMember.getId(), companyMemberInfo.getCompanyId())))) {
            for (ProjectUser projectUser : projectUserList) {
                if ("1".equals(projectUser.getType())) {
                    Project project = this.projectService.findByProjectId(projectUser.getProjectId());
                    ProjectUser projectUserOne = this.projectUserService.findFirstByProjectIdAndTypeNotAndDelFlagFalseOrderByTypeAsc(projectUser.getProjectId(), "1");
                    if (projectUserOne != null) {
                        projectUserOne.setType("1");
                        projectUserOne.setUpdateDate(new Date());
                        this.projectUserService.save(projectUserOne);
                        if (project != null) {
                            project.setOwnerId(projectUserOne.getUserId());
                            this.projectService.save(project);
                        }
                        projectUser.setDelFlag(Boolean.valueOf(true));
                        projectUser.setUpdateDate(new Date());
                        this.projectUserService.save(projectUser);
                        continue;
                    }
                    project.setDelFlag(Boolean.valueOf(true));
                    this.projectService.save(project);
                    projectUser.setDelFlag(Boolean.valueOf(true));
                    projectUser.setUpdateDate(new Date());
                    this.projectUserService.save(projectUser);
                    continue;
                }
                projectUser.setDelFlag(Boolean.valueOf(true));
                projectUser.setUpdateDate(new Date());
                this.projectUserService.save(projectUser);
            }
        }
        if ((attendanceUser = this.attendanceUserService.findByUserIdAndDelFlagFalse(companyMemberInfo.getUserId(), companyMemberInfo.getCompanyId())) != null) {
            attendanceUser.setDelFlag(Boolean.valueOf(true));
            this.attendanceUserService.save(attendanceUser);
        }
        if (!StringUtils.isEmpty((Object)(taskList = this.taskService.findByCompanyIdAndAssigneeIdAndStatusAndDelFlagFalse(companyMemberInfo.getCompanyId(), companyMemberInfo.getUserId(), "0")))) {
            for (Object task : taskList) {
                task.setAssigneeId(null);
                this.taskService.save((Task)task);
            }
        }
        if (!StringUtils.isEmpty((Object)(tasks = this.taskService.findByCompanyIdAndStatusAndDelFlagFalse(companyMemberInfo.getCompanyId(), "0")))) {
            for (Task task : tasks) {
                TaskConcern taskConcern = this.taskConcernService.findByTaskIdAndUserId(task.getId(), companyMemberInfo.getUserId());
                if (StringUtils.isEmpty((Object)taskConcern)) continue;
                taskConcern.setStatus("0");
                this.taskConcernService.save(taskConcern);
            }
        }
        List approvalTemplateList = this.approvalTemplateService.findByCompanyId(companyMemberInfo.getCompanyId());
        for (Object approvalTemplate : approvalTemplateList) {
            if (approvalTemplate.getUserIds() == null) continue;
            try {
                List list = (List)JsonUtil.jackson.readValue(approvalTemplate.getUserIds(), List.class);
                boolean contains = list.contains(companyMember.getId().intValue());
                if (!contains) continue;
                for (int i = 0; i < list.size(); ++i) {
                    if (!list.get(i).equals(companyMember.getId().intValue())) continue;
                    list.remove(i);
                }
                if (list.size() > 0) {
                    Object[] str = list.toArray(new Integer[list.size()]);
                    approvalTemplate.setUserIds(Arrays.toString(str));
                    this.approvalTemplateService.save((ApprovalTemplate)approvalTemplate);
                    continue;
                }
                approvalTemplate.setUserIds(null);
                this.approvalTemplateService.save((ApprovalTemplate)approvalTemplate);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        List companyUserRelations = this.companyUserRelationService.findByUserIdAndCompanyIdAndDelFlagFalse(companyMemberInfo.getUserId(), companyMemberInfo.getCompanyId());
        for (CompanyUserRelation companyUserRelation : companyUserRelations) {
            companyUserRelation.setDelFlag(Boolean.valueOf(true));
            this.companyUserRelationService.save(companyUserRelation);
        }
        companyMemberInfo.setDelFlag(Boolean.valueOf(true));
        this.save(companyMemberInfo);
        Company company = this.companyService.findById(companyMemberInfo.getCompanyId());
        if (company == null) {
            return ResultModel.error((ResultStatus)ResultStatus.COMPANY_NO_EXIST, (String)languageType);
        }
        List companyMemberInfoList = this.findByUserIdAndStatus(companyMemberInfo.getUserId(), Constants.AuditStatus.adopt.getType());
        if (companyMemberInfoList != null && companyMemberInfoList.size() > 0) {
            CompanyMemberInfo memberInfo = (CompanyMemberInfo)companyMemberInfoList.get(0);
            if (companyMember == null || companyMember.getCurrentCompany() == null) {
                return ResultModel.error((ResultStatus)ResultStatus.ACCOUNT_NO_EXIST, (String)languageType);
            }
            if (companyMember.getCurrentCompany().equals(company.getId())) {
                companyMember.setCurrentCompany(memberInfo.getCompanyId());
                this.userService.save(companyMember);
            }
        } else {
            companyMember.setCurrentCompany(null);
            this.userService.save(companyMember);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("companyId", companyMemberInfo.getCompanyId());
        map.put("action", "\u5220\u9664\u6210\u5458");
        map.put("msg", user.getName() + Constants.NoticeContent.removeCompany.getName() + company.getName());
        map.put("msgEn", user.getName() + Constants.NoticeContent.removeCompany.getNameEnglish() + company.getName());
        try {
            this.noticeService.saveSendNotice(companyMemberInfo.getUserId(), Constants.NoticeParentType.company, Constants.NoticeType.companyDelInfo, Constants.Originator.member, user.getId(), map, "1");
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            e.printStackTrace();
        }
        if ("0".equals("0")) {
            if (!StringUtils.isEmpty((Object)companyMember) && StringUtils.isNotBlank((String)companyMember.getPushToken())) {
                this.xgPushService.pushTokenIosOrAndroidBelievers(companyMember.getPushToken(), Constants.TitleNotify.company.getName(), Constants.ContentNotify.shiftCompany.getName() + company.getName(), null, Constants.IntentType.systemNotice.getType());
            }
        } else if (!StringUtils.isEmpty((Object)companyMember) && StringUtils.isNotBlank((String)companyMember.getPushToken())) {
            this.xgPushService.pushTokenForeign(companyMember.getPushToken(), Constants.TitleNotify.company.getEnglishName(), Constants.ContentNotify.shiftCompany.getEnglishName() + company.getName(), Constants.SHOWFLAG);
        }
        return ResultModel.ok();
    }

    public ResultModel<User> reduceCompanyMember(User user, CompanyMemberInfo companyMemberInfo, Long companyId) {
        List tasks;
        List taskList;
        AttendanceUser attendanceUser;
        List projectUserList;
        List fileFolderPowerNoAdminList;
        companyMemberInfo.setDelFlag(Boolean.valueOf(true));
        List fileFolderPowerEntityList = this.fileFolderPowerService.findByUserIdAndPowerTypeAndDelFlagFalse(companyMemberInfo.getUserId(), "0", "1");
        if (fileFolderPowerEntityList.size() > 0) {
            for (Object fileFolderPowerEntity : fileFolderPowerEntityList) {
                FileFolderPowerEntity folderPowerTypeOneList = this.fileFolderPowerService.findFirstByFileFolderIdAndPowerTypeNotAndDelFlagFalseOrderByPowerTypeAsc(fileFolderPowerEntity.getFileFolderId(), "0");
                if (folderPowerTypeOneList == null) continue;
                folderPowerTypeOneList.setPowerType("0");
                folderPowerTypeOneList.setUpdateBy(user.getId());
                folderPowerTypeOneList.setUpdateDate(new Date());
                this.fileFolderPowerService.saveEntity(folderPowerTypeOneList);
                this.fileFolderPowerService.delFileFolderPower(fileFolderPowerEntity.getFileFolderId(), fileFolderPowerEntity.getUserId());
            }
        }
        if ((fileFolderPowerNoAdminList = this.fileFolderPowerService.findByUserIdAndPowerTypeAndDelFlagFalse(companyMemberInfo.getUserId(), "0", "2")).size() > 0) {
            for (Object fileFolderPowerEntity : fileFolderPowerNoAdminList) {
                this.fileFolderPowerService.delFileFolderPower(fileFolderPowerEntity.getFileFolderId(), fileFolderPowerEntity.getUserId());
            }
        }
        if (!StringUtils.isEmpty((Object)(projectUserList = this.projectUserService.findByUserIdAndCompanyIdAndDelFlagFalse(user.getId(), companyMemberInfo.getCompanyId())))) {
            for (ProjectUser projectUser : projectUserList) {
                if ("1".equals(projectUser.getType())) {
                    Project project = this.projectService.findByProjectId(projectUser.getProjectId());
                    ProjectUser projectUserOne = this.projectUserService.findFirstByProjectIdAndTypeNotAndDelFlagFalseOrderByTypeAsc(projectUser.getProjectId(), "1");
                    if (projectUserOne != null) {
                        projectUserOne.setType("1");
                        projectUserOne.setUpdateDate(new Date());
                        this.projectUserService.save(projectUserOne);
                        if (project != null) {
                            project.setOwnerId(projectUserOne.getUserId());
                            this.projectService.save(project);
                        }
                        projectUser.setDelFlag(Boolean.valueOf(true));
                        projectUser.setUpdateDate(new Date());
                        this.projectUserService.save(projectUser);
                        continue;
                    }
                    project.setDelFlag(Boolean.valueOf(true));
                    this.projectService.save(project);
                    projectUser.setDelFlag(Boolean.valueOf(true));
                    projectUser.setUpdateDate(new Date());
                    this.projectUserService.save(projectUser);
                    continue;
                }
                projectUser.setDelFlag(Boolean.valueOf(true));
                projectUser.setUpdateDate(new Date());
                this.projectUserService.save(projectUser);
            }
        }
        if ((attendanceUser = this.attendanceUserService.findByUserIdAndDelFlagFalse(user.getId(), companyId)) != null) {
            attendanceUser.setDelFlag(Boolean.valueOf(true));
            this.attendanceUserService.save(attendanceUser);
        }
        if (!StringUtils.isEmpty((Object)(taskList = this.taskService.findByCompanyIdAndAssigneeIdAndStatusAndDelFlagFalse(companyId, user.getId(), "0")))) {
            for (Object task : taskList) {
                task.setAssigneeId(null);
                this.taskService.save((Task)task);
            }
        }
        if (!StringUtils.isEmpty((Object)(tasks = this.taskService.findByCompanyIdAndStatusAndDelFlagFalse(companyId, "0")))) {
            for (Task task : tasks) {
                TaskConcern taskConcern = this.taskConcernService.findByTaskIdAndUserId(task.getId(), user.getId());
                if (StringUtils.isEmpty((Object)taskConcern)) continue;
                taskConcern.setStatus("0");
                this.taskConcernService.save(taskConcern);
            }
        }
        List approvalTemplateList = this.approvalTemplateService.findByCompanyId(companyId);
        for (Object approvalTemplate : approvalTemplateList) {
            if (approvalTemplate.getUserIds() == null) continue;
            try {
                List list = (List)JsonUtil.jackson.readValue(approvalTemplate.getUserIds(), List.class);
                boolean contains = list.contains(user.getId().intValue());
                if (!contains) continue;
                for (int i = 0; i < list.size(); ++i) {
                    if (!list.get(i).equals(user.getId().intValue())) continue;
                    list.remove(i);
                }
                if (list.size() > 0) {
                    Object[] str = list.toArray(new Integer[list.size()]);
                    approvalTemplate.setUserIds(Arrays.toString(str));
                    this.approvalTemplateService.save((ApprovalTemplate)approvalTemplate);
                    continue;
                }
                approvalTemplate.setUserIds(null);
                this.approvalTemplateService.save((ApprovalTemplate)approvalTemplate);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        List companyUserRelations = this.companyUserRelationService.findByUserIdAndCompanyIdAndDelFlagFalse(user.getId(), companyMemberInfo.getCompanyId());
        for (CompanyUserRelation companyUserRelation : companyUserRelations) {
            companyUserRelation.setDelFlag(Boolean.valueOf(true));
            this.companyUserRelationService.save(companyUserRelation);
        }
        Company company = this.companyService.findById(companyId);
        this.save(companyMemberInfo);
        List companyMemberInfoList = this.findByUserIdAndStatus(user.getId(), Constants.AuditStatus.adopt.getType());
        if (companyMemberInfoList != null && companyMemberInfoList.size() > 0) {
            CompanyMemberInfo memberInfo = (CompanyMemberInfo)companyMemberInfoList.get(0);
            if (user.getCurrentCompany().equals(company.getId())) {
                user.setCurrentCompany(memberInfo.getCompanyId());
                user = this.userService.save(user);
                user.setManager(memberInfo.getManager());
            }
        } else {
            user.setCurrentCompany(null);
            user = this.userService.save(user);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("companyId", company.getId());
        map.put("action", "\u9000\u51fa\u56e2\u961f");
        map.put("msg", user.getName() + Constants.NoticeContent.exitCompany.getName() + company.getName());
        map.put("msgEn", user.getName() + Constants.NoticeContent.exitCompany.getNameEnglish() + company.getName());
        try {
            this.noticeService.saveSendNotice(company.getOwnerId(), Constants.NoticeParentType.company, Constants.NoticeType.companyexit, Constants.Originator.member, user.getId(), map, "1");
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            e.printStackTrace();
        }
        List userIdList = this.findByParams(companyMemberInfo.getCompanyId(), Constants.ManagerStatus.companyOwner.getType(), Constants.ManagerStatus.companyManager.getType());
        if (userIdList != null) {
            for (Long userId : userIdList) {
                User userOwner = this.userService.findById(userId);
                if ("0".equals("0")) {
                    if (StringUtils.isEmpty((Object)userOwner) || !StringUtils.isNotBlank((String)userOwner.getPushToken())) continue;
                    this.xgPushService.pushTokenIosOrAndroidBelievers(userOwner.getPushToken(), Constants.TitleNotify.company.getName(), user.getName() + Constants.ContentNotify.exitCompany.getName() + company.getName(), null, Constants.IntentType.systemNotice.getType());
                    continue;
                }
                if (StringUtils.isEmpty((Object)userOwner) || !StringUtils.isNotBlank((String)userOwner.getPushToken())) continue;
                this.xgPushService.pushTokenForeign(userOwner.getPushToken(), Constants.TitleNotify.company.getEnglishName(), user.getName() + Constants.ContentNotify.exitCompany.getEnglishName() + company.getName(), Constants.SHOWFLAG);
            }
        }
        return ResultModel.suc((Object)user);
    }

    public ResultModel<CompanyMemberInfo> updateManager(User user, CompanyMemberInfo companyMemberInfo, String languageType) {
        Company company = this.companyService.findById(companyMemberInfo.getCompanyId());
        if (company == null) {
            return ResultModel.error((ResultStatus)ResultStatus.COMPANY_NO_EXIST, (String)languageType);
        }
        if (companyMemberInfo.getManager().equals(Constants.ManagerStatus.companyOrdinaryMember.getType())) {
            companyMemberInfo.setManager(Constants.ManagerStatus.companyManager.getType());
            this.save(companyMemberInfo);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("companyId", companyMemberInfo.getCompanyId());
            map.put("action", "\u8bbe\u4e3a\u7ba1\u7406\u5458");
            map.put("msg", user.getName() + Constants.NoticeContent.setYouTO.getName() + company.getName() + Constants.NoticeContent.companyManager.getName());
            map.put("msgEn", user.getName() + Constants.NoticeContent.setYouTO.getNameEnglish() + Constants.NoticeContent.companyManager.getNameEnglish() + company.getName());
            try {
                this.noticeService.saveSendNotice(companyMemberInfo.getUserId(), Constants.NoticeParentType.company, Constants.NoticeType.companySetManager, Constants.Originator.member, user.getId(), map, "2");
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
                e.printStackTrace();
            }
            this.dynamicService.saveDynamic(user.getId(), Constants.DynamicParentType.company, companyMemberInfo.getCompanyId(), Constants.DynamicOriginatorType.companyManager, companyMemberInfo.getUserId(), Constants.DynamicType.setCompanyManager.getName(), Constants.DynamicActionType.companyAddManager, Constants.DynamicType.setCompanyManager.getNameEnglish());
            if ("0".equals("0")) {
                if (!StringUtils.isEmpty((Object)companyMemberInfo.getUser()) && StringUtils.isNotBlank((String)companyMemberInfo.getUser().getPushToken())) {
                    this.xgPushService.pushTokenIosOrAndroidBelievers(companyMemberInfo.getUser().getPushToken(), Constants.TitleNotify.company.getName(), user.getName() + Constants.ContentNotify.settingManager.getName() + company.getName() + "\u56e2\u961f\u7ba1\u7406\u5458", null, Constants.IntentType.systemNotice.getType());
                }
            } else if (!StringUtils.isEmpty((Object)companyMemberInfo.getUser()) && StringUtils.isNotBlank((String)companyMemberInfo.getUser().getPushToken())) {
                this.xgPushService.pushTokenForeign(companyMemberInfo.getUser().getPushToken(), Constants.TitleNotify.company.getEnglishName(), user.getName() + Constants.ContentNotify.settingManager.getEnglishName() + company.getName(), Constants.SHOWFLAG);
            }
            return ResultModel.ok();
        }
        companyMemberInfo.setManager(Constants.ManagerStatus.companyOrdinaryMember.getType());
        this.save(companyMemberInfo);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("companyId", companyMemberInfo.getCompanyId());
        map.put("action", "\u53d6\u6d88\u7ba1\u7406\u5458");
        map.put("msg", user.getName() + Constants.NoticeContent.setYouTO.getName() + company.getName() + Constants.NoticeContent.companyMember.getName());
        map.put("msgEn", user.getName() + Constants.NoticeContent.setYouTO.getNameEnglish() + Constants.NoticeContent.companyMember.getNameEnglish() + company.getName());
        try {
            this.noticeService.saveSendNotice(companyMemberInfo.getUserId(), Constants.NoticeParentType.company, Constants.NoticeType.companyDelManager, Constants.Originator.member, user.getId(), map, "2");
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            e.printStackTrace();
        }
        this.dynamicService.saveDynamic(user.getId(), Constants.DynamicParentType.company, companyMemberInfo.getCompanyId(), Constants.DynamicOriginatorType.companyManager, companyMemberInfo.getUserId(), Constants.DynamicType.cancelManager.getName(), Constants.DynamicActionType.cmpanyDelManager, Constants.DynamicType.cancelManager.getNameEnglish());
        if ("0".equals("0")) {
            if (!StringUtils.isEmpty((Object)companyMemberInfo.getUser()) && StringUtils.isNotBlank((String)companyMemberInfo.getUser().getPushToken())) {
                this.xgPushService.pushTokenIosOrAndroidBelievers(companyMemberInfo.getUser().getPushToken(), Constants.TitleNotify.company.getName(), user.getName() + Constants.ContentNotify.settingManager.getName() + company.getName() + "\u56e2\u961f\u6210\u5458", null, Constants.IntentType.systemNotice.getType());
            }
        } else if (!StringUtils.isEmpty((Object)companyMemberInfo.getUser()) && StringUtils.isNotBlank((String)companyMemberInfo.getUser().getPushToken())) {
            this.xgPushService.pushTokenForeign(companyMemberInfo.getUser().getPushToken(), Constants.TitleNotify.company.getEnglishName(), user.getName() + Constants.ContentNotify.settingmember.getEnglishName() + company.getName(), Constants.SHOWFLAG);
        }
        return ResultModel.ok();
    }

    public List<Long> findByParams(Long companyId, String owner, String manager) {
        return ((CompanyMemberInfoDao)this.dao).findByParams(companyId, owner, manager);
    }

    public int findByCompanyCount(Long userId) {
        return ((CompanyMemberInfoDao)this.dao).findByCompanyCount(userId, Constants.AuditStatus.adopt.getType());
    }
}

