/*
 * Decompiled with CFR 0.152.
 */
package com.ym.tlifang.service.attendance;

import com.alibaba.dubbo.config.annotation.Service;
import com.ym.tlifang.BaseEntity;
import com.ym.tlifang.Constants;
import com.ym.tlifang.ResultModel;
import com.ym.tlifang.attendance.AttendanceClasses;
import com.ym.tlifang.attendance.AttendanceDayCount;
import com.ym.tlifang.attendance.AttendanceDayTotal;
import com.ym.tlifang.attendance.AttendanceHolidays;
import com.ym.tlifang.attendance.AttendanceTime;
import com.ym.tlifang.attendance.AttendanceUserRecord;
import com.ym.tlifang.attendance.AttendanceWeekday;
import com.ym.tlifang.attendance.AttendanceWorkday;
import com.ym.tlifang.dao.attendance.AttendanceUserRecordDao;
import com.ym.tlifang.model.attendance.AttendancePersonalDetailModel;
import com.ym.tlifang.service.AbstractBaseService;
import com.ym.tlifang.service.attendance.AttendanceClassesService;
import com.ym.tlifang.service.attendance.AttendanceDayCountService;
import com.ym.tlifang.service.attendance.AttendanceDayTotalService;
import com.ym.tlifang.service.attendance.AttendanceOutsideService;
import com.ym.tlifang.service.attendance.AttendanceReportUserService;
import com.ym.tlifang.service.attendance.AttendanceUserRecordService;
import com.ym.tlifang.service.attendance.AttendanceUserService;
import com.ym.tlifang.service.system.DynamicService;
import com.ym.tlifang.util.DateUtils;
import com.ym.tlifang.util.JsonUtil;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Service(interfaceClass=AttendanceUserRecordService.class, timeout=30000, retries=-1)
public class AttendanceUserRecordServiceImpl
extends AbstractBaseService<AttendanceUserRecord, AttendanceUserRecordDao>
implements AttendanceUserRecordService {
    @Autowired
    private DynamicService dynamicService;
    @Autowired
    private AttendanceOutsideService attendanceOutsideService;
    @Autowired
    private AttendanceClassesService attendanceClassesService;
    @Autowired
    private AttendanceDayTotalService attendanceDayTotalService;
    @Autowired
    private AttendanceUserService attendanceUserService;
    @Autowired
    private AttendanceReportUserService attendanceReportUserService;
    @Autowired
    private AttendanceDayCountService attendanceDayCountService;

    public Integer findDegree(Long userId, Long companyId, String attendanceDate) {
        return ((AttendanceUserRecordDao)this.dao).findByUserIdAndAttendanceDateAndCompanyIdOrderByIdDesc(userId, attendanceDate, companyId).size();
    }

    public List<String> findStatusAndType(Long userId, List<String> attendanceTimes, Date date, Integer degree, Long companyId, Integer before, Integer after) throws ParseException {
        Integer time;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String attendanceDate = sdf.format(date);
        String nextType = null;
        String status = null;
        String result = null;
        Integer minutes = 60;
        sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        Long timeArr = date.getTime();
        Long timeSet = sdf.parse(attendanceDate + " " + attendanceTimes.get(degree)).getTime();
        Integer judge = 2;
        String throughTime = "";
        if (degree % judge == 0) {
            nextType = "0";
            if (timeArr > timeSet) {
                time = (int)((timeArr - timeSet) / 60000L);
                status = "\u8fdf\u5230" + time + "\u5206\u949f\u4e0a\u73ed\u4e86";
                throughTime = time.toString();
                if (time >= minutes) {
                    status = "\u8fdf\u5230" + time / 60 + "\u5c0f\u65f6\u4e0a\u73ed\u4e86";
                }
                result = "4";
            } else {
                if ((int)((timeSet - timeArr) / 60000L) > before && before != 0) {
                    return null;
                }
                status = "\u51c6\u65f6\u4e0a\u73ed\u4e86";
                result = "1";
            }
        } else {
            nextType = "1";
            if (timeSet > timeArr) {
                time = (int)((timeSet - timeArr) / 60000L);
                status = "\u65e9\u9000" + time + "\u5206\u949f\u4e0b\u73ed\u4e86";
                throughTime = time.toString();
                if (time >= minutes) {
                    status = "\u65e9\u9000" + time / 60 + "\u5c0f\u65f6\u4e0b\u73ed\u4e86";
                }
                result = "3";
            } else {
                if ((int)((timeArr - timeSet) / 60000L) > after && after != 0 && attendanceTimes.size() - degree == 1) {
                    return null;
                }
                status = "\u51c6\u65f6\u4e0b\u73ed\u4e86";
                result = "2";
                Integer sucDegree = ((AttendanceUserRecordDao)this.dao).findByUserIdAndAttendanceDateAndStatusLikeAndCompanyId(userId, attendanceDate, "\u51c6\u65f6%", companyId).size();
                if (attendanceTimes.size() - sucDegree == 1) {
                    status = "\u51fa\u52e4";
                }
            }
        }
        if (attendanceTimes.size() - degree == 1) {
            nextType = "2";
        }
        ArrayList<String> strings = new ArrayList<String>();
        strings.add(nextType);
        strings.add(status);
        strings.add(result);
        strings.add(throughTime);
        return strings;
    }

    public AttendanceUserRecord save(AttendanceUserRecord attendanceUserRecord) {
        String last = "\u51fa\u52e4";
        String content = (attendanceUserRecord = (AttendanceUserRecord)super.save((BaseEntity)attendanceUserRecord)).getStatus();
        if (last.equals(content)) {
            content = "\u51c6\u65f6\u4e0b\u73ed\u4e86";
        }
        if (!"0".equals(attendanceUserRecord.getSignResult())) {
            String contentEnglish = Constants.DynamicType.attendanceIn.getNameEnglish();
            if ("2".equals(attendanceUserRecord.getSignResult())) {
                contentEnglish = Constants.DynamicType.attendanceOut.getNameEnglish();
            }
            if ("3".equals(attendanceUserRecord.getSignResult())) {
                contentEnglish = attendanceUserRecord.getThroughTime() >= Constants.SIXTY ? Constants.DynamicType.attendanceEarly.getNameEnglish() + attendanceUserRecord.getThroughTime() / Constants.SIXTY + Constants.DynamicType.attendanceEarlyHour.getNameEnglish() : Constants.DynamicType.attendanceEarly.getNameEnglish() + attendanceUserRecord.getThroughTime() + Constants.DynamicType.attendanceEarlyTime.getNameEnglish();
            }
            if ("4".equals(attendanceUserRecord.getSignResult())) {
                contentEnglish = attendanceUserRecord.getThroughTime() >= Constants.SIXTY ? Constants.DynamicType.attendanceLater.getNameEnglish() + attendanceUserRecord.getThroughTime() / Constants.SIXTY + Constants.DynamicType.attendanceLaterHour.getNameEnglish() : Constants.DynamicType.attendanceLater.getNameEnglish() + attendanceUserRecord.getThroughTime() + Constants.DynamicType.attendanceLaterTime.getNameEnglish();
            }
            this.dynamicService.saveDynamic(attendanceUserRecord.getUserId(), Constants.DynamicParentType.company, attendanceUserRecord.getCompanyId(), Constants.DynamicOriginatorType.attendance, attendanceUserRecord.getId(), content, Constants.DynamicActionType.attendance, contentEnglish);
        }
        return attendanceUserRecord;
    }

    public List<AttendanceUserRecord> findByCompanyId(Long companyId) {
        return ((AttendanceUserRecordDao)this.dao).findByCompanyIdOrderByCreateDateDesc(companyId);
    }

    public AttendanceUserRecord findByUserId(Long userId, Long companyId) {
        SimpleDateFormat sdt = new SimpleDateFormat("yyyy-MM-dd");
        String date = sdt.format(new Date());
        List attendanceUserRecordList = ((AttendanceUserRecordDao)this.dao).findByUserIdAndAttendanceDateAndCompanyIdOrderByIdDesc(userId, date, companyId);
        AttendanceUserRecord attendanceUserRecord = new AttendanceUserRecord();
        if (attendanceUserRecordList.size() == 0) {
            attendanceUserRecord.setNextType("3");
        } else {
            attendanceUserRecord = (AttendanceUserRecord)attendanceUserRecordList.get(0);
        }
        attendanceUserRecord.setAllTimes(Integer.valueOf(attendanceUserRecordList.size() + 1));
        return attendanceUserRecord;
    }

    public List<Integer> findAttendance(Long userId, Long companyId, String date) {
        ArrayList<Integer> integers = new ArrayList<Integer>();
        date = date + "%";
        integers.add(((AttendanceUserRecordDao)this.dao).findByUserIdAndCompanyIdAndAttendanceDateLikeAndStatusLike(userId, companyId, date, "\u51fa\u52e4").size());
        integers.add(((AttendanceUserRecordDao)this.dao).findByUserIdAndCompanyIdAndAttendanceDateLikeAndStatusLike(userId, companyId, date, "\u8fdf\u5230%").size());
        integers.add(((AttendanceUserRecordDao)this.dao).findByUserIdAndCompanyIdAndAttendanceDateLikeAndStatusLike(userId, companyId, date, "\u65e9\u9000%").size());
        return integers;
    }

    public List<AttendanceUserRecord> findByTrueAttendance(Long userId, Long companyId, String date) {
        return ((AttendanceUserRecordDao)this.dao).findByUserIdAndAttendanceDateAndStatusLikeAndCompanyId(userId, date, "\u51fa\u52e4%", companyId);
    }

    public Map<String, Object> findWebPersonRecord(Long userId, Long companyId, String date) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("internalRecords", ((AttendanceUserRecordDao)this.dao).findByUserIdAndCompanyIdAndAttendanceDateLike(userId, companyId, date + "%"));
        result.put("outsideRecords", this.attendanceOutsideService.findOutsideRecords(userId, companyId, date + "%"));
        return result;
    }

    public List<AttendanceUserRecord> findAppPersonRecord(Long userId, Long companyId, String attendanceDate) {
        attendanceDate = attendanceDate + "%";
        return ((AttendanceUserRecordDao)this.dao).findByUserIdAndCompanyIdAndAttendanceDateLike(userId, companyId, attendanceDate);
    }

    public List<Boolean> updateEarlyLater(String department, Long userId, Long companyId, String attendanceDate) throws Exception {
        attendanceDate = attendanceDate + "%";
        List attendanceUserRecordList = ((AttendanceUserRecordDao)this.dao).findByUserIdAndCompanyIdAndAttendanceDateLikeAndStatusLike(userId, companyId, attendanceDate, "\u65e9\u9000%");
        List attendanceUserRecords = ((AttendanceUserRecordDao)this.dao).findByUserIdAndCompanyIdAndAttendanceDateLikeAndStatusLike(userId, companyId, attendanceDate, "\u8fdf\u5230%");
        Integer outsideTime = this.attendanceOutsideService.countByCompanyIdAndUserIdAndDateLike(companyId, userId, attendanceDate);
        ArrayList<Boolean> booleans = new ArrayList<Boolean>();
        ArrayList<String> reasonList = new ArrayList<String>();
        if (attendanceUserRecordList.size() != 0) {
            reasonList.add("\u65e9\u9000");
        }
        if (attendanceUserRecords.size() != 0) {
            reasonList.add("\u8fdf\u5230");
        }
        if (attendanceUserRecords.size() == 0 && attendanceUserRecordList.size() == 0) {
            reasonList.add("\u672a\u7b7e\u5230");
        }
        if (outsideTime > 0) {
            reasonList.add("\u5916\u52e4");
        }
        AttendanceDayCount attendanceDayCount = new AttendanceDayCount(companyId, userId, JsonUtil.jackson.writeValueAsString(reasonList), department, attendanceDate.substring(0, attendanceDate.length() - 1));
        this.attendanceDayCountService.save(attendanceDayCount);
        booleans.add(attendanceUserRecords.size() != 0);
        booleans.add(attendanceUserRecordList.size() != 0);
        return booleans;
    }

    public List<AttendanceUserRecord> findByCompanyIdDate(Long companyId, String attendanceDate) {
        return ((AttendanceUserRecordDao)this.dao).findByCompanyIdAndAttendanceDate(companyId, attendanceDate);
    }

    public Integer findSuccessTime(Long userId, String attendanceDate, Long companyId) {
        return ((AttendanceUserRecordDao)this.dao).findByUserIdAndAttendanceDateAndStatusLikeAndCompanyId(userId, attendanceDate, "\u51c6\u65f6%", companyId).size();
    }

    public void saveDayCount(String lastDay) {
        List attendanceClassesList = this.attendanceClassesService.findCompanyId();
        for (Object[] objects : attendanceClassesList) {
            Boolean bl = this.attendanceDayTotalService.findAttendanceDayTotal(Long.valueOf(objects[0].toString()), lastDay);
            if (bl.booleanValue()) continue;
            Calendar cal = Calendar.getInstance();
            cal.setTime(DateUtils.parseDate((Object)lastDay));
            Integer workday = cal.get(7);
            String mouth = DateUtils.getYearMonthStr((Date)DateUtils.parseDate((Object)lastDay), (String)"month");
            AttendanceDayTotal attendanceDayTotal = new AttendanceDayTotal();
            attendanceDayTotal.setRecordDate(lastDay);
            attendanceDayTotal.setCompanyId(Long.valueOf(objects[0].toString()));
            attendanceDayTotal.setUserCount(this.attendanceUserService.countByCompanyIdAndDelFlagFalse(attendanceDayTotal.getCompanyId(), workday));
            attendanceDayTotal.setSignIn(((AttendanceUserRecordDao)this.dao).countSignIn(attendanceDayTotal.getCompanyId(), lastDay));
            attendanceDayTotal.setSignOut(((AttendanceUserRecordDao)this.dao).countSignOut(attendanceDayTotal.getCompanyId(), lastDay));
            attendanceDayTotal.setLater(((AttendanceUserRecordDao)this.dao).countLater(attendanceDayTotal.getCompanyId(), lastDay + "%"));
            attendanceDayTotal.setEarly(((AttendanceUserRecordDao)this.dao).countLeave(attendanceDayTotal.getCompanyId(), lastDay + "%"));
            attendanceDayTotal.setOutsideAttendance(this.attendanceOutsideService.findOutsideTime(attendanceDayTotal.getCompanyId(), lastDay));
            attendanceDayTotal.setMonthPeople(this.attendanceReportUserService.findMonthPeople(attendanceDayTotal.getCompanyId(), mouth));
            attendanceDayTotal.setMonthSignIn(this.attendanceReportUserService.findMonthSignOut(attendanceDayTotal.getCompanyId(), mouth));
            attendanceDayTotal.setMonthFailAttendance(this.attendanceReportUserService.findMonthFail(attendanceDayTotal.getCompanyId(), mouth));
            attendanceDayTotal.setMonthLater(((AttendanceUserRecordDao)this.dao).countLater(attendanceDayTotal.getCompanyId(), mouth + "%"));
            attendanceDayTotal.setMonthEarly(((AttendanceUserRecordDao)this.dao).countLeave(attendanceDayTotal.getCompanyId(), mouth + "%"));
            attendanceDayTotal.setMonthOutside(this.attendanceOutsideService.findOutsideTime(attendanceDayTotal.getCompanyId(), mouth));
            this.attendanceDayTotalService.save(attendanceDayTotal);
        }
    }

    public ResultModel<List<AttendancePersonalDetailModel>> findPersonalDetail(Long userId, Long companyId, String lastDay, String type, String languageType) {
        List attendanceUserRecordList = ((AttendanceUserRecordDao)this.dao).findByUserIdAndCompanyIdAndAttendanceDateLikeAndSignResultAndSignTimeNotNullOrderByCreateDateDesc(userId, companyId, lastDay + "%", type);
        ArrayList<AttendancePersonalDetailModel> attendancePersonalDetailModelList = new ArrayList<AttendancePersonalDetailModel>();
        for (AttendanceUserRecord attendanceUserRecord : attendanceUserRecordList) {
            if (attendanceUserRecord.getAttendanceDate().equals(DateUtils.getDate())) continue;
            AttendancePersonalDetailModel attendancePersonalDetailModel = new AttendancePersonalDetailModel(attendanceUserRecord.getAttendanceDate(), attendanceUserRecord.getSignTime(), attendanceUserRecord.getStatus().substring(0, attendanceUserRecord.getStatus().length() - 3));
            attendancePersonalDetailModelList.add(attendancePersonalDetailModel);
        }
        return ResultModel.suc(attendancePersonalDetailModelList, (String)languageType);
    }

    public List<AttendanceTime> getAttendanceTime(Date date, AttendanceClasses attendanceClasses, List<AttendanceHolidays> attendanceHolidays, List<AttendanceWeekday> attendanceWeekdays, Map<String, AttendanceWorkday> attendanceWorkdayMap) {
        for (AttendanceWeekday attendanceWeekday : attendanceWeekdays) {
            if (!attendanceWeekday.getDate().equals(DateUtils.formatDate((Date)date, (Object[])new Object[]{"yyyy-MM-dd"}))) continue;
            if ("1".equals(attendanceWeekday.getType())) {
                return null;
            }
            if (!"2".equals(attendanceWeekday.getType())) continue;
            return this.getAttendanceTime(attendanceWeekday.getTimeArray());
        }
        if (attendanceHolidays != null) {
            for (AttendanceHolidays attendanceHolidays1 : attendanceHolidays) {
                if (!attendanceHolidays1.getDate().equals(DateUtils.formatDate((Date)date, (Object[])new Object[]{"yyyy-MM-dd"}))) continue;
                return null;
            }
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        AttendanceWorkday attendanceWorkday = attendanceWorkdayMap.get(Integer.valueOf(cal.get(7)).toString());
        if (attendanceWorkday == null) {
            return null;
        }
        return attendanceWorkday.getAttendanceTimeList();
    }

    public List getAttendanceTime(String timeArraty) {
        try {
            List list = (List)JsonUtil.jackson.readValue(timeArraty, List.class);
            ArrayList<AttendanceTime> attendanceTimes = new ArrayList<AttendanceTime>();
            for (Map map : list) {
                AttendanceTime attendanceTime = new AttendanceTime();
                attendanceTime.setBegin(map.get("begin").toString());
                attendanceTime.setEnd(map.get("end").toString());
                attendanceTimes.add(attendanceTime);
            }
            return attendanceTimes;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Map<Long, Integer> findTotalAbnormalTime(Long companyId, String attendanceDate, String signResult) {
        List totalAbnormalTimes = ((AttendanceUserRecordDao)this.dao).findTotalAbnormalTime(companyId, attendanceDate, signResult);
        HashMap<Long, Integer> map = new HashMap<Long, Integer>();
        for (Object[] totalAbnormalTime : totalAbnormalTimes) {
            Long.valueOf(totalAbnormalTime[0].toString());
            map.put(Long.valueOf(totalAbnormalTime[0].toString()), Integer.valueOf(totalAbnormalTime[1] == null ? "0" : totalAbnormalTime[1].toString()));
        }
        return map;
    }

    public Map<String, Map<String, List<String>>> findMonthRecord(Long companyId, String attendanceDate, String language) {
        if (language == null) {
            language = Constants.LanguageType.CN.getName();
        }
        HashMap<String, Map<String, List<String>>> map = new HashMap<String, Map<String, List<String>>>();
        List monthRecords = ((AttendanceUserRecordDao)this.dao).findMonthRecord(companyId, attendanceDate);
        for (Object[] monthRecord : monthRecords) {
            Map userMap = map.get(monthRecord[0].toString()) == null ? new HashMap() : (Map)map.get(monthRecord[0].toString());
            List set = userMap.get(monthRecord[1].toString().substring(8)) == null ? new ArrayList() : (List)userMap.get(monthRecord[1].toString().substring(8));
            String a = monthRecord[2].toString().equals("1") ? (Constants.LanguageType.CN.getName().equals(language) ? "\u7b7e\u5230\uff1a" : "Sign in:") : (monthRecord[2].toString().equals("2") ? (Constants.LanguageType.CN.getName().equals(language) ? "\u7b7e\u9000\uff1a" : "Sign back:") : (monthRecord[2].toString().equals("3") ? (Constants.LanguageType.CN.getName().equals(language) ? "\u65e9\u9000\uff1a" : "Leave early:") : (Constants.LanguageType.CN.getName().equals(language) ? "\u8fdf\u5230\uff1a" : "Late:")));
            set.add(a + monthRecord[3].toString());
            userMap.put(monthRecord[1].toString().substring(8), set);
            map.put(monthRecord[0].toString(), userMap);
        }
        List allOutsides = this.attendanceOutsideService.findAllOutside(companyId, attendanceDate);
        for (Object[] allOutside : allOutsides) {
            Map userMap = map.get(allOutside[0].toString()) == null ? new HashMap() : (Map)map.get(allOutside[0].toString());
            String a = allOutside[1].toString();
            List<String> set = userMap.get(a.substring(8, 10)) == null ? new ArrayList<String>() : (List)userMap.get(a.substring(8, 10));
            set.add((Constants.LanguageType.CN.getName().equals(language) ? "\u5916\u52e4\uff1a" : "Field attendance:") + a.substring(11));
            userMap.put(a.substring(8, 10), set);
            map.put(allOutside[0].toString(), userMap);
        }
        return map;
    }
}

