/*
 * Decompiled with CFR 0.152.
 */
package com.ym.tlifang.service.attendance;

import com.alibaba.dubbo.config.annotation.Service;
import com.ym.tlifang.BaseEntity;
import com.ym.tlifang.attendance.AttendanceReport;
import com.ym.tlifang.dao.attendance.AttendanceReportDao;
import com.ym.tlifang.service.AbstractBaseService;
import com.ym.tlifang.service.attendance.AttendanceClassesService;
import com.ym.tlifang.service.attendance.AttendanceReportService;
import com.ym.tlifang.service.attendance.AttendanceReportUserService;
import com.ym.tlifang.service.attendance.AttendanceUserRecordService;
import com.ym.tlifang.service.attendance.AttendanceUserService;
import com.ym.tlifang.service.attendance.AttendanceWeekdayService;
import com.ym.tlifang.service.attendance.AttendanceWorkdayService;
import com.ym.tlifang.service.company.CompanyService;
import com.ym.tlifang.service.company.CompanyUserRelationService;
import com.ym.tlifang.service.user.UserService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Service(interfaceClass=AttendanceReportService.class, timeout=30000, retries=-1)
public class AttendanceReportServiceImpl
extends AbstractBaseService<AttendanceReport, AttendanceReportDao>
implements AttendanceReportService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private AttendanceUserRecordService attendanceUserRecordService;
    @Autowired
    private AttendanceWeekdayService attendanceWeekdayService;
    @Autowired
    private AttendanceWorkdayService attendanceWorkdayService;
    @Autowired
    private AttendanceClassesService attendanceClassesService;
    @Autowired
    private AttendanceUserService attendanceUserService;
    @Autowired
    private UserService userService;
    @Autowired
    private CompanyUserRelationService companyUserRelationService;
    @Autowired
    private CompanyService companyService;
    @Autowired
    private AttendanceReportUserService attendanceReportUserService;

    public AttendanceReport save(AttendanceReport attendanceReport) {
        return (AttendanceReport)super.save((BaseEntity)attendanceReport);
    }

    public List<AttendanceReport> findReportList(Long companyId, String date) {
        List attendanceReportList = ((AttendanceReportDao)this.dao).findByCompanyIdAndDateAndDelFlagFalse(companyId, date);
        for (AttendanceReport attendanceReport : attendanceReportList) {
            List attendanceReportUserList = this.attendanceReportUserService.findByReportUser(attendanceReport.getId());
            attendanceReport.setAttendanceReportUserList(attendanceReportUserList);
        }
        return attendanceReportList;
    }

    public AttendanceReport findByCompanyIdAndDateAndClassesId(Long companyId, String date, Long classesId) {
        return ((AttendanceReportDao)this.dao).findByCompanyIdAndDateAndClassesIdAndDelFlagFalse(companyId, date, classesId);
    }

    public AttendanceReport findMaxByCompanyIdAndClassesId(Long companyId, Long classesId) {
        List attendanceReports = ((AttendanceReportDao)this.dao).findByCompanyIdAndClassesIdAndDelFlagFalseOrderByRecordTimeDesc(companyId, classesId);
        if (attendanceReports != null && attendanceReports.size() > 0) {
            return (AttendanceReport)attendanceReports.get(0);
        }
        return null;
    }
}

