/*
 * Decompiled with CFR 0.152.
 */
package com.ym.tlifang.api.controller.sys;

import com.alibaba.dubbo.config.annotation.Reference;
import com.ym.tlifang.PageInfo;
import com.ym.tlifang.ResultModel;
import com.ym.tlifang.ResultStatus;
import com.ym.tlifang.api.authorization.annotation.Authorization;
import com.ym.tlifang.api.authorization.annotation.CurrentUser;
import com.ym.tlifang.api.authorization.annotation.LanguageType;
import com.ym.tlifang.api.controller.BaseController;
import com.ym.tlifang.model.sys.DynamicModel;
import com.ym.tlifang.service.system.DynamicService;
import com.ym.tlifang.user.User;
import com.ym.tlifang.util.StringUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"dynamic"})
@Api(value="dynamic", description="\u52a8\u6001")
public class DynamicController
extends BaseController {
    @Reference
    DynamicService dynamicService;

    @GetMapping
    @ApiOperation(value="\u67e5\u8be2\u52a8\u6001\u5217\u8868\uff08\u7528\u4e8e\u67e5\u8be2\u5355\u4e2a\u7c7b\u578b\u52a8\u6001\uff09")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="language_type", value="\u8bed\u8a00\u7c7b\u578b", required=false, dataType="string", paramType="header"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body"), @ApiImplicitParam(name="parentType", value="\u7236\u7c7b\u578b\uff081.\u56e2\u961f\uff0c2.\u9879\u76ee\uff0c3.\u4efb\u52a1\uff09", required=true, dataType="string", paramType="query"), @ApiImplicitParam(name="parentTypeId", value="\u7236\u7c7b\u578b\u4e3b\u952eid", required=true, dataType="Long", paramType="query"), @ApiImplicitParam(name="pageNo", value="\u5206\u9875\u9875\u7801", required=true, dataType="Integer", paramType="query"), @ApiImplicitParam(name="pageSize", value="\u5206\u9875\u6761\u6570", required=true, dataType="Integer", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel getDynamic(@CurrentUser User currentUser, String parentType, Long parentTypeId, Integer pageNo, Integer pageSize, @LanguageType String languageType) {
        if (StringUtils.isEmpty((Object)parentType) || parentTypeId == null) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        PageInfo dynamicEntityList = this.dynamicService.findByParentTypeAndParentTypeId(currentUser.getId(), parentType, parentTypeId, pageNo, pageSize, languageType);
        return ResultModel.suc((Object)dynamicEntityList);
    }

    @GetMapping(value={"/getDynamicOriginator"})
    @ApiOperation(value="\u67e5\u8be2\u9009\u9879\u5361\u52a8\u6001\u5217\u8868\uff08\u7528\u4e8e\u67e5\u8be2\u8003\u52e4\uff0c\u4e8b\u52a1\uff09")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="language_type", value="\u8bed\u8a00\u7c7b\u578b", required=false, dataType="string", paramType="header"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body"), @ApiImplicitParam(name="parentType", value="\u7236\u7c7b\u578b\uff081.\u56e2\u961f\uff0c2.\u9879\u76ee\uff09", required=true, dataType="string", paramType="query"), @ApiImplicitParam(name="parentTypeId", value="\u7236\u7c7b\u578b\u4e3b\u952eid", required=true, dataType="Long", paramType="query"), @ApiImplicitParam(name="originatorType", value="\u4e3b\u4f53\u7c7b\u578b(\u8003\u52e4:attendance\uff0c\u4e8b\u52a1:affairs)", required=true, dataType="Long", paramType="query"), @ApiImplicitParam(name="pageNo", value="\u5206\u9875\u9875\u7801", required=true, dataType="Integer", paramType="query"), @ApiImplicitParam(name="pageSize", value="\u5206\u9875\u6761\u6570", required=true, dataType="Integer", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel getDynamicOriginatorType(@CurrentUser User currentUser, String parentType, Long parentTypeId, String originatorType, Integer pageNo, Integer pageSize, @LanguageType String languageType) {
        if (StringUtils.isEmpty((Object)parentType) || parentTypeId == null || StringUtils.isEmpty((Object)originatorType)) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        PageInfo dynamicEntityList = this.dynamicService.findByParentTypeAndParentTypeIdAndOriginatorType(currentUser.getId(), parentType, parentTypeId, originatorType, pageNo, pageSize, languageType);
        return ResultModel.suc((Object)dynamicEntityList);
    }

    @GetMapping(value={"/getDynamicAll"})
    @ApiOperation(value="\u67e5\u8be2\u672c\u516c\u53f8\u6240\u6709\u52a8\u6001\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body"), @ApiImplicitParam(name="companyId", value="\u516c\u53f8id", required=true, dataType="Long", paramType="query"), @ApiImplicitParam(name="pageNo", value="\u5206\u9875\u9875\u7801", required=true, dataType="Integer", paramType="query"), @ApiImplicitParam(name="pageSize", value="\u5206\u9875\u6761\u6570", required=true, dataType="Integer", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel getDynamicAll(@CurrentUser User currentUser, Long companyId, Integer pageNo, Integer pageSize, @LanguageType String languageType) {
        PageInfo dynamicEntityList = this.dynamicService.findByUserIdAndCompanyId(currentUser.getId(), companyId, pageNo, pageSize, languageType);
        return ResultModel.suc((Object)dynamicEntityList);
    }

    @GetMapping(value={"/getUserProjectDynamic"})
    @ApiOperation(value="\u67e5\u8be2\u672c\u516c\u53f8\u4e0e\u6211\u76f8\u5173\u7684\u6240\u6709\u9879\u76ee\u52a8\u6001\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body"), @ApiImplicitParam(name="companyId", value="\u516c\u53f8id", required=true, dataType="Long", paramType="query"), @ApiImplicitParam(name="pageNo", value="\u5206\u9875\u9875\u7801", required=true, dataType="Integer", paramType="query"), @ApiImplicitParam(name="pageSize", value="\u5206\u9875\u6761\u6570", required=true, dataType="Integer", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel getUserProjectDynamic(@CurrentUser User currentUser, Long companyId, Integer pageNo, Integer pageSize, @LanguageType String languageType) {
        PageInfo dynamicEntityList = this.dynamicService.findByUserIdAndCompanyIdAndProject(currentUser.getId(), companyId, pageNo, pageSize, languageType);
        return ResultModel.suc((Object)dynamicEntityList);
    }

    @GetMapping(value={"/getTaskDynamic"})
    @ApiOperation(value="\u67e5\u8be2\u67d0\u4e2a\u4efb\u52a1\u52a8\u6001\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="language_type", value="\u8bed\u8a00\u7c7b\u578b", required=false, dataType="string", paramType="header"), @ApiImplicitParam(name="taskId", value="\u4efb\u52a1id", required=true, dataType="Long", paramType="query"), @ApiImplicitParam(name="pageNo", value="\u5206\u9875\u9875\u7801", required=false, dataType="Integer", paramType="query"), @ApiImplicitParam(name="pageSize", value="\u5206\u9875\u6761\u6570", required=false, dataType="Integer", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<PageInfo<DynamicModel>> getUserProjectDynamic(Long taskId, Integer pageNo, Integer pageSize, @LanguageType String languageType) {
        if (taskId == null) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        PageInfo dynamicModelPageInfo = this.dynamicService.findByTaskId(taskId, pageNo, pageSize, languageType);
        return ResultModel.suc((Object)dynamicModelPageInfo);
    }
}

